/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.business.application.impl.onbrd;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hom.business.application.common.ReentryRuleService;
import kd.hr.hom.business.application.hrpi.IHomToHrpiAppService;
import kd.hr.hom.business.application.onbrd.IValidEntryDateService;
import kd.hr.hom.business.domain.repository.common.HomCommonRepository;
import kd.hr.hom.common.constant.BaseDataIdConstants;
import kd.hr.hom.common.entity.HomCommonWrapper;
import kd.hr.hom.common.enums.ViewTypeEnum;
import kd.hr.hom.common.util.FileServiceUtils;

public class ValidEntryDateServiceImpl
implements IValidEntryDateService {
    private static final Log LOGGER = LogFactory.getLog(FileServiceUtils.class);

    @Override
    public void validEntryDateOfQuitDateByMultiEntity(List<HomCommonWrapper> rowDataWrapperList) {
        List<DynamicObject> bizDatas = rowDataWrapperList.stream().map(HomCommonWrapper::getBizData).collect(Collectors.toList());
        Map<Long, Optional<String>> validEntryDateOfQuitDateMap = this.validEntryDateOfQuitDate(bizDatas.toArray(new DynamicObject[0]), false);
        for (HomCommonWrapper homCommonWrapper : rowDataWrapperList) {
            DynamicObject bizData = homCommonWrapper.getBizData();
            Optional<String> message = validEntryDateOfQuitDateMap.getOrDefault(bizData.getLong("personfield.id"), Optional.empty());
            message.ifPresent(arg_0 -> ((HomCommonWrapper)homCommonWrapper).addErrMsg(arg_0));
        }
    }

    @Override
    public Map<Long, Optional<String>> validEntryDateOfQuitDate(DynamicObject[] onBrdBills, boolean mobile) {
        LOGGER.info("###validOnbrdDateOfQuitDate-start");
        this.employeeIdToDy(onBrdBills);
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)onBrdBills.length);
        Map<Long, Date> idAndEffectDate = Arrays.stream(onBrdBills).filter(data -> data.getDate("effectdate") != null).filter(data -> ViewTypeEnum.AGAIN.getCode().equals(data.getString("viewtype"))).collect(Collectors.toMap(data -> data.getLong("personfield.id"), data -> data.getDate("effectdate"), (k1, k2) -> k1));
        LOGGER.info("###validOnbrdDateOfQuitDate-IdAndEffectDate {}", idAndEffectDate);
        if (CollectionUtils.isEmpty(idAndEffectDate)) {
            return resultMap;
        }
        Map<Long, Date> lastFileQuitDate = this.getLastFileQuitDate(onBrdBills);
        for (Map.Entry<Long, Date> entry : idAndEffectDate.entrySet()) {
            Long id = entry.getKey();
            Date quitDate = lastFileQuitDate.get(id);
            if (quitDate == null) continue;
            quitDate = HRDateTimeUtils.addDay((Date)quitDate, (long)-1L);
            if (!HRDateTimeUtils.dayBefore((Date)entry.getValue(), (Date)quitDate)) continue;
            String date = HRDateTimeUtils.format((Date)quitDate, (String)"yyyy-MM-dd");
            String message = mobile ? String.format(Locale.ROOT, ResManager.loadKDString((String)"\u60a8\u5c5e\u4e8e\u518d\u6b21\u5165\u804c\uff0c\u9884\u7ea6\u5165\u804c\u65e5\u671f\u9700\u665a\u4e8e\u6216\u7b49\u4e8e%s\u3002", (String)"ValidEntryDateServiceImpl_0", (String)"hr-hom-business", (Object[])new Object[0]), date) : String.format(Locale.ROOT, ResManager.loadKDString((String)"\u8be5\u4eba\u5458\u5c5e\u4e8e\u518d\u6b21\u5165\u804c\uff0c\u5165\u804c\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e%s\u3002", (String)"ValidEntryDateServiceImpl_1", (String)"hr-hom-business", (Object[])new Object[0]), date);
            resultMap.put(id, Optional.of(message));
        }
        LOGGER.info("###validOnbrdDateOfQuitDate-end resultMap {}", (Object)resultMap);
        return resultMap;
    }

    private void employeeIdToDy(DynamicObject[] onBrdBills) {
        Map<Long, Long> idAndLongTypeEmployeeId = Arrays.stream(onBrdBills).filter(data -> data.getDate("effectdate") != null).filter(data -> ViewTypeEnum.AGAIN.getCode().equals(data.getString("viewtype"))).filter(data -> data.get("personfield") != null).filter(data -> data.getLong("personfield.id") == 0L).collect(Collectors.toMap(data -> data.getLong("id"), data -> data.getLong("personfield")));
        LOGGER.info("###validOnbrdDateOfQuitDate-idAndLongTypeEmployeeId {}", idAndLongTypeEmployeeId);
        if (!CollectionUtils.isEmpty(idAndLongTypeEmployeeId)) {
            QFilter qFilter = new QFilter("id", "in", idAndLongTypeEmployeeId.values());
            DynamicObject[] employeeDys = HomCommonRepository.queryDynamicObjects("hrpi_employee", "person,id", qFilter);
            Map<Long, DynamicObject> employeeIdAndDys = Arrays.stream(employeeDys).collect(Collectors.toMap(data -> data.getLong("id"), data -> data, (k1, k2) -> k1));
            for (DynamicObject onBrdBill : onBrdBills) {
                DynamicObject employeeDy = employeeIdAndDys.get(idAndLongTypeEmployeeId.getOrDefault(onBrdBill.getLong("id"), 0L));
                onBrdBill.set("personfield", (Object)employeeDy);
            }
        }
    }

    @Override
    public Optional<String> validEntryDateByPropertyChanged(IFormView view) {
        DynamicObject dataEntity = view.getModel().getDataEntity();
        Map<Long, Optional<String>> validEntryDateOfQuitDateMap = IValidEntryDateService.getInstance().validEntryDateOfQuitDate(new DynamicObject[]{dataEntity}, false);
        Optional<String> message = validEntryDateOfQuitDateMap.getOrDefault(dataEntity.getLong("personfield.id"), Optional.empty());
        message.ifPresent(arg_0 -> ((IFormView)view).showTipNotification(arg_0));
        return message;
    }

    private Map<Long, Date> getLastFileQuitDate(DynamicObject[] onBrdBills) {
        LOGGER.info("###getLastFileQuitDate-start");
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)onBrdBills.length);
        Map<Long, Long> idAndPersonFields = Arrays.stream(onBrdBills).filter(data -> ViewTypeEnum.AGAIN.getCode().equals(data.getString("viewtype"))).filter(data -> data.getLong("personfield.id") != 0L).collect(Collectors.toMap(data -> data.getLong("personfield.id"), data -> data.getLong("personfield.person.id"), (k1, k2) -> k1));
        if (CollectionUtils.isEmpty(idAndPersonFields)) {
            LOGGER.info("###getLastFileQuitDate-idAndPersonFields is null");
            return resultMap;
        }
        QFilter qFilter = new QFilter("id", "in", idAndPersonFields.values());
        Object[] persons = IHomToHrpiAppService.getInstance().listFieldsFilterInfo("personindexid", this.setQFilter(qFilter, false), "hrpi_person");
        if (ArrayUtils.isEmpty((Object[])persons)) {
            LOGGER.warn("###getLastFileQuitDate.persons is null");
            return resultMap;
        }
        Map<Long, Long> personIdAndPersonIndexId = Arrays.stream(persons).collect(Collectors.toMap(data -> data.getLong("id"), data -> data.getLong("personindexid"), (k1, k2) -> k1));
        if (CollectionUtils.isEmpty(idAndPersonFields)) {
            LOGGER.warn("###getLastFileQuitDate-personIdAndPersonIndexId is null");
            return resultMap;
        }
        ArrayList<Long> personIndexIds = new ArrayList<Long>(personIdAndPersonIndexId.values());
        Map<Long, DynamicObject> lastErmanfiles = ReentryRuleService.getInstance().getLastErmanfiles(personIndexIds);
        if (CollectionUtils.isEmpty(lastErmanfiles)) {
            LOGGER.warn("###getLastFileQuitDate.persons is null");
            return resultMap;
        }
        HashMap personIndexIdAndPersonId = Maps.newHashMapWithExpectedSize((int)lastErmanfiles.size());
        for (Map.Entry<Long, DynamicObject> entry : lastErmanfiles.entrySet()) {
            long personId = entry.getValue().getLong("person.id");
            personIndexIdAndPersonId.put(entry.getKey(), personId);
        }
        if (CollectionUtils.isEmpty((Map)personIndexIdAndPersonId)) {
            LOGGER.warn("###getLastFileQuitDate-personIndexIdAndPersonId is null");
            return resultMap;
        }
        QFilter qFilter1 = new QFilter("person", "in", personIndexIdAndPersonId.values());
        Object[] empnonentrel = IHomToHrpiAppService.getInstance().listFieldsFilterInfo("startdate,person", this.setQFilter(qFilter1, true).and(new QFilter("laborrelstatus.labrelstatusprd.id", "=", (Object)BaseDataIdConstants.HBSS_LABRELSTATUSPRD_1020)), "hrpi_empnonentrel");
        if (ArrayUtils.isEmpty((Object[])empnonentrel)) {
            LOGGER.warn("###getLastFileQuitDate.empnonentrel is null");
            return resultMap;
        }
        Map<Long, Date> personIdAndStartDate = Arrays.stream(empnonentrel).collect(Collectors.toMap(data -> data.getLong("person.id"), data -> data.getDate("startdate"), (k1, k2) -> k1.before((Date)k2) ? k2 : k1));
        if (ArrayUtils.isEmpty((Object[])empnonentrel)) {
            LOGGER.warn("###getLastFileQuitDate.personIdAndStartDate is null");
            return resultMap;
        }
        for (Map.Entry<Long, Long> entry : idAndPersonFields.entrySet()) {
            Long key = entry.getKey();
            Date value = personIdAndStartDate.getOrDefault(personIndexIdAndPersonId.getOrDefault(personIdAndPersonIndexId.getOrDefault(entry.getValue(), 0L), 0L), null);
            resultMap.put(key, value);
        }
        LOGGER.info("###getLastFileQuitDate-end result {} ", (Object)resultMap);
        return resultMap;
    }

    private QFilter setQFilter(QFilter qFilter, boolean businesss) {
        qFilter = qFilter.and("iscurrentversion", "=", (Object)"1").and("datastatus", "=", (Object)"1");
        if (businesss) {
            qFilter = qFilter.and("businessstatus", "=", (Object)"1");
        }
        return qFilter;
    }
}

