/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.business.application.impl.page;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Label;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRInteDateTimeUtil;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hom.business.application.hcf.IHomToHcfAppService;
import kd.hr.hom.business.application.impl.page.OnbrdNullPageServiceImpl;
import kd.hr.hom.business.application.impl.page.PanelApAdatper;
import kd.hr.hom.business.application.page.ICertificatePageService;
import kd.hr.hom.business.domain.service.hcf.IHcfDataDomainService;
import kd.hr.hom.business.domain.service.impl.hcf.HcfDataDomainService;
import kd.hr.hom.business.domain.service.onbrd.IOnbrdBillDomainService;
import kd.hr.hom.common.constant.HcfCanCreConstants;
import kd.hr.hom.common.util.HOMObjectUtils;
import kd.hr.hom.common.util.IDCardUtils;

public class CertificatePageServiceImpl
implements ICertificatePageService {
    private static final Log logger = LogFactory.getLog(CertificatePageServiceImpl.class);
    public static final String PROPERTIES_CANCRE = "id,candidate,credentialstype,number,ismajor,percardname,expirationdate,faceimage,reverseimage,createtime,ispermanent";

    @Override
    public void generateCreCardsView(IFormView formView, String panelKey, final Long candidateId, Long onbrdBillId) {
        HashSet candidateIdSet = new HashSet(){
            private static final long serialVersionUID = -6275061595158813786L;
            {
                this.add(candidateId);
            }
        };
        Map<Long, DynamicObjectCollection> map = new HcfDataDomainService().queryMultiRowEntity(candidateIdSet, "hcf_cancre", PROPERTIES_CANCRE);
        DynamicObjectCollection dataCollection = map.get(candidateId);
        if (CollectionUtils.isEmpty((Collection)dataCollection)) {
            new OnbrdNullPageServiceImpl().loadOnbrdNullPage(formView);
            return;
        }
        formView.setVisible(Boolean.FALSE, new String[]{"onbrdnullpage"});
        List certificateInfos = dataCollection.stream().sorted(new Comparator<DynamicObject>(){

            @Override
            public int compare(DynamicObject certificateDy1, DynamicObject certificateDy2) {
                int ismajor1 = certificateDy1.getBoolean("ismajor") ? 1 : 0;
                int ismajor2 = certificateDy2.getBoolean("ismajor") ? 1 : 0;
                int compare = ismajor2 - ismajor1;
                if (compare != 0) {
                    return compare;
                }
                Date date1 = certificateDy1.getDate("createtime");
                Date date2 = certificateDy2.getDate("createtime");
                if (date1 != null && date2 != null) {
                    compare = date2.compareTo(date1);
                }
                return compare;
            }
        }).collect(Collectors.toList());
        FlexPanelAp allCardsPanel = this.generateCardsPanel(panelKey);
        for (int i = 0; i < certificateInfos.size(); ++i) {
            DynamicObject certificateInfo = (DynamicObject)certificateInfos.get(i);
            PanelApAdatper cardPanelStyleAdapter = new PanelApAdatper("cardPanel" + i){

                @Override
                public void setStyle() {
                    this.panelAp.setGrow(0);
                    this.panelAp.setShrink(0);
                }
            };
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
            formShowParameter.getOpenStyle().setTargetKey("cardPanel" + i);
            formShowParameter.setStatus(OperationStatus.VIEW);
            formShowParameter.setFormId("hom_cancreinfo_view");
            formShowParameter.setCustomParams(this.getParamsMapForShowCard(certificateInfo));
            formShowParameter.setCustomParam("id", (Object)certificateInfo.getString("id"));
            formShowParameter.setCustomParam("index", (Object)(i + ""));
            formShowParameter.setCustomParam("candidate", (Object)candidateId.toString());
            formShowParameter.setCustomParam("onbrdid", (Object)onbrdBillId.toString());
            formShowParameter.setCustomParam("showEditBtn", (Object)Boolean.TRUE);
            formView.showForm(formShowParameter);
            allCardsPanel.getItems().add(cardPanelStyleAdapter.getPanelAp());
        }
        formView.updateControlMetadata(allCardsPanel.getKey(), allCardsPanel.createControl());
    }

    private FlexPanelAp generateCardsPanel(String panelKey) {
        PanelApAdatper mainPanelApt = new PanelApAdatper(panelKey){

            @Override
            public void setStyle() {
                this.panelAp.setGrow(0);
                this.panelAp.setShrink(1);
                this.panelAp.setAlignSelf("stretch");
            }
        };
        return mainPanelApt.getPanelAp();
    }

    @Override
    public Map<String, Object> getParamsMapForShowCard(DynamicObject certificateInfo) {
        HashMap customParamsmap = Maps.newHashMapWithExpectedSize((int)8);
        DynamicObject credentialsType = certificateInfo.getDynamicObject("credentialstype");
        customParamsmap.put("credentialstype", HRObjectUtils.isEmpty((Object)credentialsType) ? "" : credentialsType.getString("id"));
        customParamsmap.put("credentialstype.name", HRObjectUtils.isEmpty((Object)credentialsType) ? "" : credentialsType.getString("name"));
        customParamsmap.put("number", certificateInfo.getString("number"));
        customParamsmap.put("ismajor", certificateInfo.getString("ismajor"));
        customParamsmap.put("percardname", certificateInfo.getString("percardname"));
        Date expirationDate = certificateInfo.getDate("expirationdate");
        customParamsmap.put("expirationdate", expirationDate == null ? "" : HRInteDateTimeUtil.formatDate((String)"hom_cancreinfo_edit", (String)"expirationdate", (Date)expirationDate));
        String faceImage = certificateInfo.getString("faceimage");
        customParamsmap.put("faceimage", faceImage == null ? "" : faceImage.split("-")[0]);
        String reverseImage = certificateInfo.getString("reverseimage");
        customParamsmap.put("reverseimage", reverseImage == null ? "" : reverseImage.split("-")[0]);
        customParamsmap.put("ispermanent", certificateInfo.getString("ispermanent"));
        return customParamsmap;
    }

    @Override
    public void setValueWithParamsMap(IFormView formView, Map<String, Object> customParamsmap) {
        IDataModel dataModel = formView.getModel();
        dataModel.setValue("credentialstype", customParamsmap.get("credentialstype"));
        this.setLabelData(formView, "credentialstypename", customParamsmap.get("credentialstype.name").toString());
        formView.getModel().setValue("number", (Object)customParamsmap.get("number").toString());
        Boolean isMajor = Boolean.valueOf(customParamsmap.get("ismajor").toString());
        dataModel.setValue("ismajora", (Object)isMajor);
        formView.setVisible(isMajor, new String[]{"ismajor"});
        ((Label)formView.getControl("percardname")).setText("");
        this.setLabelData(formView, "percardname", customParamsmap.get("percardname").toString());
        boolean isPermanent = HOMObjectUtils.getBooleanValOfObject((Object)customParamsmap.get("ispermanent"));
        if (isPermanent) {
            ((Label)formView.getControl("expirationdate")).setText(ResManager.loadKDString((String)"\u6c38\u4e45\u6709\u6548", (String)"CertificatePageServiceImpl_3", (String)"hr-hom-business", (Object[])new Object[0]));
        } else {
            ((Label)formView.getControl("expirationdate")).setText("");
            this.setLabelData(formView, "expirationdate", customParamsmap.get("expirationdate").toString());
        }
    }

    @Override
    public boolean validateCreNumber(DynamicObject credentialsType, String credentialsNumber) {
        long creType;
        if (HRStringUtils.isEmpty((String)credentialsNumber)) {
            return true;
        }
        long l = creType = HRObjectUtils.isEmpty((Object)credentialsType) ? 0L : credentialsType.getLong("id");
        if (HcfCanCreConstants.CREDENTIALSTYPE_ID_IDCARD == creType) {
            return IDCardUtils.validIdentityCardNo(null, (String)"CN01", (String)credentialsNumber);
        }
        return !HRStringUtils.isEmpty((String)credentialsNumber);
    }

    @Override
    public Map<Long, String> getCreTypeNumberMap(Long candidateId) {
        HashMap entityFields = Maps.newHashMapWithExpectedSize((int)2);
        entityFields.put("hcf_cancre", "credentialstype");
        Map<String, DynamicObjectCollection> map = IHomToHcfAppService.getInstance().getCandidate(candidateId, entityFields, 0L);
        DynamicObjectCollection creCollection = map.get("hcf_cancre");
        HashMap result = Maps.newHashMapWithExpectedSize((int)creCollection.size());
        for (DynamicObject certificateInfo : creCollection) {
            DynamicObject credentialsType = certificateInfo.getDynamicObject("credentialstype");
            String creTypeNumber = HRObjectUtils.isEmpty((Object)credentialsType) ? "" : credentialsType.getString("number");
            result.put(certificateInfo.getLong("id"), creTypeNumber);
        }
        return result;
    }

    @Override
    public String validateDateField(DynamicObject certificateInfo) {
        Date expirationDate;
        Date issueDate;
        Date today = HRDateTimeUtils.truncateDate((Date)new Date());
        StringBuilder errorMsg = new StringBuilder();
        Date birthDate = HRDateTimeUtils.truncateDate((Date)certificateInfo.getDate("birthdate"));
        if (birthDate != null && !HRDateTimeUtils.dayBefore((Date)birthDate, (Date)today)) {
            errorMsg.append(ResManager.loadKDString((String)"\u51fa\u751f\u65e5\u671f\u5e94\u5c0f\u4e8e\u5f53\u524d\u65e5\u671f\uff1b", (String)"CertificatePageServiceImpl_0", (String)"hr-hom-business", (Object[])new Object[0]));
        }
        if ((issueDate = HRDateTimeUtils.truncateDate((Date)certificateInfo.getDate("issuedate"))) != null && HRDateTimeUtils.dayBefore((Date)today, (Date)issueDate)) {
            errorMsg.append(ResManager.loadKDString((String)"\u8bc1\u4ef6\u7b7e\u53d1\u65e5\u671f\u5e94\u5c0f\u4e8e\u7b49\u4e8e\u5f53\u524d\u65e5\u671f\uff1b", (String)"CertificatePageServiceImpl_1", (String)"hr-hom-business", (Object[])new Object[0]));
        }
        if ((expirationDate = HRDateTimeUtils.truncateDate((Date)certificateInfo.getDate("expirationdate"))) != null && HRDateTimeUtils.dayBefore((Date)expirationDate, (Date)today)) {
            errorMsg.append(ResManager.loadKDString((String)"\u8bc1\u4ef6\u5230\u671f\u65e5\u671f\u5e94\u5927\u4e8e\u7b49\u4e8e\u5f53\u524d\u65e5\u671f\uff1b", (String)"CertificatePageServiceImpl_2", (String)"hr-hom-business", (Object[])new Object[0]));
        }
        return errorMsg.toString();
    }

    @Override
    public Set<Long> judgeCertificateIfDuplicate(DynamicObject credentialsType, String credentialsNumber, Long currentPkId) {
        QFilter qFilter = new QFilter("credentialstype", "=", (Object)credentialsType.getLong("id"));
        qFilter.and("number", "=", (Object)credentialsNumber);
        String hcfProperties = "credentialstype" + ',' + "number" + ',' + "candidate.id";
        Object[] creInfos = IHcfDataDomainService.getInstance().queryHcfAttachedData("hcf_cancre", hcfProperties, new QFilter[]{qFilter});
        HashSet<Long> ids = new HashSet<Long>(creInfos.length);
        if (currentPkId == null) {
            if (HRArrayUtils.isEmpty((Object[])creInfos)) {
                return ids;
            }
            return Arrays.stream(creInfos).map(creInfo -> creInfo.getLong("candidate.id")).collect(Collectors.toSet());
        }
        for (Object creInfo2 : creInfos) {
            Long pkIdFromDB = creInfo2.getLong("id");
            if (currentPkId.longValue() == pkIdFromDB.longValue()) continue;
            ids.add(creInfo2.getLong("candidate.id"));
        }
        return ids;
    }

    private void setLabelData(IFormView formView, String labelKey, String data) {
        Label label;
        if (HRStringUtils.isNotEmpty((String)labelKey) && data != null && (label = (Label)formView.getControl(labelKey)) != null) {
            label.setText(data);
        }
    }

    public void synOnbrdCreNumber(Long onbrdId, DynamicObject cretificatecInfo) {
        if (onbrdId == null || onbrdId == 0L) {
            logger.info("onbrdId==null || onbrdId.longValue()==0L");
            return;
        }
        String properties = "certificatetype" + "," + "certificatenumber";
        QFilter qFilter = new QFilter("id", "=", (Object)onbrdId);
        IOnbrdBillDomainService onbrdBillDomainService = IOnbrdBillDomainService.getInstance();
        DynamicObject onbrdBillInfo = onbrdBillDomainService.findOnbrdBill(properties, new QFilter[]{qFilter});
        if (onbrdBillInfo == null) {
            logger.info("onbrdBillInfo == null");
            return;
        }
        if (cretificatecInfo == null) {
            logger.info("cretificatecInfo==null");
            onbrdBillInfo.set("certificatetype", (Object)0L);
            onbrdBillInfo.set("certificatenumber", (Object)"");
        } else if (cretificatecInfo.getBoolean("ismajor")) {
            onbrdBillInfo.set("certificatetype", (Object)cretificatecInfo.getDynamicObject("credentialstype"));
            onbrdBillInfo.set("certificatenumber", (Object)cretificatecInfo.getString("number"));
            logger.info(cretificatecInfo.getString("id") + " this cretificatec number is empty:" + HRStringUtils.isEmpty((String)cretificatecInfo.getString("number")));
        } else {
            logger.info("this cretificatecInfo is not major, onbrdId:" + onbrdId);
        }
        onbrdBillDomainService.saveOnbrdBillInfo(onbrdBillInfo);
    }

    public boolean validateCreNumber(JSONObject credentialsType, String certificatenumber) {
        long creType;
        if (HRStringUtils.isEmpty((String)certificatenumber)) {
            return true;
        }
        long typeId = HRObjectUtils.isEmpty((Object)credentialsType) || credentialsType.getLong("id") == null ? 0L : credentialsType.getLong("id");
        long l = creType = HRObjectUtils.isEmpty((Object)credentialsType) ? 0L : typeId;
        if (HcfCanCreConstants.CREDENTIALSTYPE_ID_IDCARD == creType) {
            return IDCardUtils.validIdentityCardNo(null, (String)"CN01", (String)certificatenumber);
        }
        return !HRStringUtils.isEmpty((String)certificatenumber);
    }
}

