/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.business.application.impl.processing;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hom.business.application.utils.ScheduleTaskUtil;
import kd.hr.hom.business.domain.service.common.IBaseDataDomainService;
import kd.hr.hom.business.domain.service.onbrd.IOnbrdBillDomainService;
import kd.hr.hom.business.domain.service.onbrd.IOnbrdInfoInitService;
import kd.hr.hom.common.entity.HomCommonWrapper;
import kd.hr.hom.common.enums.InitTypeEnum;
import kd.hr.hom.common.enums.ProcessStatusEnum;

public class OnbrdJobInfoUpgradeTask
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(OnbrdJobInfoUpgradeTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        IOnbrdBillDomainService onbrdBillService = IOnbrdBillDomainService.getInstance();
        String properties = "id" + "," + "apositiontype" + "," + "ajobscm" + "," + "ajobscmorg" + "," + "ajob" + "," + "jobseq" + "," + "jobfamily" + "," + "jobclass" + "," + "ajoblevel" + "," + "joblevelscm" + "," + "ajobgrade" + "," + "jobgradescm";
        QFilter qfilter = new QFilter("ajob", "!=", (Object)0L);
        QFilter jobseqFilter = new QFilter("jobseq", "=", (Object)0L);
        jobseqFilter.or(new QFilter("jobseq", "is null", null));
        qfilter.and(jobseqFilter);
        qfilter.and(new QFilter("processstatus", "!=", (Object)ProcessStatusEnum.END_PROCESS.getValue()));
        Object[] onbrdBills = onbrdBillService.findOnbrdBills(properties, new QFilter[]{qfilter});
        if (HRArrayUtils.isEmpty((Object[])onbrdBills)) {
            ScheduleTaskUtil.disEnableTask("hom_jobinfo_upgrade_SKDP_S");
            LOGGER.info("That is no data need to Upgrade JobInfo");
            return;
        }
        LOGGER.info("Need Upgrade JobInfo size:" + onbrdBills.length);
        IBaseDataDomainService baseDataDomainService = IBaseDataDomainService.getInstance();
        Set<Long> jobLevelIds = Stream.of(onbrdBills).map(onbrdBill -> onbrdBill.getLong("ajoblevel.id")).collect(Collectors.toSet());
        Set<Long> jobGradeIds = Stream.of(onbrdBills).map(onbrdBill -> onbrdBill.getLong("ajobgrade.id")).collect(Collectors.toSet());
        Map<Long, DynamicObject> jobLevelMap = baseDataDomainService.getBaseDataInfoByIds("hbjm_joblevelhr", jobLevelIds, "joblevelscm");
        Map<Long, DynamicObject> jobGradeMap = baseDataDomainService.getBaseDataInfoByIds("hbjm_jobgradehr", jobGradeIds, "jobgradescm");
        List<HomCommonWrapper> onbrdBillWrapperList = Stream.of(onbrdBills).map(onbrdBill -> new HomCommonWrapper(onbrdBill)).collect(Collectors.toList());
        IOnbrdInfoInitService.getInstance().initJobInfos(onbrdBillWrapperList, InitTypeEnum.ONBRD_NEW_ADDONE.getValue());
        for (Object onbrdBill2 : onbrdBills) {
            DynamicObject ajobgrade;
            DynamicObject ajoblevel = onbrdBill2.getDynamicObject("ajoblevel");
            if (ajoblevel != null) {
                onbrdBill2.set("joblevelscm", (Object)jobLevelMap.get(ajoblevel.getLong("id")));
            }
            if ((ajobgrade = onbrdBill2.getDynamicObject("ajobgrade")) == null) continue;
            onbrdBill2.set("jobgradescm", (Object)jobGradeMap.get(ajobgrade.getLong("id")));
        }
        onbrdBillService.saveOnbrdBillInfos((DynamicObject[])onbrdBills);
        LOGGER.info("End Upgrade JobInfo");
        ScheduleTaskUtil.disEnableTask("hom_jobinfo_upgrade_SKDP_S");
    }
}

