/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.business.application.impl.rule;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.imp.MultiEntityRowData;
import kd.hr.hom.business.application.impl.rule.HcfMultiRowCommonValidator;
import kd.hr.hom.business.domain.repository.common.BaseDataRepository;

public class HcfLgabilityValidator
extends HcfMultiRowCommonValidator {
    @Override
    protected void validateCustom(String optionCode, List<MultiEntityRowData> rowDataList, ImportLogger importLogger) {
        super.validateCustom(optionCode, rowDataList, importLogger);
        this.validateDataRelation(rowDataList, importLogger);
    }

    private void validateDataRelation(List<MultiEntityRowData> rowDataList, ImportLogger importLogger) {
        Set certificateIds = rowDataList.stream().filter(rowData -> !HRObjectUtils.isEmpty((Object)rowData.getOpEntity().getDynamicObject("certificate"))).map(rowData -> rowData.getOpEntity().getDynamicObject("certificate").getLong("id")).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(certificateIds)) {
            return;
        }
        QFilter qFilter = new QFilter("id", "in", certificateIds);
        DynamicObject[] languagecertInfos = BaseDataRepository.getLanguagecertInfos("", new QFilter[]{qFilter});
        Map<Long, DynamicObject> languagecertInfoMap = Stream.of(languagecertInfos).collect(Collectors.toMap(languagecertInfo -> languagecertInfo.getLong("id"), languagecertInfo -> languagecertInfo, (oldValue, newValue) -> newValue));
        for (MultiEntityRowData rowData2 : rowDataList) {
            DynamicObject certificateInfo;
            DynamicObject lgabilityInfoFromExcel = rowData2.getOpEntity();
            DynamicObject language = lgabilityInfoFromExcel.getDynamicObject("language");
            DynamicObject certificate = lgabilityInfoFromExcel.getDynamicObject("certificate");
            if (HRObjectUtils.isEmpty((Object)language) || HRObjectUtils.isEmpty((Object)certificate) || HRStringUtils.equals((String)"1420_S", (String)(certificateInfo = languagecertInfoMap.get(certificate.getLong("id"))).getString("number")) || certificateInfo.getLong("languagetype.id") == language.getLong("id")) continue;
            importLogger.log(rowData2.getRownum(), ResManager.loadKDString((String)"\u8bed\u8a00\u79cd\u7c7b\u4e0e\u8bed\u8a00\u8bc1\u4e66\u4e0d\u5339\u914d\u3002", (String)"HcfLgabilityValidator_0", (String)"hr-hom-business", (Object[])new Object[0]));
        }
    }
}

