/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.business.application.impl.rule;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.bussiness.cert.HRCertCommonHelper;
import kd.hr.hbp.bussiness.cert.HRCertPromptInfoTypeEnum;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hom.business.application.onbrd.IOnbrdCommonAppService;
import kd.hr.hom.business.application.onbrd.IOnbrdConfirmAppService;
import kd.hr.hom.business.application.onbrd.IValidEntryDateService;
import kd.hr.hom.business.application.rule.IOnbrdCommonValidator;
import kd.hr.hom.business.application.rule.IOnbrdConfirmValidatorService;
import kd.hr.hom.business.application.staff.IStaffUseService;
import kd.hr.hom.business.domain.service.onbrd.IOnbrdBillDomainService;
import kd.hr.hom.business.domain.service.util.OnbrdValidateUtils;
import kd.hr.hom.common.entity.HomCommonWrapper;
import kd.hr.hom.common.enums.ProcessStatusEnum;
import kd.hr.hom.common.util.HOMObjectUtils;
import kd.sdk.hr.hom.business.onbrd.IConfirmOnbrdService;
import org.apache.commons.lang3.time.DateUtils;

public class OnbrdConfirmValidatorService
implements IOnbrdConfirmValidatorService {
    private final Log logger = LogFactory.getLog(OnbrdConfirmValidatorService.class);

    @Override
    public Map<String, String> getRequiredFieldNameMap() {
        HashMap<String, String> checkIfEmptyFieldMap = new HashMap<String, String>();
        checkIfEmptyFieldMap.put("effectdate", ResManager.loadKDString((String)"\u5165\u804c\u65e5\u671f", (String)"OnbrdConfirmValidatorService_1", (String)"hr-hom-business", (Object[])new Object[0]));
        checkIfEmptyFieldMap.put("employeeno", ResManager.loadKDString((String)"\u5de5\u53f7", (String)"OnbrdConfirmValidatorService_2", (String)"hr-hom-business", (Object[])new Object[0]));
        checkIfEmptyFieldMap.put("name", ResManager.loadKDString((String)"\u59d3\u540d", (String)"OnbrdConfirmValidatorService_3", (String)"hr-hom-business", (Object[])new Object[0]));
        checkIfEmptyFieldMap.put("candidate", ResManager.loadKDString((String)"\u5173\u8054\u7684\u5019\u9009\u4eba", (String)"OnbrdConfirmValidatorService_4", (String)"hr-hom-business", (Object[])new Object[0]));
        checkIfEmptyFieldMap.put("certificatenumber", ResManager.loadKDString((String)"\u8bc1\u4ef6\u53f7\u7801", (String)"OnbrdConfirmValidatorService_5", (String)"hr-hom-business", (Object[])new Object[0]));
        return checkIfEmptyFieldMap;
    }

    private static StringBuilder getSelectPropsForValidate() {
        StringBuilder selectProperties = new StringBuilder().append("id");
        selectProperties.append(',').append("candidate");
        selectProperties.append(',').append("effectdate");
        selectProperties.append(',').append("aadminorg");
        selectProperties.append(',').append("ajob");
        selectProperties.append(',').append("aposition");
        selectProperties.append(',').append("stdposition");
        selectProperties.append(',').append("enrollstatus");
        return selectProperties;
    }

    @Override
    public DynamicObject[] getOnbrdBillForCheckValid(Collection<Long> onbrdBillIds) {
        QFilter qFilter = new QFilter("id", "in", onbrdBillIds);
        String propertiesSelected = OnbrdConfirmValidatorService.getSelectPropsForValidate().toString();
        return IOnbrdBillDomainService.getInstance().findOnbrdBills(propertiesSelected, new QFilter[]{qFilter});
    }

    @Override
    public void takeConfirmPageInfoToTargetObject(DynamicObject confirmPageInfo, DynamicObject targetOnbrdBillInfo) {
        targetOnbrdBillInfo.set("effectdate", confirmPageInfo.get("effectdate"));
    }

    private static String checkEffectDateIfLaterThanNow(Date effectDate) {
        Date currentDate = HRDateTimeUtils.truncateDate((Date)new Date());
        if (Objects.isNull(effectDate)) {
            return ResManager.loadKDString((String)"\u5165\u804c\u65e5\u671f\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u6267\u884c\u786e\u8ba4\u5165\u804c\u64cd\u4f5c\u3002", (String)"OnbrdConfirmValidatorService_16", (String)"hr-hom-business", (Object[])new Object[0]);
        }
        if (HRDateTimeUtils.dayAfter((Date)HRDateTimeUtils.truncateDate((Date)effectDate), (Date)currentDate) && !OnbrdValidateUtils.isSkipEffectDateValidate()) {
            return ResManager.loadKDString((String)"\u8fd8\u672a\u5230\u8fbe\u7ea6\u5b9a\u7684\u5165\u804c\u65e5\u671f\uff0c\u4e0d\u53ef\u786e\u8ba4\u5165\u804c\u3002", (String)"OnbrdConfirmValidatorService_17", (String)"hr-hom-business", (Object[])new Object[0]);
        }
        return null;
    }

    @Override
    public boolean checkIfInvalidWithField(DynamicObject onbrdBillInfo, String fieldName) {
        DynamicObject dynamicObject = onbrdBillInfo.getDynamicObject(fieldName);
        return !HRObjectUtils.isEmpty((Object)dynamicObject) && !HRStringUtils.equals((String)"1", (String)dynamicObject.getString("enable"));
    }

    public String checkIfInvalid(DynamicObject onbrdBillInfo) {
        StringBuilder invalidMesage = new StringBuilder();
        int invalidCount = 0;
        ImmutableMap fieldDisplayNameMap = ImmutableMap.builder().put((Object)"aposition", (Object)ResManager.loadKDString((String)"\u5c97\u4f4d", (String)"OnbrdConfirmValidatorService_24", (String)"hr-hom-business", (Object[])new Object[0])).put((Object)"stdposition", (Object)ResManager.loadKDString((String)"\u6807\u51c6\u5c97\u4f4d", (String)"OnbrdConfirmValidatorService_25", (String)"hr-hom-business", (Object[])new Object[0])).put((Object)"ajob", (Object)ResManager.loadKDString((String)"\u804c\u4f4d", (String)"OnbrdConfirmValidatorService_12", (String)"hr-hom-business", (Object[])new Object[0])).put((Object)"aadminorg", (Object)ResManager.loadKDString((String)"\u90e8\u95e8", (String)"OnbrdConfirmValidatorService_13", (String)"hr-hom-business", (Object[])new Object[0])).build();
        for (Map.Entry entry : fieldDisplayNameMap.entrySet()) {
            if (!this.checkIfInvalidWithField(onbrdBillInfo, (String)entry.getKey())) continue;
            if (invalidCount > 0) {
                invalidMesage.append('/');
            }
            invalidMesage.append((String)entry.getValue());
            ++invalidCount;
        }
        return invalidMesage.toString();
    }

    @Override
    public String checkOnbrdBillInfo(DynamicObject onbrdBillSimpleInfo) {
        Date effectDate = onbrdBillSimpleInfo.getDate("effectdate");
        if (effectDate == null) {
            return ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5165\u804c\u65e5\u671f\u3002", (String)"OnbrdConfirmValidatorService_6", (String)"hr-hom-business", (Object[])new Object[0]);
        }
        Date currentDate = new Date();
        StringBuilder checkTips = new StringBuilder();
        String invalidMesage = this.checkIfInvalid(onbrdBillSimpleInfo);
        if (DateUtils.isSameDay((Date)effectDate, (Date)currentDate)) {
            if (HRStringUtils.isNotEmpty((String)invalidMesage)) {
                checkTips.append(invalidMesage).append(ResManager.loadKDString((String)"\u5df2\u5931\u6548\uff0c\u8bf7\u53ca\u65f6\u4fee\u6539\u3002", (String)"OnbrdConfirmValidatorService_7", (String)"hr-hom-business", (Object[])new Object[0]));
            }
        } else if (HRDateTimeUtils.dayAfter((Date)effectDate, (Date)currentDate) && !OnbrdValidateUtils.isSkipEffectDateValidate()) {
            checkTips.append(ResManager.loadKDString((String)"\u8fd8\u672a\u5230\u8fbe\u7ea6\u5b9a\u7684\u5165\u804c\u65e5\u671f\uff0c\u4e0d\u53ef\u786e\u8ba4\u5165\u804c\u3002", (String)"OnbrdConfirmValidatorService_17", (String)"hr-hom-business", (Object[])new Object[0]));
        } else if (HRStringUtils.isNotEmpty((String)invalidMesage)) {
            checkTips.append(ResManager.loadKDString((String)"\u5165\u804c\u65e5\u671f\u5c0f\u4e8e\u5f53\u524d\u65e5\u671f\uff0c", (String)"OnbrdConfirmValidatorService_9", (String)"hr-hom-business", (Object[])new Object[0])).append(invalidMesage).append(ResManager.loadKDString((String)"\u5df2\u5931\u6548\uff0c\u8bf7\u518d\u6b21\u786e\u8ba4\u3002", (String)"OnbrdConfirmValidatorService_10", (String)"hr-hom-business", (Object[])new Object[0]));
        } else if (HRDateTimeUtils.dayAfter((Date)effectDate, (Date)currentDate) && OnbrdValidateUtils.isSkipEffectDateValidate()) {
            checkTips.append(ResManager.loadKDString((String)"\u5165\u804c\u65e5\u671f\u5927\u4e8e\u5f53\u524d\u65e5\u671f\uff0c\u8bf7\u518d\u6b21\u786e\u8ba4\u3002", (String)"OnbrdConfirmValidatorService_33", (String)"hr-hom-business", (Object[])new Object[0]));
        } else {
            checkTips.append(ResManager.loadKDString((String)"\u5165\u804c\u65e5\u671f\u65e9\u4e8e\u5f53\u524d\u65e5\u671f\uff0c\u8bf7\u518d\u6b21\u786e\u8ba4\u3002", (String)"OnbrdConfirmValidatorService_11", (String)"hr-hom-business", (Object[])new Object[0]));
        }
        return checkTips.toString();
    }

    @Override
    public Map<Long, String> checkEnableForDoComfirm(DynamicObject[] onbrdBillDetailInfos, String operateKey) {
        HashMap checkResultMap = Maps.newHashMapWithExpectedSize((int)onbrdBillDetailInfos.length);
        for (DynamicObject onbrdBillDetailInfo : onbrdBillDetailInfos) {
            String effectDateCheckResult;
            Long onbrdId2 = onbrdBillDetailInfo.getLong("id");
            ArrayList<String> errorMsgs = new ArrayList<String>();
            ArrayList<String> emptyFieldNames = new ArrayList<String>();
            Map<String, String> checkIfEmptyFieldMap = this.getRequiredFieldNameMap(onbrdBillDetailInfo);
            for (Map.Entry<String, String> entry : checkIfEmptyFieldMap.entrySet()) {
                Object object = onbrdBillDetailInfo.get(entry.getKey());
                if (!HRObjectUtils.isEmpty((Object)object)) continue;
                emptyFieldNames.add(entry.getValue());
                break;
            }
            if (!emptyFieldNames.isEmpty()) {
                errorMsgs.add(this.emptyFiledCheck(emptyFieldNames, operateKey, false, onbrdBillDetailInfo));
            }
            if (!IOnbrdBillDomainService.getInstance().isAuditPass(onbrdBillDetailInfo)) {
                if (IOnbrdBillDomainService.getInstance().isSaveStatus(onbrdBillDetailInfo)) {
                    errorMsgs.add(ResManager.loadKDString((String)"\u6570\u636e\u5904\u7406\u4e2d\uff0c\u8bf7\u7a0d\u540e\u64cd\u4f5c\u3002", (String)"OnbrdConfirmValidatorService_29", (String)"hr-hom-business", (Object[])new Object[0]));
                } else if ("btn_confirmcheckin".equals(operateKey)) {
                    errorMsgs.add(ResManager.loadKDString((String)"\u786e\u8ba4\u62a5\u5230\u5931\u8d25\uff0c\u8be5\u5019\u9009\u4eba\u672a\u5b8c\u6210\u5ba1\u6279\u3002", (String)"OnbrdConfirmValidatorService_26", (String)"hr-hom-business", (Object[])new Object[0]));
                } else {
                    errorMsgs.add(ResManager.loadKDString((String)"\u786e\u8ba4\u5165\u804c\u5931\u8d25\uff0c\u8be5\u5019\u9009\u4eba\u672a\u5b8c\u6210\u5ba1\u6279\u3002", (String)"OnbrdConfirmValidatorService_27", (String)"hr-hom-business", (Object[])new Object[0]));
                }
            }
            if (HRStringUtils.isNotEmpty((String)(effectDateCheckResult = OnbrdConfirmValidatorService.checkEffectDateIfLaterThanNow(onbrdBillDetailInfo.getDate("effectdate"))))) {
                errorMsgs.add(effectDateCheckResult);
            }
            String processStatus = onbrdBillDetailInfo.getString("processstatus");
            if (HRStringUtils.equals((String)ProcessStatusEnum.END_PROCESS.getValue(), (String)processStatus)) {
                if ("btn_confirmcheckin".equals(operateKey)) {
                    errorMsgs.add(ResManager.loadKDString((String)"\u5165\u804c\u6d41\u7a0b\u5df2\u7ed3\u675f\uff0c\u4e0d\u80fd\u6267\u884c\u786e\u8ba4\u62a5\u5230\u64cd\u4f5c\u3002", (String)"OnbrdConfirmValidatorService_23", (String)"hr-hom-business", (Object[])new Object[0]));
                } else {
                    errorMsgs.add(ResManager.loadKDString((String)"\u5165\u804c\u6d41\u7a0b\u5df2\u7ed3\u675f\uff0c\u4e0d\u80fd\u6267\u884c\u786e\u8ba4\u5165\u804c\u64cd\u4f5c\u3002", (String)"OnbrdConfirmValidatorService_22", (String)"hr-hom-business", (Object[])new Object[0]));
                }
            }
            checkResultMap.put(onbrdId2, String.join((CharSequence)System.lineSeparator(), errorMsgs));
        }
        Map<Long, String> validateEffectDateMap = IOnbrdCommonAppService.getInstance().validateEffectDateWithOrgField(onbrdBillDetailInfos);
        validateEffectDateMap.forEach((onbrdId, errMsg) -> {
            if (HRStringUtils.isNotEmpty((String)errMsg)) {
                String otherMsg = (String)checkResultMap.get(onbrdId);
                checkResultMap.put(onbrdId, HRStringUtils.isEmpty((String)otherMsg) ? errMsg : otherMsg + System.lineSeparator() + errMsg);
            }
        });
        return checkResultMap;
    }

    private Map<String, String> getRequiredFieldNameMap(DynamicObject onbrdBillDetailInfo) {
        HashMap<String, String> checkIfEmptyFieldMap = new HashMap<String, String>();
        this.getFieldName(onbrdBillDetailInfo, checkIfEmptyFieldMap, "effectdate", ResManager.loadKDString((String)"\u5165\u804c\u65e5\u671f", (String)"OnbrdConfirmValidatorService_1", (String)"hr-hom-business", (Object[])new Object[0]));
        this.getFieldName(onbrdBillDetailInfo, checkIfEmptyFieldMap, "employeeno", ResManager.loadKDString((String)"\u5de5\u53f7", (String)"OnbrdConfirmValidatorService_2", (String)"hr-hom-business", (Object[])new Object[0]));
        this.getFieldName(onbrdBillDetailInfo, checkIfEmptyFieldMap, "name", ResManager.loadKDString((String)"\u59d3\u540d", (String)"OnbrdConfirmValidatorService_3", (String)"hr-hom-business", (Object[])new Object[0]));
        this.getFieldName(onbrdBillDetailInfo, checkIfEmptyFieldMap, "candidate", ResManager.loadKDString((String)"\u5173\u8054\u7684\u5019\u9009\u4eba", (String)"OnbrdConfirmValidatorService_4", (String)"hr-hom-business", (Object[])new Object[0]));
        this.getFieldName(onbrdBillDetailInfo, checkIfEmptyFieldMap, "certificatenumber", ResManager.loadKDString((String)"\u8bc1\u4ef6\u53f7\u7801", (String)"OnbrdConfirmValidatorService_5", (String)"hr-hom-business", (Object[])new Object[0]));
        return checkIfEmptyFieldMap;
    }

    private void getFieldName(DynamicObject onbrdBillDetailInfo, Map<String, String> checkIfEmptyFieldMap, String key, String loadKDString) {
        String effectDate = onbrdBillDetailInfo.getDataEntityType().getProperties().containsKey((Object)key) ? ((IDataEntityProperty)onbrdBillDetailInfo.getDataEntityType().getProperties().get((Object)key)).getDisplayName().getLocaleValue() : loadKDString;
        checkIfEmptyFieldMap.put(key, effectDate);
    }

    private String emptyFiledCheck(List<String> emptyFileds, String operateKey, boolean isMobile, DynamicObject onbrdBillDetailInfo) {
        String service14;
        String kdString = ResManager.loadKDString((String)"\u5f85\u5165\u804c\u4eba\u5458\u7684\u201c%1$s\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff0c%2$s\u3002", (String)"OnbrdConfirmValidatorService_14", (String)"hr-hom-business", (Object[])new Object[0]);
        String s1 = ResManager.loadKDString((String)"\u8bf7\u524d\u5f80\u5165\u804c\u4eba\u5458\u4fe1\u606f\u5f55\u5165", (String)"OnbrdConfirmValidatorService_30", (String)"hr-hom-business", (Object[])new Object[0]);
        String s2 = ResManager.loadKDString((String)"\u8bf7\u5728\u5165\u804c\u529e\u7406\u5355\u8be6\u60c5\u9875\u5f55\u5165", (String)"OnbrdConfirmValidatorService_31", (String)"hr-hom-business", (Object[])new Object[0]);
        String s3 = ResManager.loadKDString((String)"\u8bf7\u5728\u5165\u804c\u529e\u7406\u5355\u8be6\u60c5\u9875\u5f55\u5165", (String)"OnbrdConfirmValidatorService_31", (String)"hr-hom-business", (Object[])new Object[0]);
        String s4 = ResManager.loadKDString((String)"\u8bf7\u5728\u5165\u804c\u529e\u7406\u5355\u8be6\u60c5\u9875\u5f55\u5165", (String)"OnbrdConfirmValidatorService_31", (String)"hr-hom-business", (Object[])new Object[0]);
        Map<String, String> nameMap = this.getRequiredFieldNameMap(onbrdBillDetailInfo);
        if (!"btn_confirmcheckin".equals(operateKey)) {
            ArrayList<String> list = new ArrayList<String>();
            ArrayList emptyList = new ArrayList();
            emptyFileds.forEach(emptyFiled -> {
                if (emptyFiled.equals(nameMap.get("certificatenumber"))) {
                    list.add(String.format(kdString, emptyFiled, s1));
                } else if (emptyFiled.equals(nameMap.get("employeeno"))) {
                    list.add(String.format(kdString, emptyFiled, s2));
                } else {
                    emptyList.add(emptyFiled);
                }
            });
            if (emptyList.size() != 0) {
                list.add(String.format(kdString, String.join((CharSequence)"\u3001", emptyList), s3));
            }
            service14 = String.join((CharSequence)"\n", list);
        } else {
            service14 = isMobile ? String.format(ResManager.loadKDString((String)"\u60a8\u7684%s\u6682\u672a\u751f\u6210\uff0c\u8bf7\u8054\u7cfb\u5165\u804c\u670d\u52a1\u4eba\u5458\u5904\u7406\u3002", (String)"OnbrdConfirmValidatorService_19", (String)"hr-hom-business", (Object[])new Object[0]), String.join((CharSequence)"\u3001", emptyFileds)) : String.format(kdString, String.join((CharSequence)"\u3001", emptyFileds), s4);
        }
        return service14;
    }

    @Override
    public Boolean checkInvalidForDoComfirm(DynamicObject onbrdBillDetailInfo, Map<String, Object> resultMap) {
        String invalidMsg = this.checkIfInvalid(onbrdBillDetailInfo);
        if (HRStringUtils.isNotEmpty((String)invalidMsg)) {
            StringBuilder allFailReason = new StringBuilder();
            Object failReason = resultMap.get("warnMessage");
            if (Objects.nonNull(failReason)) {
                allFailReason.append(failReason);
            }
            allFailReason.append(ResManager.loadKDString((String)"\u5b58\u5728\u5931\u6548\u4fe1\u606f", (String)"OnbrdConfirmValidatorService_18", (String)"hr-hom-business", (Object[])new Object[0])).append(':').append(invalidMsg);
            resultMap.put("warnMessage", allFailReason.toString());
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public Optional<String> checkIfIsEligibleOnboard(DynamicObject onbrdBillInfo, String operateKey) {
        Long onbrdBillId = onbrdBillInfo.getLong("id");
        return this.checkIfIsEligibleOnboard(new DynamicObject[]{onbrdBillInfo}, operateKey).get(onbrdBillId);
    }

    @Override
    public Map<Long, Optional<String>> checkIfIsEligibleOnboard(DynamicObject[] onbrdBillInfos, String operateKey) {
        HashMap checkResult = Maps.newHashMapWithExpectedSize((int)onbrdBillInfos.length);
        Map<Long, String> checkPersonIfExist = IOnbrdCommonAppService.getInstance().checkPersonIfExisted(onbrdBillInfos);
        Map<Long, Optional<String>> checkResultMap = this.baseCheckIfIsEligible(onbrdBillInfos, operateKey, false);
        for (DynamicObject onbrdBillInfo : onbrdBillInfos) {
            Long onbrdBillId = onbrdBillInfo.getLong("id");
            if (checkPersonIfExist != null && StringUtils.isNotEmpty((String)checkPersonIfExist.getOrDefault(onbrdBillId, ""))) {
                checkResult.put(onbrdBillId, Optional.of(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5f53\u524d\u64cd\u4f5c\u6570\u636e\u7684\u201c%s\u201d\u4e0e\u5728\u804c\u5458\u5de5\u5b58\u5728\u4fe1\u606f\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OnbrdConfirmAppServiceImpl_4", (String)"hr-hom-business", (Object[])new Object[0]), checkPersonIfExist.get(onbrdBillId))));
                continue;
            }
            checkResult.put(onbrdBillId, checkResultMap.get(onbrdBillId));
        }
        AtomicInteger num = new AtomicInteger();
        List<HomCommonWrapper> rowDataWrapperList = Arrays.stream(onbrdBillInfos).map(entity -> new HomCommonWrapper(entity, entity, num.getAndIncrement(), (Object)this, null)).collect(Collectors.toList());
        IOnbrdCommonValidator onbrdCommonValidator = IOnbrdCommonValidator.getInstance();
        onbrdCommonValidator.validNumber(rowDataWrapperList);
        onbrdCommonValidator.validateVirtuallyOrg(rowDataWrapperList);
        IValidEntryDateService.getInstance().validEntryDateOfQuitDateByMultiEntity(rowDataWrapperList);
        Map<Long, Queue> msg = rowDataWrapperList.stream().filter(rowData -> rowData.getErrorMsgNum() > 0).collect(Collectors.toMap(rowData -> rowData.getBizData().getLong("id"), HomCommonWrapper::getErrorMsgs));
        for (Map.Entry entry : msg.entrySet()) {
            checkResult.put(entry.getKey(), Optional.ofNullable(((Queue)entry.getValue()).peek()));
        }
        Set<Long> onbrdBillIds = Stream.of(onbrdBillInfos).map(onbrdBill -> onbrdBill.getLong("id")).collect(Collectors.toSet());
        checkResult.putAll(IStaffUseService.getInstance().validateStaffUse(onbrdBillIds, "UPDATE"));
        return checkResult;
    }

    @Override
    public Map<Long, Optional<String>> baseCheckIfIsEligible(DynamicObject[] onbrdBillInfos, String operateKey, boolean isMobile) {
        HashMap checkResult = Maps.newHashMapWithExpectedSize((int)onbrdBillInfos.length);
        Map<Long, Optional<String>> validateMustInput = IOnbrdCommonAppService.getInstance().confirmOnBrdValidateMustInputField(onbrdBillInfos);
        Map<Long, String> validateEffectDateMap = IOnbrdCommonAppService.getInstance().validateEffectDateWithOrgField(onbrdBillInfos);
        for (DynamicObject onbrdBillInfo : onbrdBillInfos) {
            String invalidResult;
            String validateResultEffectDate;
            Long onbrdBillId = onbrdBillInfo.getLong("id");
            ArrayList<String> errMsglist = new ArrayList<String>();
            ArrayList<String> emptyFieldNames = new ArrayList<String>();
            Map<String, String> checkIfEmptyFieldMap = this.getRequiredFieldNameMap(onbrdBillInfo);
            for (Map.Entry<String, String> entry : checkIfEmptyFieldMap.entrySet()) {
                Object object = onbrdBillInfo.get(entry.getKey());
                if (!HRObjectUtils.isEmpty((Object)object)) continue;
                emptyFieldNames.add(entry.getValue());
            }
            AtomicBoolean flag = new AtomicBoolean(true);
            HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create(null, IConfirmOnbrdService.class, (String)"kd.sdk.hr.hom.business.onbrd.IConfirmOnbrdService", null);
            hrPluginProxy.callReplace(hrPlugin -> {
                flag.set(hrPlugin.tpiInfo(errMsglist, emptyFieldNames, operateKey, isMobile, onbrdBillInfo));
                return null;
            });
            if (!emptyFieldNames.isEmpty() && flag.get()) {
                errMsglist.add(this.emptyFiledCheck(emptyFieldNames, operateKey, isMobile, onbrdBillInfo));
            }
            if (validateMustInput.containsKey(onbrdBillId)) {
                Optional<String> validateMustInputOptional = validateMustInput.get(onbrdBillId);
                validateMustInputOptional.ifPresent(errMsglist::add);
            }
            if (!IOnbrdBillDomainService.getInstance().isAuditPass(onbrdBillInfo)) {
                if (IOnbrdBillDomainService.getInstance().isSaveStatus(onbrdBillInfo)) {
                    errMsglist.add(ResManager.loadKDString((String)"\u6570\u636e\u5904\u7406\u4e2d\uff0c\u8bf7\u7a0d\u540e\u64cd\u4f5c\u3002", (String)"OnbrdConfirmValidatorService_29", (String)"hr-hom-business", (Object[])new Object[0]));
                } else if ("btn_confirmcheckin".equals(operateKey)) {
                    errMsglist.add(ResManager.loadKDString((String)"\u786e\u8ba4\u62a5\u5230\u5931\u8d25\uff0c\u8be5\u5019\u9009\u4eba\u672a\u5b8c\u6210\u5ba1\u6279\u3002", (String)"OnbrdConfirmValidatorService_26", (String)"hr-hom-business", (Object[])new Object[0]));
                } else {
                    errMsglist.add(ResManager.loadKDString((String)"\u786e\u8ba4\u5165\u804c\u5931\u8d25\uff0c\u8be5\u5019\u9009\u4eba\u672a\u5b8c\u6210\u5ba1\u6279\u3002", (String)"OnbrdConfirmValidatorService_27", (String)"hr-hom-business", (Object[])new Object[0]));
                }
            }
            Date effectDate = onbrdBillInfo.getDate("effectdate");
            Date currentDate = HRDateTimeUtils.truncateDate((Date)new Date());
            if (effectDate != null && HRDateTimeUtils.dayAfter((Date)HRDateTimeUtils.truncateDate((Date)effectDate), (Date)currentDate) && !OnbrdValidateUtils.isSkipEffectDateValidate()) {
                errMsglist.add(ResManager.loadKDString((String)"\u8fd8\u672a\u5230\u8fbe\u7ea6\u5b9a\u7684\u5165\u804c\u65e5\u671f\uff0c\u4e0d\u53ef\u786e\u8ba4\u5165\u804c\u3002", (String)"OnbrdConfirmValidatorService_20", (String)"hr-hom-business", (Object[])new Object[0]));
            }
            Date validunitl = onbrdBillInfo.getDate("validuntil");
            if (effectDate != null && validunitl != null && HRDateTimeUtils.dayAfter((Date)effectDate, (Date)validunitl)) {
                String format = HRDateTimeUtils.format((Date)validunitl, (String)"yyyy-MM-dd");
                errMsglist.add(String.format(ResManager.loadKDString((String)"\u5165\u804c\u65e5\u671f\u9700\u5728\u5165\u804c\u6709\u6548\u671f\uff08%s\uff09\u5185\u3002", (String)"ReservationOnbrdPlugin_3", (String)"hr-hom-formplugin", (Object[])new Object[0]), format));
            }
            if (HRStringUtils.isNotEmpty((String)(validateResultEffectDate = validateEffectDateMap.get(onbrdBillId)))) {
                errMsglist.add(validateResultEffectDate);
            }
            String processStatus = onbrdBillInfo.getString("processstatus");
            if (HRStringUtils.equals((String)ProcessStatusEnum.END_PROCESS.getValue(), (String)processStatus)) {
                if ("btn_confirmcheckin".equals(operateKey)) {
                    errMsglist.add(ResManager.loadKDString((String)"\u5165\u804c\u6d41\u7a0b\u5df2\u7ed3\u675f\uff0c\u4e0d\u80fd\u6267\u884c\u786e\u8ba4\u62a5\u5230\u64cd\u4f5c\u3002", (String)"OnbrdConfirmValidatorService_23", (String)"hr-hom-business", (Object[])new Object[0]));
                } else {
                    errMsglist.add(ResManager.loadKDString((String)"\u5165\u804c\u6d41\u7a0b\u5df2\u7ed3\u675f\uff0c\u4e0d\u80fd\u6267\u884c\u786e\u8ba4\u5165\u804c\u64cd\u4f5c\u3002", (String)"OnbrdConfirmValidatorService_22", (String)"hr-hom-business", (Object[])new Object[0]));
                }
            }
            if (HRStringUtils.isNotEmpty((String)(invalidResult = this.checkIfInvalid(onbrdBillInfo)))) {
                String suffix = ResManager.loadKDString((String)"\u5df2\u5931\u6548\uff0c\u8bf7\u8c03\u6574\u3002", (String)"OnbrdConfirmValidatorService_28", (String)"hr-hom-business", (Object[])new Object[0]);
                errMsglist.add(invalidResult + suffix);
            }
            checkResult.put(onbrdBillId, errMsglist.isEmpty() ? Optional.empty() : Optional.of(String.join((CharSequence)"\n", errMsglist)));
        }
        return checkResult;
    }

    @Override
    public Optional<String> baseCheckIfIsEligible(DynamicObject onbrdBillInfo, String operateKey, boolean isMobile) {
        Map<Long, Optional<String>> checkResultMap = this.baseCheckIfIsEligible(new DynamicObject[]{onbrdBillInfo}, operateKey, isMobile);
        return checkResultMap.get(onbrdBillInfo.getLong("id"));
    }

    @Override
    public boolean checkCertCountForOnbrdConfirm(IFormView formView, int count, String operateKey) {
        Map verifyResult = HRCertCommonHelper.verifyCertCount((String)"1WXB5G9/BL46", (String)"hom_onbrdpersonlist", (int)count);
        this.logger.info("HRCertCommonHelper.verifyCertCount: {}", JSONObject.toJSON((Object)verifyResult));
        String verifyCertInfoType = (String)verifyResult.get("infoType");
        boolean ifShowMessage = Boolean.parseBoolean((String)verifyResult.get("showMessage"));
        boolean isForbidden = HRStringUtils.equals((String)HRCertPromptInfoTypeEnum.FORBIDDEN.getName(), (String)verifyCertInfoType);
        if (ifShowMessage) {
            String verifyCertMessage = (String)verifyResult.get("message");
            if (isForbidden) {
                formView.showErrorNotification(verifyCertMessage);
            } else {
                formView.showTipNotification(verifyCertMessage);
            }
        }
        return !isForbidden;
    }

    @Override
    public boolean checkCertCountForConfirmNoTips(int count, String operateKey) {
        Map verifyResult = HRCertCommonHelper.verifyCertCount((String)"1WXB5G9/BL46", (String)"hom_onbrdpersonlist", (int)count);
        this.logger.info("HRCertCommonHelper.verifyCertCount: {}", JSONObject.toJSON((Object)verifyResult));
        String verifyCertInfoType = (String)verifyResult.get("infoType");
        return !HRStringUtils.equals((String)HRCertPromptInfoTypeEnum.FORBIDDEN.getName(), (String)verifyCertInfoType);
    }

    @Override
    public Map<Long, Map<String, Object>> reCheck(DynamicObject[] onbrdBillDetailInfoList, String operateKey) {
        HashMap allCheckResultMap = Maps.newHashMapWithExpectedSize((int)onbrdBillDetailInfoList.length);
        Map verifyResult = HRCertCommonHelper.verifyCertCount((String)"1WXB5G9/BL46", (String)"hom_onbrdpersonlist", (int)onbrdBillDetailInfoList.length);
        this.logger.info("HRCertCommonHelper.verifyCertCount: {}", (Object)HOMObjectUtils.toJSONString((Object)verifyResult));
        String verifyCertInfoType = (String)verifyResult.get("infoType");
        String verifyCertMessage = (String)verifyResult.get("message");
        for (DynamicObject onbrdBillDetailInfo : onbrdBillDetailInfoList) {
            Map<String, Object> resultMap = IOnbrdConfirmAppService.getInstance().getPersonInfoFeedbackMap(onbrdBillDetailInfo);
            resultMap.put("isSuccess", Boolean.TRUE);
            allCheckResultMap.put(onbrdBillDetailInfo.getLong("id"), resultMap);
            if (!HRStringUtils.equals((String)HRCertPromptInfoTypeEnum.FORBIDDEN.getName(), (String)verifyCertInfoType)) continue;
            resultMap.put("failReason", verifyCertMessage);
            resultMap.put("isSuccess", Boolean.FALSE);
        }
        Map<Long, String> baseCheckResultMap = IOnbrdConfirmValidatorService.getInstance().checkEnableForDoComfirm(onbrdBillDetailInfoList, operateKey);
        baseCheckResultMap.forEach((onbrdId, errMsg) -> {
            if (HRStringUtils.isNotEmpty((String)errMsg)) {
                Map resultMap = (Map)allCheckResultMap.get(onbrdId);
                resultMap.put("failReason", errMsg);
                resultMap.put("isSuccess", Boolean.FALSE);
            }
        });
        Map<Long, String> checkPersonResult = IOnbrdCommonAppService.getInstance().checkPersonIfExisted(onbrdBillDetailInfoList);
        checkPersonResult.forEach((onbrdId, fieldNames) -> {
            if (StringUtils.isNotEmpty((String)fieldNames)) {
                Map resultMap = (Map)allCheckResultMap.get(onbrdId);
                if (HRStringUtils.equals((String)ResManager.loadKDString((String)"\u4eba\u5458\u63a5\u53e3\u672a\u8fd4\u56de\u67e5\u8be2\u7ed3\u679c\u3002", (String)"OnbrdConfirmAppServiceImpl_7", (String)"hr-hom-business", (Object[])new Object[0]), (String)fieldNames)) {
                    resultMap.put("failReason", ResManager.loadKDString((String)"\u63a5\u53e3\u670d\u52a1\u5f02\u5e38\uff0c\u65e0\u6cd5\u6821\u9a8c\u4eba\u5458\u552f\u4e00\u6027\u3002", (String)"OnbrdConfirmAppServiceImpl_8", (String)"hr-hom-business", (Object[])new Object[0]));
                } else {
                    resultMap.put("failReason", String.format(ResManager.loadKDString((String)"\u5f53\u524d\u64cd\u4f5c\u6570\u636e\u7684\u201c%s\u201d\u4e0e\u5728\u804c\u5458\u5de5\u5b58\u5728\u4fe1\u606f\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OnbrdConfirmAppServiceImpl_4", (String)"hr-hom-business", (Object[])new Object[0]), fieldNames));
                }
                resultMap.put("isSuccess", Boolean.FALSE);
            }
        });
        AtomicInteger num = new AtomicInteger();
        List<HomCommonWrapper> rowDataWrapperList = Arrays.stream(onbrdBillDetailInfoList).map(entity -> new HomCommonWrapper(entity, entity, num.getAndIncrement(), (Object)this, null)).collect(Collectors.toList());
        IOnbrdCommonValidator onbrdCommonValidator = IOnbrdCommonValidator.getInstance();
        onbrdCommonValidator.validNumber(rowDataWrapperList);
        IValidEntryDateService.getInstance().validEntryDateOfQuitDateByMultiEntity(rowDataWrapperList);
        Map<Long, Queue> msg = rowDataWrapperList.stream().filter(rowData -> rowData.getErrorMsgNum() > 0).collect(Collectors.toMap(rowData -> rowData.getBizData().getLong("id"), HomCommonWrapper::getErrorMsgs));
        for (Map.Entry<Long, Queue> longQueueEntry : msg.entrySet()) {
            Map resultMap = (Map)allCheckResultMap.get(longQueueEntry.getKey());
            resultMap.put("failReason", Optional.ofNullable(longQueueEntry.getValue().peek()));
            resultMap.put("isSuccess", Boolean.FALSE);
        }
        Set<Long> onbrdBillIds = allCheckResultMap.keySet();
        Map<Long, Optional<String>> validateStaffUseMap = IStaffUseService.getInstance().validateStaffUse(onbrdBillIds, "UPDATE");
        validateStaffUseMap.forEach((onbrdId, validateStaffUseResult) -> {
            if (RequestContext.getOrCreate().getCurrUserId() != -1L && Optional.ofNullable(validateStaffUseResult).isPresent() && validateStaffUseResult.isPresent()) {
                Map resultMap = (Map)allCheckResultMap.get(onbrdId);
                resultMap.put("failReason", validateStaffUseResult.get());
                resultMap.put("isSuccess", Boolean.FALSE);
            }
        });
        return allCheckResultMap;
    }
}

