/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.business.application.impl.rule;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.cache.IHRAppCache;
import kd.hr.hbp.formplugin.web.imp.MultiEntityRowData;
import kd.hr.hom.business.application.rule.IOnbrdImportCacheService;
import kd.hr.hom.common.util.HOMObjectUtils;

public class OnbrdImportCacheService
implements IOnbrdImportCacheService {
    private static final Log logger = LogFactory.getLog(OnbrdImportCacheService.class);
    private static final String KEY_IMPORTNEWRECORD = "hom_import_new";
    private static final String KEY_IMPORTWRAPPASSED = "hom_import_wrappassed";
    private static final String KEY_CANDIDATE_EXCELNO = "hom_candidate_excelno";

    @Override
    public void putNewCandidateIdsToCache(Set<Long> candidateIds) {
        String traceId = RequestContext.get().getTraceId();
        logger.info("traceId:" + traceId + ",candidateIds:" + JSONObject.toJSONString(candidateIds));
        IHRAppCache cache = HRAppCache.get((String)KEY_IMPORTNEWRECORD);
        JSONObject jsonObject = (JSONObject)cache.get(traceId, JSONObject.class);
        if (jsonObject == null || jsonObject.isEmpty()) {
            jsonObject = new JSONObject();
            jsonObject.put("time", (Object)System.currentTimeMillis());
            jsonObject.put("candidateIds", candidateIds);
        } else {
            List candidateIdsLast = (List)jsonObject.getObject("candidateIds", List.class);
            candidateIdsLast.addAll(candidateIds);
            jsonObject.put("candidateIds", (Object)candidateIdsLast);
        }
        cache.put(traceId, (Object)jsonObject);
    }

    @Override
    public List<Long> getCurrentNewCandidateIds() {
        IHRAppCache cache = HRAppCache.get((String)KEY_IMPORTNEWRECORD);
        JSONObject jsonObject = (JSONObject)cache.get(RequestContext.get().getTraceId(), JSONObject.class);
        List<Long> candidateIds = new ArrayList<Long>();
        if (jsonObject != null && !jsonObject.isEmpty()) {
            candidateIds = (List)jsonObject.getObject("candidateIds", List.class);
        }
        logger.info(JSONObject.toJSONString(candidateIds));
        return candidateIds;
    }

    @Override
    public void putWrapPassedRelationInfoToCache(List<ImportBillData> onbrdBillRowdatas, ImportLogger importLogger) {
        Set checkFailedRows = importLogger.getLogCache().keySet();
        Map<String, Integer> passedRowdatasMap = onbrdBillRowdatas.stream().filter(rowdata -> {
            int rowNum = rowdata.getStartIndex();
            return !checkFailedRows.contains(rowNum);
        }).collect(Collectors.toMap(rowdata -> {
            JSONObject data = rowdata.getData().getJSONObject("data");
            String entityName = (String)data.keySet().iterator().next();
            JSONObject onbrdBillJson = data.getJSONObject(entityName);
            JSONObject candidateJson = onbrdBillJson.getJSONObject("candidate");
            return candidateJson.getString("number");
        }, rowdata -> rowdata.getStartIndex(), (oldValue, newValue) -> newValue));
        String traceId = RequestContext.get().getTraceId();
        logger.info("traceId:" + traceId + ",passedRowdatas:" + JSONObject.toJSONString(passedRowdatasMap));
        IHRAppCache cache = HRAppCache.get((String)KEY_IMPORTWRAPPASSED);
        Map<String, Integer> allRowdatasMap = (Map<String, Integer>)cache.get(traceId, Map.class);
        if (CollectionUtils.isEmpty((Map)allRowdatasMap)) {
            allRowdatasMap = passedRowdatasMap;
        } else {
            allRowdatasMap.putAll(passedRowdatasMap);
        }
        cache.put(traceId, allRowdatasMap);
    }

    @Override
    public Map<String, Integer> getWrapPassedRelationInfos() {
        IHRAppCache cache = HRAppCache.get((String)KEY_IMPORTWRAPPASSED);
        Map passedRowdatasMap = (Map)cache.get(RequestContext.get().getTraceId(), Map.class);
        return passedRowdatasMap == null ? new HashMap() : passedRowdatasMap;
    }

    @Override
    public Map<Integer, Long> getRelationInfosFromCache(String sheetName) {
        String traceId = RequestContext.get().getTraceId();
        logger.info("sheetName:" + sheetName + ",traceId" + traceId);
        IHRAppCache cache = HRAppCache.get((String)KEY_CANDIDATE_EXCELNO);
        JSONObject jsonObject = (JSONObject)cache.get(traceId, JSONObject.class);
        if (jsonObject == null || jsonObject.isEmpty()) {
            return new HashMap<Integer, Long>();
        }
        HashMap relationInfoStrMap = (HashMap)jsonObject.getObject(sheetName, Map.class);
        if (CollectionUtils.isEmpty((Map)relationInfoStrMap)) {
            relationInfoStrMap = new HashMap();
        }
        Map<Integer, Long> relationInfoMap = relationInfoStrMap.entrySet().stream().collect(Collectors.toMap(entry -> Integer.parseInt((String)entry.getKey()), entry -> (Long)entry.getValue(), (oldValue, newValue) -> newValue));
        return relationInfoMap;
    }

    @Override
    public void putRelationInfosToCache(List<MultiEntityRowData> rowDataList, String sheetName) {
        Map<Integer, Long> thisRelationInfoMap;
        HashMap<Integer, Long> relationInfoMap;
        String traceId = RequestContext.get().getTraceId();
        logger.info("start traceId:" + traceId + ", sheetName:" + sheetName);
        IHRAppCache cache = HRAppCache.get((String)KEY_CANDIDATE_EXCELNO);
        JSONObject traceJsonObject = (JSONObject)cache.get(traceId, JSONObject.class);
        if (traceJsonObject == null || traceJsonObject.isEmpty()) {
            traceJsonObject = new JSONObject();
        }
        if (CollectionUtils.isEmpty((Map)(relationInfoMap = (HashMap<Integer, Long>)traceJsonObject.getObject(sheetName, Map.class)))) {
            relationInfoMap = new HashMap<Integer, Long>(rowDataList.size());
        }
        if (!CollectionUtils.isEmpty(thisRelationInfoMap = rowDataList.stream().filter(rowData -> !HOMObjectUtils.isEmpty((Object)rowData.getOpEntity().getDynamicObject("candidate"))).collect(Collectors.toMap(MultiEntityRowData::getRownum, rowData -> rowData.getOpEntity().getLong("candidate.id"), (oldValue, newValue) -> newValue)))) {
            relationInfoMap.putAll(thisRelationInfoMap);
        }
        traceJsonObject.put(sheetName, relationInfoMap);
        cache.put(traceId, (Object)traceJsonObject);
        logger.info("start traceId:" + traceId + ", sheetName:" + sheetName);
    }
}

