/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.business.application.impl.rule;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hom.business.application.rule.IOnbrdImportCacheService;
import kd.hr.hom.business.application.rule.IOnbrdImportInitService;
import kd.hr.hom.business.domain.service.hcf.IHcfDataDomainService;
import kd.hr.hom.business.domain.service.onbrd.IOnbrdBillDomainService;
import kd.hr.hom.common.entity.DataDiv;
import kd.hr.hom.common.util.HOMObjectUtils;
import kd.sdk.hr.hom.business.onbrd.IOnbrdService;

public class OnbrdImportInitServiceImpl
implements IOnbrdImportInitService {
    private static final Log LOGGER = LogFactory.getLog(OnbrdImportInitServiceImpl.class);

    private List<DynamicObject> getCandidateNewList(Map<String, Tuple<Integer, String>> candidateMap, ImportLogger importLogger) {
        QFilter qFilter = new QFilter("number", "in", candidateMap.keySet());
        Map<String, DynamicObject> candidateFromDBMap = IHcfDataDomainService.getInstance().queryCandidate("number", new QFilter[]{qFilter});
        ArrayList<DynamicObject> candidateNewList = new ArrayList<DynamicObject>(candidateMap.size());
        for (Map.Entry<String, Tuple<Integer, String>> entry : candidateMap.entrySet()) {
            String number = entry.getKey();
            Tuple<Integer, String> recordTuple = entry.getValue();
            if (!HRObjectUtils.isEmpty((Object)candidateFromDBMap.get(number))) {
                importLogger.log((Integer)recordTuple.item1, ResManager.loadKDString((String)"\u5019\u9009\u4eba\u7f16\u53f7\u91cd\u590d;", (String)"OnbrdImportInitServiceImpl_1", (String)"hr-hom-business", (Object[])new Object[0]));
                continue;
            }
            DynamicObject candidateNew = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"hcf_candidate"));
            candidateNew.set("name", recordTuple.item2);
            candidateNew.set("number", (Object)number);
            candidateNewList.add(candidateNew);
        }
        if (candidateFromDBMap != null && !candidateFromDBMap.isEmpty()) {
            LOGGER.info("candidateFromDBMap:{}", (Object)JSONObject.toJSONString(candidateFromDBMap.keySet()));
        }
        return candidateNewList;
    }

    @Override
    public void validateDataFormat(List<ImportBillData> onbrdBillRowdatas, ImportLogger importLogger) {
        onbrdBillRowdatas.forEach(rowdata -> {
            JSONObject data = rowdata.getData().getJSONObject("data");
            String entityName = (String)data.keySet().iterator().next();
            int rowNum = rowdata.getStartIndex();
            JSONObject onbrdBillJson = data.getJSONObject(entityName);
            String name = onbrdBillJson.getString("name");
            if (HRStringUtils.isNotEmpty((String)name) && name.length() > 200) {
                importLogger.log(Integer.valueOf(rowNum), ResManager.loadKDString((String)"\u5b57\u6bb5\u201c\u59d3\u540d\u201d\u8f93\u5165\u957f\u5ea6\u8d85\u51fa\u9650\u5b9a\u8303\u56f4[0,200];", (String)"OnbrdImportInitServiceImpl_0", (String)"hr-hom-business", (Object[])new Object[0]));
            }
            String probationTime = onbrdBillJson.getString("probationtime");
            String isProbation = onbrdBillJson.getString("isprobation");
            String perprobationtime = onbrdBillJson.getString("perprobationtime");
            if ("true".equals(isProbation) && (HRStringUtils.isEmpty((String)probationTime) || HRStringUtils.isEmpty((String)perprobationtime))) {
                importLogger.log(Integer.valueOf(rowNum), ResManager.loadKDString((String)"\u662f\u5426\u8bd5\u7528\u671f\u4e3a\u201c\u662f\u201d\u65f6\uff0c\u5fc5\u987b\u586b\u5199\u8bd5\u7528\u671f\u548c\u8bd5\u7528\u671f\u9650\u5355\u4f4d\u3002", (String)"OnbrdImportValidator_4", (String)"hr-hom-business", (Object[])new Object[0]));
            }
            if (HRStringUtils.isNotEmpty((String)probationTime) && !HOMObjectUtils.checkIfInteger((String)probationTime)) {
                importLogger.log(Integer.valueOf(rowNum), ResManager.loadKDString((String)"\u8bd5\u7528\u671f\u683c\u5f0f\u9519\u8bef;", (String)"OnbrdImportInitServiceImpl_2", (String)"hr-hom-business", (Object[])new Object[0]));
            }
        });
    }

    @Override
    public void wrapOriginalJson(List<ImportBillData> rowdatas, Map<String, ImportLogger> importLoggerMap, String optionCode) {
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create(null, IOnbrdService.class, (String)"kd.sdk.hr.hom.business.onbrd.IOnbrdService", null);
        hrPluginProxy.callReplace(hrPlugin -> {
            hrPlugin.beforeWrapOriginalJson(rowdatas, importLoggerMap, optionCode);
            return null;
        });
        Map<String, List<ImportBillData>> sheetMap = rowdatas.stream().collect(Collectors.groupingBy(rowdata -> (String)rowdata.getData().getJSONObject("data").keySet().iterator().next()));
        List<ImportBillData> onbrdBillRowdatas = sheetMap.get("hom_personwaitstart");
        if (CollectionUtils.isEmpty(onbrdBillRowdatas)) {
            return;
        }
        if (!HRStringUtils.equals((String)optionCode, (String)"new")) {
            return;
        }
        ImportLogger importLogger = importLoggerMap.get("hom_personwaitstart");
        this.validateDataFormat(onbrdBillRowdatas, importLogger);
        HashMap<String, Tuple<Integer, String>> candidateMap = new HashMap<String, Tuple<Integer, String>>();
        onbrdBillRowdatas.forEach(rowdata -> {
            JSONObject data = rowdata.getData().getJSONObject("data");
            String entityName = (String)data.keySet().iterator().next();
            int rowNum = rowdata.getStartIndex();
            JSONObject onbrdBillJson = data.getJSONObject(entityName);
            JSONObject candidateJson = onbrdBillJson.getJSONObject("candidate");
            JSONObject nameJson = onbrdBillJson.getJSONObject("name");
            String name = "";
            if (Objects.nonNull(nameJson)) {
                name = nameJson.getString("zh_CN");
            }
            if (candidateJson == null || candidateJson.isEmpty()) {
                importLogger.log(Integer.valueOf(rowNum), ResManager.loadKDString((String)"\u5019\u9009\u4eba\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a;", (String)"OnbrdImportInitServiceImpl_28", (String)"hr-hom-business", (Object[])new Object[0]));
                return;
            }
            String candidateNum = candidateJson.getString("number");
            Tuple recordFromExcel = (Tuple)candidateMap.get(candidateNum);
            if (recordFromExcel != null) {
                importLogger.log(Integer.valueOf(rowNum), ResManager.loadKDString((String)"\u5019\u9009\u4eba\u7f16\u53f7\u91cd\u590d;", (String)"OnbrdImportInitServiceImpl_1", (String)"hr-hom-business", (Object[])new Object[0]));
            } else {
                candidateMap.put(candidateNum, Tuple.create((Object)rowNum, (Object)name));
            }
            boolean isCadre = Boolean.TRUE.equals(onbrdBillJson.getBoolean("iscadre"));
            JSONObject cadreType = onbrdBillJson.getJSONObject("cadretype");
            String appDispatchNum = onbrdBillJson.getString("appdispatchnum");
            DataDiv<Object> dataDiv = IOnbrdBillDomainService.getInstance().validateImportCadreInfo(isCadre, cadreType, appDispatchNum);
            if (!HRCollUtil.isEmpty((Collection)dataDiv.getErrMsgs())) {
                for (String errMsg : dataDiv.getErrMsgs()) {
                    importLogger.log(Integer.valueOf(rowNum), errMsg);
                }
            }
        });
        LOGGER.info("candidateMap from excel:" + JSONObject.toJSON(candidateMap));
        List<DynamicObject> candidateNewList = this.getCandidateNewList(candidateMap, importLogger);
        if (!CollectionUtils.isEmpty(candidateNewList)) {
            Map<String, DynamicObject> saveResult = IHcfDataDomainService.getInstance().saveCandidate(candidateNewList.toArray(new DynamicObject[candidateNewList.size()]));
            Set<Long> candidateIds = saveResult.values().stream().map(candidate -> candidate.getLong("id")).collect(Collectors.toSet());
            IOnbrdImportCacheService.getInstance().putNewCandidateIdsToCache(candidateIds);
        }
        IOnbrdImportCacheService.getInstance().putWrapPassedRelationInfoToCache(onbrdBillRowdatas, importLogger);
    }
}

