/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.business.application.impl.ssc;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hom.business.domain.repository.common.HomCommonRepository;
import kd.hr.hom.business.domain.service.ssc.AbstractBuildButtonViewService;
import kd.hr.hom.common.enums.CollectApproveStatusEnum;
import kd.hr.hom.common.enums.OnbrdStatusEnum;

public class OnbrdApproveBtnViewStrategy
extends AbstractBuildButtonViewService {
    private static final String APPROVE_PASS_KEY = "approvepass";
    private static final String APPROVE_PASS_OP = "donothing_approvepass";
    private static final String APPROVE_REJECT_KEY = "approvereject";
    private static final String APPROVE_REJECT_OP = "donothing_approvereject";
    private static final String APPROVE_FAIL_KEY = "approvefail";
    private static final String APPROVE_FAIL_OP = "donothing_approvefail";

    @Override
    public Map<String, Object> buildButtonViewInfo(Long activityId) {
        DynamicObject collectDy = HomCommonRepository.queryDynamicObjectByPk("hom_collect", "onboard,approvestatus", activityId);
        if (HRObjectUtils.isEmpty((Object)collectDy)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5165\u804c\u6d3b\u52a8\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\u3002", (String)"OnbrdApproveBtnViewStrategy_4", (String)"hr-hom-business", (Object[])new Object[0]));
        }
        String enrollStatus = collectDy.getString("onboard.enrollstatus");
        String approveStatus = collectDy.getString("approvestatus");
        OnbrdStatusEnum onbrdStatusEnum = OnbrdStatusEnum.getOnbrdStatusEnumByValue((String)enrollStatus);
        List<Map<String, String>> buttons = new ArrayList<Map<String, String>>();
        switch (onbrdStatusEnum) {
            case WAIT_ONBRD: {
                buttons = this.getButtonInfoWaitOnBrdByAuditStatus(approveStatus);
                break;
            }
            case HAS_ONBRD: 
            case BREAK_UP: {
                buttons.add(this.buildCommonCloseButton());
                break;
            }
        }
        return this.buildResultData(activityId, buttons, CollectApproveStatusEnum.valueByStatus((String)approveStatus).getPageId());
    }

    private List<Map<String, String>> getButtonInfoWaitOnBrdByAuditStatus(String approveStatus) {
        ArrayList<Map<String, String>> buttonList = new ArrayList<Map<String, String>>();
        CollectApproveStatusEnum collectApproveStatusEnum = CollectApproveStatusEnum.valueByStatus((String)approveStatus);
        switch (collectApproveStatusEnum) {
            case APPROVING: {
                buttonList.add(this.buildButtonInfo(APPROVE_PASS_KEY, APPROVE_PASS_OP, ResManager.loadKDString((String)"\u5ba1\u6838\u901a\u8fc7", (String)"OnbrdApproveBtnViewStrategy_0", (String)"hr-hom-business", (Object[])new Object[0])));
                buttonList.add(this.buildButtonInfo(APPROVE_REJECT_KEY, APPROVE_REJECT_OP, ResManager.loadKDString((String)"\u9a73\u56de\u4fee\u6539", (String)"OnbrdApproveBtnViewStrategy_1", (String)"hr-hom-business", (Object[])new Object[0])));
                buttonList.add(this.buildButtonInfo(APPROVE_FAIL_KEY, APPROVE_FAIL_OP, ResManager.loadKDString((String)"\u5ba1\u6838\u4e0d\u901a\u8fc7", (String)"OnbrdApproveBtnViewStrategy_2", (String)"hr-hom-business", (Object[])new Object[0])));
                buttonList.add(this.buildCommonCloseButton());
                break;
            }
            case REJECT: {
                buttonList.add(this.buildCommonSubmitButton());
                buttonList.add(this.buildButtonInfo("notice", "donothing_notice", ResManager.loadKDString((String)"\u4e00\u952e\u63d0\u9192", (String)"OnbrdApproveBtnViewStrategy_3", (String)"hr-hom-business", (Object[])new Object[0])));
                buttonList.add(this.buildCommonCloseButton());
                break;
            }
            case PASS: 
            case FAIL: 
            case REMIT: {
                buttonList.add(this.buildCommonCloseButton());
                break;
            }
        }
        return buttonList;
    }
}

