/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.business.domain.repository.config;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRMapUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hom.common.enums.InfoGroupFieldTypeEnum;

public class CollectConfigRepository {
    private static final Log LOGGER = LogFactory.getLog(CollectConfigRepository.class);
    private static final HRBaseServiceHelper COLLECT_CONFIG_HIS_SERVICE_HELPER = new HRBaseServiceHelper("hom_infocollectconfighis");
    private static final HRBaseServiceHelper HBSS_CREDENTIALS_TYPE = new HRBaseServiceHelper("hbss_credentialstype");

    public static DynamicObject[] queryCredentialsType(String properties, QFilter ... qFilter) {
        return HBSS_CREDENTIALS_TYPE.query(properties, qFilter);
    }

    public static DynamicObject queryCollectConfigHisById(String properties, Long id) {
        DynamicObject configDy = COLLECT_CONFIG_HIS_SERVICE_HELPER.loadDynamicObject(new QFilter[]{new QFilter("id", "=", (Object)id)});
        CollectConfigRepository.filterDeletedFields(configDy);
        return configDy;
    }

    private static void filterDeletedFields(DynamicObject configDy) {
        DynamicObjectCollection groups;
        if (configDy != null && !CollectionUtils.isEmpty((Collection)(groups = configDy.getDynamicObjectCollection("infogroupentity")))) {
            for (DynamicObject group : groups) {
                DynamicObjectCollection fieldCollection = group.getDynamicObjectCollection("infofieldentity");
                if (CollectionUtils.isEmpty((Collection)fieldCollection)) continue;
                HashMap groupProMap = new HashMap(4);
                fieldCollection.removeIf(val -> {
                    if (val.getInt("field.fieldtype") == Integer.parseInt(InfoGroupFieldTypeEnum.TEXT.getFieldType())) {
                        String pageKey = val.getString("field.pageid");
                        Map allFields = (Map)groupProMap.get(pageKey);
                        if (allFields == null && !HRStringUtils.isBlank((CharSequence)pageKey)) {
                            try {
                                MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)pageKey);
                                if (!HRObjectUtils.isEmpty((Object)dataEntityType)) {
                                    allFields = dataEntityType.getAllFields();
                                    groupProMap.put(pageKey, allFields);
                                }
                            }
                            catch (NullPointerException e) {
                                LOGGER.error("filter_deletedfield: getDataEntityType error, pageKey:{}", (Object)pageKey);
                            }
                        }
                        String fieldKey = val.getString("field.fieldnumber");
                        if (!HRMapUtils.isEmpty((Map)allFields) && allFields.get(fieldKey) == null) {
                            LOGGER.info("filter_deletedfield:{}-{}", (Object)pageKey, (Object)fieldKey);
                            return true;
                        }
                    }
                    return false;
                });
            }
        }
    }
}

