/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.business.domain.service;

import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.resource.ResManager;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.sdk.hr.hom.common.annotation.Service;

public class ServiceFactory<T> {
    private static Map<String, String> serviceMap = new HashMap<String, String>(16);

    public static <T> T getService(Class<T> clazz) {
        return (T)ServiceFactory.getService(clazz.getSimpleName());
    }

    public static Object getService(String serviceName) {
        String className = serviceMap.get(serviceName);
        if (className == null) {
            Object service = kd.bos.service.ServiceFactory.getService((String)serviceName);
            if (service == null) {
                throw new RuntimeException(String.format(ResManager.loadKDString((String)"\u672a\u627e\u5230\u201c%s\u201d\u5bf9\u5e94\u7684\u670d\u52a1\u5b9e\u73b0\u3002", (String)"ServiceFactory_0", (String)"hr-hom-business", (Object[])new Object[0]), serviceName));
            }
            return service;
        }
        return TypesContainer.getOrRegisterSingletonInstance((String)className);
    }

    public static <T> T getImplService(Class<T> clazz, String serviceName) {
        ServiceLoader<T> load = ServiceLoader.load(clazz);
        for (T chain : load) {
            String value;
            Service annotation = chain.getClass().getAnnotation(Service.class);
            kd.hr.hom.business.application.common.Service annotationDeprecated = chain.getClass().getAnnotation(kd.hr.hom.business.application.common.Service.class);
            if (!(!HRObjectUtils.isEmpty((Object)annotation) ? serviceName.equalsIgnoreCase(value = annotation.value()) : !HRObjectUtils.isEmpty((Object)annotationDeprecated) && serviceName.equalsIgnoreCase(value = annotationDeprecated.value()))) continue;
            return chain;
        }
        return null;
    }

    public static <T> Map<String, T> getImplService(Class<T> clazz) {
        HashMap<String, T> result = new HashMap<String, T>();
        ServiceLoader<T> load = ServiceLoader.load(clazz);
        for (T chain : load) {
            Service annotation = chain.getClass().getAnnotation(Service.class);
            if (HRObjectUtils.isEmpty((Object)annotation)) continue;
            String value = annotation.value();
            result.put(value, chain);
        }
        return result;
    }

    static {
        serviceMap.put("IShowEmbedPageService", "kd.hr.hom.business.application.impl.page.ShowEmbedPageServiceImpl");
        serviceMap.put("IPutValueToModelService", "kd.hr.hom.business.application.impl.page.PutValueToModelService");
        serviceMap.put("IHomToHcfAppService", "kd.hr.hom.business.application.impl.hcf.HomToHcfAppServiceImpl");
        serviceMap.put("IAttachmentAppService", "kd.hr.hom.business.application.impl.onbrd.AttachmentAppServiceImpl");
        serviceMap.put("IHomToHrcsAppService", "kd.hr.hom.business.application.impl.hrcs.HomToHrcsAppServiceImpl");
        serviceMap.put("IOnbrdCommonAppService", "kd.hr.hom.business.application.impl.onbrd.OnbrdCommonAppServiceImpl");
        serviceMap.put("IPersonFileIntegrateService", "kd.hr.hom.business.application.impl.hpfs.PersonFileIntegrateServiceImpl");
        serviceMap.put("IAcceptManageService", "kd.hr.hom.business.domain.service.impl.collect.AcceptManageServiceImpl");
        serviceMap.put("IMobCommonAppService", "kd.hr.hom.business.application.impl.mobile.MobMobCommonAppServiceImpl");
        serviceMap.put("IHomToCvpAppService", "kd.hr.hom.business.application.impl.cvp.HomToCvpAppServiceImpl");
        serviceMap.put("IOnbrdReservationService", "kd.hr.hom.business.application.impl.onbrd.OnbrdReservationServiceImpl");
        serviceMap.put("IHomFaceDetectService", "kd.hr.hom.business.application.impl.cvp.HomFaceDetectServiceImpl");
        serviceMap.put("IOnbrdCommonValidator", "kd.hr.hom.business.application.impl.rule.OnbrdCommonValidator");
        serviceMap.put("IOnbrdImportCacheService", "kd.hr.hom.business.application.impl.rule.OnbrdImportCacheService");
        serviceMap.put("IOnbrdBreakupAppService", "kd.hr.hom.business.application.impl.onbrd.OnbrdBreakupAppServiceImpl");
        serviceMap.put("IOnbrdBillService", "kd.hr.hom.business.application.impl.tsc.OnbrdBillServiceImpl");
        serviceMap.put("IBreakupOnbrdBillService", "kd.hr.hom.business.application.impl.tsc.BreakupOnbrdBillServiceImpl");
        serviceMap.put("IStaffUseService", "kd.hr.hom.business.application.impl.staff.StaffUseServiceImpl");
        serviceMap.put("IContactInfoService", "kd.hr.hom.business.application.impl.extension.ContactInfoServiceImpl");
        serviceMap.put("IOnbrdConfirmValidatorService", "kd.hr.hom.business.application.impl.rule.OnbrdConfirmValidatorService");
        serviceMap.put("IOnbrdBillDomainService", "kd.hr.hom.business.domain.service.impl.onbrd.OnbrdBillDomainService");
        serviceMap.put("IOnbrdCheckinDomainService", "kd.hr.hom.business.domain.service.impl.checkin.OnbrdCheckinDomainService");
        serviceMap.put("IHcfDataDomainService", "kd.hr.hom.business.domain.service.impl.hcf.HcfDataDomainService");
        serviceMap.put("IActivityDomainService", "kd.hr.hom.business.domain.service.impl.activity.ActivityDomainService");
        serviceMap.put("ICollectService", "kd.hr.hom.business.domain.service.impl.collect.CollectServiceImpl");
        serviceMap.put("IUploadConfigDomainService", "kd.hr.hom.business.domain.service.impl.base.UploadConfigDomainServiceImpl");
        serviceMap.put("ICollectMatchTemplateService", "kd.hr.hom.business.domain.service.impl.collect.CollectMatchTemplateServiceImpl");
        serviceMap.put("IHomRuleEngineService", "kd.hr.hom.business.domain.service.impl.common.HomRuleEngineServiceImpl");
        serviceMap.put("ISendMessageService", "kd.hr.hom.business.domain.service.impl.common.SendMessageServiceImpl");
        serviceMap.put("IActivityManageService", "kd.hr.hom.business.domain.service.impl.activity.ActivityManageServiceImpl");
        serviceMap.put("IHomDataMutexService", "kd.hr.hom.business.domain.service.impl.common.HomDataMutexServiceImpl");
        serviceMap.put("IBaseDataDomainService", "kd.hr.hom.business.domain.service.impl.common.BaseDataDomainServiceImpl");
        serviceMap.put("ISyncCollectToHcf", "kd.hr.hom.business.domain.service.impl.collect.SyncCollectToHcfImpl");
        serviceMap.put("ISyncCollectFromHcf", "kd.hr.hom.business.domain.service.impl.collect.SyncCollectFromHcfImpl");
        serviceMap.put("ICollectApproveLogService", "kd.hr.hom.business.domain.service.impl.collect.CollectApproveLogServiceImpl");
        serviceMap.put("IOnbrdInviteDomainService", "kd.hr.hom.business.domain.service.impl.invite.OnbrdInviteDomainService");
        serviceMap.put("ICollectGroupStatusService", "kd.hr.hom.business.domain.service.impl.collect.CollectGroupStatusServiceImpl");
        serviceMap.put("ICooperationManageService", "kd.hr.hom.business.domain.service.impl.collect.CooperatonManageServiceImpl");
        serviceMap.put("IActivityCommonInfoService", "kd.hr.hom.business.domain.service.impl.activity.ActivityCommonInfoServiceImpl");
        serviceMap.put("ICollectFieldVerifyService", "kd.hr.hom.business.domain.service.impl.collect.CollectFieldVerifyServiceImpl");
        serviceMap.put("IHbpmDataDomainService", "kd.hr.hom.business.domain.service.impl.hbpm.HbpmDataDomainService");
        serviceMap.put("IHbjmDataDomainService", "kd.hr.hom.business.domain.service.impl.hbjm.HbjmDataDomainService");
        serviceMap.put("IHrCertCommonAppService", "kd.hr.hom.business.application.impl.hbp.IHrCertCommonAppServiceImpl");
        serviceMap.put("IIntegrateService", "kd.hr.hom.business.domain.service.impl.integrate.IntegrateService");
        serviceMap.put("IHomToHrpiAppService", "kd.hr.hom.business.application.impl.hrpi.HomToHrpiAppService");
        serviceMap.put("IHomConfigDomainService", "kd.hr.hom.business.domain.service.impl.base.HomConfigDomainServiceImpl");
        serviceMap.put("IPreOpenFormCheckService", "kd.hr.hom.business.domain.service.impl.common.PreOpenFormCheckServiceImpl");
        serviceMap.put("IHomConfigService", "kd.hr.hom.business.domain.service.impl.common.HomConfigServiceImpl");
        serviceMap.put("ICreateOnbrdBillDomainService", "kd.hr.hom.business.domain.service.impl.tsc.CreateOnbrdBillDomainServiceImpl");
        serviceMap.put("IOnbrdInfoInitService", "kd.hr.hom.business.domain.service.impl.onbrd.OnbrdInfoInitService");
        serviceMap.put("IBreakupOnbrdBillDomainService", "kd.hr.hom.business.domain.service.impl.tsc.BreakupOnbrdBillDomainServiceImpl");
        serviceMap.put("ICollectValidateService", "kd.hr.hom.business.domain.service.impl.collect.CollectValidateServiceImpl");
        serviceMap.put("ICertificatePageService", "kd.hr.hom.business.application.impl.page.CertificatePageServiceImpl");
        serviceMap.put("IOnbrdWorkTableService", "kd.hr.hom.business.application.impl.onbrd.OnbrdWorkTableServiceImpl");
        serviceMap.put("IOnbrdService", "kd.hr.hom.business.domain.service.impl.onbrd.OnbrdServiceImpl");
        serviceMap.put("IOnbrdConfirmAppService", "kd.hr.hom.business.application.impl.onbrd.OnbrdConfirmAppServiceImpl");
        serviceMap.put("IDevParamConfigExternalService", "kd.hr.hom.business.application.impl.hpfs.DevParamConfigExternalServiceImpl");
        serviceMap.put("IHrmpExternalService", "kd.hr.hom.business.application.impl.hbpm.HrmpExternalServiceImpl");
        serviceMap.put("IQueryVidService", "kd.hr.hom.business.application.impl.onbrd.QueryVidServiceImpl");
        serviceMap.put("IPerChgBizService", "kd.hr.hom.business.application.impl.hpfs.IPerChgBizServiceImpl");
        serviceMap.put("IHsbsExternalService", "kd.hr.hom.business.application.impl.hsbs.HsbsExternalServiceImpl");
        serviceMap.put("IRepealOnbrdConfirmService", "kd.hr.hom.business.application.impl.onbrd.RepealOnbrdConfirmServiceImpl");
        serviceMap.put("IHpfsDataDomainService", "kd.hr.hom.business.domain.service.impl.hpfs.HpfsDataDomainService");
        serviceMap.put("IBlackListService", "kd.hr.hom.business.application.impl.blacklist.BlackListServiceImpl");
        serviceMap.put("IPreOnBrdService", "kd.hr.hom.business.domain.service.impl.preonbrd.PreOnBrdServiceImpl");
        serviceMap.put("IValidEntryDateService", "kd.hr.hom.business.application.impl.onbrd.ValidEntryDateServiceImpl");
        serviceMap.put("BuildApproveFailFormStrategy", "kd.hr.hom.business.application.impl.ssc.BuildApproveFailFormStrategy");
        serviceMap.put("BuildApproveRejectFormStrategy", "kd.hr.hom.business.application.impl.ssc.BuildApproveRejectFormStrategy");
        serviceMap.put("IOnbrdShareService", "kd.hr.hom.business.application.impl.onbrd.OnbrdShareServiceImpl");
        serviceMap.put("OnbrdApproveBtnViewStrategy", "kd.hr.hom.business.application.impl.ssc.OnbrdApproveBtnViewStrategy");
        serviceMap.put("OnbrdCollaborateBtnViewStrategy", "kd.hr.hom.business.application.impl.ssc.OnbrdCollaborateBtnViewStrategy");
        serviceMap.put("OnbrdCollectBtnViewStrategy", "kd.hr.hom.business.application.impl.ssc.OnbrdCollectBtnViewStrategy");
        serviceMap.put("BuildCollMatchTempFormStrategy", "kd.hr.hom.business.application.impl.ssc.BuildCollMatchTempFormStrategy");
        serviceMap.put("IBdInfoGroupService", "kd.hr.hom.business.domain.service.impl.base.BdInfoGroupServiceImpl");
    }
}

