/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.business.domain.service.impl.collect;

import java.text.MessageFormat;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hom.business.domain.repository.common.HomCommonRepository;
import kd.hr.hom.business.domain.repository.config.CollectConfigRepository;
import kd.hr.hom.business.domain.service.ServiceFactory;
import kd.hr.hom.business.domain.service.collect.ICollectGroupStatusService;
import kd.hr.hom.business.domain.service.collect.ICollectService;
import kd.hr.hom.common.entity.InfoGroupConfigEntity;
import kd.hr.hom.common.enums.InfoGroupStatusEnum;

public class CollectGroupStatusServiceImpl
implements ICollectGroupStatusService {
    private static final Log logger = LogFactory.getLog(CollectGroupStatusServiceImpl.class);

    @Override
    public void saveCollectGroupStatus(DynamicObject dynamicObject) {
        if (HRObjectUtils.isEmpty((Object)dynamicObject)) {
            logger.warn("collect activity is empty");
            return;
        }
        long id = dynamicObject.getLong("id");
        long collectConfigHisId = (dynamicObject = HomCommonRepository.queryDynamicObjectByPk("hom_collect", "", id)).getLong("collectconfighis.id");
        if (collectConfigHisId == 0L) {
            logger.info(MessageFormat.format("\u91c7\u96c6\u6d3b\u52a8{0}\u672a\u5339\u914d\u5230\u91c7\u96c6\u6a21\u677f", id));
            return;
        }
        try {
            DynamicObject dyn = HomCommonRepository.queryDynamicObject("hom_collectgroupstatus", "id", new QFilter("collectactivity", "=", (Object)id));
            if (!HRObjectUtils.isEmpty((Object)dyn)) {
                logger.info(MessageFormat.format("\u91c7\u96c6\u6d3b\u52a8{0}\u5df2\u521d\u59cb\u5316\u6570\u636e\uff0c\u4e0d\u518d\u91cd\u590d\u521b\u5efa", id));
                return;
            }
            DynamicObject dataEntity = CollectConfigRepository.queryCollectConfigHisById("", collectConfigHisId);
            InfoGroupConfigEntity infoGroupConfigEntity = ServiceFactory.getService(ICollectService.class).transferDynToEntity(dataEntity);
            HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("hom_collectgroupstatus");
            DynamicObject collectGroupStatus = hrBaseServiceHelper.generateEmptyDynamicObject();
            collectGroupStatus.set("collectactivity", (Object)id);
            infoGroupConfigEntity.getInfoGroupEntityList().forEach(infoGroupEntity -> {
                DynamicObject infogroupentry = collectGroupStatus.getDynamicObjectCollection("infogroupentry").addNew();
                infogroupentry.set("infogroup", (Object)infoGroupEntity.getInfoGroupId());
                infogroupentry.set("infogroupstatus", (Object)InfoGroupStatusEnum.UN_COMPLETE.getStatus());
            });
            hrBaseServiceHelper.saveOne(collectGroupStatus);
            dynamicObject = HomCommonRepository.queryDynamicObjectByPk("hom_collect", "", id);
            logger.info(MessageFormat.format("\u91c7\u96c6\u6d3b\u52a8{0}\u521d\u59cb\u5316\u6570\u636e\u6210\u529f", id));
        }
        catch (Exception e) {
            logger.error(MessageFormat.format("\u91c7\u96c6\u6d3b\u52a8{0}\u521d\u59cb\u5316\u6570\u636e\u5931\u8d25", id), (Throwable)e);
        }
    }

    @Override
    public void completeCollectGroup(List<Long> completeInfoGroupId, Long activityId) {
        DynamicObject dyn = HomCommonRepository.queryDynamicObjectByPk("hom_collect", "", activityId);
        if (HRObjectUtils.isEmpty((Object)dyn)) {
            logger.warn("collect activity is empty");
            return;
        }
        this.saveCollectGroupStatus(dyn);
        DynamicObject collectGroupDyn = HomCommonRepository.queryDynamicObject("hom_collectgroupstatus", "", new QFilter("collectactivity", "=", (Object)dyn.getLong("id")));
        collectGroupDyn.getDynamicObjectCollection("infogroupentry").forEach(dynamicObject -> {
            if (completeInfoGroupId.contains(dynamicObject.getLong("infogroup.id"))) {
                dynamicObject.set("infogroupstatus", (Object)InfoGroupStatusEnum.COMPLETE.getStatus());
            }
        });
        HomCommonRepository.updateDynamicObject("hom_collectgroupstatus", collectGroupDyn);
    }

    @Override
    public void setCollectGroupUndo(List<Long> unCompleteInfoGroupId, Long activityId) {
        DynamicObject dyn = HomCommonRepository.queryDynamicObjectByPk("hom_collect", "", activityId);
        this.saveCollectGroupStatus(dyn);
        DynamicObject collectGroupDyn = HomCommonRepository.queryDynamicObject("hom_collectgroupstatus", "", new QFilter("collectactivity", "=", (Object)dyn.getLong("id")));
        collectGroupDyn.getDynamicObjectCollection("infogroupentry").forEach(dynamicObject -> {
            if (unCompleteInfoGroupId.contains(dynamicObject.getLong("infogroup.id"))) {
                dynamicObject.set("infogroupstatus", (Object)InfoGroupStatusEnum.UN_COMPLETE.getStatus());
            }
        });
        HomCommonRepository.updateDynamicObject("hom_collectgroupstatus", collectGroupDyn);
    }

    @Override
    public void completeUnRejectCollectGroup(List<Long> completeInfoGroupId, Long activityId) {
        DynamicObject dyn = HomCommonRepository.queryDynamicObjectByPk("hom_collect", "", activityId);
        this.saveCollectGroupStatus(dyn);
        DynamicObject collectGroupDyn = HomCommonRepository.queryDynamicObject("hom_collectgroupstatus", "", new QFilter("collectactivity", "=", (Object)dyn.getLong("id")));
        collectGroupDyn.getDynamicObjectCollection("infogroupentry").forEach(dynamicObject -> {
            if (completeInfoGroupId.contains(dynamicObject.getLong("infogroup.id")) && !InfoGroupStatusEnum.REJECT.getStatus().equals(dynamicObject.getString("infogroupstatus"))) {
                dynamicObject.set("infogroupstatus", (Object)InfoGroupStatusEnum.COMPLETE.getStatus());
            }
        });
        HomCommonRepository.updateDynamicObject("hom_collectgroupstatus", collectGroupDyn);
    }

    @Override
    public Long getCompleteCollectGroup(Long activityId) {
        DynamicObject dyn = HomCommonRepository.queryDynamicObjectByPk("hom_collect", "", activityId);
        this.saveCollectGroupStatus(dyn);
        DynamicObject collectGroupDyn = HomCommonRepository.queryDynamicObject("hom_collectgroupstatus", "", new QFilter("collectactivity", "=", (Object)dyn.getLong("id")));
        return collectGroupDyn.getDynamicObjectCollection("infogroupentry").stream().filter(dynamicObject -> InfoGroupStatusEnum.COMPLETE.getStatus().equals(dynamicObject.get("infogroupstatus"))).count();
    }

    @Override
    public void setCollectGroupStatus(List<Long> unCompleteInfoGroupId, Long activityId, InfoGroupStatusEnum statusEnum) {
        DynamicObject dyn = HomCommonRepository.queryDynamicObjectByPk("hom_collect", "", activityId);
        this.saveCollectGroupStatus(dyn);
        DynamicObject collectGroupDyn = HomCommonRepository.queryDynamicObject("hom_collectgroupstatus", "", new QFilter("collectactivity", "=", (Object)dyn.getLong("id")));
        collectGroupDyn.getDynamicObjectCollection("infogroupentry").forEach(dynamicObject -> {
            if (unCompleteInfoGroupId.contains(dynamicObject.getLong("infogroup.id"))) {
                dynamicObject.set("infogroupstatus", (Object)statusEnum.getStatus());
            }
        });
        HomCommonRepository.updateDynamicObject("hom_collectgroupstatus", collectGroupDyn);
    }

    @Override
    public void setActiveStatusCompleted(String onbrdBillId, Long activityId) {
        QFilter activityFilter = new QFilter("collectactivity", "=", (Object)activityId);
        DynamicObject query = HomCommonRepository.queryDynamicObject("hom_collectgroupstatus", "", activityFilter);
        DynamicObjectCollection dynamicObjectCollection = query.getDynamicObjectCollection("infogroupentry");
        for (DynamicObject object : dynamicObjectCollection) {
            if (!InfoGroupStatusEnum.REJECT.getStatus().equals(object.getString("infogroupstatus"))) continue;
            object.set("infogroupstatus", (Object)InfoGroupStatusEnum.COMPLETE.getStatus());
        }
        HomCommonRepository.updateDynamicObject("hom_collectgroupstatus", query);
    }
}

