/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.business.domain.service.impl.collect;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.UrlUtil;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.entity.commonfield.ComboField;
import kd.bos.metadata.entity.commonfield.ComboItem;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Padding;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.AttachmentPanelAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.metadata.form.control.VectorAp;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.common.control.HRFieldAp;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hom.business.application.cvp.IHomToCvpAppService;
import kd.hr.hom.business.application.hcf.IHomToHcfAppService;
import kd.hr.hom.business.application.impl.onbrd.OnbrdWorkTableServiceImpl;
import kd.hr.hom.business.application.onbrd.IOnbrdWorkTableService;
import kd.hr.hom.business.domain.repository.common.HomCommonRepository;
import kd.hr.hom.business.domain.repository.config.CollectConfigRepository;
import kd.hr.hom.business.domain.service.ServiceFactory;
import kd.hr.hom.business.domain.service.activity.IActivityDomainService;
import kd.hr.hom.business.domain.service.collect.DynamicFiledViewServiceFactory;
import kd.hr.hom.business.domain.service.collect.ICollectGroupStatusService;
import kd.hr.hom.business.domain.service.collect.ICollectService;
import kd.hr.hom.business.domain.service.collect.ISyncCollectToHcf;
import kd.hr.hom.business.domain.service.common.IHomConfigService;
import kd.hr.hom.business.domain.service.common.ISendMessageService;
import kd.hr.hom.business.domain.service.onbrd.IOnbrdBillDomainService;
import kd.hr.hom.common.constant.InfoGroupFieldConstants;
import kd.hr.hom.common.entity.DynViewParamEntity;
import kd.hr.hom.common.entity.InfoGroupCertEntity;
import kd.hr.hom.common.entity.InfoGroupConfigEntity;
import kd.hr.hom.common.enums.ActivityNumberEnum;
import kd.hr.hom.common.enums.ActivityStatusEnum;
import kd.hr.hom.common.enums.CollectManageStatusEnum;
import kd.hr.hom.common.enums.InfoGroupEnum;
import kd.hr.hom.common.enums.InfoGroupFieldTypeEnum;
import kd.hr.hom.common.enums.OnbrdStatusEnum;
import kd.hr.hom.common.enums.RuleEngineSceneNumberEnum;
import kd.hr.hom.common.util.FlexBuildUtils;
import kd.sdk.hr.hom.common.InfoGroupEntity;

public class CollectServiceImpl
implements ICollectService {
    private static final Log LOGGER = LogFactory.getLog(CollectServiceImpl.class);
    private static final IOnbrdWorkTableService WORK_TABLE_SERVICE = new OnbrdWorkTableServiceImpl();
    private static final String EDUATTACH_EXTENDNAME = "JPG,PNG,JPEG,PDF";
    private static final Map<Long, String> ATTACH_FIELD_EXTENDNAME = ImmutableMap.builder().put((Object)1408187915879632899L, (Object)"JPG,PNG,JPEG,PDF").put((Object)1408187915879632900L, (Object)"JPG,PNG,JPEG,PDF").put((Object)1408187915879632901L, (Object)"JPG,PNG,JPEG,PDF").put((Object)1249297648691749894L, (Object)"JPG,PNG,JPEG,PDF").put((Object)1249297648691749896L, (Object)"JPG,PNG,JPEG,PDF").build();

    @Override
    public void registerDynamicProps(String key, DynamicObjectType mainType, InfoGroupEntity.InfoGroupField field, DynamicObject dynamicObject, String seq) {
        String className;
        IDataEntityProperty entityProperty = null;
        String fieldName = key + field.getFieldId() + seq;
        String displayName = field.getFieldName();
        if (InfoGroupFieldConstants.RSM_PTDATA.equals(field.getFieldId())) {
            className = "DateRangeProp";
        } else {
            entityProperty = (IDataEntityProperty)dynamicObject.getDataEntityType().getProperties().get((Object)field.getFieldKey());
            if (entityProperty == null) {
                return;
            }
            className = entityProperty.getClass().getSimpleName();
        }
        DynamicFiledViewServiceFactory.getDynamicFiledViewService(className).registerDynamicProps(mainType, fieldName, entityProperty, displayName, field);
    }

    @Override
    public FieldAp buildFieldAp(InfoGroupEntity.InfoGroupField infoGroupField, String seq) {
        Tips tips;
        String suffix = HRStringUtils.isEmpty((String)seq) ? "" : seq;
        String fieldKey = "field" + infoGroupField.getFieldId() + suffix;
        Field field = this.buildField(infoGroupField, suffix);
        field.setKey(fieldKey);
        field.setMustInput(infoGroupField.isFieldMustInput());
        field.setId(fieldKey);
        FieldAp fieldAp = ((HRFieldAp.Builder)new HRFieldAp.Builder(fieldKey).setMarginRight("0px")).build();
        fieldAp.setId(fieldKey);
        fieldAp.setKey(fieldKey);
        fieldAp.setField(field);
        fieldAp.setName(new LocaleString(infoGroupField.getFieldName()));
        fieldAp.setFireUpdEvt(true);
        fieldAp.setFieldId(fieldKey);
        if (HRStringUtils.isNotEmpty((String)infoGroupField.getFieldRemark())) {
            tips = new Tips();
            tips.setContent(new LocaleString(infoGroupField.getFieldRemark()));
            tips.setTriggerType("hover");
            tips.setShowIcon(true);
            tips.setType("text");
            tips.setIsConfirm(false);
            fieldAp.setCtlTips(tips);
        } else if (infoGroupField.getFieldId().equals(InfoGroupFieldConstants.ISMAJOR_CERT)) {
            tips = new Tips();
            tips.setContent(ResManager.getLocaleString((String)"\u4e3b\u8bc1\u4ef6\u4e0d\u80fd\u66f4\u6539\u4e3a\u5426\uff0c\u53ef\u66f4\u6539\u5176\u4ed6\u8bc1\u4ef6\u4e3a\u4e3b\u8bc1\u4ef6", (String)"BooleanFiledViewServiceImpl_0", (String)"hr-hom-business"));
            tips.setTriggerType("hover");
            tips.setShowIcon(true);
            tips.setType("text");
            tips.setIsConfirm(false);
            fieldAp.setCtlTips(tips);
        }
        fieldAp.setDateSelectType(1);
        fieldAp.setOpenSelector(true);
        fieldAp.setQuickAddNew(false);
        List<String> confValList = ServiceFactory.getService(IHomConfigService.class).getConfValList("collect_field_fullline", "");
        if (confValList.contains(String.valueOf(infoGroupField.getFieldId()))) {
            fieldAp.setFullLine(true);
        }
        return fieldAp;
    }

    @Override
    public AttachmentPanelAp buildAttachPanelAp(InfoGroupEntity.InfoGroupField infoGroupField, String seq) {
        String suffix = HRStringUtils.isEmpty((String)seq) ? "" : seq;
        String fieldKey = "field" + infoGroupField.getFieldId() + suffix;
        AttachmentPanelAp attachmentPanelAp = new AttachmentPanelAp();
        attachmentPanelAp.setId(fieldKey);
        attachmentPanelAp.setKey(fieldKey);
        attachmentPanelAp.setMaxAtmCount(infoGroupField.getFieldCount());
        attachmentPanelAp.setMaxAtmSize(30);
        attachmentPanelAp.setLock("view");
        attachmentPanelAp.setStyle(new Style());
        String extendName = ATTACH_FIELD_EXTENDNAME.get(infoGroupField.getFieldId());
        if (HRStringUtils.isNotEmpty((String)extendName)) {
            attachmentPanelAp.setExtendName(extendName);
        }
        return attachmentPanelAp;
    }

    @Override
    public InfoGroupConfigEntity transferDynToEntity(DynamicObject dataEntity) {
        InfoGroupConfigEntity infoGroupConfigEntity = new InfoGroupConfigEntity();
        infoGroupConfigEntity.setConfigName(dataEntity.getLocaleString("name").getLocaleValue());
        DynamicObjectCollection dynamicObjectCollection = dataEntity.getDynamicObjectCollection("infogroupentity");
        Boolean enableOcr = IHomToCvpAppService.getInstance().isCollectEnableOcr();
        dynamicObjectCollection.forEach(dynamicObject -> {
            InfoGroupEntity infoGroup = new InfoGroupEntity();
            infoGroup.setInfoGroupId(Long.valueOf(dynamicObject.getLong("infogroup.id")));
            infoGroup.setInfoGroupName(dynamicObject.getLocaleString("infogroupname").getLocaleValue());
            infoGroup.setInfoGroupNumber(dynamicObject.getString("infogroup.number"));
            infoGroup.setMultipleEntity(dynamicObject.getBoolean("infogroup.multipleentity"));
            infoGroup.setImgKey(dynamicObject.getString("infogroup.imgkey"));
            infoGroup.setInfoGroupOcr(enableOcr != false && dynamicObject.getBoolean("infogroup.infogroupocr"));
            infoGroup.setInfoGroupDisplayTips(dynamicObject.getLocaleString("infogroup.displaytips").getLocaleValue());
            infoGroup.setMustInput(Boolean.valueOf(dynamicObject.getBoolean("infogroupmustinput")));
            DynamicObjectCollection fieldCollection = dynamicObject.getDynamicObjectCollection("infofieldentity");
            fieldCollection.forEach(dyn -> {
                InfoGroupEntity.InfoGroupField infoGroupField = new InfoGroupEntity.InfoGroupField();
                if (HRObjectUtils.isEmpty((Object)dyn.get("field"))) {
                    return;
                }
                infoGroupField.setFieldId(Long.valueOf(dyn.getLong("field.id")));
                if (HRStringUtils.isEmpty((String)dyn.getLocaleString("fieldnameshow").getLocaleValue())) {
                    infoGroupField.setFieldName(dyn.getLocaleString("field.fieldname").getLocaleValue());
                } else {
                    infoGroupField.setFieldName(dyn.getLocaleString("fieldnameshow").getLocaleValue());
                }
                infoGroupField.setFieldApprove(dyn.getBoolean("fieldapprove"));
                infoGroupField.setFieldMustInput(dyn.getBoolean("fieldmustinput"));
                infoGroupField.setFieldCount(dyn.getInt("fieldcount"));
                infoGroupField.setFieldType(dyn.getInt("field.fieldtype"));
                infoGroupField.setFieldRecheck(dyn.getBoolean("fieldrecheck"));
                infoGroupField.setFieldKey(dyn.getString("field.fieldnumber"));
                infoGroupField.setListShow(Boolean.valueOf(dyn.getBoolean("field.listshow")));
                infoGroupField.setListShowFirst(Boolean.valueOf(dyn.getBoolean("field.listshowfirstline")));
                infoGroupField.setFieldOcr(enableOcr != false && dyn.getBoolean("field.fieldocr"));
                infoGroupField.setPageKey(dyn.getString("field.pageid"));
                infoGroupField.setFieldRemark(dyn.getLocaleString("fieldremark").getLocaleValue());
                infoGroupField.setFieldRecheckStand(dyn.getLocaleString("fieldrecheckstand").getLocaleValue());
                infoGroup.getInfoGroupFieldList().add(infoGroupField);
            });
            infoGroupConfigEntity.getInfoGroupEntityList().add(infoGroup);
        });
        DynamicObjectCollection dynamicObjectCertCollection = dataEntity.getDynamicObjectCollection("certentity");
        if (!CollectionUtils.isEmpty((Collection)dynamicObjectCertCollection)) {
            dynamicObjectCertCollection.forEach(dynamicObject -> {
                if (dynamicObject.getBoolean("ischeck")) {
                    InfoGroupCertEntity infoGroupCertEntity = new InfoGroupCertEntity();
                    infoGroupCertEntity.setCertTypeNumber(dynamicObject.getString("certtype.id"));
                    String certTypeName = dynamicObject.getLocaleString("certtype.name").getLocaleValue();
                    infoGroupCertEntity.setCertTypeName(certTypeName);
                    infoGroupConfigEntity.getInfoGroupCertEntityList().add(infoGroupCertEntity);
                }
            });
        }
        return infoGroupConfigEntity;
    }

    @Override
    public InfoGroupConfigEntity transferDynToEntity(DynamicObject dataEntity, Long orgId) {
        InfoGroupConfigEntity infoGroupConfigEntity = new InfoGroupConfigEntity();
        infoGroupConfigEntity.setConfigName(dataEntity.getLocaleString("name").getLocaleValue());
        DynamicObjectCollection dynamicObjectCollection = dataEntity.getDynamicObjectCollection("infogroupentity");
        Boolean enableOcr = IHomToCvpAppService.getInstance().isCollectEnableOcr(orgId);
        dynamicObjectCollection.forEach(dynamicObject -> {
            InfoGroupEntity infoGroup = new InfoGroupEntity();
            infoGroup.setInfoGroupId(Long.valueOf(dynamicObject.getLong("infogroup.id")));
            infoGroup.setInfoGroupName(dynamicObject.getLocaleString("infogroupname").getLocaleValue());
            infoGroup.setInfoGroupNumber(dynamicObject.getString("infogroup.number"));
            infoGroup.setMultipleEntity(dynamicObject.getBoolean("infogroup.multipleentity"));
            infoGroup.setImgKey(dynamicObject.getString("infogroup.imgkey"));
            infoGroup.setInfoGroupOcr(enableOcr != false && dynamicObject.getBoolean("infogroup.infogroupocr"));
            infoGroup.setInfoGroupDisplayTips(dynamicObject.getLocaleString("infogroup.displaytips").getLocaleValue());
            infoGroup.setMustInput(Boolean.valueOf(dynamicObject.getBoolean("infogroupmustinput")));
            DynamicObjectCollection fieldCollection = dynamicObject.getDynamicObjectCollection("infofieldentity");
            fieldCollection.forEach(dyn -> {
                InfoGroupEntity.InfoGroupField infoGroupField = new InfoGroupEntity.InfoGroupField();
                if (HRObjectUtils.isEmpty((Object)dyn.get("field"))) {
                    return;
                }
                infoGroupField.setFieldId(Long.valueOf(dyn.getLong("field.id")));
                if (HRStringUtils.isEmpty((String)dyn.getLocaleString("fieldnameshow").getLocaleValue())) {
                    infoGroupField.setFieldName(dyn.getLocaleString("field.fieldname").getLocaleValue());
                } else {
                    infoGroupField.setFieldName(dyn.getLocaleString("fieldnameshow").getLocaleValue());
                }
                infoGroupField.setFieldApprove(dyn.getBoolean("fieldapprove"));
                infoGroupField.setFieldMustInput(dyn.getBoolean("fieldmustinput"));
                infoGroupField.setFieldCount(dyn.getInt("fieldcount"));
                infoGroupField.setFieldType(dyn.getInt("field.fieldtype"));
                infoGroupField.setFieldRecheck(dyn.getBoolean("fieldrecheck"));
                infoGroupField.setFieldKey(dyn.getString("field.fieldnumber"));
                infoGroupField.setListShow(Boolean.valueOf(dyn.getBoolean("field.listshow")));
                infoGroupField.setListShowFirst(Boolean.valueOf(dyn.getBoolean("field.listshowfirstline")));
                infoGroupField.setFieldOcr(enableOcr != false && dyn.getBoolean("field.fieldocr"));
                infoGroupField.setPageKey(dyn.getString("field.pageid"));
                infoGroupField.setFieldRemark(dyn.getLocaleString("fieldremark").getLocaleValue());
                infoGroupField.setFieldRecheckStand(dyn.getLocaleString("fieldrecheckstand").getLocaleValue());
                infoGroup.getInfoGroupFieldList().add(infoGroupField);
            });
            infoGroupConfigEntity.getInfoGroupEntityList().add(infoGroup);
        });
        DynamicObjectCollection dynamicObjectCertCollection = dataEntity.getDynamicObjectCollection("certentity");
        if (!CollectionUtils.isEmpty((Collection)dynamicObjectCertCollection)) {
            dynamicObjectCertCollection.forEach(dynamicObject -> {
                if (dynamicObject.getBoolean("ischeck")) {
                    InfoGroupCertEntity infoGroupCertEntity = new InfoGroupCertEntity();
                    infoGroupCertEntity.setCertTypeNumber(dynamicObject.getString("certtype.id"));
                    String certTypeName = dynamicObject.getLocaleString("certtype.name").getLocaleValue();
                    infoGroupCertEntity.setCertTypeName(certTypeName);
                    infoGroupConfigEntity.getInfoGroupCertEntityList().add(infoGroupCertEntity);
                }
            });
        }
        return infoGroupConfigEntity;
    }

    @Override
    public List<InfoGroupEntity> getAllInfoGroupEntity() {
        DynamicObject[] dynamicObjects = HomCommonRepository.queryDynamicObjects("hom_bdinfogroup", "", new QFilter[0]);
        ArrayList<InfoGroupEntity> infoGroupEntityList = new ArrayList<InfoGroupEntity>();
        Arrays.stream(dynamicObjects).forEach(dynamicObject -> {
            InfoGroupEntity infoGroup = new InfoGroupEntity();
            infoGroup.setInfoGroupId(Long.valueOf(dynamicObject.getLong("id")));
            infoGroup.setInfoGroupNumber(dynamicObject.getString("number"));
            infoGroup.setMultipleEntity(dynamicObject.getBoolean("multipleentity"));
            DynamicObjectCollection fieldCollection = dynamicObject.getDynamicObjectCollection("infogroupfield");
            fieldCollection.forEach(dyn -> {
                InfoGroupEntity.InfoGroupField infoGroupField = new InfoGroupEntity.InfoGroupField();
                infoGroupField.setFieldId(Long.valueOf(dyn.getLong("id")));
                infoGroupField.setFieldName(dyn.getLocaleString("fieldname").getLocaleValue());
                infoGroupField.setFieldType(dyn.getInt("fieldtype"));
                infoGroupField.setFieldKey(dyn.getString("fieldnumber"));
                infoGroupField.setListShow(Boolean.valueOf(dyn.getBoolean("listshow")));
                infoGroupField.setListShowFirst(Boolean.valueOf(dyn.getBoolean("listshowfirstline")));
                infoGroupField.setFieldOcr(dyn.getBoolean("fieldocr"));
                infoGroupField.setPageKey(dyn.getString("pageid"));
                infoGroup.getInfoGroupFieldList().add(infoGroupField);
            });
            infoGroupEntityList.add(infoGroup);
        });
        return infoGroupEntityList;
    }

    @Override
    public InfoGroupConfigEntity transferDynToEntity(DynamicObject dataEntity, String type) {
        InfoGroupConfigEntity infoGroupConfigEntity = new InfoGroupConfigEntity();
        if (Objects.isNull(dataEntity)) {
            return infoGroupConfigEntity;
        }
        infoGroupConfigEntity.setConfigName(dataEntity.getLocaleString("name").getLocaleValue());
        DynamicObjectCollection dynamicObjectCollection = dataEntity.getDynamicObjectCollection("infogroupentity");
        dynamicObjectCollection.forEach(dynamicObject -> {
            InfoGroupEntity infoGroup = new InfoGroupEntity();
            infoGroup.setInfoGroupId(Long.valueOf(dynamicObject.getLong("infogroup.id")));
            infoGroup.setInfoGroupName(dynamicObject.getLocaleString("infogroupname").getLocaleValue());
            infoGroup.setInfoGroupNumber(dynamicObject.getString("infogroup.number"));
            infoGroup.setMultipleEntity(dynamicObject.getBoolean("infogroup.multipleentity"));
            infoGroup.setImgKey(dynamicObject.getString("infogroup.imgkey"));
            if ("acceptmanage".equals(type)) {
                infoGroup.setInfoGroupOcr(false);
            }
            infoGroup.setInfoGroupDisplayTips(dynamicObject.getLocaleString("infogroup.displaytips").getLocaleValue());
            infoGroup.setMustInput(Boolean.valueOf(dynamicObject.getBoolean("infogroupmustinput")));
            DynamicObjectCollection fieldCollection = dynamicObject.getDynamicObjectCollection("infofieldentity");
            fieldCollection.forEach(dyn -> {
                InfoGroupEntity.InfoGroupField infoGroupField = new InfoGroupEntity.InfoGroupField();
                if (HRObjectUtils.isEmpty((Object)dyn.get("field"))) {
                    return;
                }
                infoGroupField.setFieldId(Long.valueOf(dyn.getLong("field.id")));
                if (HRStringUtils.isEmpty((String)dyn.getLocaleString("fieldnameshow").getLocaleValue())) {
                    infoGroupField.setFieldName(dyn.getLocaleString("field.fieldname").getLocaleValue());
                } else {
                    infoGroupField.setFieldName(dyn.getLocaleString("fieldnameshow").getLocaleValue());
                }
                infoGroupField.setFieldApprove(dyn.getBoolean("fieldapprove"));
                infoGroupField.setFieldMustInput(dyn.getBoolean("fieldmustinput"));
                infoGroupField.setFieldCount(dyn.getInt("fieldcount"));
                infoGroupField.setFieldType(dyn.getInt("field.fieldtype"));
                infoGroupField.setFieldRecheck(dyn.getBoolean("fieldrecheck"));
                infoGroupField.setFieldKey(dyn.getString("field.fieldnumber"));
                infoGroupField.setListShow(Boolean.valueOf(dyn.getBoolean("field.listshow")));
                infoGroupField.setListShowFirst(Boolean.valueOf(dyn.getBoolean("field.listshowfirstline")));
                infoGroupField.setPageKey(dyn.getString("field.pageid"));
                infoGroupField.setFieldRemark(dyn.getLocaleString("fieldremark").getLocaleValue());
                infoGroupField.setFieldRecheckStand(dyn.getLocaleString("fieldrecheckstand").getLocaleValue());
                infoGroup.getInfoGroupFieldList().add(infoGroupField);
            });
            infoGroupConfigEntity.getInfoGroupEntityList().add(infoGroup);
        });
        DynamicObjectCollection dynamicObjectCertCollection = dataEntity.getDynamicObjectCollection("certentity");
        if (!CollectionUtils.isEmpty((Collection)dynamicObjectCertCollection)) {
            dynamicObjectCertCollection.stream().forEach(dynamicObject -> {
                if (dynamicObject.getBoolean("ischeck")) {
                    InfoGroupCertEntity infoGroupCertEntity = new InfoGroupCertEntity();
                    infoGroupCertEntity.setCertTypeNumber(dynamicObject.getString("certtype.id"));
                    String certTypeName = dynamicObject.getLocaleString("certtype.name").getLocaleValue();
                    infoGroupCertEntity.setCertTypeName(certTypeName);
                    infoGroupConfigEntity.getInfoGroupCertEntityList().add(infoGroupCertEntity);
                }
            });
        }
        return infoGroupConfigEntity;
    }

    @Override
    public void buildInfoGroupEntity(InfoGroupConfigEntity infoGroupConfigEntity, InfoGroupEntity infoGroupEntity, FlexPanelAp fieldDataFlexAp, DynViewParamEntity dynViewParamEntity) {
        FlexPanelAp fieldFlexAp = FlexBuildUtils.buildFlexPanelAp((String)("infogroupfield" + infoGroupEntity.getInfoGroupNumber()));
        fieldFlexAp.setDirection("column");
        fieldFlexAp.setAlignItems("stretch");
        fieldFlexAp.setParentId("infogroupdataflex" + infoGroupEntity.getInfoGroupNumber().toLowerCase());
        fieldFlexAp.setStyle(FlexBuildUtils.buildStyleWithBorder());
        fieldFlexAp.setAlignSelf("stretch");
        fieldDataFlexAp.getItems().add(fieldFlexAp);
        if (InfoGroupEnum.CERTIFICATE_INFO.getNumber().equals(infoGroupEntity.getInfoGroupNumber())) {
            FlexPanelAp infogroupfieldFlex = this.buildCert(infoGroupConfigEntity);
            fieldFlexAp.getItems().add(infogroupfieldFlex);
        }
        this.buildInfoGroupFlexByFieldType(fieldFlexAp, infoGroupEntity, "", dynViewParamEntity);
    }

    @Override
    public FlexPanelAp buildCert(InfoGroupConfigEntity infoGroupConfigEntity) {
        FlexPanelAp infogroupfieldFlex = FlexBuildUtils.buildFlexPanelAp((String)"infogroupflexcert");
        infogroupfieldFlex.setParentId("infogroup");
        infogroupfieldFlex.setDirection("column");
        infogroupfieldFlex.setAlignItems("stretch");
        FlexPanelAp infogroupfieldFlex1 = FlexBuildUtils.buildFlexPanelAp((String)"infogroupflextypecert");
        infogroupfieldFlex.getItems().add(infogroupfieldFlex1);
        infogroupfieldFlex1.setParentId("infogroupflexcert");
        FieldAp fieldAp = new FieldAp();
        fieldAp.setId("fieldcerttype");
        fieldAp.setKey("fieldcerttype");
        ComboField comboField = new ComboField();
        List infoGroupCertEntityList = infoGroupConfigEntity.getInfoGroupCertEntityList();
        String certSortInfoStr = "{\"1010\":1,\"1060\":2,\"1070\":3,\"1050\":4,\"1020\":5}";
        Map certSortRuleMap = (Map)JSONObject.parseObject((String)certSortInfoStr, Map.class);
        infoGroupCertEntityList = infoGroupCertEntityList.stream().sorted(Comparator.comparingInt(cert -> certSortRuleMap.getOrDefault(cert.getCertTypeNumber(), Integer.MAX_VALUE))).collect(Collectors.toList());
        ArrayList items = Lists.newArrayListWithCapacity((int)infoGroupCertEntityList.size());
        for (InfoGroupCertEntity infoGroupCertEntity : infoGroupCertEntityList) {
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(infoGroupCertEntity.getCertTypeName()));
            item.setValue(String.valueOf(infoGroupCertEntity.getCertTypeNumber()));
            items.add(item);
        }
        comboField.setItems((List)items);
        comboField.setId("fieldcerttype");
        comboField.setKey("fieldcerttype");
        fieldAp.setField((Field)comboField);
        fieldAp.setName(ResManager.getLocaleString((String)"\u8bc1\u4ef6\u7c7b\u578b", (String)"CollectServiceImpl_0", (String)"hr-hom-business"));
        fieldAp.setParentId("infogroupflextypecert");
        fieldAp.setFireUpdEvt(true);
        infogroupfieldFlex1.getItems().add(fieldAp);
        return infogroupfieldFlex;
    }

    @Override
    public void buildInfoGroupFlexByFieldType(FlexPanelAp fieldFlexAp, InfoGroupEntity infoGroupEntity, String seq, DynViewParamEntity dynViewParamEntity) {
        LinkedHashMap collect = infoGroupEntity.getInfoGroupFieldList().stream().collect(Collectors.groupingBy(InfoGroupEntity.InfoGroupField::getFieldType, LinkedHashMap::new, Collectors.toList()));
        for (Map.Entry<Integer, List<InfoGroupEntity.InfoGroupField>> entry : collect.entrySet()) {
            Integer key = (Integer)entry.getKey();
            FlexPanelAp infogroupfieldFlex = FlexBuildUtils.buildFlexPanelAp((String)("infogroupfield" + infoGroupEntity.getInfoGroupNumber().toLowerCase() + key + seq));
            fieldFlexAp.getItems().add(infogroupfieldFlex);
            infogroupfieldFlex.setDirection("row");
            infogroupfieldFlex.setAlignItems("flex-start");
            infogroupfieldFlex.setWidth(new LocaleString("100%"));
            if (key == Integer.parseInt(InfoGroupFieldTypeEnum.ATTACH.getFieldType())) {
                infogroupfieldFlex.setDirection("column");
                infogroupfieldFlex.setAlignItems("stretch");
                infogroupfieldFlex.getStyle().getPadding().setLeft("15px");
            }
            infogroupfieldFlex.setGrow(0);
            infogroupfieldFlex.setShrink(0);
            infogroupfieldFlex.setJustifyContent("flex-start");
            infogroupfieldFlex.setId("infogroupflextype" + infoGroupEntity.getInfoGroupNumber().toLowerCase() + key + seq);
            infogroupfieldFlex.setParentId("infogroupfield" + infoGroupEntity.getInfoGroupNumber().toLowerCase());
            infogroupfieldFlex.getStyle().getPadding().setLeft("14px");
            if (key != 0) {
                infogroupfieldFlex.getStyle().getPadding().setBottom("15px");
            }
            this.buildFieldEntityAp(entry, infogroupfieldFlex, seq, dynViewParamEntity);
        }
    }

    @Override
    public void buildFieldEntityAp(Map.Entry<Integer, List<InfoGroupEntity.InfoGroupField>> integerListEntry, FlexPanelAp infogroupfieldFlex, String seq, DynViewParamEntity dynViewParamEntity) {
        for (InfoGroupEntity.InfoGroupField infoGroupField : integerListEntry.getValue()) {
            FlexPanelAp fieldFlex = FlexBuildUtils.buildFlexPanelAp((String)("fieldboard" + infoGroupField.getFieldId() + seq));
            fieldFlex.setStyle(FlexBuildUtils.buildFlexStyleNon());
            infogroupfieldFlex.getItems().add(fieldFlex);
            fieldFlex.setDirection("row");
            fieldFlex.setAlignItems("stretch");
            fieldFlex.setJustifyContent("flex-start");
            if (integerListEntry.getKey() != Integer.parseInt(InfoGroupFieldTypeEnum.ATTACH.getFieldType())) {
                fieldFlex.setGrow(0);
                fieldFlex.setOverflow("visible");
            }
            if (integerListEntry.getKey() == Integer.parseInt(InfoGroupFieldTypeEnum.IMAGE.getFieldType())) {
                Padding padding = new Padding();
                padding.setLeft("0px");
                padding.setRight("28px");
                fieldFlex.getStyle().setPadding(padding);
            }
            fieldFlex.setId("fieldboard" + infoGroupField.getFieldId() + seq);
            fieldFlex.setParentId(infogroupfieldFlex.getId());
            if (dynViewParamEntity.isApprove() && infoGroupField.isFieldApprove()) {
                Style style1 = new Style();
                Margin margin = new Margin();
                margin.setRight("0px");
                margin.setLeft("-16px");
                margin.setTop("10px");
                style1.setMargin(margin);
                VectorAp approveAp = new VectorAp();
                approveAp.setKey("approveon" + infoGroupField.getFieldId() + seq);
                approveAp.setId("approveon" + infoGroupField.getFieldId() + seq);
                approveAp.setfontClass("kdfont kdfont-biaoji");
                approveAp.setParentId("fieldboard" + infoGroupField.getFieldId() + seq);
                approveAp.setFontSize(16);
                approveAp.setClickable(true);
                approveAp.setStyle(style1);
                fieldFlex.getItems().add(approveAp);
                VectorAp approveOnAp = new VectorAp();
                approveOnAp.setKey("approveoff" + infoGroupField.getFieldId() + seq);
                approveOnAp.setId("approveoff" + infoGroupField.getFieldId() + seq);
                approveOnAp.setfontClass("kdfont kdfont-yibiaoji");
                approveOnAp.setParentId("fieldboard" + infoGroupField.getFieldId());
                approveOnAp.setFontSize(16);
                approveOnAp.setClickable(true);
                approveOnAp.setForeColor("#ff991c");
                approveOnAp.setStyle(style1);
                fieldFlex.getItems().add(approveOnAp);
                if (infoGroupField.getFieldType() == Integer.parseInt(InfoGroupFieldTypeEnum.IMAGE.getFieldType())) {
                    Style style = new Style();
                    Padding padding = new Padding();
                    padding.setTop("5px");
                    style.setPadding(padding);
                    approveAp.setStyle(style);
                    approveOnAp.setStyle(style);
                }
            }
            if (infoGroupField.getFieldType() == Integer.parseInt(InfoGroupFieldTypeEnum.ATTACH.getFieldType())) {
                FlexPanelAp attachNameFlex = FlexBuildUtils.buildFlexPanelAp((String)("attachNameFlex" + infoGroupField.getFieldId()));
                attachNameFlex.setWidth(new LocaleString("98%"));
                attachNameFlex.setParentId("fieldboard" + integerListEntry.getKey());
                fieldFlex.getItems().add(attachNameFlex);
                String label = "attachfield" + infoGroupField.getFieldId() + seq;
                LabelAp labelAp = FlexBuildUtils.buildLabelAp((String)label, (String)infoGroupField.getFieldName());
                labelAp.setForeColor("#666666");
                if (HRStringUtils.isNotEmpty((String)infoGroupField.getFieldRemark())) {
                    Tips tips = new Tips();
                    tips.setContent(new LocaleString(infoGroupField.getFieldRemark()));
                    tips.setTriggerType("hover");
                    tips.setShowIcon(true);
                    tips.setType("text");
                    tips.setIsConfirm(false);
                    labelAp.setCtlTips(tips);
                }
                attachNameFlex.getItems().add(labelAp);
                if (infoGroupField.isFieldMustInput()) {
                    String mustlabel = "mustfield" + infoGroupField.getFieldId() + seq;
                    LabelAp mustInputLabel = FlexBuildUtils.buildLabelAp((String)mustlabel, (String)"*");
                    mustInputLabel.setForeColor("red");
                    attachNameFlex.getItems().add(mustInputLabel);
                }
                AttachmentPanelAp attachmentPanelAp = ServiceFactory.getService(ICollectService.class).buildAttachPanelAp(infoGroupField, seq);
                attachmentPanelAp.setParentId("fieldboard" + infoGroupField.getFieldId() + seq);
                Padding padding = new Padding();
                padding.setLeft("0px");
                attachmentPanelAp.getStyle().setPadding(padding);
                fieldFlex.setWidth(new LocaleString("100%"));
                fieldFlex.getItems().add(attachmentPanelAp);
                continue;
            }
            FieldAp fieldAp = ServiceFactory.getService(ICollectService.class).buildFieldAp(infoGroupField, seq);
            fieldAp.setParentId("fieldboard" + infoGroupField.getFieldId() + seq);
            fieldFlex.setJustifyContent("flex-end");
            List<String> confValList = ServiceFactory.getService(IHomConfigService.class).getConfValList("collect_field_fullline", "");
            if (confValList.contains(String.valueOf(infoGroupField.getFieldId()))) {
                fieldFlex.setWidth(new LocaleString("90%"));
            }
            fieldFlex.getItems().add(fieldAp);
        }
    }

    @Override
    public String getSubmitPro(InfoGroupConfigEntity infoGroupConfigEntity, Long onboardId) {
        try {
            List infoGroupEntityList = infoGroupConfigEntity.getInfoGroupEntityList();
            Long completeInfoGroup = 0L;
            DynamicObject activityDynamicObject = HomCommonRepository.queryDynamicObject("hom_collect", "", new QFilter("onboard.id", "=", (Object)onboardId));
            if (!HRObjectUtils.isEmpty((Object)activityDynamicObject)) {
                completeInfoGroup = ServiceFactory.getService(ICollectGroupStatusService.class).getCompleteCollectGroup(activityDynamicObject.getLong("id"));
            }
            return completeInfoGroup + "/" + infoGroupEntityList.size();
        }
        catch (Exception e) {
            LOGGER.error("getSubmitPro fail", (Throwable)e);
            return "";
        }
    }

    @Override
    public void syncSubmitPro(Long onboardId) {
        DynamicObject activityDynamicObject = HomCommonRepository.queryDynamicObject("hom_collect", "", new QFilter("onboard.id", "=", (Object)onboardId));
        if (HRObjectUtils.isEmpty((Object)activityDynamicObject) || HRObjectUtils.isEmpty((Object)activityDynamicObject.get("collectconfighis"))) {
            return;
        }
        long collectConfigHisId = activityDynamicObject.getLong("collectconfighis.id");
        DynamicObject dataEntity = CollectConfigRepository.queryCollectConfigHisById("", collectConfigHisId);
        InfoGroupConfigEntity infoGroupConfigEntity = ServiceFactory.getService(ICollectService.class).transferDynToEntity(dataEntity);
        String submitPro = this.getSubmitPro(infoGroupConfigEntity, onboardId);
        activityDynamicObject.set("submitpro", (Object)submitPro);
        HomCommonRepository.updateDynamicObject("hom_collect", activityDynamicObject);
    }

    @Override
    public void syncInfoGroupStatus(InfoGroupEntity infoGroupEntity, Long candidateId, Long activityId) {
        HashMap hcfMultiMap = Maps.newHashMapWithExpectedSize((int)3);
        infoGroupEntity.getInfoGroupFieldList().forEach(field -> {
            String pageKey = field.getPageKey();
            if (pageKey.contains("hcf_")) {
                ServiceFactory.getService(ISyncCollectToHcf.class).fillEntityMap(hcfMultiMap, (InfoGroupEntity.InfoGroupField)field, pageKey);
            }
        });
        for (Map.Entry stringListEntry : hcfMultiMap.entrySet()) {
            DynamicObjectCollection multiRowEntity;
            String pageKey = (String)stringListEntry.getKey();
            if (pageKey.equals("hcf_educertificate") || !CollectionUtils.isEmpty((Collection)(multiRowEntity = IHomToHcfAppService.getInstance().getHisMultiRowEntity(candidateId, pageKey)))) continue;
            ServiceFactory.getService(ICollectGroupStatusService.class).setCollectGroupUndo(Collections.singletonList(infoGroupEntity.getInfoGroupId()), activityId);
        }
    }

    @Override
    public void syncSubmitProByCandidateId(Long candidateId) {
        DynamicObject[] onbrdBills;
        QFilter qFilter = new QFilter("candidate", "=", (Object)candidateId);
        for (DynamicObject onbrdBill : onbrdBills = IOnbrdBillDomainService.getInstance().findOnbrdBills("enrollstatus", new QFilter[]{qFilter})) {
            String enrollStatus = onbrdBill.getString("enrollstatus");
            if (HRStringUtils.equals((String)OnbrdStatusEnum.HAS_ONBRD.getValue(), (String)enrollStatus) || HRStringUtils.equals((String)OnbrdStatusEnum.BREAK_UP.getValue(), (String)enrollStatus)) continue;
            this.syncSubmitPro(onbrdBill.getLong("id"));
        }
    }

    @Override
    public void noticeCandidate(Long onboardId) {
        LinkedList qFilterList = Lists.newLinkedList();
        qFilterList.add(new QFilter("sendtext", "=", (Object)"0"));
        qFilterList.add(new QFilter("collectstatus", "=", (Object)CollectManageStatusEnum.SUBMIT.getStatus()));
        qFilterList.add(new QFilter("onboard.id", "=", (Object)onboardId));
        ArrayList<String> onboardStatus = new ArrayList<String>();
        onboardStatus.add(OnbrdStatusEnum.WAIT_START.toString());
        onboardStatus.add(OnbrdStatusEnum.WAIT_ONBRD.toString());
        qFilterList.add(new QFilter("onboard.enrollstatus", "in", onboardStatus));
        String selectField = "onboard.effectdate,sendtext,collectstatus,onboard.org.number,onboard.id,onboard.phone,onboard.enrollstatus";
        DynamicObject[] dynamicObjects = HomCommonRepository.queryDynamicObjects("hom_collect", selectField, qFilterList.toArray(new QFilter[0]));
        this.noticeCandidate(dynamicObjects);
    }

    @Override
    public void noticeCandidate(DynamicObject[] dynamicObjects) {
        if (HRArrayUtils.isEmpty((Object[])dynamicObjects)) {
            return;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, 3);
        Date targetDate = calendar.getTime();
        for (DynamicObject dynamicObject : dynamicObjects) {
            Date effectDate = dynamicObject.getDate("onboard.effectdate");
            if (effectDate == null || targetDate.compareTo(effectDate) < 0) continue;
            LOGGER.info(MessageFormat.format("biz id is {0},effectdate is {1}", dynamicObject.getLong("id"), effectDate));
            String buNumber = dynamicObject.getString("onboard.org.number");
            Long bizId = dynamicObject.getLong("onboard.id");
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("activityUrl", "");
            ImmutableList phoneList = ImmutableList.of((Object)dynamicObject.getString("onboard.phone"));
            ImmutableList emailList = ImmutableList.of((Object)dynamicObject.getString("onboard.peremail"));
            HashMap<String, List<String>> concatMap = new HashMap<String, List<String>>();
            concatMap.put("phone", (List<String>)phoneList);
            concatMap.put("email", (List<String>)emailList);
            Boolean result = ServiceFactory.getService(ISendMessageService.class).sendTextMessage(buNumber, bizId, RuleEngineSceneNumberEnum.COLLECT_TASK_NOTICE_MESSAGE, concatMap, paramMap);
            dynamicObject.set("sendtext", (Object)(result != false ? "1" : "0"));
        }
        HomCommonRepository.updateDynamicObjects("hom_collect", dynamicObjects);
    }

    @Override
    public void noticeCandidateWithoutCond(DynamicObject[] dynamicObjects) {
        if (HRArrayUtils.isEmpty((Object[])dynamicObjects)) {
            return;
        }
        for (DynamicObject dynamicObject : dynamicObjects) {
            Boolean result = ServiceFactory.getService(ISendMessageService.class).sendMessageNew(dynamicObject, RuleEngineSceneNumberEnum.COLLECT_NOTICE_MESSAGE);
            dynamicObject.set("sendtext", (Object)(result != false ? "1" : "0"));
        }
        HomCommonRepository.updateDynamicObjects("hom_collect", dynamicObjects);
    }

    @Override
    public void sendNoticeCandidate(Long onbrdId, Date dateNew, Date dateOld) {
        if (dateNew != null && (dateOld == null || dateNew.compareTo(dateOld) != 0)) {
            this.noticeCandidate(onbrdId);
        }
    }

    @Override
    public Integer workTableCollectCountNum(String enrollstatus, String collectstatus, List<Long> adminorgids, List<Long> hrbuids) {
        List<Long> onboardId = this.workTableCollectOnbIds(enrollstatus, collectstatus, adminorgids, hrbuids);
        if (onboardId == null) {
            return 0;
        }
        return onboardId.size();
    }

    @Override
    public List<Long> workTableCollectOnbIds(String enrollstatus, String collectstatus, List<Long> adminorgids, List<Long> hrbuids) {
        DynamicObject[] collectDyns = this.workTableCollect(enrollstatus, collectstatus, adminorgids, hrbuids);
        if (collectDyns == null || collectDyns.length == 0) {
            return new ArrayList<Long>();
        }
        QFilter status = new QFilter("activityins.taskstatus", "!=", (Object)ActivityStatusEnum.TOASSIGN.getValue());
        List onboardId = Arrays.stream(collectDyns).map(dy -> dy.getLong("onboard.id")).collect(Collectors.toList());
        QFilter onbFilter = new QFilter("onbrdid", "in", onboardId);
        QFilter activityTypeFilter = new QFilter("activity.id", "=", (Object)ActivityNumberEnum.INFOCOLLECTION.getId());
        QFilter activity = new QFilter("activityins", "!=", (Object)0L);
        QFilter perQFilter = WORK_TABLE_SERVICE.getPermQFilter("hom_collaborationalllist", "QXX0001");
        if (!HRObjectUtils.isEmpty((Object)perQFilter)) {
            onbFilter = onbFilter.and(perQFilter);
        }
        DynamicObject[] activityDyns = HomCommonRepository.queryDynamicObjects("hom_activeinfobody", "onbrdid", status, onbFilter, activityTypeFilter, activity);
        return Arrays.stream(activityDyns).map(dy -> dy.getLong("onbrdid.id")).collect(Collectors.toList());
    }

    @Override
    public void syncMajorCertInfo(Long candidateId, Long onboardId) {
        DynamicObjectCollection multiRowEntity = IHomToHcfAppService.getInstance().getHisMultiRowEntity(candidateId, "hcf_cancre");
        DynamicObject onbrdDyn = HomCommonRepository.queryDynamicObjectByPk("hom_onbrdbillbase", "", onboardId);
        if (CollectionUtils.isEmpty((Collection)multiRowEntity)) {
            onbrdDyn.set("certificatetype", null);
            onbrdDyn.set("certificatenumber", null);
        } else if (multiRowEntity.size() == 1) {
            List<Map<String, DynamicObjectCollection>> list = this.setDynamic(multiRowEntity);
            IHomToHcfAppService.getInstance().saveOrUpdateCandidates(list);
            onbrdDyn.set("certificatetype", ((DynamicObject)multiRowEntity.get(0)).get("credentialstype"));
            onbrdDyn.set("certificatenumber", ((DynamicObject)multiRowEntity.get(0)).get("number"));
        } else {
            DynamicObject majorDyn = multiRowEntity.stream().filter(dynamicObject -> dynamicObject.getBoolean("ismajor")).findFirst().get();
            onbrdDyn.set("certificatetype", majorDyn.get("credentialstype"));
            onbrdDyn.set("certificatenumber", majorDyn.get("number"));
        }
        HomCommonRepository.updateDynamicObject("hom_onbrdbillbase", onbrdDyn);
    }

    private List<Map<String, DynamicObjectCollection>> setDynamic(DynamicObjectCollection multiRowEntity) {
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"hcf_cancre");
        ArrayList<Map<String, DynamicObjectCollection>> list = new ArrayList<Map<String, DynamicObjectCollection>>(1);
        for (DynamicObject dynamicObject : multiRowEntity) {
            DynamicObjectCollection saveDataDyColl = new DynamicObjectCollection();
            HashMap<String, DynamicObjectCollection> map = new HashMap<String, DynamicObjectCollection>(2);
            DynamicObject newDy = new DynamicObject((DynamicObjectType)dataEntityType);
            HRDynamicObjectUtils.copy((DynamicObject)dynamicObject, (DynamicObject)newDy);
            newDy.set("sourcevid", (Object)0L);
            saveDataDyColl.add((Object)newDy);
            map.put("hcf_cancre", saveDataDyColl);
            list.add(map);
        }
        return list;
    }

    private DynamicObject[] workTableCollect(String enrollstatus, String collectstatus, List<Long> adminorgids, List<Long> hrbuids) {
        List<Long> onbrdIds = ServiceFactory.getService(IActivityDomainService.class).findWorkTableOnbrd(enrollstatus, adminorgids, hrbuids);
        QFilter collectQFilter = new QFilter("collectstatus", "=", (Object)collectstatus);
        QFilter conFilter = new QFilter("onboard", "in", onbrdIds);
        return HomCommonRepository.queryDynamicObjects("hom_collect", "onboard", collectQFilter, conFilter);
    }

    @Override
    public void workTableSendNotice(String enrollstatus, String collectstatus, List<Long> adminorgids, List<Long> hrbuids, Boolean isall) {
        List<Long> onbrdIds = this.workTableCollectOnbIds(enrollstatus, collectstatus, adminorgids, hrbuids);
        QFilter conFilter = new QFilter("onboard", "in", onbrdIds);
        QFilter collectQFilter = new QFilter("collectstatus", "=", (Object)collectstatus);
        ArrayList<QFilter> list = new ArrayList<QFilter>();
        list.add(conFilter);
        list.add(collectQFilter);
        if (isall.booleanValue()) {
            QFilter isAllQFilter = new QFilter("sendtext", "=", (Object)"0");
            list.add(isAllQFilter);
        }
        DynamicObject[] collectDyns = HomCommonRepository.queryDynamicObjects("hom_collect", "onboard,sendtext", list.toArray(new QFilter[0]));
        this.noticeCandidateWithoutCond(collectDyns);
    }

    @Override
    public boolean isCollectActivityChange(DynamicObject dynamicObject) {
        DynamicObject currentCollect = HomCommonRepository.queryDynamicObjectByPk("hom_collect", "collectstatus,approvestatus", dynamicObject.getLong("id"));
        return !HRStringUtils.equals((String)dynamicObject.getString("collectstatus"), (String)currentCollect.getString("collectstatus")) || !HRStringUtils.equals((String)dynamicObject.getString("approvestatus"), (String)currentCollect.getString("approvestatus"));
    }

    @Override
    public void dynEntityBindAttach(List<Map<String, Object>> attachments, String controlKey, IFormView view) {
        if (CollectionUtils.isEmpty(attachments)) {
            return;
        }
        FileService attachmentFileService = FileServiceFactory.getAttachmentFileService();
        TempFileCache tempFileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        for (Map<String, Object> attachment : attachments) {
            String url = (String)attachment.get("url");
            if (!url.contains("&kdedcba")) continue;
            url = url.substring(0, url.indexOf("&kdedcba"));
            String path = UrlUtil.getParam((String)url, (String)"path");
            InputStream inputStream = attachmentFileService.getInputStream(path);
            String tempFileUrl = tempFileCache.saveAsFullUrl((String)attachment.get("name"), inputStream, 7200);
            attachment.put("url", tempFileUrl);
        }
        IPageCache cache = (IPageCache)view.getService(IPageCache.class);
        String cacheJsonString = cache.get("TampAttCache" + view.getPageId());
        Map<String, List<Map<String, Object>>> attachmentInfo = new HashMap<String, List<Map<String, Object>>>();
        if (!StringUtils.isEmpty((CharSequence)cacheJsonString)) {
            attachmentInfo = (Map)SerializationUtils.fromJsonString((String)cacheJsonString, Map.class);
        }
        attachmentInfo.put(controlKey, attachments);
        cacheJsonString = SerializationUtils.toJsonString(attachmentInfo);
        cache.put("TampAttCache" + view.getPageId(), cacheJsonString);
    }

    @Override
    public InfoGroupEntity.InfoGroupField findInfoGroupFieldById(List<InfoGroupEntity.InfoGroupField> infoGroupFieldList, Long fieldId) {
        if (CollectionUtils.isEmpty(infoGroupFieldList)) {
            return null;
        }
        Optional<InfoGroupEntity.InfoGroupField> result = infoGroupFieldList.stream().filter(infoGroupField -> fieldId.equals(infoGroupField.getFieldId())).findFirst();
        return result.orElse(null);
    }

    @Override
    public void afterF7Select(AfterF7SelectEvent evt, IDataModel dataModel, IFormView view) {
        ListSelectedRowCollection listSelectedRowCollection = evt.getListSelectedRowCollection();
        Object[] primaryKeyValues = listSelectedRowCollection.getPrimaryKeyValues();
        String fieldKey = ((Control)evt.getSource()).getKey();
        DynamicProperty property = dataModel.getDataEntityType().getProperty(fieldKey);
        if (property instanceof BasedataProp) {
            DynamicProperty idProperty = dataModel.getDataEntityType().getProperty(fieldKey + "_id");
            if (HRArrayUtils.isEmpty((Object[])primaryKeyValues)) {
                List inputValues = evt.getInputValues();
                if (CollectionUtils.isEmpty((Collection)inputValues)) {
                    dataModel.getDataEntity().set(fieldKey + "_id", (Object)0L);
                    dataModel.getDataEntity().set(fieldKey, null);
                    view.updateView(fieldKey);
                    return;
                }
                idProperty.setValueFast((Object)dataModel.getDataEntity(), inputValues.get(0));
            } else {
                idProperty.setValueFast((Object)dataModel.getDataEntity(), primaryKeyValues[0]);
            }
        } else if (property instanceof MulBasedataProp) {
            // empty if block
        }
    }
}

