/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.business.domain.service.impl.collect;

import com.google.common.collect.ImmutableMap;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.function.BiConsumer;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.field.DateEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.entity.commonfield.DateField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hom.common.constant.InfoGroupFieldConstants;
import kd.hr.hom.common.enums.CollectDynFormTypeEnum;
import kd.sdk.hr.hom.business.collect.IDynamicFiledViewService;
import kd.sdk.hr.hom.common.InfoGroupEntity;

public class DateFiledViewServiceImpl
implements IDynamicFiledViewService {
    Map<Long, BiConsumer<DateEdit, IFormView>> FIELD_STRATEGY_MAP = ImmutableMap.builder().put((Object)InfoGroupFieldConstants.BASE_BIRTHDAY, this::timeBeforeCurrent).put((Object)InfoGroupFieldConstants.CERT_BIR, this::timeBeforeCurrent).put((Object)InfoGroupFieldConstants.CERT_ISSUEDATE, this::timeBeforeAndEqualCurrent).put((Object)InfoGroupFieldConstants.CERT_EXPIRATIONDATE, this::timeAfterAndEqualCurrent).put((Object)InfoGroupFieldConstants.EDU_STARTTIME, this::eduTimeRangeStart).put((Object)InfoGroupFieldConstants.EDU_ENDTIME, this::eduTimeRangeEnd).put((Object)InfoGroupFieldConstants.WORK_STARTDATE, this::timeDefault).put((Object)InfoGroupFieldConstants.WORK_ENDDATE, this::timeDefault).put((Object)InfoGroupFieldConstants.LANG_SIGNTIME, this::timeBeforeAndEqualCurrent).put((Object)InfoGroupFieldConstants.RSMPATINV_APPLYTIME, this::timeBeforeAndEqualCurrent).put((Object)InfoGroupFieldConstants.EXAM_TIME, this::timeBeforeAndEqualCurrent).build();

    public Control getControl(String key, AbstractFormPlugin plugin, InfoGroupEntity.InfoGroupField infoGroupField) {
        DateEdit dateEdit = new DateEdit();
        dateEdit.setKey(key);
        dateEdit.setView(plugin.getView());
        if (!CollectDynFormTypeEnum.PRE_VIEW.getFormType().equals(plugin.getView().getFormShowParameter().getCustomParams().get("formtype"))) {
            this.FIELD_STRATEGY_MAP.getOrDefault(infoGroupField.getFieldId(), this::timeDefault).accept(dateEdit, plugin.getView());
        }
        return dateEdit;
    }

    public Field<?> buildField(IDataEntityProperty entityProperty, InfoGroupEntity.InfoGroupField infoGroupField, String suffix) {
        DateField dateField = new DateField();
        String key = "field" + infoGroupField.getFieldId();
        dateField.setId(key);
        dateField.setKey(key);
        return dateField;
    }

    public void registerDynamicProps(DynamicObjectType mainType, String fieldName, IDataEntityProperty entityProperty, String displayName, InfoGroupEntity.InfoGroupField field) {
        this.addFieldProp(mainType, fieldName, entityProperty, (FieldProp)new DateProp(), displayName, field);
    }

    private void timeDefault(DateEdit dateEdit, IFormView formView) {
    }

    private void timeBeforeAndEqualCurrent(DateEdit dateEdit, IFormView formView) {
        dateEdit.setMaxDate(new Date());
        dateEdit.setMaxDate(HRDateTimeUtils.format((Date)new Date()));
    }

    private void timeBeforeCurrent(DateEdit dateEdit, IFormView formView) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -1);
        dateEdit.setMaxDate(calendar.getTime());
        dateEdit.setMaxDate(HRDateTimeUtils.format((Date)calendar.getTime()));
    }

    private void eduTimeRangeStart(DateEdit dateEdit, IFormView formView) {
        IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)formView.getModel().getDataEntityType().getProperties().get((Object)("field" + InfoGroupFieldConstants.EDU_ENDTIME));
        if (HRObjectUtils.isEmpty((Object)iDataEntityProperty)) {
            return;
        }
        Date endDate = formView.getModel().getDataEntity().getDate("field" + InfoGroupFieldConstants.EDU_ENDTIME);
        if (!HRObjectUtils.isEmpty((Object)endDate)) {
            dateEdit.setMaxDate(endDate);
            dateEdit.setMaxDate(HRDateTimeUtils.format((Date)endDate));
        }
    }

    private void eduTimeRangeEnd(DateEdit dateEdit, IFormView formView) {
        IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)formView.getModel().getDataEntityType().getProperties().get((Object)("field" + InfoGroupFieldConstants.EDU_STARTTIME));
        if (HRObjectUtils.isEmpty((Object)iDataEntityProperty)) {
            return;
        }
        Date startDate = (Date)formView.getModel().getValue("field" + InfoGroupFieldConstants.EDU_STARTTIME);
        if (!HRObjectUtils.isEmpty((Object)startDate)) {
            dateEdit.setMinDate(startDate);
            dateEdit.setMinDate(HRDateTimeUtils.format((Date)startDate));
        }
    }

    private void timeAfterAndEqualCurrent(DateEdit dateEdit, IFormView formView) {
        dateEdit.setMinDate(new Date());
        dateEdit.setMinDate(HRDateTimeUtils.format((Date)new Date()));
    }
}

