/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.business.domain.service.impl.collect;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hom.business.application.hcf.IHomToHcfAppService;
import kd.hr.hom.business.domain.repository.common.HomCommonRepository;
import kd.hr.hom.business.domain.service.ServiceFactory;
import kd.hr.hom.business.domain.service.collect.ISyncCollectFromHcf;
import kd.hr.hom.business.domain.service.collect.ISyncCollectToHcf;
import kd.hr.hom.business.domain.service.common.IHomConfigService;
import kd.hr.hom.common.constant.InfoGroupFieldConstants;
import kd.hr.hom.common.entity.InfoGroupConfigEntity;
import kd.hr.hom.common.enums.InfoGroupFieldTypeEnum;
import kd.sdk.hr.hom.common.InfoGroupEntity;

public class SyncCollectFromHcfImpl
implements ISyncCollectFromHcf {
    @Override
    public void getCollectFromHcfByInfoGroup(IFormView iFormView, InfoGroupConfigEntity infoGroupConfigData, String infogroupnumber) {
        String pageKey;
        long onboardId = iFormView.getParentView().getModel().getDataEntity().getLong("onboard.id");
        HashMap hcfSingleMap = Maps.newHashMapWithExpectedSize((int)3);
        HashMap homEntityMap = Maps.newHashMapWithExpectedSize((int)3);
        List infoGroupEntityList = infoGroupConfigData.getInfoGroupEntityList();
        InfoGroupEntity infoGroupEntity = infoGroupEntityList.stream().filter(infoGroup -> infoGroup.getInfoGroupNumber().equalsIgnoreCase(infogroupnumber)).findFirst().get();
        infoGroupEntity.getInfoGroupFieldList().forEach(field -> {
            String pageKey = field.getPageKey();
            if ("hom_standardfield".equals(pageKey)) {
                return;
            }
            if (pageKey.contains("hcf_")) {
                ServiceFactory.getService(ISyncCollectToHcf.class).fillEntityMap(hcfSingleMap, (InfoGroupEntity.InfoGroupField)field, pageKey);
            } else {
                ServiceFactory.getService(ISyncCollectToHcf.class).fillEntityMap(homEntityMap, (InfoGroupEntity.InfoGroupField)field, pageKey);
            }
        });
        Long candidateId = iFormView.getParentView().getModel().getDataEntity().getLong("onboard.candidate.id");
        for (Map.Entry stringListEntry : hcfSingleMap.entrySet()) {
            pageKey = (String)stringListEntry.getKey();
            if ("hcf_canaddress".equals(pageKey)) {
                DynamicObjectCollection canAddressDynamicObject = IHomToHcfAppService.getInstance().getHisMultiRowEntity(candidateId, pageKey);
                String confVal = ServiceFactory.getService(IHomConfigService.class).getConfVal("ADDRESS_ID_MAP", "");
                if (HRStringUtils.isNotEmpty((String)confVal)) {
                    Map map = (Map)JSONObject.parseObject((String)confVal, Map.class);
                    InfoGroupFieldConstants.ADDRESS_ID_MAP.putAll(map);
                }
                InfoGroupFieldConstants.ADDRESS_ID_MAP.values().forEach(value -> this.setValue(iFormView, (Long)value, null));
                canAddressDynamicObject.forEach(dynamicObject -> {
                    String addressType = dynamicObject.getString("addresstype.id");
                    for (Map.Entry stringLongEntry : InfoGroupFieldConstants.ADDRESS_ID_MAP.entrySet()) {
                        String key = (String)stringLongEntry.getKey();
                        if (!key.startsWith(addressType)) continue;
                        String replaceKey = key.replace(addressType + "_", "");
                        this.setValue(iFormView, (Long)stringLongEntry.getValue(), dynamicObject.get(replaceKey));
                    }
                });
                continue;
            }
            this.getHcfSingleData(iFormView, pageKey, candidateId, (List)stringListEntry.getValue());
        }
        for (Map.Entry stringListEntry : homEntityMap.entrySet()) {
            pageKey = (String)stringListEntry.getKey();
            this.getHcfHomData(iFormView, pageKey, onboardId, (List)stringListEntry.getValue());
        }
    }

    private void setValue(IFormView formView, Long fieldId, Object object) {
        IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)formView.getModel().getDataEntityType().getProperties().get((Object)("field" + fieldId));
        if (HRObjectUtils.isEmpty((Object)iDataEntityProperty)) {
            return;
        }
        if (object == null || HRStringUtils.isEmpty((String)object.toString()) || HRObjectUtils.isEmpty((Object)object)) {
            formView.getModel().setValue("field" + fieldId, null);
            return;
        }
        if (iDataEntityProperty instanceof BasedataProp) {
            formView.getModel().getDataEntity().set("field" + fieldId + "_id", ((DynamicObject)object).get("id"));
        }
        formView.getModel().setValue("field" + fieldId, object);
    }

    @Override
    public void getHcfSingleData(IFormView iFormView, String pageKey, Long candidateId, List<InfoGroupEntity.InfoGroupField> fieldList) {
        DynamicObject singleRowEntity = IHomToHcfAppService.getInstance().getSingleRowEntity(candidateId, pageKey);
        if (HRObjectUtils.isEmpty((Object)singleRowEntity)) {
            singleRowEntity = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)pageKey));
            singleRowEntity.set("candidate", (Object)candidateId);
        }
        for (InfoGroupEntity.InfoGroupField infoGroupField : fieldList) {
            if (infoGroupField.getFieldType() == Integer.parseInt(InfoGroupFieldTypeEnum.ATTACH.getFieldType())) {
                AttachmentPanel attachmentPanel = (AttachmentPanel)iFormView.getControl("field" + infoGroupField.getFieldId());
                List attachments = AttachmentServiceHelper.getAttachments((String)infoGroupField.getPageKey(), (Object)singleRowEntity.getLong("id"), (String)infoGroupField.getFieldKey());
                IClientViewProxy proxy = (IClientViewProxy)attachmentPanel.getView().getService(IClientViewProxy.class);
                proxy.setFieldProperty(attachmentPanel.getKey(), "v", (Object)attachments);
                continue;
            }
            iFormView.getModel().setValue("field" + infoGroupField.getFieldId(), singleRowEntity.get(infoGroupField.getFieldKey()));
            IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)singleRowEntity.getDataEntityType().getProperties().get((Object)infoGroupField.getFieldKey());
            if (!(iDataEntityProperty instanceof BasedataProp)) continue;
            DynamicObject dynamicObject = singleRowEntity.getDynamicObject(infoGroupField.getFieldKey());
            if (HRObjectUtils.isEmpty((Object)dynamicObject)) {
                iFormView.updateView("field" + infoGroupField.getFieldId());
                continue;
            }
            iFormView.getModel().getDataEntity().set("field" + infoGroupField.getFieldId() + "_id", (Object)dynamicObject.getLong("id"));
        }
    }

    @Override
    public void getHcfHomData(IFormView iFormView, String pageKey, Long onboardId, List<InfoGroupEntity.InfoGroupField> fieldList) {
        DynamicObject homEntity = HomCommonRepository.queryDynamicObjectByPk(pageKey, "", iFormView.getParentView().getModel().getDataEntity().getLong("onboard.id"));
        for (InfoGroupEntity.InfoGroupField infoGroupField : fieldList) {
            if (infoGroupField.getFieldType() == Integer.parseInt(InfoGroupFieldTypeEnum.ATTACH.getFieldType())) {
                AttachmentPanel attachmentPanel = (AttachmentPanel)iFormView.getControl("field" + infoGroupField.getFieldId());
                List attachments = AttachmentServiceHelper.getAttachments((String)infoGroupField.getPageKey(), (Object)onboardId, (String)infoGroupField.getFieldKey());
                IClientViewProxy proxy = (IClientViewProxy)attachmentPanel.getView().getService(IClientViewProxy.class);
                proxy.setFieldProperty(attachmentPanel.getKey(), "v", (Object)attachments);
                continue;
            }
            iFormView.getModel().setValue("field" + infoGroupField.getFieldId(), homEntity.get(infoGroupField.getFieldKey()));
            IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)homEntity.getDataEntityType().getProperties().get((Object)infoGroupField.getFieldKey());
            if (!(iDataEntityProperty instanceof BasedataProp)) continue;
            DynamicObject dynamicObject = homEntity.getDynamicObject(infoGroupField.getFieldKey());
            if (HRObjectUtils.isEmpty((Object)dynamicObject)) {
                iFormView.updateView("field" + infoGroupField.getFieldId());
                continue;
            }
            iFormView.getModel().getDataEntity().set("field" + infoGroupField.getFieldId() + "_id", (Object)dynamicObject.getLong("id"));
        }
    }
}

