/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.business.domain.service.impl.collect;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.TextProp;
import kd.bos.form.control.Control;
import kd.bos.form.field.EmailEdit;
import kd.bos.form.field.TelephoneEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.entity.commonfield.EmailField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.TelephoneField;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.sdk.hr.hom.business.collect.IDynamicFiledViewService;
import kd.sdk.hr.hom.common.InfoGroupEntity;

public class TextFiledViewServiceImpl
implements IDynamicFiledViewService {
    private final Set<String> PHONE_FIELD_LIST = ImmutableSet.of((Object)"phone", (Object)"mobilephone", (Object)"emrgphone");
    private final Set<String> EMAIL_FIELD_LIST = ImmutableSet.of((Object)"peremail");
    private final Set<String> BANK_FIELD_LIST = ImmutableSet.of((Object)"account");

    public Field<?> buildField(IDataEntityProperty entityProperty, InfoGroupEntity.InfoGroupField infoGroupField, String suffix) {
        TextProp originProp = (TextProp)entityProperty;
        TextField field = new TextField();
        field.setMaxLength(originProp.getMaxLenth());
        field.setMinLength(originProp.getMinLenth());
        if (this.PHONE_FIELD_LIST.contains(infoGroupField.getFieldKey())) {
            TelephoneField telephoneField = new TelephoneField();
            telephoneField.setValidateRule(true);
            return telephoneField;
        }
        if (this.EMAIL_FIELD_LIST.contains(infoGroupField.getFieldKey())) {
            return new EmailField();
        }
        if (this.BANK_FIELD_LIST.contains(infoGroupField.getFieldKey())) {
            field.setTextFormat("(4, )");
            field.setMinLength(16);
            field.setMaxLength(23);
        }
        return field;
    }

    public void registerDynamicProps(DynamicObjectType mainType, String fieldName, IDataEntityProperty entityProperty, String displayName, InfoGroupEntity.InfoGroupField field) {
        TextProp originProp = (TextProp)entityProperty;
        TextProp textProp = new TextProp();
        textProp.setMaxLenth(originProp.getMaxLenth());
        textProp.setMinLenth(originProp.getMinLenth());
        this.addFieldProp(mainType, fieldName, entityProperty, (FieldProp)textProp, displayName, field);
    }

    public Control getControl(String key, AbstractFormPlugin plugin, InfoGroupEntity.InfoGroupField infoGroupField) {
        TextEdit textEdit = new TextEdit();
        if (this.PHONE_FIELD_LIST.contains(infoGroupField.getFieldKey())) {
            TelephoneEdit telephoneEdit = new TelephoneEdit();
            telephoneEdit.setKey(key);
            telephoneEdit.setView(plugin.getView());
            return telephoneEdit;
        }
        if (this.EMAIL_FIELD_LIST.contains(infoGroupField.getFieldKey())) {
            EmailEdit emailEdit = new EmailEdit();
            emailEdit.setKey(key);
            emailEdit.setView(plugin.getView());
            return emailEdit;
        }
        textEdit.setKey(key);
        textEdit.setView(plugin.getView());
        return textEdit;
    }
}

