/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.business.domain.service.impl.common;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.operate.MutexHelper;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mutex.AutoReleaseLock;
import kd.bos.mutex.DataMutex;
import kd.bos.mutex.impl.MutexLockInfo;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hom.business.domain.service.common.IHomDataMutexService;

public class HomDataMutexServiceImpl
implements IHomDataMutexService {
    private static final Log logger = LogFactory.getLog(HomDataMutexServiceImpl.class);

    @Override
    public boolean release(String dataObjId, String entityKey, String operationKey) {
        return DataMutex.create().release(dataObjId, entityKey, operationKey);
    }

    @Override
    public Map<Long, Boolean> batchRequire(Collection<Long> dataObjIdSet, String entityKey, String operationKey) {
        return this.batchRequire(dataObjIdSet, entityKey, operationKey, false);
    }

    @Override
    public Map<Long, Boolean> batchRequire(Collection<Long> dataObjIdSet, String entityKey, String operationKey, boolean isStrict) {
        logger.info("Start to batchRequire");
        String groupId = MutexHelper.getMutexGroupId((String)entityKey, (String)operationKey);
        ArrayList<HashMap> dataList = new ArrayList<HashMap>(dataObjIdSet.size());
        for (Long dataObjId : dataObjIdSet) {
            HashMap map = Maps.newHashMapWithExpectedSize((int)5);
            map.put("dataObjId", String.valueOf(dataObjId));
            map.put("entityKey", entityKey);
            map.put("operationKey", operationKey);
            map.put("groupId", groupId);
            map.put("isStrict", isStrict);
            dataList.add(map);
        }
        Map batchRequireResult = DataMutex.create().batchrequire(dataList);
        try {
            logger.info("End to batchRequire" + HRJSONUtils.toString((Object)batchRequireResult));
        }
        catch (IOException iOException) {
            logger.error((Throwable)iOException);
        }
        return batchRequireResult.entrySet().stream().peek(entry -> {
            if (entry.getValue() != null && ((Boolean)entry.getValue()).booleanValue()) {
                AutoReleaseLock.create().register((String)entry.getKey(), entityKey, operationKey);
            }
        }).collect(Collectors.toMap(entry -> Long.parseLong((String)entry.getKey()), Map.Entry::getValue));
    }

    @Override
    public Map<Long, Boolean> batchRelease(Collection<Long> dataObjIdSet, String entityKey, String operationKey) {
        logger.info("Start to batchRelease");
        String groupId = MutexHelper.getMutexGroupId((String)entityKey, (String)operationKey);
        ArrayList<HashMap> dataList = new ArrayList<HashMap>(dataObjIdSet.size());
        for (Long dataObjId : dataObjIdSet) {
            HashMap map = Maps.newHashMapWithExpectedSize((int)5);
            map.put("dataObjId", String.valueOf(dataObjId));
            map.put("entityKey", entityKey);
            map.put("operationKey", operationKey);
            map.put("groupId", groupId);
            dataList.add(map);
        }
        Map batchReleaseResult = DataMutex.create().batchRelease(dataList);
        try {
            logger.info("End to batchRelease " + HRJSONUtils.toString((Object)batchReleaseResult));
        }
        catch (IOException iOException) {
            logger.error((Throwable)iOException);
        }
        return batchReleaseResult.entrySet().stream().collect(Collectors.toMap(entry -> Long.parseLong((String)entry.getKey()), Map.Entry::getValue));
    }

    @Override
    public boolean releaseLock(IFormView formView) {
        return MutexHelper.release((IFormView)formView);
    }

    @Override
    public boolean requireLock(String pkId, String entityName, IFormView view, String operationKey, boolean isStrict, String isNeedView) {
        logger.info("HomDataMutexServiceImpl:pkid=" + pkId + "entityname:" + entityName + "operationKey:" + operationKey);
        StringBuilder errMsg = new StringBuilder();
        boolean result = true;
        MutexLockInfo lockInfo = new MutexLockInfo(pkId, (String)null, (String)null, entityName, operationKey, isStrict, "default");
        result = "1".equals(isNeedView) && view != null ? MutexHelper.require((IFormView)view, (MutexLockInfo)lockInfo, (StringBuilder)errMsg) : MutexHelper.require((MutexLockInfo)lockInfo, (StringBuilder)errMsg);
        if (!result && view != null) {
            view.showTipNotification(errMsg.toString());
        }
        if (result) {
            AutoReleaseLock.create().register(pkId, entityName, operationKey);
        }
        return result;
    }

    @Override
    public void cleanMutexLockCacheBeforeRequireLock(IFormView view, String pkId, String entityName, String operationKey) {
        if (view == null) {
            return;
        }
        IPageCache pageCache = view.getPageCache();
        String mutexEntityKey = pageCache.get("MUTEX_ENTITY_KEY");
        String mutexOpKey = pageCache.get("MUTEX_OPER_KEY");
        String mutexObjId = pageCache.get("MUTEX_OBJ_ID");
        if (HRStringUtils.equals((String)pkId, (String)mutexObjId) && HRStringUtils.equals((String)entityName, (String)mutexEntityKey) && HRStringUtils.equals((String)operationKey, (String)mutexOpKey)) {
            pageCache.put("MUTEX_ENTITY_KEY", null);
            pageCache.put("MUTEX_OPER_KEY", null);
            pageCache.put("MUTEX_OBJ_ID", null);
        }
    }
}

