/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.business.domain.service.impl.hcf;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hom.business.application.hcf.IHomToHcfAppService;
import kd.hr.hom.business.domain.repository.HcfRepository;
import kd.hr.hom.business.domain.repository.common.HomCommonRepository;
import kd.hr.hom.business.domain.service.hcf.IHcfDataDomainService;
import kd.hr.hom.business.domain.service.onbrd.IOnbrdBillDomainService;

public class HcfDataDomainService
implements IHcfDataDomainService {
    @Override
    public void syncDataFormHcfToHom(Long onbrdId) {
        DynamicObject onbrdBillDyn = HomCommonRepository.queryDynamicObjectByPk("hom_onbrdbillbase", "", onbrdId);
        IHomToHcfAppService homToHcfAppService = IHomToHcfAppService.getInstance();
        DynamicObject candidateConInfo = homToHcfAppService.getSingleRowEntity(onbrdBillDyn.getLong("candidate.id"), "hcf_cancontactinfo");
        DynamicObject canBaseInfo = homToHcfAppService.getSingleRowEntity(onbrdBillDyn.getLong("candidate.id"), "hcf_canbaseinfo");
        if (!HRObjectUtils.isEmpty((Object)candidateConInfo)) {
            onbrdBillDyn.set("phone", candidateConInfo.get("phone"));
            onbrdBillDyn.set("peremail", candidateConInfo.get("peremail"));
        }
        if (!HRObjectUtils.isEmpty((Object)canBaseInfo)) {
            onbrdBillDyn.set("gender", canBaseInfo.get("gender"));
            onbrdBillDyn.set("name", canBaseInfo.get("name"));
        }
        HomCommonRepository.updateDynamicObject("hom_onbrdbillbase", onbrdBillDyn);
    }

    @Override
    public Map<String, Object> saveCandidateWithResult(DynamicObject[] candidates) {
        if (HRArrayUtils.isEmpty((Object[])candidates)) {
            return null;
        }
        DynamicObjectCollection collection = Arrays.stream(candidates).collect(Collectors.toCollection(DynamicObjectCollection::new));
        return HcfRepository.saveCandidateData("hcf_candidate", collection);
    }

    @Override
    public Map<String, DynamicObject> saveCandidate(DynamicObject[] candidates) {
        Map<String, Object> saveResult = this.saveCandidateWithResult(candidates);
        if (CollectionUtils.isEmpty(saveResult)) {
            return null;
        }
        Set candidateNumSet = Arrays.stream(candidates).map(candidate -> candidate.getString("number")).collect(Collectors.toSet());
        QFilter qFilter = new QFilter("number", "in", candidateNumSet);
        return this.queryCandidate("boid", new QFilter[]{qFilter});
    }

    @Override
    public DynamicObject saveCandidate(DynamicObject candidate) {
        Map<String, DynamicObject> resultMap = this.saveCandidate(new DynamicObject[]{candidate});
        if (CollectionUtils.isEmpty(resultMap)) {
            return null;
        }
        return resultMap.get(candidate.getString("number"));
    }

    @Override
    public void saveHcfToHom(Long onbrdId, Map<String, Object> param) {
        if (onbrdId != null && !onbrdId.equals(0L) && !HRObjectUtils.isEmpty(param) && param.size() > 0) {
            IOnbrdBillDomainService onbrdBillDomainService = IOnbrdBillDomainService.getInstance();
            String selectProperties = param.keySet().stream().collect(Collectors.joining(","));
            DynamicObject onbrdBillObj = onbrdBillDomainService.findOnbrdBillById(selectProperties, onbrdId);
            for (Map.Entry<String, Object> map : param.entrySet()) {
                onbrdBillObj.set(map.getKey(), map.getValue());
            }
            onbrdBillDomainService.saveOnbrdBillInfo(onbrdBillObj);
        }
    }

    @Override
    public DynamicObject getAddressType(String addressTypeNumber) {
        return HcfRepository.getAddressType(addressTypeNumber);
    }

    @Override
    public DynamicObject getAddressTypeById(Long addressTypeId) {
        return HcfRepository.getAddressTypeById(addressTypeId);
    }

    @Override
    public Map<String, DynamicObject> queryCandidate(String propertiesSelected, QFilter[] qFilters) {
        DynamicObject[] candidateFromDBs = HcfRepository.queryCandidate(propertiesSelected, qFilters);
        return Arrays.stream(candidateFromDBs).collect(Collectors.toMap(candidate -> candidate.getString("number"), candidate -> candidate, (oldValue, newValue) -> newValue));
    }

    @Override
    public DynamicObject[] queryHcfAttachedData(String hcfEntityName, String hcfProperties, QFilter[] qFilters) {
        return HcfRepository.queryHcfAttachedData(hcfEntityName, hcfProperties, qFilters);
    }

    @Override
    public DynamicObject[] queryHcfAttachedData(Collection<Long> candidateIds, String hcfEntityName, String hcfProperties) {
        return HcfRepository.queryHcfAttachedData(candidateIds, hcfEntityName, hcfProperties);
    }

    @Override
    public Map<Long, Map<String, DynamicObjectCollection>> queryOrLoadHcfAttachedData(List<Long> candidateIds, Map<String, String> entityFieldsMap) {
        return HcfRepository.getCandidateBatch(candidateIds, entityFieldsMap);
    }

    @Override
    public Map<Long, DynamicObject> querySingleRowEntity(Collection<Long> candidateIds, String hcfEntityName, String hcfProperties) {
        if (HRStringUtils.isEmpty((String)hcfProperties)) {
            HashMap entityFieldsMap = Maps.newHashMapWithExpectedSize((int)2);
            entityFieldsMap.put(hcfEntityName, "");
            ArrayList<Long> candidateIdList = new ArrayList<Long>(candidateIds);
            Map<Long, Map<String, DynamicObjectCollection>> candidateInfoMaps = this.queryOrLoadHcfAttachedData(candidateIdList, entityFieldsMap);
            return candidateInfoMaps.entrySet().stream().filter(entry -> {
                Map entityMap = (Map)entry.getValue();
                boolean isNoData = CollectionUtils.isEmpty((Map)entityMap) || CollectionUtils.isEmpty((Collection)((Collection)entityMap.get(hcfEntityName)));
                return !isNoData;
            }).collect(Collectors.toMap(Map.Entry::getKey, entry -> (DynamicObject)((DynamicObjectCollection)((Map)entry.getValue()).get(hcfEntityName)).get(0), (oldValue, newValue) -> newValue));
        }
        return HcfRepository.querySingleRowEntity(candidateIds, hcfEntityName, hcfProperties);
    }

    @Override
    public Map<Long, DynamicObjectCollection> queryMultiRowEntity(Collection<Long> candidateIds, String hcfEntityName, String hcfProperties) {
        ArrayList<Long> candidateIdList = new ArrayList<Long>(candidateIds);
        if (HRStringUtils.isEmpty((String)hcfProperties)) {
            HashMap entityFieldsMap = Maps.newHashMapWithExpectedSize((int)2);
            entityFieldsMap.put(hcfEntityName, "");
            Map<Long, Map<String, DynamicObjectCollection>> candidateInfoMaps = this.queryOrLoadHcfAttachedData(candidateIdList, entityFieldsMap);
            return candidateInfoMaps.entrySet().stream().filter(entry -> {
                Map entityMap = (Map)entry.getValue();
                boolean isNoData = CollectionUtils.isEmpty((Map)entityMap) || CollectionUtils.isEmpty((Collection)((Collection)entityMap.get(hcfEntityName)));
                return !isNoData;
            }).collect(Collectors.toMap(Map.Entry::getKey, entry -> (DynamicObjectCollection)((Map)entry.getValue()).get(hcfEntityName), (oldValue, newValue) -> newValue));
        }
        return HcfRepository.queryMultiRowEntity(candidateIdList, hcfEntityName, hcfProperties);
    }

    @Override
    public Map<String, Object> saveHcfAttachedData(String hcfEntityName, DynamicObject[] hcfAttachedDatas) {
        DynamicObjectCollection collection = Arrays.stream(hcfAttachedDatas).collect(Collectors.toCollection(DynamicObjectCollection::new));
        return HcfRepository.saveCandidateData(hcfEntityName, collection);
    }

    @Override
    public Map<String, Object> saveHcfAttachedData(Map<String, Collection<DynamicObject>> hcfEntityInfosMap) {
        HashMap candidateInfoMap = Maps.newHashMapWithExpectedSize((int)hcfEntityInfosMap.size());
        for (Map.Entry<String, Collection<DynamicObject>> entry : hcfEntityInfosMap.entrySet()) {
            if (entry.getValue() instanceof DynamicObjectCollection) {
                candidateInfoMap.put(entry.getKey(), (DynamicObjectCollection)entry.getValue());
                continue;
            }
            DynamicObjectCollection collection = new DynamicObjectCollection();
            for (DynamicObject dynamicObject : entry.getValue()) {
                collection.add((Object)dynamicObject);
            }
            candidateInfoMap.put(entry.getKey(), collection);
        }
        ArrayList<Map<String, DynamicObjectCollection>> candidateInfoList = new ArrayList<Map<String, DynamicObjectCollection>>(2);
        candidateInfoList.add(candidateInfoMap);
        return HcfRepository.saveCandidateData(candidateInfoList);
    }

    @Override
    public Map<Long, Map<String, Object>> deleteByIds(Set<Long> ids, String entityName) {
        if (CollectionUtils.isEmpty(ids)) {
            return new HashMap<Long, Map<String, Object>>();
        }
        return HcfRepository.deleteByIds(ids, entityName);
    }

    @Override
    public void deleteHcfAttachedData(String entityName, List<Long> candidateIds) {
        HcfRepository.deleteHcfAttachedData(entityName, candidateIds);
    }
}

