/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.business.domain.service.impl.msg;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.api.EmailInfo;
import kd.bos.message.api.IMessageService;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hom.business.application.utils.SendMessageUtil;
import kd.hr.hom.business.domain.service.ServiceFactory;
import kd.hr.hom.business.domain.service.msg.MsgParamService;

public class EmailMsgParamServiceImpl
implements MsgParamService {
    private static final Log logger = LogFactory.getLog(EmailMsgParamServiceImpl.class);

    public boolean sendMessage(Map<String, List<String>> targetMap, DynamicObject templateDyn, DynamicObject onbrdBill, Map<String, String> paramMap) {
        Map<String, String> messageTextMap;
        if (this.beforeCheck(templateDyn, onbrdBill)) {
            logger.info("\u6d88\u606f\u6e20\u9053\u7981\u7528{0}", (Object)templateDyn.getString("msgchannel"));
            return true;
        }
        try {
            messageTextMap = this.getMessageText(templateDyn, onbrdBill.getLong("id"), paramMap);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            return false;
        }
        List<String> receiverList = targetMap.getOrDefault("email", new ArrayList());
        receiverList = SendMessageUtil.getFilterStrList(receiverList);
        if (HRCollUtil.isEmpty(receiverList)) {
            return true;
        }
        HashMap<String, Object> emailInfoMap = new HashMap<String, Object>(16);
        emailInfoMap.put("title", messageTextMap.getOrDefault("emailTitle", ""));
        emailInfoMap.put("receiver", receiverList);
        emailInfoMap.put("copyreceiver", receiverList);
        emailInfoMap.put("secretreceiver", receiverList);
        emailInfoMap.put("content", messageTextMap.getOrDefault("emailContent", ""));
        return this.sendMailInfo(emailInfoMap);
    }

    private boolean sendMailInfo(Map<String, Object> emailInfoMap) {
        try {
            Object attachmentNames;
            if (CollectionUtils.isEmpty(emailInfoMap)) {
                return false;
            }
            EmailInfo emailInfo = new EmailInfo();
            emailInfo.setTitle((String)emailInfoMap.get("title"));
            Object receiver = emailInfoMap.get("receiver");
            if (receiver instanceof List) {
                List receiverList = (List)receiver;
                emailInfo.setReceiver(receiverList);
            }
            emailInfo.setContentMimeType("HTML");
            emailInfo.setContent((String)emailInfoMap.get("content"));
            Object attachments = emailInfoMap.get("attachments");
            if (attachments instanceof List) {
                List attachmentsList = (List)attachments;
                emailInfo.setAttachments(attachmentsList);
            }
            if ((attachmentNames = emailInfoMap.get("attachmentnames")) instanceof List) {
                emailInfo.setAttachmentNames((List)attachmentNames);
            }
            ServiceFactory.getService(IMessageService.class).sendEmail(emailInfo);
            logger.info("sendmail-end-resultMap success");
            return true;
        }
        catch (Exception exception) {
            logger.error("sendMailInfo exception", (Throwable)exception);
            return false;
        }
    }
}

