/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.business.domain.service.impl.msg;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hom.business.application.utils.SendMessageUtil;
import kd.hr.hom.business.domain.service.impl.common.MessageTemplateParser;
import kd.hr.hom.business.domain.service.impl.common.SendMessageServiceImpl;
import kd.hr.hom.business.domain.service.msg.MsgParamService;

public class SmsMsgParamServiceImpl
implements MsgParamService {
    private static final Log logger = LogFactory.getLog(SendMessageServiceImpl.class);

    public boolean sendMessage(Map<String, List<String>> targetMap, DynamicObject templateDyn, DynamicObject onbrdBill, Map<String, String> paramMap) {
        Map<String, String> messageTextMap;
        if (this.beforeCheck(templateDyn, onbrdBill)) {
            logger.info("\u6d88\u606f\u6e20\u9053\u7981\u7528{0}", (Object)templateDyn.getString("msgchannel"));
            return true;
        }
        try {
            messageTextMap = this.getMessageText(templateDyn, onbrdBill.getLong("id"), paramMap);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            return false;
        }
        try {
            List phoneList = targetMap.getOrDefault("phone", new ArrayList());
            Tuple<String, String> sysWhiteListConfig = SendMessageUtil.smsWhiteList();
            phoneList = phoneList.stream().filter(phone -> !HRStringUtils.equals((String)((String)sysWhiteListConfig.item1), (String)"1") || ((String)sysWhiteListConfig.item2).contains((CharSequence)phone)).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(phoneList)) {
                return true;
            }
            MessageInfo messageInfo = new MessageInfo();
            messageInfo.setMessageContent((ILocaleString)new LocaleString(messageTextMap.getOrDefault("content", "")));
            messageInfo.setNotifyType(templateDyn.getString("msgchannel"));
            Map<String, Object> params = MessageTemplateParser.parserMessageTplParam(templateDyn.getString("number"), onbrdBill.getLong("id"), new HashMap<String, Object>(), templateDyn);
            params.put("phone", phoneList);
            params.putAll(paramMap);
            if (params.containsKey("phone")) {
                params.put("model_phone", params.get("phone"));
            }
            if (params.containsKey("email")) {
                params.put("model_email", params.get("email"));
            }
            messageInfo.setParams(params);
            MessageCenterServiceHelper.batchSendMessages(Collections.singletonList(messageInfo));
            return true;
        }
        catch (Exception exception) {
            logger.error("sendTextMessageService exception", (Throwable)exception);
            return false;
        }
    }
}

