/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.business.domain.service.impl.onbrd;

import java.util.Collections;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hom.business.application.common.Service;
import kd.hr.hom.business.application.onbrd.IOnbrdBreakupAppService;
import kd.hr.hom.business.application.onbrd.IOnbrdCommonAppService;
import kd.hr.hom.business.domain.service.ServiceFactory;
import kd.hr.hom.business.domain.service.common.IBaseDataDomainService;
import kd.hr.hom.business.domain.service.onbrd.IOnbrdBillExecuteService;
import kd.hr.hom.common.enums.OnbrdStatusEnum;
import kd.hr.hom.common.enums.ProcessStatusEnum;

@Service(value="breakup")
public class BreakUpOnbrdBillExecuteServiceImpl
implements IOnbrdBillExecuteService {
    @Override
    public Tuple<Boolean, String> validateOnbrdBill(DynamicObject onbrdBill) {
        boolean checkPermission = ServiceFactory.getService(IOnbrdCommonAppService.class).checkPermission("hom_personwaitonbrd", "24IKE4ZWX1B7");
        if (!checkPermission) {
            String permItemName = IBaseDataDomainService.getInstance().getPermItemNameById("24IKE4ZWX1B7");
            String msg = String.format(ResManager.loadKDString((String)"\u6ca1\u6709\u201c%1$s\u201d\u7684\u529f\u80fd\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"OnbrdCommonAppServiceImpl_1", (String)"hr-hom-business", (Object[])new Object[0]), permItemName);
            return Tuple.create((Object)Boolean.FALSE, (Object)msg);
        }
        String processStatus = onbrdBill.getString("processstatus");
        if (HRStringUtils.equals((String)ProcessStatusEnum.END_PROCESS.getValue(), (String)processStatus)) {
            return Tuple.create((Object)Boolean.FALSE, (Object)ResManager.loadKDString((String)"\u6d41\u7a0b\u72b6\u6001\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u4e0d\u80fd\u91cd\u590d\u6267\u884c\u64cd\u4f5c\uff1b", (String)"OnbrdBreakupEdit_16", (String)"hr-hom-formplugin", (Object[])new Object[0]));
        }
        String enrollStatus = onbrdBill.getString("enrollstatus");
        if (!HRStringUtils.equals((String)OnbrdStatusEnum.WAIT_ONBRD.getValue(), (String)enrollStatus)) {
            return Tuple.create((Object)Boolean.FALSE, (Object)ResManager.loadKDString((String)"\u53ea\u80fd\u7ec8\u6b62\u5165\u804c\u6d41\u7a0b\u4e2d\u7684\u5355\u636e\u3002", (String)"IOnbrdBillExecuteService_1", (String)"hr-hom-business", (Object[])new Object[0]));
        }
        return Tuple.create((Object)Boolean.TRUE, (Object)"");
    }

    @Override
    public Tuple<Boolean, String> executeOnbrdBill(DynamicObject onbrdBill, String remark) {
        Boolean result = IOnbrdBreakupAppService.getInstance().doSomethingsWithBreakup(Collections.singletonList(onbrdBill.getLong("id")), null, null, remark, null);
        String desc = result != false ? "" : ResManager.loadKDString((String)"\u7ec8\u6b62\u5165\u804c\u5931\u8d25", (String)"IOnbrdBillExecuteService_2", (String)"hr-hom-business", (Object[])new Object[0]);
        return Tuple.create((Object)result, (Object)desc);
    }
}

