/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.business.domain.service.impl.onbrd;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hom.business.application.hrpi.IHomToHrpiAppService;
import kd.hr.hom.business.application.onbrd.IOnbrdCommonAppService;
import kd.hr.hom.business.domain.repository.HcfRepository;
import kd.hr.hom.business.domain.repository.OnbrdBillRepository;
import kd.hr.hom.business.domain.repository.common.HomCommonRepository;
import kd.hr.hom.business.domain.service.ServiceFactory;
import kd.hr.hom.business.domain.service.collect.ICollectService;
import kd.hr.hom.business.domain.service.onbrd.IOnbrdBillDomainService;
import kd.hr.hom.common.constant.InfoGroupFieldConstants;
import kd.hr.hom.common.constant.OnbrdPersonFieldConstants;
import kd.hr.hom.common.entity.DataDiv;
import kd.hr.hom.common.enums.ActivityStatusEnum;
import kd.hr.hom.common.enums.BillStatusEnum;
import kd.hr.hom.common.enums.CheckinStatusEnum;
import kd.hr.hom.common.enums.OnbrdStatusEnum;
import kd.hr.hom.common.enums.SynchStatusEnum;
import kd.sdk.hr.hom.common.InfoGroupEntity;

public class OnbrdBillDomainService
implements IOnbrdBillDomainService {
    private static final int CERT_VALIDATE = 0;
    private static final int CERT_VALUE_ERROR = 2;
    private static final int CERT_PERSON_VALUE_ERROR = 4;

    @Override
    public DynamicObject findOnbrdBillById(String selectProperties, Object pk) {
        return OnbrdBillRepository.findOnbrdBillById(selectProperties, pk);
    }

    @Override
    public DynamicObject[] findOnbrdBills(String selectProperties, QFilter[] filters) {
        return OnbrdBillRepository.findOnbrdBills(selectProperties, filters);
    }

    @Override
    public DynamicObject findOnbrdBill(String selectProperties, QFilter[] filters) {
        Object[] onbrdBills = this.findOnbrdBills(selectProperties, filters);
        if (HRArrayUtils.isEmpty((Object[])onbrdBills)) {
            return null;
        }
        return onbrdBills[0];
    }

    @Override
    public Object saveOnbrdBillInfo(DynamicObject dynamicObject) {
        return OnbrdBillRepository.saveOnbrdBillInfo(dynamicObject);
    }

    @Override
    public Object[] saveOnbrdBillInfos(DynamicObject[] dynamicObjects) {
        return OnbrdBillRepository.saveOnbrdBillInfos(dynamicObjects);
    }

    @Override
    public int deleteByCandidateIds(Collection<Long> candidateIds) {
        if (CollectionUtils.isEmpty(candidateIds)) {
            return 0;
        }
        return OnbrdBillRepository.deleteByCandidateIds(candidateIds);
    }

    @Override
    public int deleteByPkIds(Collection<Long> onbrdBillIds) {
        if (CollectionUtils.isEmpty(onbrdBillIds)) {
            return 0;
        }
        return OnbrdBillRepository.deleteByPkIds(onbrdBillIds);
    }

    @Override
    public boolean isEnrolled(Long onbrdId) {
        DynamicObject onbrdBillInfo = this.findOnbrdBillById("enrollstatus", onbrdId);
        if (!HRObjectUtils.isEmpty((Object)onbrdBillInfo)) {
            String enrollStatus = onbrdBillInfo.getString("enrollstatus");
            if (HRStringUtils.equals((String)OnbrdStatusEnum.HAS_ONBRD.toString(), (String)enrollStatus) || HRStringUtils.equals((String)OnbrdStatusEnum.BREAK_UP.toString(), (String)enrollStatus)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isCanOperate(Long onbrdId) {
        DynamicObject onbrdBillInfo = this.findOnbrdBillById("enrollstatus", onbrdId);
        if (!HRObjectUtils.isEmpty((Object)onbrdBillInfo)) {
            String enrollStatus = onbrdBillInfo.getString("enrollstatus");
            if (HRStringUtils.equals((String)OnbrdStatusEnum.HAS_ONBRD.toString(), (String)enrollStatus) || HRStringUtils.equals((String)OnbrdStatusEnum.BREAK_UP.toString(), (String)enrollStatus)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isEnrolled(Object[] onbrdIds) {
        QFilter onbrdIdsFilter = new QFilter("id", "in", (Object)onbrdIds);
        DynamicObject[] onbrdBills = this.findOnbrdBills("enrollstatus", new QFilter[]{onbrdIdsFilter});
        HashSet<String> enrollStatusSet = new HashSet<String>(onbrdBills.length);
        enrollStatusSet.add(OnbrdStatusEnum.HAS_ONBRD.toString());
        enrollStatusSet.add(OnbrdStatusEnum.BREAK_UP.toString());
        for (DynamicObject onbrdBill2 : onbrdBills) {
            enrollStatusSet.contains(onbrdBill2.getString("enrollstatus"));
        }
        return Arrays.stream(onbrdBills).filter(onbrdBill -> enrollStatusSet.contains(onbrdBill.getString("enrollstatus"))).findAny().isPresent();
    }

    @Override
    public DynamicObject[] isEnrolledInfos(Object[] onbrdIds) {
        QFilter onbrdIdsFilter = new QFilter("id", "in", (Object)onbrdIds);
        HashSet<String> enrollStatusSet = new HashSet<String>(2);
        enrollStatusSet.add(OnbrdStatusEnum.HAS_ONBRD.toString());
        enrollStatusSet.add(OnbrdStatusEnum.BREAK_UP.toString());
        QFilter enrollStatusFilter = new QFilter("enrollstatus", "in", enrollStatusSet);
        DynamicObject[] onbrdBills = this.findOnbrdBills("enrollstatus", new QFilter[]{onbrdIdsFilter.and(enrollStatusFilter)});
        return onbrdBills;
    }

    @Override
    public boolean generateViewForEnrollStatus(Long onbrdId, IFormView view, String ... btnStrs) {
        boolean isEnroll = IOnbrdBillDomainService.getInstance().isEnrolled(onbrdId);
        if (isEnroll) {
            view.setVisible(Boolean.FALSE, btnStrs);
            return true;
        }
        return false;
    }

    @Override
    public Map<Long, DynamicObject> queryByCandidateId(Collection<Long> candidateIds, String properties) {
        QFilter qFilter = new QFilter("candidate", "in", candidateIds);
        Object[] onbrdBills = this.findOnbrdBills(properties, new QFilter[]{qFilter});
        if (HRArrayUtils.isEmpty((Object[])onbrdBills)) {
            return new HashMap<Long, DynamicObject>();
        }
        return Stream.of(onbrdBills).collect(Collectors.toMap(onbrdBill -> onbrdBill.getLong("candidate.id"), onbrdBill -> onbrdBill, (oldValue, newValue) -> newValue));
    }

    @Override
    public Optional<String> validateCertNum(Long applicationId, String certType, String certNum) {
        if (HRStringUtils.isEmpty((String)certNum) || HRStringUtils.isEmpty((String)certType)) {
            return Optional.empty();
        }
        QFilter qFilters = new QFilter("credentialstype.id", "=", (Object)Long.valueOf(certType)).and(new QFilter("number", "=", (Object)certNum));
        Object[] attachData = HcfRepository.queryHcfAttachedData("hcf_cancre", "candidate,credentialstype,number", new QFilter[]{qFilters});
        if (HRArrayUtils.isEmpty((Object[])attachData)) {
            return Optional.empty();
        }
        List<String> enrollStatusSet = Arrays.asList(OnbrdStatusEnum.WAIT_ONBRD.getValue(), OnbrdStatusEnum.HAS_ONBRD.getValue(), OnbrdStatusEnum.WAIT_START.getValue());
        QFilter filter = new QFilter("enrollstatus", "in", enrollStatusSet).and("synchstatus", "!=", (Object)SynchStatusEnum.SYNCH_SUCCESS.getValue());
        DynamicObject[] dynamicObjects = HomCommonRepository.queryDynamicObjects("hom_onbrdbilltpl", "phone,candidate", filter);
        Set candidateIdList = Arrays.stream(dynamicObjects).filter(dynamicObject -> !applicationId.equals(dynamicObject.getLong("id"))).map(dynamicObject -> dynamicObject.getLong("candidate.id")).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(candidateIdList)) {
            return Optional.empty();
        }
        String certificateOfCandidateNumber = Arrays.stream(attachData).filter(dynamicObject -> candidateIdList.contains(dynamicObject.getLong("candidate.id"))).map(dynamicObject -> dynamicObject.getString("candidate.number")).collect(Collectors.joining(" "));
        if (StringUtils.isBlank((CharSequence)certificateOfCandidateNumber)) {
            return Optional.empty();
        }
        return Optional.of(String.format(ResManager.loadKDString((String)"\u201c\u8bc1\u4ef6\u53f7\u7801\u201d\u4e0e\u5df2\u6709\u5019\u9009\u4eba\uff08\u5019\u9009\u4eba\u7f16\u53f7\u4e3a%s\uff09\u6570\u636e\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"OnbrdBillDomainService_3", (String)"hr-hom-business", (Object[])new Object[0]), certificateOfCandidateNumber));
    }

    @Override
    public void setWaitCheckin(DynamicObject[] dynamicObjects) {
        Map<Long, String> checkinMap = this.getCheckinMap(dynamicObjects);
        for (DynamicObject dynamicObject : dynamicObjects) {
            long onbrdId = dynamicObject.getLong("id");
            if (checkinMap.get(onbrdId) == null) continue;
            dynamicObject.set("checkinstatus", (Object)checkinMap.get(onbrdId));
        }
    }

    private Map<String, String> validatePhoneAndEmailHomUniq(InfoGroupEntity currentInfoGroup, Map<String, Object> params, Long applicationId) {
        HashMap validateHomUniqMap = Maps.newHashMapWithExpectedSize((int)4);
        if (CollectionUtils.isEmpty(params)) {
            return validateHomUniqMap;
        }
        List<DynamicObject> onBrdBillList = this.getFilterBrdBillList(applicationId);
        String phoneName = ServiceFactory.getService(ICollectService.class).findInfoGroupFieldById(currentInfoGroup.getInfoGroupFieldList(), InfoGroupFieldConstants.CONTACT_PHONE).getFieldName();
        String emailName = ServiceFactory.getService(ICollectService.class).findInfoGroupFieldById(currentInfoGroup.getInfoGroupFieldList(), InfoGroupFieldConstants.CONTACT_PEREMAIL).getFieldName();
        String email = (String)params.getOrDefault("peremail", "");
        String emailUniqInfo = this.validEmail(onBrdBillList, email, emailName);
        validateHomUniqMap.put("peremail", emailUniqInfo);
        String phone = (String)params.getOrDefault("phone", "");
        String phoneUniqInfo = this.validPhone(onBrdBillList, phone, phoneName);
        validateHomUniqMap.put("phone", phoneUniqInfo);
        return validateHomUniqMap;
    }

    private boolean showTipUniq(Map<String, String> resultMap, IFormView view) {
        if (CollectionUtils.isEmpty(resultMap)) {
            return false;
        }
        String email = resultMap.get("peremail");
        if (StringUtils.isNotBlank((CharSequence)email)) {
            view.showTipNotification(email);
            return true;
        }
        String phone = resultMap.get("phone");
        if (StringUtils.isNotBlank((CharSequence)phone)) {
            view.showTipNotification(phone);
            return true;
        }
        return false;
    }

    @Override
    public int certInfoUniqCheck(String fieldcerttype, String fieldcertvalue, Long onboardId, IFormView view) {
        Optional<String> certNumInfo = this.validateCertNum(onboardId, fieldcerttype, fieldcertvalue);
        if (certNumInfo.isPresent()) {
            view.showTipNotification(certNumInfo.get());
            return 2;
        }
        if (StringUtils.isNotBlank((CharSequence)fieldcerttype) && StringUtils.isNotBlank((CharSequence)fieldcertvalue)) {
            DynamicObject dy = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"hom_onbrdbillbase"));
            DynamicObject onbrdBillInfo = HomCommonRepository.queryDynamicObjectByPk("hom_onbrdbillbase", "certificatenumber,certificatetype,peremail,phone,name,viewtype,employeeno,candidatenumber", onboardId);
            if (!HRObjectUtils.isEmpty((Object)onbrdBillInfo)) {
                HRDynamicObjectUtils.copy((DynamicObject)onbrdBillInfo, (DynamicObject)dy);
            }
            dy.set("certificatenumber", (Object)fieldcertvalue);
            DynamicObject fieldcerttypes = (DynamicObject)view.getModel().getValue("field" + InfoGroupFieldConstants.CERT_TYPE);
            dy.set("certificatetype", (Object)fieldcerttypes);
            Optional<String> personRes = IHomToHrpiAppService.getInstance().validOnePersonWithTip(dy, "certificatenumber");
            if (personRes.isPresent()) {
                view.showTipNotification(personRes.get());
                return 4;
            }
        }
        return 0;
    }

    @Override
    public boolean phoneAndEmailUniqCheck(InfoGroupEntity currentInfoGroup, long onboardId, IFormView view) {
        Optional<String> phoneRes;
        String key;
        Map<String, Object> params = this.getParamsMap(currentInfoGroup, view);
        Map<String, String> resultMap = this.validatePhoneAndEmailHomUniq(currentInfoGroup, params, onboardId);
        if (this.showTipUniq(resultMap, view)) {
            return true;
        }
        DynamicObject dy = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"hom_onbrdbillbase"));
        DynamicObject onbrdBillInfo = HomCommonRepository.queryDynamicObjectByPk("hom_onbrdbillbase", "certificatenumber,certificatetype,peremail,phone,name,viewtype,employeeno,candidatenumber", onboardId);
        if (!HRObjectUtils.isEmpty((Object)onbrdBillInfo)) {
            HRDynamicObjectUtils.copy((DynamicObject)onbrdBillInfo, (DynamicObject)dy);
        }
        if (StringUtils.isNotBlank((Object)params.get("phone"))) {
            dy.set("phone", params.get("phone"));
        }
        if (StringUtils.isNotBlank((Object)params.get("peremail"))) {
            dy.set("peremail", params.get("peremail"));
        }
        if (StringUtils.isNotBlank((CharSequence)(key = this.getKey(params))) && (phoneRes = IHomToHrpiAppService.getInstance().validOnePersonWithTip(dy, key)).isPresent()) {
            view.showTipNotification(phoneRes.get());
            return true;
        }
        return false;
    }

    @Override
    public boolean isAuditPass(DynamicObject bill) {
        return BillStatusEnum.AUDIT_PASS.getCode().equals(bill.getString("billstatus"));
    }

    @Override
    public boolean isSaveStatus(DynamicObject bill) {
        return BillStatusEnum.SAVE.getCode().equals(bill.getString("billstatus"));
    }

    private Map<String, Object> getParamsMap(InfoGroupEntity currentInfoGroup, IFormView view) {
        String emailValue;
        String phoneValue;
        HashMap params = Maps.newHashMapWithExpectedSize((int)4);
        if (currentInfoGroup.getInfoGroupFieldList().stream().anyMatch(infoGroupField -> InfoGroupFieldConstants.CONTACT_PHONE.equals(infoGroupField.getFieldId())) && StringUtils.isNotBlank((CharSequence)(phoneValue = view.getModel().getDataEntity().getString("field" + InfoGroupFieldConstants.CONTACT_PHONE)))) {
            params.put("phone", phoneValue);
        }
        if (currentInfoGroup.getInfoGroupFieldList().stream().anyMatch(infoGroupField -> InfoGroupFieldConstants.CONTACT_PEREMAIL.equals(infoGroupField.getFieldId())) && StringUtils.isNotBlank((CharSequence)(emailValue = view.getModel().getDataEntity().getString("field" + InfoGroupFieldConstants.CONTACT_PEREMAIL)))) {
            params.put("peremail", emailValue);
        }
        return params;
    }

    private String getKey(Map<String, Object> params) {
        if (params.containsKey("phone")) {
            return "phone";
        }
        if (params.containsKey("peremail")) {
            return "peremail";
        }
        return "";
    }

    private String validPhone(List<DynamicObject> onBrdBillList, String phone, String phoneName) {
        String phoneOfCandidateNumber;
        if (StringUtils.isBlank((CharSequence)phone)) {
            return phone;
        }
        Optional<String> validPhone = IOnbrdCommonAppService.getInstance().validatePhone(phone, phoneName);
        String phoneUniqInfo = validPhone.isPresent() ? validPhone.get() : (StringUtils.isBlank((CharSequence)(phoneOfCandidateNumber = onBrdBillList.stream().filter(dynamicObject -> StringUtils.isNotBlank((CharSequence)phone) && dynamicObject.getString("phone").equals(phone)).map(dynamicObject -> dynamicObject.getString("candidatenumber")).collect(Collectors.joining(" ")))) ? phoneOfCandidateNumber : String.format(ResManager.loadKDString((String)"\u201c\u8054\u7cfb\u7535\u8bdd\u201d\u4e0e\u5df2\u6709\u5019\u9009\u4eba\uff08\u5019\u9009\u4eba\u7f16\u53f7\u4e3a%s\uff09\u6570\u636e\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"OnbrdBillDomainService_1", (String)"hr-hom-business", (Object[])new Object[0]), phoneOfCandidateNumber));
        return phoneUniqInfo;
    }

    private String validEmail(List<DynamicObject> onBrdBillList, String email, String emailName) {
        String emailOfCandidateNumber;
        if (StringUtils.isBlank((CharSequence)email)) {
            return email;
        }
        Optional<String> validEmail = IOnbrdCommonAppService.getInstance().validateEmail(email, emailName);
        String emailUniqInfo = validEmail.isPresent() ? validEmail.get() : (StringUtils.isBlank((CharSequence)(emailOfCandidateNumber = onBrdBillList.stream().filter(dynamicObject -> StringUtils.isNotBlank((CharSequence)email) && dynamicObject.getString("peremail").equals(email)).map(dynamicObject -> dynamicObject.getString("candidatenumber")).collect(Collectors.joining(" ")))) ? emailOfCandidateNumber : String.format(ResManager.loadKDString((String)"\u201c\u90ae\u7bb1\u201d\u4e0e\u5df2\u6709\u5019\u9009\u4eba\uff08\u5019\u9009\u4eba\u7f16\u53f7\u4e3a%s\uff09\u6570\u636e\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"OnbrdBillDomainService_0", (String)"hr-hom-business", (Object[])new Object[0]), emailOfCandidateNumber));
        return emailUniqInfo;
    }

    private List<DynamicObject> getFilterBrdBillList(Long applicationId) {
        List<String> enrollStatusSet = Arrays.asList(OnbrdStatusEnum.WAIT_ONBRD.getValue(), OnbrdStatusEnum.HAS_ONBRD.getValue(), OnbrdStatusEnum.WAIT_START.getValue());
        QFilter filter = new QFilter("enrollstatus", "in", enrollStatusSet).and("synchstatus", "!=", (Object)SynchStatusEnum.SYNCH_SUCCESS.getValue());
        DynamicObject[] dynamicObjects = HomCommonRepository.queryDynamicObjects("hom_onbrdbilltpl", "phone,peremail,certificatetype,certificatenumber,employeeno,candidatenumber", filter);
        return Arrays.stream(dynamicObjects).filter(dynamicObject -> applicationId == 0L || !applicationId.equals(dynamicObject.getLong("id"))).collect(Collectors.toList());
    }

    private Map<Long, String> getCheckinMap(DynamicObject[] dynamicObjects) {
        Set onbrdIds = Arrays.stream(dynamicObjects).map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toSet());
        QFilter activity = new QFilter("activity", "=", (Object)OnbrdPersonFieldConstants.ACTIVITY_CHECKIN_ID);
        QFilter onbrd = new QFilter("onbrdid", "in", onbrdIds);
        DynamicObject[] activityObjs = HomCommonRepository.queryDynamicObjects("hom_activeinfobody", "activityins.taskstatus,onbrdid.id", activity.and(onbrd));
        HashMap waitCheckinMap = Maps.newHashMapWithExpectedSize((int)activityObjs.length);
        for (DynamicObject activityObj : activityObjs) {
            String taskstatus = activityObj.getString("activityins.taskstatus");
            long onbrdId = activityObj.getLong("onbrdid.id");
            if (!ActivityStatusEnum.PROCESSING.getValue().equals(taskstatus) && !ActivityStatusEnum.TERMINATED.getValue().equals(taskstatus)) continue;
            waitCheckinMap.put(onbrdId, CheckinStatusEnum.WAIT_CHECKIN.getValue());
        }
        return waitCheckinMap;
    }

    @Override
    public int getCount(QFilter[] qFilter) {
        return OnbrdBillRepository.getCount(qFilter);
    }

    @Override
    public DataDiv<Object> validateImportCadreInfo(boolean isCadre, JSONObject cadreType, String appDispatchNum) {
        DataDiv dataDiv = new DataDiv(null);
        if (!isCadre && !HRObjectUtils.isEmpty((Object)cadreType)) {
            dataDiv.getErrMsgs().add(ResManager.loadKDString((String)"\u5458\u5de5\u4e3a\u5e72\u90e8\u65f6\uff0c\u624d\u5141\u8bb8\u586b\u5199\u5e72\u90e8\u7c7b\u522b;", (String)"OnbrdImportInitServiceImpl_29", (String)"hr-hom-business", (Object[])new Object[0]));
        }
        if (!isCadre && !HRStringUtils.isBlank((CharSequence)appDispatchNum)) {
            dataDiv.getErrMsgs().add(ResManager.loadKDString((String)"\u5458\u5de5\u4e3a\u5e72\u90e8\u65f6\uff0c\u624d\u5141\u8bb8\u586b\u5199\u4efb\u804c\u53d1\u6587\u6587\u53f7;", (String)"OnbrdImportInitServiceImpl_30", (String)"hr-hom-business", (Object[])new Object[0]));
        }
        if (isCadre && HRObjectUtils.isEmpty((Object)cadreType)) {
            dataDiv.getErrMsgs().add(ResManager.loadKDString((String)"\u5458\u5de5\u4e3a\u5e72\u90e8\u65f6\uff0c\u5e72\u90e8\u7c7b\u522b\u5fc5\u586b;", (String)"OnbrdImportInitServiceImpl_31", (String)"hr-hom-business", (Object[])new Object[0]));
        }
        return dataDiv;
    }
}

