/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.business.domain.service.impl.preonbrd;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.hr.hbp.common.util.HRMapUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hom.business.domain.repository.PreOnBrdBillRepository;
import kd.hr.hom.business.domain.repository.common.HomCommonRepository;
import kd.hr.hom.business.domain.service.preonbrd.IPreOnBrdService;
import kd.hr.hom.common.enums.PreOnBrdBillStatusEnum;

public class PreOnBrdServiceImpl
implements IPreOnBrdService {
    private static final Log LOGGER = LogFactory.getLog(PreOnBrdServiceImpl.class);

    @Override
    public DynamicObject queryOne(String fields, long id) {
        return PreOnBrdBillRepository.getInstance().queryOne(fields, id);
    }

    @Override
    public void beforeValidateUnSubmit(AbstractFormPlugin formPlugin, BeforeDoOperationEventArgs args, String billStatus) {
        if (!PreOnBrdBillStatusEnum.ALREADYSUBMIT.getCode().equals(billStatus) && !PreOnBrdBillStatusEnum.APPROVING.getCode().equals(billStatus)) {
            formPlugin.getView().showErrorNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u64a4\u9500\u5355\u636e\u72b6\u6001\u4e3a\u201c\u5df2\u63d0\u4ea4\u201d\u201c\u5ba1\u6279\u4e2d\u201d\u7684\u5355\u636e\uff0c\u5f53\u524d\u5355\u636e\u72b6\u6001\u4e3a\u201c%s\u201d\u3002", (String)"PreOnBrdServiceImpl_24", (String)"hr-hom-business", (Object[])new Object[]{PreOnBrdBillStatusEnum.getName((String)billStatus)}));
            args.setCancel(true);
        }
    }

    @Override
    public DynamicObject[] query(String fields, List<Long> preOnBrdBillIds) {
        QFilter qFilter = new QFilter("id", "in", preOnBrdBillIds);
        return PreOnBrdBillRepository.getInstance().query(fields, new QFilter[]{qFilter});
    }

    @Override
    public DynamicObject[] queryByCerNos(String fields, List<String> perCerNos) {
        QFilter qFilter = new QFilter("entryentity.certificatenumber", "in", perCerNos);
        QFilter eFilter = new QFilter("billstatus", "in", (Object)new String[]{PreOnBrdBillStatusEnum.TEMPSTORAGE.getCode(), PreOnBrdBillStatusEnum.ALREADYSUBMIT.getCode(), PreOnBrdBillStatusEnum.WAITRESUBMIT.getCode(), PreOnBrdBillStatusEnum.APPROVING.getCode()});
        return PreOnBrdBillRepository.getInstance().query(fields, new QFilter[]{qFilter, eFilter});
    }

    @Override
    public Table<Integer, String, DynamicObject> validatePreOnbrd(DynamicObject[] onbrdInfoList) {
        List<QFilter> qFilterList = this.buildPreOnbrdQFilter(onbrdInfoList);
        DynamicObject[] dynamicObject = HomCommonRepository.queryDynamicObjects("hom_preonbrdentry", "", qFilterList.toArray(new QFilter[0]));
        HashBasedTable result = HashBasedTable.create();
        Map<String, List<DynamicObject>> certificatenumberCollect = Arrays.stream(dynamicObject).filter(onbrd -> HRStringUtils.isNotEmpty((String)onbrd.getString("certificatenumber"))).collect(Collectors.groupingBy(onbrd -> onbrd.getString("certificatetype.id") + "-" + onbrd.getString("certificatenumber")));
        Integer index = 0;
        for (DynamicObject onbrdInfo : onbrdInfoList) {
            Integer n = index;
            Integer n2 = index = Integer.valueOf(index + 1);
            if (HRMapUtils.isEmpty(certificatenumberCollect) || !HRStringUtils.isNotEmpty((String)onbrdInfo.getString("certificatenumber")) || !certificatenumberCollect.containsKey(onbrdInfo.getString("certificatetype.id") + "-" + onbrdInfo.getString("certificatenumber"))) continue;
            result.put((Object)index, (Object)"certificatenumber", (Object)certificatenumberCollect.get(onbrdInfo.getString("certificatetype.id") + "-" + onbrdInfo.getString("certificatenumber")).get(0));
        }
        return result;
    }

    private List<QFilter> buildPreOnbrdQFilter(DynamicObject[] onbrdInfoList) {
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
        ArrayList<String> phoneList = new ArrayList<String>();
        ArrayList<String> peremailList = new ArrayList<String>();
        ArrayList<String> certificatenumberList = new ArrayList<String>();
        ArrayList<String> employeenoList = new ArrayList<String>();
        for (DynamicObject onbrdInfo : onbrdInfoList) {
            this.setValue(phoneList, onbrdInfo.getString("phone"));
            this.setValue(employeenoList, onbrdInfo.getString("employeeno"));
            this.setValue(peremailList, onbrdInfo.getString("peremail"));
            this.setValue(certificatenumberList, onbrdInfo.getString("certificatenumber"));
        }
        QFilter qFilter = null;
        if (!CollectionUtils.isEmpty(phoneList)) {
            QFilter tempQFilter = new QFilter("phone", "in", phoneList);
            QFilter qFilter2 = qFilter = qFilter == null ? tempQFilter : qFilter.or(tempQFilter);
        }
        if (!CollectionUtils.isEmpty(employeenoList)) {
            QFilter tempQFilter = new QFilter("employeeno", "in", employeenoList);
            QFilter qFilter3 = qFilter = qFilter == null ? tempQFilter : qFilter.or(tempQFilter);
        }
        if (!CollectionUtils.isEmpty(peremailList)) {
            QFilter tempQFilter = new QFilter("peremail", "in", peremailList);
            QFilter qFilter4 = qFilter = qFilter == null ? tempQFilter : qFilter.or(tempQFilter);
        }
        if (!CollectionUtils.isEmpty(certificatenumberList)) {
            QFilter tempQFilter = new QFilter("certificatenumber", "in", certificatenumberList);
            qFilter = qFilter == null ? tempQFilter : qFilter.or(tempQFilter);
        }
        qFilterList.add(QFilter.isNotNull((String)"onbrd"));
        ArrayList<String> billStatus = new ArrayList<String>(Arrays.asList("A,B,G,D".split(",")));
        qFilterList.add(new QFilter("prebatchonbrd.billstatus", "in", billStatus));
        if (!HRObjectUtils.isEmpty((Object)qFilter)) {
            qFilterList.add(qFilter);
        }
        return qFilterList;
    }

    private void setValue(List<String> list, String value) {
        if (!StringUtils.isEmpty((String)value)) {
            list.add(value);
        }
    }
}

