/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.opplugin.collect.activehandle;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.hr.hom.business.application.hrcs.IHomToHrcsAppService;
import kd.hr.hom.business.application.staff.IStaffUseService;
import kd.hr.hom.business.domain.repository.common.HomCommonRepository;
import kd.hr.hom.opplugin.validate.activehandle.SubmitValidator;
import kd.sdk.hr.hom.business.activity.IActivityDomainService;

public class SubmitOp
extends HRDataBaseOp {
    private static final ThreadPool THREAD_POOL = ThreadPools.newFixedThreadPool((String)"ActiveHandleSubmitOp", (int)10);
    private static final Log LOGGER = LogFactory.getLog(SubmitOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs args) {
        args.getFieldKeys().add("activityins");
        args.getFieldKeys().add("onbrdid");
        args.getFieldKeys().add("finishdate");
        args.getFieldKeys().add("activity");
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        args.addValidator((AbstractValidator)new SubmitValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        OperationResult result;
        DynamicObject[] dataEntities = args.getDataEntities();
        int dataLength = dataEntities.length;
        ArrayList<DynamicObject> canCommitDyList = new ArrayList<DynamicObject>(dataLength);
        ArrayList<Long> activityIds = new ArrayList<Long>();
        for (DynamicObject item : dataEntities) {
            DynamicObject activityIns = item.getDynamicObject("activityins");
            if (HRObjectUtils.isEmpty((Object)activityIns)) continue;
            activityIds.add(activityIns.getLong("id"));
            canCommitDyList.add(item);
            item.set("finishdate", (Object)new Date());
        }
        if (HRCollUtil.isEmpty(activityIds)) {
            String errMsg = ResManager.loadKDString((String)"\u672a\u627e\u5230\u534f\u4f5c\u5173\u8054\u7684\u6d3b\u52a8\u5b9e\u4f8b\uff0c\u63d0\u4ea4\u5931\u8d25", (String)"ActiveHandleSubmitOp_0", (String)"hr-hom-opplugin", (Object[])new Object[0]);
            throw new KDBizException(errMsg);
        }
        LOGGER.info("###ActiveHandle.SubmitOp.beforeExecuteOperationTransaction batchSendTextMessage activityIds:{}", activityIds);
        try (TXHandle ignored = TX.notSupported();){
            result = this.operationResult = IHomToHrcsAppService.getInstance().batchConsentTask(activityIds, "");
        }
        if (!result.isSuccess()) {
            LOGGER.error("###ActiveHandle.SubmitOp. batchConsentTask fail!, errMsg:{}", (Object)result.getAllErrorOrValidateInfo());
            String errMsg = ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25", (String)"ActiveHandleSubmitOp_1", (String)"hr-hom-opplugin", (Object[])new Object[0]);
            throw new KDBizException(errMsg);
        }
        HomCommonRepository.updateDynamicObjects((String)"hom_activeinfobody", (DynamicObject[])canCommitDyList.toArray(new DynamicObject[0]));
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs args) {
        DynamicObject[] dataEntities = args.getDataEntities();
        ArrayList<Long> activityIds = new ArrayList<Long>();
        ArrayList<DynamicObject> canCommitDyList = new ArrayList<DynamicObject>(dataEntities.length);
        HashMap onbrdActivityNumberMap = Maps.newHashMapWithExpectedSize((int)canCommitDyList.size());
        for (DynamicObject item : dataEntities) {
            DynamicObject activityIns = item.getDynamicObject("activityins");
            if (HRObjectUtils.isEmpty((Object)activityIns)) continue;
            canCommitDyList.add(item);
            activityIds.add(activityIns.getLong("id"));
            long onbrdBillId = item.getLong("onbrdid.id");
            String activityNumber = item.getString("activity.number");
            onbrdActivityNumberMap.put(onbrdBillId, Collections.singletonList(activityNumber));
        }
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create(null, IActivityDomainService.class, (String)"kd.sdk.hr.hom.business.activity.IActivityDomainService", null);
        hrPluginProxy.callReplace(hrplugin -> {
            hrplugin.handleTrdActivity(activityIds);
            return null;
        });
        THREAD_POOL.execute(() -> IStaffUseService.getInstance().sendMsgForOnbrdActivity(onbrdActivityNumberMap), RequestContext.getOrCreate());
    }
}

