/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.opplugin.collect.approve;

import java.util.Collections;
import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.hr.hom.business.domain.repository.common.HomCommonRepository;
import kd.hr.hom.business.domain.service.ServiceFactory;
import kd.hr.hom.business.domain.service.activity.IActivityDomainService;
import kd.hr.hom.business.domain.service.collect.ICollectApproveLogService;
import kd.hr.hom.business.domain.service.common.ISendMessageService;
import kd.hr.hom.common.enums.ActivityNumberEnum;
import kd.hr.hom.common.enums.CollectApproveStatusEnum;
import kd.hr.hom.common.enums.RuleEngineSceneNumberEnum;
import kd.hr.hom.opplugin.validate.approve.ApprovePassValidator;

public class ApprovePassOp
extends HRDataBaseOp {
    private static final Log LOGGER = LogFactory.getLog(ApprovePassOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs args) {
        args.getFieldKeys().add("templateresult");
        args.getFieldKeys().add("onboard");
        args.getFieldKeys().add("sendtext");
        args.getFieldKeys().add("approvestatus");
        args.getFieldKeys().add("approvemodifier");
        args.getFieldKeys().add("approvemodifytime");
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        args.addValidator((AbstractValidator)new ApprovePassValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        DynamicObject[] dataEntities = args.getDataEntities();
        DynamicObject dataEntity = dataEntities[0];
        long billId = dataEntity.getLong("id");
        ((ICollectApproveLogService)ServiceFactory.getService(ICollectApproveLogService.class)).approvePassCollectLog(Long.valueOf(billId));
        dataEntity.set("approvestatus", (Object)CollectApproveStatusEnum.PASS.getStatus());
        dataEntity.set("approvemodifier", (Object)RequestContext.get().getCurrUserId());
        dataEntity.set("approvemodifytime", (Object)new Date());
        HomCommonRepository.updateDynamicObject((String)"hom_collect", (DynamicObject)dataEntity);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs args) {
        super.afterExecuteOperationTransaction(args);
        DynamicObject[] dataEntities = args.getDataEntities();
        DynamicObject dataEntity = dataEntities[0];
        ((ISendMessageService)ServiceFactory.getService(ISendMessageService.class)).sendMessageNew(dataEntity, RuleEngineSceneNumberEnum.COLLECT_APPROVE_PASS);
        IActivityDomainService.getInstance().batchConsentTask(Collections.singletonList(dataEntity.getLong("onboard.id")), ActivityNumberEnum.INFOAUDIT);
    }
}

