/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.opplugin.collect.approve;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRMapUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.hr.hom.business.domain.repository.common.HomCommonRepository;
import kd.hr.hom.business.domain.service.ServiceFactory;
import kd.hr.hom.business.domain.service.common.ISendMessageService;
import kd.hr.hom.common.enums.RuleEngineSceneNumberEnum;
import kd.hr.hom.opplugin.validate.approve.OneClickNoticeValidator;

public class OneClickNoticeOp
extends HRDataBaseOp {
    private static final Log LOGGER = LogFactory.getLog(OneClickNoticeOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs args) {
        args.getFieldKeys().add("templateresult");
        args.getFieldKeys().add("onboard");
        args.getFieldKeys().add("sendtext");
        args.getFieldKeys().add("approvestatus");
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        args.addValidator((AbstractValidator)new OneClickNoticeValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        Map result;
        DynamicObject[] dataEntities = args.getDataEntities();
        HashMap listMap = Maps.newHashMapWithExpectedSize((int)dataEntities.length);
        ArrayList<DynamicObject> canNoticeList = new ArrayList<DynamicObject>(dataEntities.length);
        ArrayList<Long> onboardIds = new ArrayList<Long>(dataEntities.length);
        for (DynamicObject dynamicObject : dataEntities) {
            if (!"1".equals(dynamicObject.getString("templateresult"))) continue;
            String buNumber = dynamicObject.getString("onboard.org.number");
            Long bizId = dynamicObject.getLong("onboard.id");
            ArrayList<String> phoneList = new ArrayList<String>();
            ArrayList<String> emailList = new ArrayList<String>();
            String phone = dynamicObject.getString("onboard.phone");
            phoneList.add(phone);
            String email = dynamicObject.getString("onboard.peremail");
            emailList.add(email);
            HashMap<Long, HashMap<String, ArrayList<String>>> longListMap = (HashMap<Long, HashMap<String, ArrayList<String>>>)listMap.get(buNumber);
            HashMap<String, ArrayList<String>> targetMap = new HashMap<String, ArrayList<String>>();
            if (longListMap == null) {
                longListMap = new HashMap<Long, HashMap<String, ArrayList<String>>>();
            }
            targetMap.put("phone", phoneList);
            targetMap.put("email", emailList);
            longListMap.put(bizId, targetMap);
            listMap.put(buNumber, longListMap);
            canNoticeList.add(dynamicObject);
            onboardIds.add(bizId);
        }
        if (HRMapUtils.isEmpty((Map)listMap)) {
            LOGGER.info("###OneClickNoticeOp.beginOperationTransaction listMap is empty");
            throw new KDBizException(ResManager.loadKDString((String)"\u63d0\u9192\u5931\u8d25", (String)"OneClickNoticeOp_0", (String)"hr-hom-opplugin", (Object[])new Object[0]));
        }
        LOGGER.info("###OneClickNoticeOp.beforeExecuteOperationTransaction batchSendTextMessage param:{}", onboardIds);
        try (TXHandle ignored = TX.notSupported();){
            result = ((ISendMessageService)ServiceFactory.getService(ISendMessageService.class)).batchSendTextMessage((Map)listMap, RuleEngineSceneNumberEnum.COLLECT_NOTICE_MESSAGE);
        }
        LOGGER.info("###OneClickNoticeOp.beforeExecuteOperationTransaction batchSendTextMessage result:{}", (Object)result);
        if (result.containsValue(Boolean.FALSE)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u63d0\u9192\u5931\u8d25", (String)"OneClickNoticeOp_0", (String)"hr-hom-opplugin", (Object[])new Object[0]));
        }
        Iterator iterator = canNoticeList.iterator();
        while (iterator.hasNext()) {
            DynamicObject item;
            item.set("sendtext", (Object)("1".equals((item = (DynamicObject)iterator.next()).getString("templateresult")) && Boolean.TRUE.equals(result.get(item.getLong("onboard.id"))) ? "1" : "0"));
        }
        HomCommonRepository.updateDynamicObjects((String)"hom_collect", (DynamicObject[])canNoticeList.toArray(new DynamicObject[0]));
    }
}

