/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.opplugin.onbrd;

import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.hr.hom.business.application.staff.IStaffUseService;
import kd.hr.hom.business.domain.repository.common.HomCommonRepository;
import kd.hr.hom.common.enums.AuditStatusEnum;
import kd.hr.hom.common.enums.BillStatusEnum;
import kd.hr.hom.common.enums.OnbrdStatusEnum;
import kd.hr.hom.common.util.HOMObjectUtils;
import kd.hr.hom.opplugin.onbrd.UnSubmitOp;

public class ApprovalRejectToSubmitOp
extends HRDataBaseOp {
    private static final Log LOGGER = LogFactory.getLog(UnSubmitOp.class);
    private static final ThreadPool THREAD_POOL = ThreadPools.newCachedThreadPool((String)"ApprovalRejectToSubmitOp", (int)5, (int)1000);

    public void onPreparePropertys(PreparePropertysEventArgs args) {
        List fieldKeys = args.getFieldKeys();
        fieldKeys.add("enrollstatus");
        fieldKeys.add("billstatus");
        fieldKeys.add("auditstatus");
        fieldKeys.add("name");
        fieldKeys.add("employeeno");
        fieldKeys.add("billno");
        fieldKeys.add("candidate");
        fieldKeys.add("aadminorg");
        fieldKeys.add("apositiontype");
        fieldKeys.add("aposition");
        fieldKeys.add("stdposition");
        fieldKeys.add("ajob");
        fieldKeys.add("ajoblevel");
        fieldKeys.add("laborreltype");
        fieldKeys.add("effectdate");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        DynamicObject[] dataEntities;
        for (DynamicObject dataEntity : dataEntities = args.getDataEntities()) {
            dataEntity.set("enrollstatus", (Object)OnbrdStatusEnum.WAIT_START.getValue());
            dataEntity.set("billstatus", (Object)BillStatusEnum.CHARGEBANK.getCode());
            dataEntity.set("auditstatus", (Object)AuditStatusEnum.SAVE.getCode());
        }
        HomCommonRepository.saveDynamicObjects((String)"hom_onbrdinfo", (DynamicObject[])dataEntities);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs args) {
        List successPkIds = this.getOperationResult().getSuccessPkIds().stream().map(HOMObjectUtils::getLongValOfCustomParam).collect(Collectors.toList());
        if (successPkIds.isEmpty()) {
            LOGGER.info("successPkIds is empty");
        } else {
            LOGGER.info("successPkIds:{}", successPkIds);
            THREAD_POOL.execute(() -> IStaffUseService.getInstance().sendMsgForOnbrdBreakUp(successPkIds), RequestContext.get());
        }
    }
}

