/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.opplugin.onbrd;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DBRoute;
import kd.bos.entity.operate.OperationException;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.kdtx.common.Param;
import kd.bos.kdtx.common.exception.TCCTryException;
import kd.bos.kdtx.sdk.session.tcc.TCCGlobalSession;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.model.org.staff.StaffUseInParam;
import kd.hr.hbp.common.model.org.staff.StaffUseParam;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.hr.hom.business.application.staff.IStaffUseService;
import kd.hr.hom.common.enums.OnbrdStatusEnum;
import kd.hr.hom.common.util.HOMObjectUtils;
import kd.sdk.hr.hpfs.business.config.service.IDevParamConfigService;

public class OnbrdBillSaveOp
extends HRDataBaseOp {
    private static final Log LOGGER = LogFactory.getLog(OnbrdBillSaveOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs evt) {
        List fieldKeys = evt.getFieldKeys();
        fieldKeys.add("name");
        fieldKeys.add("employeeno");
        fieldKeys.add("billno");
        fieldKeys.add("candidate");
        fieldKeys.add("aadminorg");
        fieldKeys.add("apositiontype");
        fieldKeys.add("aposition");
        fieldKeys.add("stdposition");
        fieldKeys.add("ajob");
        fieldKeys.add("ajoblevel");
        fieldKeys.add("laborreltype");
        fieldKeys.add("viewtype");
        fieldKeys.add("effectdate");
        fieldKeys.add("enrollstatus");
        String staffAdminOrg = IDevParamConfigService.getInstance().queryBusinessValueByBusinessKey("staff_adminorg");
        if (!HRStringUtils.isBlank((CharSequence)staffAdminOrg)) {
            fieldKeys.add(staffAdminOrg);
        }
        IStaffUseService staffUseService = IStaffUseService.getInstance();
        Set mapFieldSet = staffUseService.getMapFieldSet();
        fieldKeys.addAll(mapFieldSet);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        Object[] dataEntities = args.getDataEntities();
        if (args.isCancelOperation()) {
            LOGGER.info("args.isCancelOperation()");
            return;
        }
        if (HRArrayUtils.isEmpty((Object[])dataEntities)) {
            LOGGER.info("That is not Bill need to save!");
            return;
        }
        List sourceDatas = Stream.of(dataEntities).collect(Collectors.toList());
        List onbrdBillParts = new ArrayList(16);
        if (sourceDatas.size() > 1000) {
            onbrdBillParts = Lists.partition(sourceDatas, (int)1000);
        } else {
            onbrdBillParts.add(sourceDatas);
        }
        HashSet failIds = new HashSet();
        for (List onbrdBillInfos : onbrdBillParts) {
            Tuple<Set<Long>, String> staffUseResult = this.staffUse(args, onbrdBillInfos);
            failIds.addAll((Collection)staffUseResult.item1);
            String errorTip = (String)staffUseResult.item2;
            if (CollectionUtils.isEmpty(failIds)) continue;
            this.throwExceptionForTcc(args, errorTip);
            break;
        }
    }

    private Tuple<Set<Long>, String> staffUse(BeginOperationTransactionArgs args, List<DynamicObject> onbrdBillInfos) {
        StaffUseParam staffUseParam;
        if (HRStringUtils.equals((String)args.getOperationKey(), (String)"startupsave")) {
            staffUseParam = IStaffUseService.getInstance().getStaffUseParamsForTCC(onbrdBillInfos.toArray(new DynamicObject[0]), "NEW");
        } else {
            Object[] onbrdBills = (DynamicObject[])onbrdBillInfos.stream().filter(onbrdBill -> HRStringUtils.equals((String)OnbrdStatusEnum.WAIT_ONBRD.getValue(), (String)onbrdBill.getString("enrollstatus"))).toArray(DynamicObject[]::new);
            if (HRArrayUtils.isEmpty((Object[])onbrdBills)) {
                LOGGER.info("That is not Bill need to save!");
                return Tuple.create(new HashSet(), (Object)"");
            }
            staffUseParam = IStaffUseService.getInstance().getStaffUseParamsForTCC((DynamicObject[])onbrdBills, "UPDATE");
        }
        if (staffUseParam == null || CollectionUtils.isEmpty((Collection)staffUseParam.getStaffUseInParamList())) {
            LOGGER.info("{} staffUseParam.getStaffUseInParamList() isEmpty", (Object)args.getOperationKey());
            return Tuple.create(new HashSet(), (Object)"");
        }
        try {
            TCCGlobalSession.Try((String)"hom_IHAOSStaffUseService", (String)"hrmp", (String)"haos", (String)"IHAOSStaffUseService", (Param)staffUseParam, null, (DBRoute)DBRoute.of((String)"hrb.hom"));
            LOGGER.info("staffUseParam.getStaffUseInParamList().size():{}", (Object)staffUseParam.getStaffUseInParamList().size());
            LOGGER.info("staffUseParam:{}", (Object)HOMObjectUtils.toJSONString((Object)staffUseParam));
        }
        catch (TCCTryException exception) {
            LOGGER.error((Throwable)exception);
            Set failIds = staffUseParam.getStaffUseInParamList().stream().map(StaffUseInParam::getBizBillId).collect(Collectors.toSet());
            String errorTip = IStaffUseService.getInstance().getErrorTipWithException((Exception)((Object)exception));
            return Tuple.create(failIds, (Object)errorTip);
        }
        return Tuple.create(new HashSet(), (Object)"");
    }

    private void throwExceptionForTcc(BeginOperationTransactionArgs args, String errorTip) {
        DynamicObject[] dataEntities = args.getDataEntities();
        List failIds = Stream.of(dataEntities).map(onbrdBill -> onbrdBill.getLong("id")).collect(Collectors.toList());
        String operationKey = args.getOperationKey();
        List operateErrorInfos = failIds.stream().map(failId -> this.buildOperateErrorInfo((Long)failId, operationKey, errorTip)).collect(Collectors.toList());
        this.getOperationResult().getSuccessPkIds().remove(failIds);
        this.getOperationResult().getAllErrorInfo().addAll(operateErrorInfos);
        args.setDataEntities(new DynamicObject[0]);
        args.setCancelOperation(true);
        this.getOperationResult().setSuccess(false);
        this.getOperationResult().setMessage(errorTip);
        OperationException operationException = new OperationException(((Long)failIds.get(0)).toString(), "", "");
        operationException.setTitle(operationKey);
        operationException.setMessage(errorTip);
        throw operationException;
    }

    private OperateErrorInfo buildOperateErrorInfo(Long onbrdBillid, String operationKey, String errorTip) {
        OperateErrorInfo errorInfo = new OperateErrorInfo("hom_IHAOSStaffUseService_tcc", ErrorLevel.FatalError, (Object)onbrdBillid);
        errorInfo.setTitle(operationKey);
        errorInfo.setMessage(errorTip);
        return errorInfo;
    }
}

