/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.opplugin.onbrd;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.hr.hom.business.application.onbrd.IOnbrdBreakupAppService;
import kd.hr.hom.opplugin.validate.OnbrdBreakupValidator;

public class OnbrdBreakupExtOp
extends HRDataBaseOp {
    private static final Log LOGGER = LogFactory.getLog(OnbrdBreakupExtOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs evt) {
        super.onPreparePropertys(evt);
        List fieldKeys = evt.getFieldKeys();
        fieldKeys.add("breakuptype");
        fieldKeys.add("breakupreason");
        fieldKeys.add("breakupremarks");
    }

    public void onAddValidators(AddValidatorsEventArgs addValidatorsEventArgs) {
        addValidatorsEventArgs.addValidator((AbstractValidator)new OnbrdBreakupValidator());
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs args) {
        LOGGER.info("###OnbrdBreakupExtOp#afterExecuteOperationTransaction-start:{}", (Object)RequestContext.getOrCreate().getTraceId());
        super.afterExecuteOperationTransaction(args);
        Object[] dataEntities = args.getDataEntities();
        if (ObjectUtils.isEmpty((Object[])dataEntities)) {
            return;
        }
        Object dataEntity = dataEntities[0];
        DynamicObject breakupType = dataEntity.getDynamicObject("breakuptype");
        DynamicObject breakupReason = dataEntity.getDynamicObject("breakupreason");
        String breakupRemarks = dataEntity.getString("breakupremarks");
        List ids = Arrays.stream(dataEntities).map(data -> data.getLong("id")).collect(Collectors.toList());
        IOnbrdBreakupAppService.getInstance().doSomethingsWithBreakup(ids, breakupType, breakupReason, breakupRemarks, null);
        LOGGER.info("###OnbrdBreakupExtOp#afterExecuteOperationTransaction-end:{}", (Object)RequestContext.getOrCreate().getTraceId());
    }
}

