/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.opplugin.onbrd;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.form.plugin.impt.ImportContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.form.FormView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.ReflectionUtils;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hom.business.domain.repository.common.HomCommonRepository;
import kd.hr.hom.business.domain.service.onbrd.IOnbrdBillDomainService;
import kd.hr.hom.common.entity.DataDiv;
import kd.hr.hom.common.util.HOMObjectUtils;

public class OnbrdInfoImportOp
extends BatchImportPlugin {
    private static final Log LOGGER = LogFactory.getLog(OnbrdInfoImportOp.class);

    public String getDefaultImportType() {
        return "override";
    }

    public List<ComboItem> getOverrideFieldsConfig() {
        List overrideFieldsConfig = super.getOverrideFieldsConfig();
        ArrayList overideValue = Lists.newArrayListWithExpectedSize((int)1);
        for (ComboItem comboItem : overrideFieldsConfig) {
            String value = comboItem.getValue();
            if (!HRStringUtils.equals((String)"candidatenumber", (String)value) && !HRStringUtils.equals((String)"name", (String)value)) continue;
            overideValue.add(comboItem);
        }
        return overideValue;
    }

    protected void beforeSave(List<ImportBillData> billdatas, ImportLogger logger) {
        super.beforeSave(billdatas, logger);
        for (ImportBillData billdata : billdatas) {
            JSONObject data = billdata.getData();
            data.put("ajobscmorg", null);
            if (HRObjectUtils.isEmpty((Object)data.get((Object)"joblevelscm"))) {
                data.put("joblevelscm", null);
            }
            if (HRObjectUtils.isEmpty((Object)data.get((Object)"jobgradescm"))) {
                data.put("jobgradescm", null);
            }
            if (HRObjectUtils.isEmpty((Object)data.get((Object)"ajobleveltext"))) {
                data.put("ajobleveltext", null);
            }
            if (!HRObjectUtils.isEmpty((Object)data.get((Object)"ajobgradetext"))) continue;
            data.put("ajobgradetext", null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ApiResult save(List<ImportBillData> rowdatas, ImportLogger logger) {
        DynamicObject[] newDynamicObjects;
        ApiResult save;
        boolean isSetNULL = Boolean.parseBoolean(this.ctx.getOption().get("SetNULL").toString());
        LOGGER.info("isSetNULL:{}", (Object)isSetNULL);
        Iterator<ImportBillData> iterator = rowdatas.iterator();
        while (iterator.hasNext()) {
            String probationTime;
            ImportBillData rowdata = iterator.next();
            JSONObject onbrdBillJson = rowdata.getData();
            boolean ifNeedRemove = false;
            String name = onbrdBillJson.getString("name");
            if (name != null) {
                name = name.trim();
                onbrdBillJson.put("name", (Object)name);
                if (name.length() > 200) {
                    this.addErrorMsg(rowdata, logger, ResManager.loadKDString((String)"\u5b57\u6bb5\u201c\u59d3\u540d\u201d\u8f93\u5165\u957f\u5ea6\u8d85\u51fa\u9650\u5b9a\u8303\u56f4[0,200];", (String)"OnbrdInfoImportOp_4", (String)"hr-hom-opplugin", (Object[])new Object[0]));
                    ifNeedRemove = true;
                }
            }
            if (HRStringUtils.isNotEmpty((String)(probationTime = onbrdBillJson.getString("probationtime"))) && !HOMObjectUtils.checkIfInteger((String)probationTime)) {
                this.addErrorMsg(rowdata, logger, ResManager.loadKDString((String)"\u8bd5\u7528\u671f\u683c\u5f0f\u9519\u8bef;", (String)"OnbrdInfoImportOp_3", (String)"hr-hom-opplugin", (Object[])new Object[0]));
                ifNeedRemove = true;
            }
            String isProbation = onbrdBillJson.getString("isprobation");
            String perprobationtime = onbrdBillJson.getString("perprobationtime");
            if ("true".equals(isProbation) && (HRStringUtils.isEmpty((String)probationTime) || HRStringUtils.isEmpty((String)perprobationtime))) {
                this.addErrorMsg(rowdata, logger, ResManager.loadKDString((String)"\u662f\u5426\u8bd5\u7528\u671f\u8f93\u5165\"\u662f\"\uff0c\u8bd5\u7528\u671f\u548c\u8bd5\u7528\u671f\u9650\u5355\u4f4d\u5fc5\u586b;", (String)"OnbrdInfoImportOp_5", (String)"hr-hom-opplugin", (Object[])new Object[0]));
                ifNeedRemove = true;
            }
            boolean isCadre = Boolean.TRUE.equals(onbrdBillJson.getBoolean("iscadre"));
            JSONObject cadreType = onbrdBillJson.getJSONObject("cadretype");
            String appDispatchNum = onbrdBillJson.getString("appdispatchnum");
            DataDiv dataDiv = IOnbrdBillDomainService.getInstance().validateImportCadreInfo(isCadre, cadreType, appDispatchNum);
            if (!HRCollUtil.isEmpty((Collection)dataDiv.getErrMsgs())) {
                ifNeedRemove = true;
                for (String errMsg : dataDiv.getErrMsgs()) {
                    this.addErrorMsg(rowdata, logger, errMsg);
                }
            }
            if (ifNeedRemove) {
                iterator.remove();
                continue;
            }
            String jobLevelText = onbrdBillJson.getString("ajobleveltext");
            String jobGradeText = onbrdBillJson.getString("ajobgradetext");
            if (isSetNULL && (onbrdBillJson.containsKey((Object)"ajobleveltext") && jobLevelText == null || HRStringUtils.equals((String)"NULL", (String)jobLevelText))) {
                LOGGER.info("jobLevelText:{};", (Object)jobLevelText);
                onbrdBillJson.put("ajobleveltext", (Object)"NULL_CLEAR");
            } else if (!isSetNULL && HRStringUtils.isEmpty((String)jobLevelText)) {
                onbrdBillJson.put("ajobleveltext", (Object)"EMPTY_CLEAR");
            }
            if (isSetNULL && (onbrdBillJson.containsKey((Object)"ajobgradetext") && jobGradeText == null || HRStringUtils.equals((String)"NULL", (String)jobGradeText))) {
                onbrdBillJson.put("ajobgradetext", (Object)"NULL_CLEAR");
                continue;
            }
            if (isSetNULL || !HRStringUtils.isEmpty((String)jobGradeText)) continue;
            onbrdBillJson.put("ajobgradetext", (Object)"EMPTY_CLEAR");
        }
        ArrayList<String> names = new ArrayList<String>(rowdatas.size());
        for (ImportBillData rowdata : rowdatas) {
            DynamicObject[] data = rowdata.getData();
            String candidatenumber = data.getString("candidatenumber");
            names.add(candidatenumber);
        }
        DynamicObject[] dynamicObjects = HomCommonRepository.queryDynamicObjects((String)"hom_personwaitonbrd", (String)"billstatus", (QFilter[])new QFilter[]{new QFilter("candidatenumber", "in", (Object)names.toArray(new String[0]))});
        Map<Long, String> collect = Arrays.stream(dynamicObjects).collect(Collectors.toMap(formObj -> formObj.getLong("id"), formObj -> formObj.getString("billstatus")));
        for (DynamicObject dynamicObject : dynamicObjects) {
            dynamicObject.set("billstatus", (Object)"-1");
        }
        HomCommonRepository.saveDynamicObjects((String)"hom_personwaitonbrd", (DynamicObject[])dynamicObjects);
        try {
            save = super.save(rowdatas, logger);
        }
        catch (Throwable throwable) {
            DynamicObject[] newDynamicObjects2;
            for (DynamicObject dynamicObject : newDynamicObjects2 = HomCommonRepository.queryDynamicObjects((String)"hom_personwaitonbrd", (String)"billstatus", (QFilter[])new QFilter[]{new QFilter("candidatenumber", "in", (Object)names.toArray(new String[0]))})) {
                if (!"-1".equals(dynamicObject.getString("billstatus"))) continue;
                dynamicObject.set("billstatus", (Object)collect.get(dynamicObject.getLong("id")));
            }
            HomCommonRepository.saveDynamicObjects((String)"hom_personwaitonbrd", (DynamicObject[])newDynamicObjects2);
            throw throwable;
        }
        for (DynamicObject dynamicObject : newDynamicObjects = HomCommonRepository.queryDynamicObjects((String)"hom_personwaitonbrd", (String)"billstatus", (QFilter[])new QFilter[]{new QFilter("candidatenumber", "in", (Object)names.toArray(new String[0]))})) {
            if (!"-1".equals(dynamicObject.getString("billstatus"))) continue;
            dynamicObject.set("billstatus", (Object)collect.get(dynamicObject.getLong("id")));
        }
        HomCommonRepository.saveDynamicObjects((String)"hom_personwaitonbrd", (DynamicObject[])newDynamicObjects);
        return save;
    }

    private void addErrorMsg(ImportBillData rowdata, ImportLogger logger, String errorMsg) {
        int startIndex = rowdata.getStartIndex();
        if (logger.getLogCache().get(startIndex) == null) {
            logger.fail();
        }
        logger.log(Integer.valueOf(startIndex), errorMsg);
    }

    public BatchImportPlugin setContext(RequestContext rc, ImportContext ctx, List<String> startArgs) {
        try {
            Field view = ctx.getClass().getDeclaredField("view");
            ReflectionUtils.makeAccessible((Field)view);
            try {
                FormView formView = (FormView)view.get(ctx);
                formView.setVisible(Boolean.FALSE, new String[]{"radiofield", "radiofield2"});
            }
            catch (IllegalAccessException exception) {
                LOGGER.error(exception.getMessage());
            }
        }
        catch (NoSuchFieldException exception) {
            LOGGER.error(exception.getMessage());
        }
        return super.setContext(rc, ctx, startArgs);
    }
}

