/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.opplugin.onbrd;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.hr.hom.business.domain.service.impl.onbrd.OnbrdStartUpProcessService;
import kd.hr.hom.opplugin.onbrd.OnbrdStartUpProcessOp;

public class OnbrdStartUpProcessExtOp
extends OnbrdStartUpProcessOp {
    private static final Log LOGGER = LogFactory.getLog(OnbrdStartUpProcessExtOp.class);
    private static final ThreadPool THREAD_POOL = ThreadPools.newCachedThreadPool((String)"OnbrdStartUpProcessExtOp", (int)Runtime.getRuntime().availableProcessors(), (int)(2 * Runtime.getRuntime().availableProcessors()));

    @Override
    public void onPreparePropertys(PreparePropertysEventArgs evt) {
        super.onPreparePropertys(evt);
        List fieldKeys = evt.getFieldKeys();
        fieldKeys.add("name");
        fieldKeys.add("resumeno");
        fieldKeys.add("onbrdtype");
        fieldKeys.add("aadminorg");
        fieldKeys.add("certificatetype");
        fieldKeys.add("certificatenumber");
        fieldKeys.add("candidate");
        fieldKeys.add("enrollstatus");
        fieldKeys.add("checkinstatus");
        fieldKeys.add("processstatus");
        fieldKeys.add("starttime");
        fieldKeys.add("effectdate");
        fieldKeys.add("aadminorg");
        fieldKeys.add("aposition");
        fieldKeys.add("stdposition");
        fieldKeys.add("ajob");
        fieldKeys.add("viewtype");
        fieldKeys.add("againcheckresults");
        fieldKeys.add("employeeno");
        fieldKeys.add("isreplacenumber");
        fieldKeys.add("apositiontype");
        fieldKeys.add("employeenoscheme");
        fieldKeys.add("phone");
        fieldKeys.add("peremail");
        fieldKeys.add("personfield");
        fieldKeys.add("personindexid");
    }

    @Override
    public void onAddValidators(AddValidatorsEventArgs addValidatorsEventArgs) {
        addValidatorsEventArgs.addValidator((AbstractValidator)new OnbrdStartUpProcessExtValidator());
    }

    @Override
    public void afterExecuteOperationTransaction(AfterOperationArgs args) {
        super.afterExecuteOperationTransaction(args);
        DynamicObject[] dataEntities = args.getDataEntities();
        List ids = Arrays.stream(dataEntities).map(dy -> dy.getLong("id")).collect(Collectors.toList());
        THREAD_POOL.execute(() -> {
            LOGGER.info("###OnbrdStartUpProcessExtOp#afterExecuteOperationTransaction-start:{}", (Object)RequestContext.getOrCreate().getTraceId());
            new OnbrdStartUpProcessService().sendOnbrdActivityPlanIdToWorkflow(ids);
            LOGGER.info("###OnbrdStartUpProcessExtOp#afterExecuteOperationTransaction-end:{}", (Object)RequestContext.getOrCreate().getTraceId());
        }, RequestContext.get());
    }

    private static class OnbrdStartUpProcessExtValidator
    extends AbstractValidator {
        private OnbrdStartUpProcessExtValidator() {
        }

        public void validate() {
            LOGGER.info("###OnbrdStartUpProcessExtOp#validate-start");
            ExtendedDataEntity[] dataEntities = this.getDataEntities();
            List<DynamicObject> onbrdBills = Arrays.stream(dataEntities).map(ExtendedDataEntity::getDataEntity).collect(Collectors.toList());
            ArrayList errorBillList = new ArrayList(onbrdBills.size());
            new OnbrdStartUpProcessService().validateStartUpData(onbrdBills.toArray(new DynamicObject[0]), errorBillList);
            Map<Long, String> errInfoMap = errorBillList.stream().collect(Collectors.toMap(errorBill -> ((DynamicObject)errorBill.item1).getLong("id"), errorBill -> (String)Optional.ofNullable(errorBill.item2).orElse("")));
            for (ExtendedDataEntity dataEntity : dataEntities) {
                DynamicObject dy = dataEntity.getDataEntity();
                String errInfo = errInfoMap.get(dy.getLong("id"));
                if (!StringUtils.isNotBlank((CharSequence)errInfo)) continue;
                this.addFatalErrorMessage(dataEntity, errInfo);
            }
            LOGGER.info("###OnbrdStartUpProcessExtOp#validate-end");
        }
    }
}

