/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.opplugin.onbrd;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.hr.hom.business.domain.repository.common.HomCommonRepository;
import kd.hr.hom.business.domain.service.activity.IActivityDomainService;
import kd.hr.hom.common.enums.AuditStatusEnum;
import kd.hr.hom.common.enums.BillStatusEnum;
import kd.hr.hom.common.enums.OnbrdStatusEnum;
import kd.hr.hom.common.enums.ProcessStatusEnum;
import kd.hr.hom.opplugin.onbrd.OnbrdBillSaveOp;

public class OnbrdStartUpProcessOp
extends OnbrdBillSaveOp {
    private static final Log LOGGER = LogFactory.getLog(OnbrdStartUpProcessOp.class);
    private static final ThreadPool THREAD_POOL = ThreadPools.newCachedThreadPool((String)"OnbrdStartUpProcessOp", (int)5, (int)1000);

    public void onAddValidators(AddValidatorsEventArgs addValidatorsEventArgs) {
        addValidatorsEventArgs.addValidator((AbstractValidator)new OnbrdBillValidator());
    }

    @Override
    public void onPreparePropertys(PreparePropertysEventArgs evt) {
        super.onPreparePropertys(evt);
        List fieldKeys = evt.getFieldKeys();
        fieldKeys.add("enrollstatus");
        fieldKeys.add("checkinstatus");
        fieldKeys.add("processstatus");
        fieldKeys.add("starttime");
        fieldKeys.add("preenrollstatus");
        fieldKeys.add("billstatus");
        fieldKeys.add("auditstatus");
        fieldKeys.add("createtime");
    }

    @Override
    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        DynamicObject[] dataEntities;
        for (DynamicObject data : dataEntities = args.getDataEntities()) {
            data.set("enrollstatus", (Object)OnbrdStatusEnum.WAIT_ONBRD.toString());
            data.set("processstatus", (Object)ProcessStatusEnum.IN_PROCESS.getValue());
            data.set("starttime", (Object)new Date());
        }
        super.beginOperationTransaction(args);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs args) {
        DynamicObject[] dataEntities = args.getDataEntities();
        List<Object> ids = Arrays.stream(dataEntities).map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList());
        DynamicObject[] dynamicObjects = HomCommonRepository.queryDynamicObjectByPks((String)"hom_onbrdinfo", (String)"billstatus,auditstatus,billno,org", (Object[])ids.toArray(new Object[0]));
        String traceId = RequestContext.get().getTraceId();
        THREAD_POOL.execute(() -> {
            LOGGER.info("OnbrdStartUpProcessOp-afterExecuteOperationTransaction start traceId=={}", (Object)traceId);
            for (DynamicObject data : dynamicObjects) {
                boolean hasAuditFlow = IActivityDomainService.getInstance().isHasAuditFlow(data);
                data.set("billstatus", (Object)(hasAuditFlow ? BillStatusEnum.SUBMIT.getCode() : BillStatusEnum.AUDIT_PASS.getCode()));
                data.set("auditstatus", (Object)(hasAuditFlow ? AuditStatusEnum.SUBMIT.getCode() : AuditStatusEnum.DEAL_COMPLETE.getCode()));
            }
            HomCommonRepository.saveDynamicObjects((String)"hom_onbrdinfo", (DynamicObject[])dynamicObjects);
        }, RequestContext.get());
        LOGGER.info("OnbrdStartUpProcessOp-afterExecuteOperationTransaction end traceId=={}", (Object)traceId);
    }

    private static class OnbrdBillValidator
    extends HRDataBaseValidator {
        private OnbrdBillValidator() {
        }

        public void validate() {
            ExtendedDataEntity[] dataEntities;
            super.validate();
            for (ExtendedDataEntity entity : dataEntities = this.getDataEntities()) {
                DynamicObject onbrdBillInfo = entity.getDataEntity();
                String enrollStatus = onbrdBillInfo.getString("enrollstatus");
                if (HRStringUtils.equals((String)OnbrdStatusEnum.WAIT_START.getValue(), (String)enrollStatus)) continue;
                LOGGER.info("The enrollStatus is not WAIT_START");
                this.addFatalErrorMessage(entity, ResManager.loadKDString((String)"\u6d41\u7a0b\u72b6\u6001\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u4e0d\u80fd\u91cd\u590d\u6267\u884c\u64cd\u4f5c\uff1b", (String)"OnbrdStartUpProcessOp_0", (String)"hr-hom-opplugin", (Object[])new Object[0]));
            }
        }
    }
}

