/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.opplugin.preonbrd;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.operation.OperationServiceImpl;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hom.business.application.hrpi.IHomToHrpiAppService;
import kd.hr.hom.business.domain.repository.common.HomCommonRepository;
import kd.hr.hom.business.domain.service.ServiceFactory;
import kd.hr.hom.business.domain.service.common.IBaseDataDomainService;
import kd.hr.hom.business.domain.service.common.IHomConfigService;
import kd.hr.hom.business.domain.service.hcf.IHcfDataDomainService;
import kd.hr.hom.business.domain.service.impl.hcf.HcfDataDomainService;
import kd.hr.hom.business.domain.service.impl.onbrd.OnbrdInfoInitService;
import kd.hr.hom.business.domain.service.impl.onbrd.OnbrdStartUpProcessService;
import kd.hr.hom.common.constant.HcfCanCreConstants;
import kd.hr.hom.common.entity.IDCardInfo;
import kd.hr.hom.common.enums.OnbrdStatusEnum;
import kd.hr.hom.common.enums.ViewTypeEnum;
import kd.hr.hom.common.util.HOMObjectUtils;
import kd.hr.hom.common.util.IDCardUtils;
import kd.hr.hom.opplugin.preonbrd.AbstractApprovalAuditOp;
import kd.hr.hom.opplugin.preonbrd.ApprovalAuditingOp;
import kd.sdk.hr.hom.business.onbrd.IPreOnbrdService;

public class ApprovalAuditPassOp
extends AbstractApprovalAuditOp {
    private static final Log LOGGER = LogFactory.getLog(ApprovalAuditingOp.class);
    private static final ThreadPool THREAD_POOL = ThreadPools.newCachedThreadPool((String)"PreBatchOnbrdApprovalAuditPassOp", (int)5, (int)1000);
    private static final String STARTUP_SAVE = "startupsave";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final Map<String, String> hcfBaseInfoFieldMap = ImmutableMap.builder().put((Object)"name", (Object)"name").put((Object)"gender", (Object)"gender").put((Object)"nationality", (Object)"nationality").build();
    private static final Map<String, String> hcfContactinfoFieldMap = ImmutableMap.builder().put((Object)"phone", (Object)"phone").put((Object)"peremail", (Object)"peremail").build();
    private static final Map<String, String> hcfCretificateFieldMap = ImmutableMap.builder().put((Object)"certificatetype", (Object)"credentialstype").put((Object)"certificatenumber", (Object)"number").build();
    private static final Map<String, Map<String, String>> HCF_ENTITY_FIELD_MAP = ImmutableMap.builder().put((Object)"hcf_canbaseinfo", hcfBaseInfoFieldMap).put((Object)"hcf_cancontactinfo", hcfContactinfoFieldMap).put((Object)"hcf_cancre", hcfCretificateFieldMap).build();

    @Override
    public void onPreparePropertys(PreparePropertysEventArgs args) {
        List fieldKeys = args.getFieldKeys();
        fieldKeys.add(ENTRY_ENTITY);
        fieldKeys.add("onbrd");
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create(null, IPreOnbrdService.class, (String)"kd.sdk.hr.hom.business.onbrd.IPreOnbrdService", null);
        hrPluginProxy.callReplace(hrPlugin -> {
            hrPlugin.onPreparePropertys(args);
            return null;
        });
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs args) {
        DynamicObject[] dataEntities;
        LOGGER.info("afterExecuteOperationTransaction");
        for (DynamicObject preOnbrd : dataEntities = args.getDataEntities()) {
            this.approveAduitpass(preOnbrd);
        }
        HomCommonRepository.saveDynamicObjects((String)"hom_preonbrdbasebill", (DynamicObject[])dataEntities);
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create(null, IPreOnbrdService.class, (String)"kd.sdk.hr.hom.business.onbrd.IPreOnbrdService", null);
        hrPluginProxy.callReplace(hr -> {
            hr.afterPushData(dataEntities);
            return null;
        });
    }

    private void approveAduitpass(DynamicObject preOnbrd) {
        this.auditNodeAllComplete(preOnbrd);
        DynamicObject dynamicObject = HomCommonRepository.queryDynamicObjectByPk((String)"hom_preonbrdbasebill", (String)"", (Object)preOnbrd.getLong("id"));
        DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection(ENTRY_ENTITY);
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("hom_onbrdinfo");
        ArrayList onbrdList = Lists.newArrayListWithCapacity((int)3);
        ArrayList onboardIds = Lists.newArrayListWithCapacity((int)3);
        long[] onbrdIds = ORM.create().genLongIds("hom_onbrdinfo", dynamicObjectCollection.size());
        for (int i = 0; i < dynamicObjectCollection.size(); ++i) {
            DynamicObject preOnbrdEntry = (DynamicObject)dynamicObjectCollection.get(i);
            long id = preOnbrdEntry.getLong("id");
            DynamicObject onbrdInfo = hrBaseServiceHelper.generateEmptyDynamicObject();
            onbrdInfo.set("preentryonbrd", (Object)id);
            onbrdInfo.set("preonbrd", (Object)preOnbrd.getLong("id"));
            long onbrdId = onbrdIds[i];
            onbrdInfo.set("id", (Object)onbrdId);
            this.buildOnbrdInfo(preOnbrdEntry, onbrdInfo, preOnbrd);
            onbrdList.add(onbrdInfo);
            onboardIds.add(onbrdId);
            preOnbrdEntry.set("onbrd", (Object)onbrdId);
        }
        preOnbrd.set(ENTRY_ENTITY, (Object)dynamicObjectCollection);
        this.setOnbrdViewType(onbrdList);
        this.setJobInfoScm(onbrdList);
        for (DynamicObject onbrdInfo : onbrdList) {
            onbrdInfo.set("billno", (Object)new OnbrdInfoInitService().getNumberByCodeRule("hom_onbrdbillbase", "", onbrdInfo));
        }
        HomCommonRepository.saveDynamicObjects((String)"hom_onbrdinfo", (DynamicObject[])onbrdList.toArray(new DynamicObject[0]));
        String confVal = ((IHomConfigService)ServiceFactory.getService(IHomConfigService.class)).getConfVal("pre.onboard.isstartup", "false");
        if (Boolean.parseBoolean(confVal)) {
            this.startUpOnbrdList(onboardIds.toArray(new Long[0]));
        }
    }

    private void setJobInfoScm(List<DynamicObject> onbrdInfoList) {
        List jobIds = onbrdInfoList.stream().map(onbrdInfo -> HOMObjectUtils.getDynamicObjectFieldId((DynamicObject)onbrdInfo, (String)"ajob")).collect(Collectors.toList());
        Map jobRelationInfoMap = IBaseDataDomainService.getInstance().getJobLevelGradeRangeInfoByJobIds(jobIds);
        if (CollectionUtils.isEmpty((Map)jobRelationInfoMap)) {
            return;
        }
        for (DynamicObject onbrdBill : onbrdInfoList) {
            Long jobId = HOMObjectUtils.getDynamicObjectFieldId((DynamicObject)onbrdBill, (String)"ajob");
            Map jobRelationInfo = (Map)jobRelationInfoMap.get(jobId);
            if (CollectionUtils.isEmpty((Map)jobRelationInfo)) continue;
            HOMObjectUtils.setDesDyValueIfNotEmpty((DynamicObject)onbrdBill, (String)"jobseq", jobRelationInfo.get("jobseq"));
            HOMObjectUtils.setDesDyValueIfNotEmpty((DynamicObject)onbrdBill, (String)"jobfamily", jobRelationInfo.get("jobfamily"));
            HOMObjectUtils.setDesDyValueIfNotEmpty((DynamicObject)onbrdBill, (String)"jobclass", jobRelationInfo.get("jobclass"));
            String apositionType = onbrdBill.getString("apositiontype");
            if (!HRStringUtils.equals((String)"2", (String)apositionType)) continue;
            HOMObjectUtils.setDesDyValueIfNotEmpty((DynamicObject)onbrdBill, (String)"ajobscm", jobRelationInfo.get("jobscm"));
            HOMObjectUtils.setDesDyValueIfNotEmpty((DynamicObject)onbrdBill, (String)"ajobscmorg", jobRelationInfo.get("createOrg"));
            HOMObjectUtils.setDesDyValueIfNotEmpty((DynamicObject)onbrdBill, (String)"joblevelscm", jobRelationInfo.get("joblevelScmid"));
            HOMObjectUtils.setDesDyValueIfNotEmpty((DynamicObject)onbrdBill, (String)"jobgradescm", jobRelationInfo.get("jobgradeScmid"));
            List jobLevelInfos = (List)jobRelationInfo.get("joblevelRanges");
            List jobGradeInfos = (List)jobRelationInfo.get("jobgradeRanges");
            if (jobLevelInfos != null && jobLevelInfos.size() == 1) {
                HOMObjectUtils.setDesDyValueIfNotEmpty((DynamicObject)onbrdBill, (String)"ajoblevel", jobLevelInfos.get(0));
            }
            if (jobGradeInfos == null || jobGradeInfos.size() != 1) continue;
            HOMObjectUtils.setDesDyValueIfNotEmpty((DynamicObject)onbrdBill, (String)"ajobgrade", jobGradeInfos.get(0));
        }
    }

    private void buildOnbrdInfo(DynamicObject preOnbrdEntry, DynamicObject onbrdInfo, DynamicObject preOnbrd) {
        onbrdInfo.set("auditstatus", (Object)"A");
        onbrdInfo.set("billstatus", (Object)"A");
        onbrdInfo.set("enrollstatus", (Object)OnbrdStatusEnum.WAIT_START.getValue());
        onbrdInfo.set("org", preOnbrd.get("org"));
        onbrdInfo.set("creator", (Object)RequestContext.get().getCurrUserId());
        onbrdInfo.set("modifier", (Object)RequestContext.get().getCurrUserId());
        onbrdInfo.set("createtime", (Object)new Date());
        onbrdInfo.set("modifytime", (Object)new Date());
        onbrdInfo.set("datasource", (Object)4);
        if (!HRObjectUtils.isEmpty((Object)preOnbrdEntry.getLocaleString("name"))) {
            ILocaleString localeString = preOnbrdEntry.getLocaleString("name");
            for (Map.Entry stringStringEntry : localeString.entrySet()) {
                localeString.setItem((String)stringStringEntry.getKey(), (Object)((String)stringStringEntry.getValue()).trim());
            }
        }
        this.setValue("pbillno", "candidatenumber", preOnbrdEntry, onbrdInfo);
        this.setValue("aadminorg", "aadminorg", preOnbrdEntry, onbrdInfo);
        this.setValue("name", "name", preOnbrdEntry, onbrdInfo);
        this.setValue("gender", "gender", preOnbrdEntry, onbrdInfo);
        this.setValue("certificatetype", "certificatetype", preOnbrdEntry, onbrdInfo);
        this.setValue("certificatenumber", "certificatenumber", preOnbrdEntry, onbrdInfo);
        this.setValue("phone", "phone", preOnbrdEntry, onbrdInfo);
        this.setValue("peremail", "peremail", preOnbrdEntry, onbrdInfo);
        this.setValue("nationality", "nationality", preOnbrdEntry, onbrdInfo);
        this.setValue("employeeno", "employeeno", preOnbrdEntry, onbrdInfo);
        this.setValue("enterprise", "enterprise", preOnbrdEntry, onbrdInfo);
        this.setValue("managementscope", "managementscope", preOnbrdEntry, onbrdInfo);
        this.setValue("acompany", "acompany", preOnbrdEntry, onbrdInfo);
        this.setValue("baselocation", "baselocation", preOnbrdEntry, onbrdInfo);
        this.setValue("contractlocation", "contractlocation", preOnbrdEntry, onbrdInfo);
        this.setValue("workcalendar", "workcalendar", preOnbrdEntry, onbrdInfo);
        this.setValue("apositiontype", "apositiontype", preOnbrdEntry, onbrdInfo);
        this.setValue("ajob", "ajob", preOnbrdEntry, onbrdInfo);
        this.setValue("jobgradescm", "jobgradescm", preOnbrdEntry, onbrdInfo);
        this.setValue("jobgrade", "ajobgrade", preOnbrdEntry, onbrdInfo);
        this.setValue("joblevel", "ajoblevel", preOnbrdEntry, onbrdInfo);
        this.setValue("onbrdtype", "onbrdtype", preOnbrdEntry, onbrdInfo);
        this.setValue("paffaction", "affaction", preOnbrdEntry, onbrdInfo);
        this.setValue("plaborreltype", "laborreltype", preOnbrdEntry, onbrdInfo);
        this.setValue("plaborrelstatus", "laborrelstatus", preOnbrdEntry, onbrdInfo);
        this.setValue("pposstatus", "posstatus", preOnbrdEntry, onbrdInfo);
        this.setValue("onbrdtcity", "onbrdtcity", preOnbrdEntry, onbrdInfo);
        this.setValue("dependency", "dependency", preOnbrdEntry, onbrdInfo);
        this.setValue("dependencytype", "dependencytype", preOnbrdEntry, onbrdInfo);
        this.setValue("empgroup", "empgroup", preOnbrdEntry, onbrdInfo);
        this.setValue("effectdate", "effectdate", preOnbrdEntry, onbrdInfo);
        this.setValue("validuntil", "validuntil", preOnbrdEntry, onbrdInfo);
        this.setValue("handler", "handler", preOnbrdEntry, onbrdInfo);
        this.setValue("isprobation", "isprobation", preOnbrdEntry, onbrdInfo);
        this.setValue("probationtime", "probationtime", preOnbrdEntry, onbrdInfo);
        this.setValue("perprobationtime", "perprobationtime", preOnbrdEntry, onbrdInfo);
        this.setValue("ppostype", "postype", preOnbrdEntry, onbrdInfo);
        this.setValue("recruittype", "recruittype", preOnbrdEntry, onbrdInfo);
        this.setValue("recruitsource", "recruitsource", preOnbrdEntry, onbrdInfo);
        this.setValue("resumeno", "resumeno", preOnbrdEntry, onbrdInfo);
        this.setValue("offernumber", "offernumber", preOnbrdEntry, onbrdInfo);
        this.setValue("teacher", "teacher", preOnbrdEntry, onbrdInfo);
        this.setValue("joblevelscm", "joblevelscm", preOnbrdEntry, onbrdInfo);
        if (HRObjectUtils.isEmpty((Object)preOnbrdEntry.getString("perprobationtime"))) {
            onbrdInfo.set("perprobationtime", (Object)"4");
        }
        OnbrdInfoInitService onbrdInfoInitService = new OnbrdInfoInitService();
        Map hrBuOrgMap = onbrdInfoInitService.getHRBuOrgMap(new DynamicObject[]{onbrdInfo});
        if (HRObjectUtils.isEmpty((Object)onbrdInfo.get("org"))) {
            onbrdInfo.set("org", preOnbrd.get("org"));
        }
        if (HRObjectUtils.isEmpty((Object)onbrdInfo.get("ajobscmorg"))) {
            onbrdInfo.set("ajobscmorg", preOnbrd.get("org"));
        }
        Long onbrdBillId = onbrdInfo.getLong("id");
        onbrdInfo.set("hrbu", hrBuOrgMap.get(onbrdBillId));
        onbrdInfo.set("affiliateadminorg", onbrdInfo.get("aadminorg"));
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create(null, IPreOnbrdService.class, (String)"kd.sdk.hr.hom.business.onbrd.IPreOnbrdService", null);
        hrPluginProxy.callReplace(hrPlugin -> {
            hrPlugin.setOnbrdInfo(preOnbrdEntry, onbrdInfo, preOnbrd);
            return null;
        });
        this.createCandidate(preOnbrdEntry, onbrdInfo, preOnbrd);
    }

    private void setOnbrdViewType(List<DynamicObject> onbrdInfoList) {
        Map<Long, List<DynamicObject>> onbrdInfoMap = onbrdInfoList.stream().collect(Collectors.groupingBy(onbrdInfo -> onbrdInfo.getLong("certificatetype.id")));
        IHomToHrpiAppService homToHrpiAppService = IHomToHrpiAppService.getInstance();
        for (Map.Entry<Long, List<DynamicObject>> onbrdInfoEntry : onbrdInfoMap.entrySet()) {
            List<DynamicObject> billList = onbrdInfoEntry.getValue();
            List certificateNumbers = billList.stream().filter(onbrdBill -> HRStringUtils.isNotEmpty((String)onbrdBill.getString("certificatenumber"))).map(onbrdBill -> onbrdBill.getString("certificatenumber")).collect(Collectors.toList());
            Map resultMap = homToHrpiAppService.isFormerEmployeeByCreNumberAndCreType(certificateNumbers, onbrdInfoEntry.getKey());
            for (DynamicObject onbrdInfo2 : billList) {
                onbrdInfo2.set("viewtype", (Object)ViewTypeEnum.ROUTINE.getCode());
                Map formerEmployeeMap = (Map)resultMap.get(onbrdInfo2.getString("certificatenumber"));
                if (CollectionUtils.isEmpty((Map)formerEmployeeMap)) continue;
                onbrdInfo2.set("viewtype", (Object)ViewTypeEnum.AGAIN.getCode());
                onbrdInfo2.set("personfield", formerEmployeeMap.get("personfield"));
            }
        }
    }

    private void createCandidate(DynamicObject preOnbrdEntry, DynamicObject onbrdInfo, DynamicObject preOnbrd) {
        DynamicObject candidateNew = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"hcf_candidate"));
        candidateNew.set("name", (Object)onbrdInfo.getString("name"));
        candidateNew.set("number", (Object)onbrdInfo.getString("candidatenumber"));
        DynamicObject candidate = IHcfDataDomainService.getInstance().saveCandidate(candidateNew);
        onbrdInfo.set("candidate", (Object)candidate);
        for (Map.Entry<String, Map<String, String>> entry : HCF_ENTITY_FIELD_MAP.entrySet()) {
            this.saveSingleRowEntity(onbrdInfo, entry.getKey(), entry.getValue(), preOnbrdEntry, preOnbrd);
        }
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create(null, IPreOnbrdService.class, (String)"kd.sdk.hr.hom.business.onbrd.IPreOnbrdService", null);
        hrPluginProxy.callReplace(hrPlugin -> {
            hrPlugin.saveCandidateAtt(preOnbrdEntry, onbrdInfo, preOnbrd);
            return null;
        });
    }

    private void saveSingleRowEntity(DynamicObject onbrdBill, String entityName, Map<String, String> hcfFieldMap, DynamicObject preOnbrdEntry, DynamicObject preOnbrd) {
        DynamicObject certificateType;
        HashMap singleRowEntityMap = Maps.newHashMapWithExpectedSize((int)1);
        HcfDataDomainService hcfDataDomainService = new HcfDataDomainService();
        Long candidateId = onbrdBill.getLong("candidate.id");
        DynamicObject singleRowEntity = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)entityName));
        singleRowEntity.set("candidate", (Object)candidateId);
        for (Map.Entry<String, String> entry : hcfFieldMap.entrySet()) {
            singleRowEntity.set(entry.getValue(), onbrdBill.get(entry.getKey()));
        }
        if (HRStringUtils.equals((String)"hcf_cancre", (String)entityName)) {
            singleRowEntity.set("ismajor", (Object)Boolean.TRUE);
        }
        if (HRStringUtils.equals((String)"hcf_canbaseinfo", (String)entityName) && !HRObjectUtils.isEmpty((Object)(certificateType = onbrdBill.getDynamicObject("certificatetype"))) && HcfCanCreConstants.CREDENTIALSTYPE_ID_IDCARD.equals(certificateType.getLong("id"))) {
            IDCardInfo idCardInfo = IDCardUtils.parse((String)onbrdBill.getString("certificatenumber"));
            singleRowEntity.set("birthday", (Object)(HRObjectUtils.isEmpty((Object)idCardInfo) ? null : idCardInfo.getBirthDay()));
        }
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create(null, IPreOnbrdService.class, (String)"kd.sdk.hr.hom.business.onbrd.IPreOnbrdService", null);
        hrPluginProxy.callReplace(hrPlugin -> {
            hrPlugin.saveCandidateBaseInfo(onbrdBill, entityName, singleRowEntity, preOnbrdEntry, preOnbrd);
            return null;
        });
        singleRowEntityMap.put(candidateId, singleRowEntity);
        hcfDataDomainService.saveHcfAttachedData(entityName, singleRowEntityMap.values().toArray(new DynamicObject[0]));
    }

    private void setValue(String orignKey, String targetKey, DynamicObject orignOnbrdInfo, DynamicObject targetOnbrdInfo) {
        if (!targetOnbrdInfo.containsProperty(targetKey)) {
            LOGGER.error("targetOnbrdInfo don't has property" + targetKey);
            return;
        }
        targetOnbrdInfo.set(targetKey, orignOnbrdInfo.get(orignKey));
    }

    private void startUpOnbrdList(Long[] successIds) {
        OperationResult result = null;
        try {
            OperateOption option = OperateOption.create();
            option.setVariableValue("currbizappid", this.getOption().getVariableValue("currbizappid"));
            OperationServiceImpl operationService = new OperationServiceImpl();
            result = operationService.localInvokeOperation(STARTUP_SAVE, "hom_personwaitstart", (Object[])successIds, option);
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
        }
        if (result != null) {
            List successPkIds = result.getSuccessPkIds().stream().map(id -> Long.parseLong(id.toString())).collect(Collectors.toList());
            THREAD_POOL.execute(() -> {
                LOGGER.info("start flow");
                new OnbrdStartUpProcessService().sendOnbrdActivityPlanIdToWorkflow(successPkIds);
            }, RequestContext.get());
        }
    }
}

