/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.opplugin.validate;

import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.hr.hom.business.domain.service.common.IHomDataMutexService;

public class OnbrdBillDeleteValidator
extends HRDataBaseValidator {
    public void validate() {
        super.validate();
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        Set onbrdIdSet = Stream.of(dataEntities).map(entity -> entity.getDataEntity().getLong("id")).collect(Collectors.toSet());
        Map batchRequireResult = IHomDataMutexService.getInstance().batchRequire(onbrdIdSet, "hom_onbrdinfo", "delete");
        for (ExtendedDataEntity entity2 : dataEntities) {
            DynamicObject onbrdBillInfo = entity2.getDataEntity();
            Long onbrdBillId = onbrdBillInfo.getLong("id");
            String name = onbrdBillInfo.getLocaleString("name").getLocaleValue();
            if (((Boolean)batchRequireResult.get(onbrdBillId)).booleanValue()) continue;
            this.addFatalErrorMessage(entity2, String.format(ResManager.loadKDString((String)"%s\u7684\u4fe1\u606f\u6b63\u5728\u88ab\u7f16\u8f91\uff0c\u4e0d\u80fd\u5220\u9664\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"OnbrdBillDeleteValidator_0", (String)"hr-hom-opplugin", (Object[])new Object[0]), name));
        }
    }
}

