/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.opplugin.validate;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.hr.hom.business.application.onbrd.IValidEntryDateService;
import kd.hr.hom.business.application.rule.IOnbrdCommonValidator;
import kd.hr.hom.business.domain.service.onbrd.IOnbrdBillDomainService;
import kd.hr.hom.business.domain.service.onbrd.IOnbrdInfoInitService;
import kd.hr.hom.common.entity.ErrorMsgSyncProcessor;
import kd.hr.hom.common.entity.HomCommonWrapper;
import kd.hr.hom.common.enums.InitTypeEnum;
import kd.hr.hom.common.util.HOMObjectUtils;

public class OnbrdBillSaveValidator
extends HRDataBaseValidator {
    private static final Log LOGGER = LogFactory.getLog(OnbrdBillSaveValidator.class);
    private List<String> NOCHANGE_FILEDS = ImmutableList.of((Object)"org", (Object)"name", (Object)"certificatetype");

    public void validate() {
        LOGGER.info("start validate");
        super.validate();
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        this.makeFieldsNoChange(dataEntities);
        for (ExtendedDataEntity entity2 : dataEntities) {
            DynamicObject onbrdBill = entity2.getDataEntity();
            String jobLevelText = onbrdBill.getString("ajobleveltext");
            DynamicObject jobLevel = onbrdBill.getDynamicObject("ajoblevel");
            if (HRStringUtils.isEmpty((String)jobLevelText) && HOMObjectUtils.isNotEmpty((Object)jobLevel)) {
                onbrdBill.set("ajobleveltext", (Object)jobLevel.getString("name"));
            } else if (HRStringUtils.equals((String)"NULL_CLEAR", (String)jobLevelText) || HRStringUtils.equals((String)"EMPTY_CLEAR", (String)jobLevelText)) {
                LOGGER.info("jobLevelText:{};", (Object)jobLevelText);
                onbrdBill.set("ajoblevel", null);
                onbrdBill.set("ajobleveltext", (Object)"");
            }
            String jobGradeText = onbrdBill.getString("ajobgradetext");
            DynamicObject jobGrade = onbrdBill.getDynamicObject("ajobgrade");
            if (HRStringUtils.isEmpty((String)jobGradeText) && HOMObjectUtils.isNotEmpty((Object)jobGrade)) {
                onbrdBill.set("ajobgradetext", (Object)jobGrade.getString("name"));
                continue;
            }
            if (!HRStringUtils.equals((String)"NULL_CLEAR", (String)jobGradeText) && !HRStringUtils.equals((String)"EMPTY_CLEAR", (String)jobGradeText)) continue;
            onbrdBill.set("ajobgrade", null);
            onbrdBill.set("ajobgradetext", (Object)"");
        }
        SingleImportErrorMsgSynchronizer singleImportErrorMsgSynchronizer = new SingleImportErrorMsgSynchronizer();
        List rowDataWrapperList = Stream.of(dataEntities).map(entity -> new HomCommonWrapper(entity.getDataEntity(), entity, entity.getRowIndex(), (Object)this, (ErrorMsgSyncProcessor)singleImportErrorMsgSynchronizer)).collect(Collectors.toList());
        IOnbrdCommonValidator onbrdCommonValidator = IOnbrdCommonValidator.getInstance();
        onbrdCommonValidator.validateImportMustInput(rowDataWrapperList);
        onbrdCommonValidator.validateFormatWithCertificate(rowDataWrapperList);
        IOnbrdInfoInitService.getInstance().initFieldValue(rowDataWrapperList, InitTypeEnum.ONBRD_UPDATE_IMPORT.getValue());
        onbrdCommonValidator.validAjobScmOrgPermission(rowDataWrapperList);
        onbrdCommonValidator.judgeCertificateIfDuplicate(rowDataWrapperList);
        onbrdCommonValidator.judgeEmployeenoIfDuplicate(rowDataWrapperList);
        onbrdCommonValidator.validIsInBlackList(rowDataWrapperList);
        onbrdCommonValidator.judgeDuplicateByHrpiRpc(rowDataWrapperList, (List)ImmutableList.of((Object)"certificatetype.id", (Object)"certificatenumber", (Object)"employeeno"));
        onbrdCommonValidator.checkChgevent(rowDataWrapperList);
        onbrdCommonValidator.checkEmpgroup(rowDataWrapperList);
        onbrdCommonValidator.validateStaffUse(rowDataWrapperList);
        onbrdCommonValidator.validateVirtuallyOrg(rowDataWrapperList);
        onbrdCommonValidator.validateDepartPerson(rowDataWrapperList);
        List validatePassList = rowDataWrapperList.stream().filter(rowData -> rowData.getErrorMsgNum() == 0).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(validatePassList)) {
            return;
        }
        onbrdCommonValidator.validNumber(validatePassList);
        onbrdCommonValidator.validExtendEmployeeno(validatePassList);
        IValidEntryDateService.getInstance().validEntryDateOfQuitDateByMultiEntity(validatePassList);
        validatePassList = validatePassList.stream().filter(rowData -> rowData.getErrorMsgNum() == 0).collect(Collectors.toList());
        IOnbrdInfoInitService.getInstance().syncInfoToHcf(validatePassList);
        LOGGER.info("end validate");
    }

    private void makeFieldsNoChange(ExtendedDataEntity[] dataEntities) {
        Set onbrdBillIds = Stream.of(dataEntities).map(entity -> entity.getDataEntity().getLong("id")).collect(Collectors.toSet());
        QFilter qFilter = new QFilter("id", "in", onbrdBillIds);
        String properties = String.join((CharSequence)",", this.NOCHANGE_FILEDS);
        DynamicObject[] onbrdBillsFromDB = IOnbrdBillDomainService.getInstance().findOnbrdBills(properties, new QFilter[]{qFilter});
        Map<Long, DynamicObject> onbrdBillDBMap = Stream.of(onbrdBillsFromDB).collect(Collectors.toMap(onbrdBill -> onbrdBill.getLong("id"), onbrdBill -> onbrdBill, (oldValue, newValue) -> newValue));
        for (ExtendedDataEntity entity2 : dataEntities) {
            DynamicObject onbrdBillExcel = entity2.getDataEntity();
            DynamicObject onbrdBillFromDB = onbrdBillDBMap.get(onbrdBillExcel.getLong("id"));
            if (onbrdBillFromDB == null) continue;
            for (String fieldName : this.NOCHANGE_FILEDS) {
                onbrdBillExcel.set(fieldName, onbrdBillFromDB.get(fieldName));
            }
        }
    }

    public static class SingleImportErrorMsgSynchronizer
    implements ErrorMsgSyncProcessor<OnbrdBillSaveValidator, ExtendedDataEntity> {
        public void process(OnbrdBillSaveValidator originValidator, ExtendedDataEntity entity, String errorMsg) {
            originValidator.addFatalErrorMessage(entity, errorMsg);
        }
    }
}

