/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.opplugin.validate.activehandle;

import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.hr.hom.common.enums.ActivityStatusEnum;

public class SubmitValidator
extends HRDataBaseValidator {
    public void validate() {
        super.validate();
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        int dataLength = dataEntities.length;
        boolean isSingle = dataLength == 1;
        Long userId = RequestContext.get().getCurrUserId();
        for (ExtendedDataEntity extendedDataEntity : dataEntities) {
            String errMsg;
            DynamicObject activehandleDetail = extendedDataEntity.getDataEntity();
            DynamicObject activityIns = activehandleDetail.getDynamicObject("activityins");
            DynamicObject onboard = activehandleDetail.getDynamicObject("onbrdid");
            String candidateNumber = onboard.getString("candidate.number");
            String tipPrefix = "";
            if (Boolean.FALSE.equals(isSingle)) {
                tipPrefix = String.format(Locale.ROOT, ResManager.loadKDString((String)"%1$s\u7684%2$s\uff1a", (String)"ActiveHandleSubmitValidator_3", (String)"hr-hom-opplugin", (Object[])new Object[0]), candidateNumber, activehandleDetail.getString("activity.name"));
            }
            if (HRObjectUtils.isEmpty((Object)activityIns)) {
                errMsg = String.format(Locale.ROOT, ResManager.loadKDString((String)"%1$s\u6d3b\u52a8\u5b9e\u4f8b\u4e0d\u5b58\u5728\u3002", (String)"ActiveHandleSubmitValidator_0", (String)"hr-hom-opplugin", (Object[])new Object[0]), tipPrefix);
                this.addFatalErrorMessage(extendedDataEntity, errMsg);
                continue;
            }
            if (!ActivityStatusEnum.PROCESSING.getValue().equals(activityIns.getString("taskstatus"))) {
                errMsg = String.format(Locale.ROOT, ResManager.loadKDString((String)"%1$s\u4ec5\u53ef\u4ee5\u63d0\u4ea4\u5904\u7406\u4e2d\u7684\u6d3b\u52a8\u3002\u505c\u7559\u5f53\u524d\u9875\u9762\uff0c\u7136\u540e\u4e3b\u52a8\u5237\u65b0\u9875\u9762\u3002", (String)"ActiveHandleSubmitValidator_1", (String)"hr-hom-opplugin", (Object[])new Object[0]), tipPrefix);
                this.addFatalErrorMessage(extendedDataEntity, errMsg);
                continue;
            }
            DynamicObjectCollection handlers = activityIns.getDynamicObjectCollection("handlers");
            if (HRCollUtil.isEmpty((Collection)handlers)) {
                errMsg = String.format(Locale.ROOT, ResManager.loadKDString((String)"%1$s\u6570\u636e\u5904\u7406\u4eba\u5df2\u7ecf\u53d1\u751f\u53d8\u66f4\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u5904\u7406\u3002", (String)"ActiveHandleSubmitValidator_2", (String)"hr-hom-opplugin", (Object[])new Object[0]), tipPrefix);
                this.addFatalErrorMessage(extendedDataEntity, errMsg);
                continue;
            }
            List handlerIds = handlers.stream().map(handler -> handler.getLong("fbasedataId.id")).collect(Collectors.toList());
            if (!HRCollUtil.isEmpty(handlerIds) && handlerIds.contains(userId)) continue;
            errMsg = String.format(Locale.ROOT, ResManager.loadKDString((String)"%1$s\u6570\u636e\u5904\u7406\u4eba\u5df2\u7ecf\u53d1\u751f\u53d8\u66f4\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u5904\u7406\u3002", (String)"ActiveHandleSubmitValidator_2", (String)"hr-hom-opplugin", (Object[])new Object[0]), tipPrefix);
            this.addFatalErrorMessage(extendedDataEntity, errMsg);
        }
    }
}

