/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.opplugin.validate.approve;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.hr.hom.common.enums.CollectApproveStatusEnum;
import kd.hr.hom.common.enums.OnbrdStatusEnum;

public class OneClickNoticeValidator
extends HRDataBaseValidator {
    private static final List<String> enrollStatusSet = Arrays.asList(OnbrdStatusEnum.HAS_ONBRD.toString(), OnbrdStatusEnum.BREAK_UP.toString());

    public void validate() {
        super.validate();
        boolean isSingle = this.dataEntities.length == 1;
        for (ExtendedDataEntity entity : this.dataEntities) {
            String errMsg;
            DynamicObject dataEntity = entity.getDataEntity();
            DynamicObject onboard = dataEntity.getDynamicObject("onboard");
            String candidateNumber = onboard.getDynamicObject("candidate").getString("number");
            String string = candidateNumber = isSingle ? "" : candidateNumber + "\uff1a";
            if (enrollStatusSet.contains(onboard.getString("enrollstatus"))) {
                errMsg = String.format(Locale.ROOT, ResManager.loadKDString((String)"%1$s\u4e0d\u80fd\u5bf9\u5165\u804c\u72b6\u6001\u4e3a\u201c\u5df2\u5165\u804c\u201d\u201c\u5165\u804c\u7ec8\u6b62\u201d\u7684\u6570\u636e\u8fdb\u884c\u64cd\u4f5c\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"OneClickNoticeValidator_2", (String)"hr-hom-opplugin", (Object[])new Object[0]), candidateNumber);
                this.addFatalErrorMessage(entity, errMsg);
                continue;
            }
            if (CollectApproveStatusEnum.REJECT.getStatus().equals(dataEntity.getString("approvestatus"))) continue;
            errMsg = String.format(Locale.ROOT, ResManager.loadKDString((String)"%1$s\u4ec5\u53ef\u4ee5\u63d0\u9192\u9a73\u56de\u5f85\u63d0\u4ea4\u7684\u4fe1\u606f\u5ba1\u6838\u534f\u4f5c\u3002", (String)"OneClickNoticeValidator_3", (String)"hr-hom-opplugin", (Object[])new Object[0]), candidateNumber);
            this.addFatalErrorMessage(entity, errMsg);
        }
    }
}

