/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.opplugin.web.validate;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;

public class OnbrdPlaceValidator
extends AbstractValidator {
    private static final HRBaseServiceHelper PLACE_HELPER = new HRBaseServiceHelper("hom_placeentry");

    public void validate() {
        ExtendedDataEntity[] dataEntities;
        for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
            boolean isDefaultAddress;
            DynamicObject dataEntityDy = dataEntity.getDataEntity();
            boolean isSetGpsInfo = (Boolean)dataEntity.getValue("issetgpsinfo");
            if (Long.valueOf(0L).equals(dataEntityDy.getLong("masterid")) && isSetGpsInfo) {
                if (BigDecimal.ZERO.compareTo(dataEntityDy.getBigDecimal("longitude")) == 0) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5750\u6807\u7ecf\u5ea6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"OnbrdPlaceValidator_0", (String)"hr-hom-opplugin", (Object[])new Object[0]));
                }
                if (BigDecimal.ZERO.compareTo(dataEntityDy.getBigDecimal("latitude")) == 0) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5750\u6807\u7eac\u5ea6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"OnbrdPlaceValidator_1", (String)"hr-hom-opplugin", (Object[])new Object[0]));
                }
                if (BigDecimal.ZERO.compareTo(dataEntityDy.getBigDecimal("effectradius")) == 0) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201c\u6709\u6548\u534a\u5f84\uff08\u7c73\uff09\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"OnbrdPlaceValidator_2", (String)"hr-hom-opplugin", (Object[])new Object[0]));
                }
            }
            if (!(isDefaultAddress = dataEntityDy.getBoolean("isdefaultaddress"))) continue;
            DynamicObject cityDy = dataEntityDy.getDynamicObject("city");
            if (ObjectUtils.isEmpty((Object)cityDy)) {
                return;
            }
            long cityId = cityDy.getLong("id");
            QFilter cityQilter = new QFilter("city", "=", (Object)cityId);
            cityQilter.and(new QFilter("isdefaultaddress", "=", (Object)"1"));
            cityQilter.and(new QFilter("id", "!=", (Object)dataEntityDy.getLong("id")));
            if (!PLACE_HELPER.isExists(cityQilter)) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u57ce\u5e02\u5df2\u6709\u9ed8\u8ba4\u5730\u5740\uff0c\u8bf7\u5148\u4fee\u6539\u539f\u6570\u636e\u4e3a\u975e\u9ed8\u8ba4\u5730\u5740\u3002", (String)"OnbrdPlaceValidator_3", (String)"hr-hom-opplugin", (Object[])new Object[0]));
        }
    }
}

