/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hpfs.business.consumer;

import java.util.Objects;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.hr.hpfs.business.perchg.common.ChgLogHelper;
import kd.hr.hpfs.business.perchg.executor.MserviceService;
import kd.hr.hpfs.business.perchg.executor.util.PerChgUtils;

public interface IPersonChgConsumerService {
    public static final Log LOGGER = LogFactory.getLog(IPersonChgConsumerService.class);

    default public void consumerPersonChgMessage(Object body, String messageId, boolean resend, MessageAcker messageAcker) {
        String msg = (String)body;
        ChgLogHelper.writeLogAfterReceive(msg, "HPFSPersonChgConsumer");
        String uniqueKey = PerChgUtils.parseUniqueKeyFromChgMessage(msg);
        if (Objects.isNull(uniqueKey)) {
            LOGGER.error("IPersonChgConsumerService.consumerPersonChgMessage uniqueKey is empty, the message will discard messageinfo is {}", (Object)msg);
            messageAcker.discard(messageId);
            return;
        }
        String cacheKey = PerChgUtils.getPerChgRetryMaxCountCacheKey(uniqueKey);
        IAppCache appCache = AppCache.get((String)"hpfs");
        try {
            MserviceService.getInstance().execute(msg);
            LOGGER.info("IPersonChgConsumerService.consumerPersonChgMessage execute sucess");
        }
        catch (Exception ex) {
            int retryCount;
            LOGGER.error("IPersonChgConsumerService.consumerPersonChgMessage exception", (Throwable)ex);
            Integer retryCountInter = (Integer)appCache.get(PerChgUtils.getPerChgRetryMaxCountCacheKey(cacheKey), Integer.class);
            int n = retryCount = Objects.isNull(retryCountInter) ? 0 : retryCountInter;
            if (retryCount < PerChgUtils.getPerChgRetryMaxCount()) {
                LOGGER.warn("IPersonChgConsumerService.consumerPersonChgMessage retryCount:{} less than maxCount:{}", (Object)retryCount, (Object)PerChgUtils.getPerChgRetryMaxCount());
                appCache.put(PerChgUtils.getPerChgRetryMaxCountCacheKey(cacheKey), (Object)(++retryCount));
                messageAcker.deny(messageId);
                return;
            }
            LOGGER.warn("IPersonChgConsumerService.consumerPersonChgMessage over maximum retryCount; retryCount:{}, maximum:{}", (Object)retryCount, (Object)PerChgUtils.getPerChgRetryMaxCount());
        }
        messageAcker.ack(messageId);
        appCache.remove(PerChgUtils.getPerChgRetryMaxCountCacheKey(uniqueKey));
    }
}

