/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hpfs.business.perchg.common;

import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.Date;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hpfs.business.perchg.executor.enums.ChgLogStatusEnum;
import kd.hr.hpfs.business.perchg.executor.model.ChgExternalRecordDto;
import kd.hr.hpfs.business.perchg.executor.model.ChgRecordExecutorDto;
import kd.hr.hpfs.business.perchg.executor.service.ChgLogEntryService;
import kd.sdk.hr.hpfs.business.perchg.bizentity.PerChgBizInfo;
import kd.sdk.hr.hpfs.business.perchg.bizentity.PerChgBizResult;
import kd.sdk.hr.hpfs.business.perchg.bizentity.PerChgParam;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class ChgLogHelper {
    public static final ThreadLocal<Long> LOG_ID_THREAD_LOCAL = new ThreadLocal();
    private static final HRBaseServiceHelper logHelper = new HRBaseServiceHelper("hpfs_chglog");
    private static final String SELECT_PROPERTIES_CONSUME = "transactionstatus,consumer,params,billid,billsource,appid,chgrecord,event,errorlog,rtparams,transactionstatus,consumeexetime";

    public static void writeLogAfterReceive(String msg) {
        DynamicObject logDy = ChgLogHelper.createLogDyByMsg(msg);
        Object ob = logHelper.saveOne(logDy);
        DynamicObject log = (DynamicObject)ob;
        LOG_ID_THREAD_LOCAL.set((Long)log.getPkValue());
    }

    private static DynamicObject createLogDyByMsg(String msg) {
        DynamicObject logDy = logHelper.generateEmptyDynamicObject();
        logDy.set("transactionstatus", (Object)"0");
        logDy.set("consumeexetime", (Object)new Date());
        logDy.set("params", (Object)msg);
        return logDy;
    }

    public static void writeLogAfterObtainDLock(PerChgBizInfo bizInfo) {
        DynamicObject logDy = logHelper.queryOne((Object)LOG_ID_THREAD_LOCAL.get());
        logDy.set("billid", (Object)bizInfo.getBillId());
        logDy.set("billsource", (Object)bizInfo.getBillSource());
        logDy.set("billno", (Object)bizInfo.getBillNo());
        logDy.set("chgaction", (Object)bizInfo.getActionId());
        logDy.set("transactionstatus", (Object)"4");
        logHelper.saveOne(logDy);
    }

    public static void writeLogBeforeRetry(DynamicObject logDy) {
        logDy.set("consumeexetime", (Object)new Date());
        logDy.set("transactionstatus", (Object)"4");
        logHelper.saveOne(logDy);
        LOG_ID_THREAD_LOCAL.set((Long)logDy.getPkValue());
    }

    public static void writeLogAfterReceive(String msg, String consumer) {
        DynamicObject logDy = ChgLogHelper.createLogDyByMsg(msg);
        logDy.set("consumer", (Object)consumer);
        Object ob = logHelper.saveOne(logDy);
        DynamicObject log = (DynamicObject)ob;
        LOG_ID_THREAD_LOCAL.set((Long)log.getPkValue());
    }

    public static void updateLogResult(PerChgBizInfo bizInfo, PerChgBizResult bizResult, String transactionStatus) {
        DynamicObject logDy = logHelper.queryOne((Object)LOG_ID_THREAD_LOCAL.get());
        logDy.set("billid", (Object)bizInfo.getBillId());
        logDy.set("billsource", (Object)bizInfo.getBillSource());
        logDy.set("appid", (Object)RequestContext.get().getApi3rdAppId());
        logDy.set("chgrecord", (Object)bizInfo.getChgrecordId());
        logDy.set("event", (Object)bizInfo.getEventId());
        logDy.set("errorlog", (Object)bizResult.getErrMsg());
        logDy.set("rtparams", (Object)JSONObject.toJSONString((Object)bizResult));
        logDy.set("transactionstatus", (Object)transactionStatus);
        logDy.set("billno", (Object)bizInfo.getBillNo());
        logDy.set("chgaction", (Object)bizInfo.getActionId());
        ChgLogEntryService.getInstance().formatLogEntryDto2Dyn(logDy, bizInfo);
        ChgLogEntryService.getInstance().formatLogPlugin(logDy, bizInfo);
        logHelper.saveOne(logDy);
    }

    public static void writeErrorLogBeforeChg(PerChgParam perChgParam, Exception e) {
        ChgLogHelper.writeErrorLogBeforeChg(perChgParam, ExceptionUtils.getStackTrace((Throwable)e));
    }

    public static void writeErrorLogBeforeChg(PerChgParam perChgParam, String errorMsg) {
        Long logId = LOG_ID_THREAD_LOCAL.get();
        DynamicObject logDy = logHelper.queryOne((Object)logId);
        if (!Objects.isNull(perChgParam) && !CollectionUtils.isEmpty((Collection)perChgParam.getBizInfoList())) {
            PerChgBizInfo info = (PerChgBizInfo)perChgParam.getBizInfoList().get(0);
            logDy.set("billid", (Object)info.getBillId());
            logDy.set("billsource", (Object)info.getBillSource());
            logDy.set("appid", (Object)perChgParam.getAppId());
            logDy.set("billno", (Object)info.getBillNo());
            logDy.set("chgaction", (Object)info.getActionId());
        }
        logDy.set("errorlog", (Object)errorMsg);
        logDy.set("transactionstatus", (Object)"-1");
        logHelper.saveOne(logDy);
    }

    public static void updateErrorLog(DynamicObject logDy, Exception exception) {
        logDy.set("errorlog", (Object)ExceptionUtils.getStackTrace((Throwable)exception));
        logHelper.saveOne(logDy);
    }

    public static void updateErrorLog(ChgRecordExecutorDto chgRecordExecutor, Exception exception, String returnParam) {
        ChgLogHelper.updateErrorLog(chgRecordExecutor, ExceptionUtils.getStackTrace((Throwable)exception), returnParam);
    }

    public static void updateErrorLog(ChgRecordExecutorDto chgRecordExecutor, String errorMag, String returnParam) {
        ChgLogHelper.updateLog(chgRecordExecutor, errorMag, (Long)0L, returnParam, ChgLogStatusEnum.FAIL.getFlag());
    }

    public static void updateSuccessLog(ChgRecordExecutorDto chgRecordExecutor, Long recordId, String returnParam) {
        ChgLogHelper.updateLog(chgRecordExecutor, null, recordId, returnParam, ChgLogStatusEnum.RECORD_SUCCESS.getFlag());
    }

    public static void updateLog(ChgRecordExecutorDto chgRecordExecutor, String error, Long recordId, String returnParam, String transactionStatus) {
        DynamicObject logDy = logHelper.queryOne((Object)LOG_ID_THREAD_LOCAL.get());
        logDy.set("billid", (Object)chgRecordExecutor.getBillId());
        logDy.set("billsource", (Object)chgRecordExecutor.getBillSource());
        logDy.set("appid", (Object)chgRecordExecutor.getAppId());
        logDy.set("chgrecord", (Object)recordId);
        logDy.set("errorlog", (Object)error);
        logDy.set("rtparams", (Object)returnParam);
        logDy.set("transactionstatus", (Object)transactionStatus);
        logDy.set("billno", (Object)chgRecordExecutor.getBillNo());
        logDy.set("chgaction", (Object)chgRecordExecutor.getActionId());
        logHelper.saveOne(logDy);
    }

    public static void updateLog(ChgExternalRecordDto chgExternalRecordDto, String error, Long recordId, String returnParam, String transactionStatus) {
        DynamicObject logDy = logHelper.queryOne((Object)LOG_ID_THREAD_LOCAL.get());
        logDy.set("chgrecord", (Object)recordId);
        logDy.set("errorlog", (Object)error);
        logDy.set("rtparams", (Object)returnParam);
        logDy.set("transactionstatus", (Object)transactionStatus);
        logDy.set("chgaction", (Object)chgExternalRecordDto.getActionId());
        logDy.set("billsource", (Object)chgExternalRecordDto.getBillSource());
        logDy.set("billno", (Object)chgExternalRecordDto.getBillNo());
        logHelper.saveOne(logDy);
    }

    public static DynamicObject[] queryChgLog(String consumer, String status) {
        QFilter consumerFilter = new QFilter("consumer", "=", (Object)consumer);
        QFilter statusFilter = new QFilter("transactionstatus", "=", (Object)status);
        return logHelper.query(SELECT_PROPERTIES_CONSUME, new QFilter[]{consumerFilter, statusFilter});
    }

    public static void save(DynamicObject chgLog) {
        logHelper.saveOne(chgLog);
    }

    public static void save(DynamicObject[] chgLogs) {
        logHelper.save(chgLogs);
    }

    public static DynamicObject[] queryChgLog(String status) {
        QFilter statusFilter = new QFilter("transactionstatus", "=", (Object)status);
        return logHelper.query(SELECT_PROPERTIES_CONSUME, new QFilter[]{statusFilter});
    }
}

