/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hpfs.business.perchg.config.chgaction;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.cache.HRAppCache;

public class ChgConfigQueryService {
    private static ChgConfigQueryService chgActionService = new ChgConfigQueryService();

    public static ChgConfigQueryService getInstance() {
        return chgActionService;
    }

    public Map<Long, DynamicObject> getChgRule(List<Long> actionIdList) {
        Map<Long, DynamicObject> result = this.getRuleFromDB(actionIdList);
        HashMap<String, String> dataMap = new HashMap<String, String>(result.size());
        for (Map.Entry<Long, DynamicObject> dyEntry : result.entrySet()) {
            DynamicObject dy = dyEntry.getValue();
            String serialize = DynamicObjectSerializeUtil.serialize((Object[])new Object[]{dy}, (DynamicObjectType)dy.getDynamicObjectType());
            dataMap.put(String.valueOf(dyEntry.getKey()), serialize);
        }
        HRAppCache.get((String)"hpfs").put("hpfs_chgrule", dataMap);
        return result;
    }

    private Map<Long, DynamicObject> getRuleFromDB(List<Long> actionIdList) {
        HRBaseServiceHelper chgActionHelper = new HRBaseServiceHelper("hpfs_chgrule");
        DynamicObject[] allDys = chgActionHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("chgaction", "in", actionIdList), new QFilter("enable", "=", (Object)"1")});
        return Arrays.stream(allDys).collect(Collectors.toMap(dy -> dy.getDynamicObject("chgaction").getLong("id"), dy -> dy));
    }

    public Map<Long, DynamicObject> getChgActionByrule(Map<Long, DynamicObject> chgRuleCache) {
        HashMap chgActionCache = Maps.newHashMapWithExpectedSize((int)chgRuleCache.size());
        for (Map.Entry<Long, DynamicObject> chgRuleEntry : chgRuleCache.entrySet()) {
            DynamicObject chgRuleDy = chgRuleEntry.getValue();
            DynamicObject chgActionDy = chgRuleDy.getDynamicObject("chgaction");
            chgActionCache.put(chgRuleEntry.getKey(), chgActionDy);
        }
        HRAppCache.get((String)"hpfs").put("hpfs_chgaction", (Object)chgActionCache);
        return chgActionCache;
    }
}

