/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hpfs.business.perchg.crossvalidate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hpfs.business.domain.repository.perchg.ChgCrossValidRepository;
import kd.hr.hpfs.business.perchg.crossvalidate.enums.ValidateOrgEnum;
import kd.hr.hpfs.business.perchg.crossvalidate.model.CrossBillResDto;
import kd.hr.hpfs.business.perchg.crossvalidate.model.CrossValidateParamDto;
import kd.hr.hpfs.business.perchg.crossvalidate.model.CrossValidateResDto;
import kd.hr.hpfs.business.perchg.executor.enums.ChgRecordStatusEnum;
import kd.hr.hpfs.business.utils.ChgApiDataReturnUtils;
import kd.hr.hpfs.common.constants.PerModelConstants;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class ChgCrossValidateService
implements PerModelConstants {
    public static final ChgCrossValidateService CHG_CROSS_VALIDATE_SERVICE = new ChgCrossValidateService();
    private static final Log LOGGER = LogFactory.getLog(ChgCrossValidateService.class);

    public static ChgCrossValidateService getInstance() {
        return CHG_CROSS_VALIDATE_SERVICE;
    }

    public Map<String, Object> crossValidate(Map<String, Object> params) {
        LOGGER.info("CHG_HPFS_INFO.ChgCrossValidateService.crossValidate params:" + SerializationUtils.toJsonString(params));
        List<Object> data = new ArrayList();
        try {
            CrossValidateParamDto crossValidateParam = CrossValidateParamDto.format(params);
            String errorMsg = this.validate(crossValidateParam);
            if (!StringUtils.isEmpty((Object)errorMsg)) {
                return ChgApiDataReturnUtils.formatDataReturned(false, errorMsg, data);
            }
            data = this.crossValidateExecute(crossValidateParam);
            LOGGER.info("CHG_HPFS_INFO.ChgCrossValidateService.crossValidate res:" + SerializationUtils.toJsonString(data));
            return ChgApiDataReturnUtils.formatDataReturned(true, null, data);
        }
        catch (Exception e) {
            String errorInfo = String.format(Locale.ROOT, "CHG_HPFS_ERROR crossValidate params :%s", SerializationUtils.toJsonString(params));
            LOGGER.error(errorInfo, (Throwable)e);
            String errorMsg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u4e8b\u52a1\u53d8\u52a8\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u8f93\u5165\u5185\u5bb9\u3002", (String)"ChgCrossValidateService_3", (String)"hr-hpfs-business", (Object[])new Object[0]), ExceptionUtils.getStackTrace((Throwable)e));
            return ChgApiDataReturnUtils.formatDataReturned(false, errorMsg, data);
        }
    }

    public Map<String, Object> crossValidateBatch(List<Map<String, Object>> paramList) {
        LOGGER.info("CHG_HPFS_INFO.ChgCrossValidateService.crossValidateBatch params:" + SerializationUtils.toJsonString(paramList));
        try {
            HashMap errorMap = new HashMap(16);
            List<CrossValidateParamDto> crossValidateParamList = paramList.stream().map(CrossValidateParamDto::format).filter(row -> {
                String errorMsg = this.validate((CrossValidateParamDto)row);
                if (HRStringUtils.isEmpty((String)errorMsg)) {
                    return true;
                }
                errorMap.put(row.getDepEmpId(), errorMsg);
                return false;
            }).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(crossValidateParamList)) {
                return ChgApiDataReturnUtils.formatDataReturned(true, errorMap, Collections.emptyMap());
            }
            Map<Long, List<Map<String, String>>> data = this.crossValidateBatchExecute(crossValidateParamList);
            LOGGER.info("CHG_HPFS_INFO.ChgCrossValidateService.crossValidateBatch res:" + SerializationUtils.toJsonString(data));
            return ChgApiDataReturnUtils.formatDataReturned(true, errorMap, data);
        }
        catch (Exception e) {
            String errorInfo = "CHG_HPFS_ERROR crossValidateBatch paramList:" + SerializationUtils.toJsonString(paramList);
            LOGGER.error(errorInfo, (Throwable)e);
            String errorMsg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u4e8b\u52a1\u53d8\u52a8\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u8f93\u5165\u5185\u5bb9\u3002", (String)"ChgCrossValidateService_3", (String)"hr-hpfs-business", (Object[])new Object[0]), ExceptionUtils.getStackTrace((Throwable)e));
            return ChgApiDataReturnUtils.formatDataReturned(false, errorMsg, null);
        }
    }

    public Map<String, Object> getCrossValidateBills(Map<String, Object> params) {
        List<Object> data = new ArrayList();
        try {
            CrossValidateParamDto crossValidateParam = CrossValidateParamDto.format(params);
            String errorMsg = this.validate(crossValidateParam);
            if (!StringUtils.isEmpty((Object)errorMsg)) {
                return ChgApiDataReturnUtils.formatDataReturned(false, errorMsg, data);
            }
            data = this.getCrossBills(crossValidateParam);
            return ChgApiDataReturnUtils.formatDataReturned(true, null, data);
        }
        catch (Exception e) {
            LOGGER.error("CHG_HPFS_ERROR getCrossValidateBills billId :{} billSource :{}", new Object[]{params.get("billId"), params.get("billSource"), e});
            String errorMsg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u4e8b\u52a1\u53d8\u52a8\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u8f93\u5165\u5185\u5bb9\u3002", (String)"ChgCrossValidateService_3", (String)"hr-hpfs-business", (Object[])new Object[0]), e.getMessage());
            return ChgApiDataReturnUtils.formatDataReturned(false, errorMsg, data);
        }
    }

    private List<Map<String, String>> getCrossBills(CrossValidateParamDto crossValidateParam) {
        Long employeeId = Long.parseLong(crossValidateParam.getEmployeeId());
        ArrayList<Map<String, String>> res = new ArrayList<Map<String, String>>();
        List<DynamicObject> records = this.getRecord(Collections.singletonList(employeeId)).get(employeeId);
        if (CollectionUtils.isEmpty(records)) {
            return res;
        }
        records.forEach(record -> res.add((Map<String, String>)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString((Object)CrossBillResDto.format(record)), Map.class)));
        return res;
    }

    private Map<Long, List<Map<String, String>>> crossValidateBatchExecute(List<CrossValidateParamDto> crossValidateParamList) {
        HashMap<Long, List<Map<String, String>>> res = new HashMap<Long, List<Map<String, String>>>(crossValidateParamList.size());
        List<Long> employeeIds = crossValidateParamList.stream().map(row -> Long.parseLong(row.getEmployeeId())).distinct().collect(Collectors.toList());
        Map<Long, List<DynamicObject>> recordsMap = this.getRecord(employeeIds);
        Map<Long, List<Long>> employeeActionMap = this.formatEmployeeActionMap(crossValidateParamList);
        Map<Long, Map<Long, Map<Long, List<DynamicObject>>>> validationsMap = this.getCrossValidations(employeeActionMap);
        crossValidateParamList.forEach(crossValidateParam -> this.crossValidateBatchExecuteSingle((CrossValidateParamDto)crossValidateParam, recordsMap, validationsMap, (Map<Long, List<Map<String, String>>>)res));
        return res;
    }

    private void crossValidateBatchExecuteSingle(CrossValidateParamDto crossValidateParam, Map<Long, List<DynamicObject>> recordsMap, Map<Long, Map<Long, Map<Long, List<DynamicObject>>>> validationsMap, Map<Long, List<Map<String, String>>> res) {
        Long employeeId = Long.parseLong(crossValidateParam.getEmployeeId());
        Long depEmpId = Long.parseLong(crossValidateParam.getDepEmpId());
        Long chgActionId = Long.parseLong(crossValidateParam.getActionId());
        List<DynamicObject> records = recordsMap.get(employeeId);
        Map<Long, List<DynamicObject>> validations = validationsMap.get(employeeId).get(chgActionId);
        if (CollectionUtils.isEmpty(records) || CollectionUtils.isEmpty(validations)) {
            return;
        }
        ArrayList crossRes = new ArrayList(records.size());
        records.forEach(record -> this.crossValidateExecuteSingle((DynamicObject)record, validations, crossValidateParam, crossRes));
        if (!CollectionUtils.isEmpty(crossRes)) {
            res.computeIfAbsent(depEmpId, list -> new ArrayList()).addAll(crossRes);
        }
    }

    private Map<Long, List<Long>> formatEmployeeActionMap(List<CrossValidateParamDto> crossValidateParamList) {
        return crossValidateParamList.stream().collect(Collectors.groupingBy(CrossValidateParamDto::getEmployeeId)).entrySet().stream().collect(Collectors.toMap(row -> Long.parseLong((String)row.getKey()), row -> ((List)row.getValue()).stream().map(param -> Long.parseLong(param.getActionId())).distinct().collect(Collectors.toList())));
    }

    private List<Map<String, String>> crossValidateExecute(CrossValidateParamDto crossValidateParam) {
        Long employeeId = Long.parseLong(crossValidateParam.getEmployeeId());
        Long chgActionId = Long.parseLong(crossValidateParam.getActionId());
        ArrayList<Map<String, String>> res = new ArrayList<Map<String, String>>();
        List<DynamicObject> records = this.getRecord(Collections.singletonList(employeeId)).get(employeeId);
        HashMap<Long, List<Long>> employeeActionMap = new HashMap<Long, List<Long>>(1);
        employeeActionMap.put(employeeId, Collections.singletonList(Long.parseLong(crossValidateParam.getActionId())));
        if (CollectionUtils.isEmpty(records)) {
            return res;
        }
        Map<Long, List<DynamicObject>> validationMap = this.getCrossValidations(employeeActionMap).get(employeeId).get(chgActionId);
        for (DynamicObject record : records) {
            this.crossValidateExecuteSingle(record, validationMap, crossValidateParam, res);
        }
        return res;
    }

    private void crossValidateExecuteSingle(DynamicObject record, Map<Long, List<DynamicObject>> validationMap, CrossValidateParamDto crossValidateParam, List<Map<String, String>> res) {
        DynamicObject depEmpIdEntry;
        String dataStatus;
        Long committedActionId = record.getLong("chgaction.id");
        List<DynamicObject> valids = validationMap.get(committedActionId);
        if (CollectionUtils.isEmpty(valids)) {
            String warnInfo = String.format(Locale.ROOT, "CHG_WARN crossValidateExecuteSingle valid_without_rules crossValidateParam :%s", SerializationUtils.toJsonString((Object)crossValidateParam));
            LOGGER.warn(warnInfo);
            return;
        }
        String condition = this.getTimeCompareRes(record, crossValidateParam.getEffectTime());
        DynamicObject validRule = valids.stream().filter(row -> HRStringUtils.equals((String)row.getString("condition"), (String)condition)).findAny().orElse(null);
        if (validRule == null) {
            String warnInfo = String.format(Locale.ROOT, "CHG_WARN crossValidateExecuteSingle valid_without_condition_rule crossValidateParam: %s", SerializationUtils.toJsonString((Object)crossValidateParam));
            LOGGER.warn(warnInfo);
            return;
        }
        List<String> statusList = Arrays.asList(validRule.getString("crossstatus").split(","));
        if (!statusList.contains(dataStatus = record.getString("datastatus"))) {
            String warnInfo = String.format(Locale.ROOT, "CHG_WARN crossValidateExecuteSingle record_status %s not_existed_rule crossValidateParam :%s", dataStatus, SerializationUtils.toJsonString((Object)crossValidateParam));
            LOGGER.warn(warnInfo);
            return;
        }
        String orgValidType = validRule.getString("orgrelvalidtype");
        if (HRStringUtils.equals((String)orgValidType, (String)ValidateOrgEnum.VALIDATE_APPOINTED_ORG.getCode()) && (depEmpIdEntry = (DynamicObject)record.getDynamicObjectCollection("entryentity").stream().filter(row -> HRStringUtils.equals((String)row.getString("chgentity.number"), (String)"hrpi_depemp") && HRStringUtils.equals((String)String.valueOf(row.getLong("idbefore")), (String)crossValidateParam.getDepEmpId())).findAny().orElse(null)) == null) {
            String warnInfo = String.format(Locale.ROOT, "CHG_WARN crossValidateExecuteSingle valid_on_org_without_equaled_depEmpId crossValidateParam : %s", SerializationUtils.toJsonString((Object)crossValidateParam));
            LOGGER.warn(warnInfo);
            return;
        }
        CrossValidateResDto crossValidateRes = CrossValidateResDto.format(record, validRule, crossValidateParam);
        res.add((Map<String, String>)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString((Object)crossValidateRes), Map.class));
    }

    private String getTimeCompareRes(DynamicObject record, Long uncommittedTime) {
        Date committedTime = record.getDate("effecttime");
        Long committedStamp = committedTime.getTime();
        if (uncommittedTime > committedStamp) {
            return "1";
        }
        return "0";
    }

    private String validate(CrossValidateParamDto crossValidateParam) {
        String errorMsg = "";
        if (StringUtils.isEmpty((Object)crossValidateParam.getEmployeeId()) || Long.parseLong(crossValidateParam.getEmployeeId()) == 0L) {
            errorMsg = String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u4f01\u4e1a\u4eba\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ChgCrossValidateService_1", (String)"hr-hpfs-business", (Object[])new Object[0]), errorMsg);
        }
        return errorMsg;
    }

    private Map<Long, Map<Long, Map<Long, List<DynamicObject>>>> getCrossValidations(Map<Long, List<Long>> employeeActionMap) {
        List actionIdsAll = employeeActionMap.values().stream().flatMap(Collection::stream).distinct().collect(Collectors.toList());
        QFilter uncommitted = new QFilter("uncommittedtrans", "in", actionIdsAll).and(new QFilter("enable", "=", (Object)"1"));
        DynamicObject[] validations = ChgCrossValidRepository.query(new QFilter[]{uncommitted});
        Map<Long, Map> actionValidationMap = Arrays.stream(validations).collect(Collectors.groupingBy(row -> row.getLong("uncommittedtrans.id"))).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, row -> ((List)row.getValue()).stream().collect(Collectors.groupingBy(record -> record.getLong("committedtrans.id")))));
        ArrayList<Long> employees = new ArrayList<Long>(employeeActionMap.keySet());
        return employees.stream().collect(Collectors.toMap(row -> row, row -> {
            List actionIds = (List)employeeActionMap.get(row);
            if (CollectionUtils.isEmpty((Collection)actionIds)) {
                return Collections.emptyMap();
            }
            return actionIds.stream().collect(Collectors.toMap(action -> action, action -> actionValidationMap.get(action) == null ? Collections.emptyMap() : (Map)actionValidationMap.get(action)));
        }));
    }

    private Map<Long, List<DynamicObject>> getRecord(List<Long> employeeIds) {
        HRBaseServiceHelper recordHelper = new HRBaseServiceHelper("hpfs_chgrecord");
        Map<Long, List<Long>> recordEntryMap = this.getRecordEntry(employeeIds);
        List recordIds = recordEntryMap.values().stream().flatMap(Collection::stream).distinct().collect(Collectors.toList());
        DynamicObject[] records = recordHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", recordIds), new QFilter("datastatus", "in", Arrays.asList(ChgRecordStatusEnum.SUBMITTED.getCode(), ChgRecordStatusEnum.TO_EFFECT.getCode()))});
        if (records == null || records.length == 0) {
            return Collections.emptyMap();
        }
        Map<Long, DynamicObject> recordMap = Arrays.stream(records).collect(Collectors.toMap(row -> row.getLong("id"), row -> row));
        return recordEntryMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, row -> ((List)row.getValue()).stream().map(recordMap::get).filter(Objects::nonNull).collect(Collectors.toList())));
    }

    private Map<Long, List<Long>> getRecordEntry(List<Long> employeeIds) {
        HRBaseServiceHelper recordEntryHelper = new HRBaseServiceHelper("hpfs_chgrecordentry");
        Map<Long, List<Long>> employeeIdsByMidMap = this.getEmployeeIdsByMid(employeeIds);
        List employeesByMid = employeeIdsByMidMap.values().stream().flatMap(Collection::stream).distinct().collect(Collectors.toList());
        QFilter filter = new QFilter("chgentity", "=", (Object)"hrpi_employee").and(new QFilter("idbefore", "in", employeesByMid));
        DynamicObject[] recordEntry = recordEntryHelper.queryOriginalArray("chgrecord, idbefore", new QFilter[]{filter});
        if (recordEntry == null || recordEntry.length == 0) {
            return Collections.emptyMap();
        }
        Map<Long, List> recordEntryMap = Arrays.stream(recordEntry).collect(Collectors.groupingBy(row -> row.getLong("idbefore"))).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, row -> ((List)row.getValue()).stream().map(entry -> entry.getLong("chgrecord")).collect(Collectors.toList())));
        HashMap<Long, List<Long>> employeeRecordMap = new HashMap<Long, List<Long>>(employeeIds.size());
        employeeIds.forEach(row -> {
            List employeeIdsByMid = (List)employeeIdsByMidMap.get(row);
            if (employeeIdsByMid == null) {
                String warnInfo = String.format(Locale.ROOT, "CHG_WARN getRecordEntry employeeIdsByMid is null. employeeId : %s", row);
                LOGGER.warn(warnInfo);
                return;
            }
            ArrayList recordIds = new ArrayList(16);
            employeeIdsByMid.forEach(employeeId -> {
                if (recordEntryMap.get(employeeId) != null) {
                    recordIds.addAll((Collection)recordEntryMap.get(employeeId));
                }
            });
            if (!CollectionUtils.isEmpty(recordIds)) {
                employeeRecordMap.put((Long)row, recordIds);
            }
        });
        return employeeRecordMap;
    }

    private Map<Long, List<Long>> getEmployeeIdsByMid(List<Long> employeeIds) {
        HRBaseServiceHelper employeeHelper = new HRBaseServiceHelper("hrpi_employee");
        DynamicObject[] employees = employeeHelper.queryOriginalArray("id,mid", new QFilter[]{new QFilter("id", "in", employeeIds)});
        if (employees == null || employees.length == 0) {
            return employeeIds.stream().collect(Collectors.toMap(row -> row, Collections::singletonList));
        }
        Map<Long, Long> employeeMidMap = Arrays.stream(employees).collect(Collectors.toMap(row -> row.getLong("id"), row -> row.getLong("mid")));
        List mids = Arrays.stream(employees).map(row -> row.getLong("mid")).distinct().collect(Collectors.toList());
        DynamicObject[] employeeListByMid = employeeHelper.query("id,boid,mid", new QFilter[]{new QFilter("mid", "in", mids), new QFilter("iscurrentversion", "=", (Object)"1")});
        if (employeeListByMid == null || employeeListByMid.length == 0) {
            return employeeIds.stream().collect(Collectors.toMap(row -> row, Collections::singletonList));
        }
        Map<Long, List> midEmployeeIdsMap = Arrays.stream(employeeListByMid).collect(Collectors.groupingBy(row -> row.getLong("mid"))).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, row -> ((List)row.getValue()).stream().map(value -> value.getLong("boid")).collect(Collectors.toList())));
        return employeeIds.stream().collect(Collectors.toMap(row -> row, row -> {
            List<Long> employeeIdsByMid = (List<Long>)midEmployeeIdsMap.get(employeeMidMap.get(row));
            return CollectionUtils.isEmpty((Collection)employeeIdsByMid) ? Collections.singletonList(row) : employeeIdsByMid;
        }));
    }
}

