/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hpfs.business.perchg.executor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.util.ExceptionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRBaseUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hpfs.business.perchg.common.ChgLogHelper;
import kd.hr.hpfs.business.perchg.config.ConfigService;
import kd.hr.hpfs.business.perchg.executor.chgtype.ChgTypeIndividuation;
import kd.hr.hpfs.business.perchg.executor.service.ChgLogEntryService;
import kd.hr.hpfs.business.perchg.executor.service.ExecutorDataFormatService;
import kd.hr.hpfs.business.perchg.executor.service.HRPISaveService;
import kd.hr.hpfs.business.perchg.executor.service.HRPIValidateFormattedDataService;
import kd.hr.hpfs.business.perchg.executor.service.InitDataQueryService;
import kd.hr.hpfs.business.perchg.executor.util.PerChgUtils;
import kd.hr.hpfs.business.perchg.parser.EntityParserFactory;
import kd.hr.hpfs.business.perchg.parser.Parser;
import kd.hr.hpfs.business.perchg.parser.ParserResult;
import kd.hr.hpfs.business.perchg.parser.util.ParserUtil;
import kd.hr.hpfs.business.perchg.service.IAfterDataQueryPluginService;
import kd.hr.hpfs.business.perchg.service.IAfterDataSavedPluginService;
import kd.hr.hpfs.business.service.ChgPluginService;
import kd.hr.hpfs.business.service.ChgRecordService;
import kd.hr.hpfs.business.service.cert.HRCertServiceHelper;
import kd.hr.hpfs.business.service.relatiolservice.ChangePersonRelService;
import kd.hr.hpfs.common.constants.ChgStrategyConstants;
import kd.hr.hpfs.common.constants.PerModelConstants;
import kd.hr.hpfs.common.enums.ChgPluginOccasionEnum;
import kd.hr.hpfs.common.model.ChangeModel;
import kd.hr.hpfs.common.perchg.PerChgBizOperateType;
import kd.sdk.hr.hpfs.business.perchg.bizentity.PerChgBizInfo;
import kd.sdk.hr.hpfs.business.perchg.bizentity.PerChgBizResult;
import kd.sdk.hr.hpfs.business.perchg.executor.enums.ChgFlowTypeEnum;
import kd.sdk.hr.hpfs.business.perchg.executor.enums.ChgModeEnum;
import kd.sdk.hr.hpfs.business.perchg.executor.model.ChgRecordEntryDto;
import kd.sdk.hr.hpfs.common.constants.ChgConstants;
import kd.sdk.hr.hpfs.common.perchg.PerChgConstants;

public class ExecutorService
extends EntityParserFactory
implements PerModelConstants,
ChgConstants,
ChgStrategyConstants,
PerChgConstants {
    private static final Log LOGGER = LogFactory.getLog(ExecutorService.class);
    private static final ExecutorService EXECUTORSERVICE = new ExecutorService();

    public static ExecutorService getInstance() {
        return EXECUTORSERVICE;
    }

    public PerChgBizResult executeSingle(PerChgBizInfo bizInfo, PerChgBizOperateType operateType, Map<String, Object> config, Map<String, List<DynamicObject>> sourceData) {
        ConfigService configService = ConfigService.getInstance();
        DynamicObject chgActionInfo = configService.getChgActionByBizInfo(bizInfo, config);
        DynamicObject chgRuleInfo = configService.getChgRuleByBizInfo(bizInfo, config);
        DynamicObject chgGuideBase = (DynamicObject)config.get("chgGuideBase");
        return this.executeSingle(bizInfo, operateType, sourceData, chgActionInfo, chgRuleInfo, chgGuideBase);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PerChgBizResult executeSingle(PerChgBizInfo bizInfo, PerChgBizOperateType operateType, Map<String, List<DynamicObject>> sourceData, DynamicObject chgActionInfo, DynamicObject chgRuleInfo, DynamicObject chgGuideBase) {
        PerChgBizResult bizResult;
        try {
            this.generateId(bizInfo);
            this.performPluginAfterQuery(sourceData, bizInfo, chgGuideBase, ChgPluginOccasionEnum.AFTER_DATA_QUERIED.getCode());
            List<ParserResult> parserResults = this.formatParseResult(sourceData, chgRuleInfo, bizInfo);
            ChgPluginService.getInstance().performPlugin(parserResults, bizInfo, sourceData, chgActionInfo, chgRuleInfo, chgGuideBase, ChgPluginOccasionEnum.AFTER_DATA_FORMATTED.getCode());
            bizResult = this.executeDB(parserResults, operateType, bizInfo);
            new InitDataQueryService().quitAndUpdPerserLen(bizInfo);
            HRCertServiceHelper.licenseExcute(bizInfo, parserResults, sourceData);
            this.wrapBizResultByChgConfig(bizResult, chgActionInfo);
            ChgTypeIndividuation.getInstance().execute(bizResult, bizInfo, operateType, chgActionInfo, parserResults);
            this.performPluginAfterSave(bizResult, bizInfo, operateType, chgActionInfo, parserResults, chgGuideBase, ChgPluginOccasionEnum.AFTER_DATA_SAVED.getCode());
            ChgLogHelper.updateLogResult(bizInfo, bizResult, "1");
        }
        catch (RuntimeException e) {
            LOGGER.error("*****PerChg Found Error***** : ", (Throwable)e);
            bizResult = PerChgBizResult.fail((Long)bizInfo.getBillId(), (String)bizInfo.getBillSource(), (String)ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            ChgLogHelper.updateLogResult(bizInfo, bizResult, "-1");
        }
        finally {
            ChgTypeIndividuation.THREAD_LOCAL_PREEMPLOYEEMODEL.remove();
            ChgTypeIndividuation.THREAD_LOCAL_EMPLOYEEMODEL.remove();
        }
        return bizResult;
    }

    private void performPluginAfterQuery(Map<String, List<DynamicObject>> sourceData, PerChgBizInfo bizInfo, DynamicObject chgGuideBase, String occasion) {
        DynamicObjectCollection pluginCollection = chgGuideBase.getDynamicObjectCollection("entryentity");
        pluginCollection.stream().filter(row -> HRStringUtils.equals((String)occasion, (String)row.getString("plugin.occasion"))).sorted(Comparator.comparing(row -> row.getInt("seq"))).forEach(plugin -> {
            block2: {
                bizInfo.addPluginEntry(plugin);
                String className = plugin.getString("plugin.pluginpath");
                boolean interrupted = plugin.getBoolean("isinterrupted");
                String pluginNumber = plugin.getString("plugin.number");
                try {
                    Class<?> pluginClass = Class.forName(className);
                    DynamicObjectCollection collection = plugin.getDynamicObjectCollection("subentryentity");
                    HashMap<String, String> paramMap = new HashMap<String, String>();
                    collection.forEach(row -> paramMap.put(row.getString("param"), row.getString("value")));
                    IAfterDataQueryPluginService dataQueryPluginService = (IAfterDataQueryPluginService)pluginClass.newInstance();
                    dataQueryPluginService.formatSourceData(sourceData, bizInfo, paramMap);
                    bizInfo.putPluginResMap(pluginNumber, "");
                }
                catch (Exception e) {
                    LOGGER.error("IAfterDataFormatPluginService plugin error", (Throwable)e);
                    bizInfo.putPluginResMap(pluginNumber, e.getMessage());
                    if (!interrupted) break block2;
                    throw new KDException(new ErrorCode("IAfterDataFormatPluginService error", e.getMessage()), new Object[]{e});
                }
            }
        });
    }

    private void performPluginAfterSave(PerChgBizResult bizResult, PerChgBizInfo bizInfo, PerChgBizOperateType operateType, DynamicObject chgActionInfo, List<ParserResult> parserResults, DynamicObject chgGuideBase, String occasion) {
        DynamicObjectCollection pluginCollection = chgGuideBase.getDynamicObjectCollection("entryentity");
        pluginCollection.stream().filter(row -> HRStringUtils.equals((String)occasion, (String)row.getString("plugin.occasion"))).sorted(Comparator.comparing(row -> row.getInt("seq"))).forEach(plugin -> {
            block2: {
                boolean interrupted = plugin.getBoolean("isinterrupted");
                String pluginNumber = plugin.getString("plugin.number");
                try {
                    bizInfo.addPluginEntry(plugin);
                    String className = plugin.getString("plugin.pluginpath");
                    DynamicObjectCollection collection = plugin.getDynamicObjectCollection("subentryentity");
                    HashMap<String, String> paramMap = new HashMap<String, String>();
                    collection.forEach(row -> paramMap.put(row.getString("param"), row.getString("value")));
                    Class<?> pluginClass = Class.forName(className);
                    IAfterDataSavedPluginService savedPluginService = (IAfterDataSavedPluginService)pluginClass.newInstance();
                    savedPluginService.afterDataSaved(bizResult, bizInfo, operateType, chgActionInfo, parserResults, paramMap);
                    bizInfo.putPluginResMap(pluginNumber, "");
                }
                catch (Exception e) {
                    LOGGER.error("IAfterDataSavedPluginService plugin error", (Throwable)e);
                    bizInfo.putPluginResMap(pluginNumber, e.getMessage());
                    if (!interrupted) break block2;
                    throw new KDException(new ErrorCode("IAfterDataSavedPluginService error", e.getMessage()), new Object[]{e});
                }
            }
        });
    }

    private void wrapBizResultByChgConfig(PerChgBizResult bizResult, DynamicObject chgActionInfo) {
        bizResult.setMsgSynActionId(Long.valueOf(chgActionInfo.getLong("action_id")));
    }

    private void generateId(PerChgBizInfo bizInfo) {
        bizInfo.setEventId(Long.valueOf(ORM.create().genLongId("hrpi_event")));
        bizInfo.setOldErfileId(Long.valueOf(0L));
        bizInfo.setEventEntity("hrpi_event");
    }

    private List<ParserResult> formatParseResult(Map<String, List<DynamicObject>> sourceData, DynamicObject chgRuleInfo, PerChgBizInfo bizInfo) {
        DynamicObjectCollection ruleConfigs = chgRuleInfo.getDynamicObjectCollection("customentryentity");
        Map<DynamicObject, List<DynamicObject>> ruleConfigMap = ruleConfigs.stream().collect(Collectors.groupingBy(row -> row.getDynamicObject("chgtactic")));
        ArrayList<DynamicObject> tactics = new ArrayList<DynamicObject>(ruleConfigMap.keySet());
        tactics.sort(Comparator.comparingInt(tactic -> tactic.getInt("index")));
        ArrayList<ParserResult> results = new ArrayList<ParserResult>(16);
        Map<String, Object> workRoleMap = this.getWorkRoleValueMap(ruleConfigs, sourceData, ruleConfigMap);
        this.filterTactics(bizInfo, tactics, sourceData);
        tactics.forEach(tactic -> {
            DynamicObject chgObject = tactic.getDynamicObject("chgobject");
            List configList = (List)ruleConfigMap.get(tactic);
            String chgMode = tactic.getString("chgmode");
            DynamicObject mappingPlan = null;
            Optional<DynamicObject> mappingConfig = configList.stream().filter(dy -> !Objects.isNull(dy.getDynamicObject("filemapping"))).findFirst();
            if (mappingConfig.isPresent()) {
                mappingPlan = mappingConfig.get().getDynamicObject("filemapping");
            }
            ArrayList<ParserResult> tacticResult = new ArrayList<ParserResult>();
            if (Objects.isNull(chgObject)) {
                if (mappingPlan != null) {
                    this.formatMappingResult(sourceData, chgRuleInfo, tacticResult, bizInfo, mappingPlan, chgMode, tactic.getLong("id"));
                }
            } else {
                String targetTable = chgObject.getString("number");
                if (HRStringUtils.equals((String)targetTable, (String)"hrpi_personrolerel")) {
                    return;
                }
                if (mappingPlan != null) {
                    this.formatMappingResult(sourceData, chgRuleInfo, tacticResult, bizInfo, mappingPlan, chgMode, tactic.getLong("id"));
                }
                this.formatRuleConfigResult((List<ParserResult>)tacticResult, configList, sourceData, (DynamicObject)tactic, bizInfo, chgMode, workRoleMap, tactic.getLong("id"));
            }
            if (PerChgUtils.isReemployment(bizInfo)) {
                this.formatFirstjoincomdate(tacticResult, sourceData);
            }
            tacticResult.forEach(result -> this.setSysDateAndEnddate((ParserResult)result, chgMode));
            if (!CollectionUtils.isEmpty(tacticResult)) {
                ChgLogEntryService.getInstance().formatLogEntry(tactic.getLong("id"), bizInfo, tacticResult);
                results.addAll(tacticResult);
            }
        });
        this.updateIdsRecord(bizInfo, sourceData);
        return results;
    }

    private void filterTactics(PerChgBizInfo bizInfo, List<DynamicObject> tactics, Map<String, List<DynamicObject>> sourceData) {
        if (bizInfo.getChgEventId() == 1010L) {
            this.specialFilterOnbrdTactics(bizInfo, tactics, sourceData);
        }
        if (PerChgUtils.skipCreateNewPerson(bizInfo)) {
            tactics.removeIf(tactic -> 1010L == tactic.getLong("id"));
        }
    }

    private void specialFilterOnbrdTactics(PerChgBizInfo bizInfo, List<DynamicObject> tactics, Map<String, List<DynamicObject>> sourceData) {
        DynamicObject billSource;
        DataEntityPropertyCollection properties;
        List<DynamicObject> billSources = sourceData.get(bizInfo.getBillSource());
        if (Objects.nonNull(billSources) && billSources.size() > 0 && (!(properties = (billSource = billSources.get(0)).getDataEntityType().getProperties()).containsKey((Object)"iscadre") || HRStringUtils.equals((String)"0", (String)billSource.getString("iscadre")) || HRStringUtils.equals((String)"false", (String)billSource.getString("iscadre")))) {
            tactics.removeIf(tactic -> 2680L == tactic.getLong("id") || 2700L == tactic.getLong("id"));
        }
    }

    private void setSysDateAndEnddate(ParserResult parseresult, String chgMode) {
        DynamicObject dyn = (DynamicObject)parseresult.getParserParam().get("hisDy");
        DataEntityPropertyCollection collection = dyn.getDataEntityType().getProperties();
        if (collection.get((Object)"sysenddate") != null && collection.get((Object)"enddate") != null) {
            if (HRStringUtils.equals((String)chgMode, (String)"0") && Objects.nonNull(dyn.getDate("sysenddate"))) {
                dyn.set("enddate", (Object)dyn.getDate("sysenddate"));
            } else {
                Date endDate = dyn.getDate("enddate");
                Date sysEndDate = dyn.getDate("sysenddate");
                if (Objects.nonNull(sysEndDate) && Objects.nonNull(endDate) && sysEndDate.getTime() == HRBaseUtils.getMaxEndDate().getTime() && endDate.getTime() != HRBaseUtils.getMaxEndDate().getTime()) {
                    dyn.set("sysenddate", (Object)HRDateTimeUtils.addDay((Date)endDate, (long)1L));
                } else if (Objects.nonNull(sysEndDate)) {
                    dyn.set("enddate", (Object)HRDateTimeUtils.addDay((Date)sysEndDate, (long)-1L));
                }
            }
        }
        if (collection.get((Object)"startdate") != null && collection.get((Object)"enddate") != null && Objects.nonNull(dyn.getDate("startdate")) && Objects.nonNull(dyn.getDate("enddate")) && HRDateTimeUtils.dayAfter((Date)dyn.getDate("startdate"), (Date)dyn.getDate("enddate"))) {
            dyn.set("enddate", (Object)dyn.getDate("startdate"));
        }
    }

    private Map<String, Object> getWorkRoleValueMap(DynamicObjectCollection ruleConfigs, Map<String, List<DynamicObject>> sourceData, Map<DynamicObject, List<DynamicObject>> ruleConfigMap) {
        HashMap<String, Object> workRoleValueMap = new HashMap<String, Object>();
        DynamicObject workRoleMappingTable = this.getWorkRoleMappingPlan(ruleConfigs);
        if (workRoleMappingTable != null) {
            return this.getValueFromMapping(workRoleMappingTable, sourceData);
        }
        DynamicObject workRoleTactic = ruleConfigMap.keySet().stream().filter(row -> row.get("chgobject") != null && HRStringUtils.equals((String)row.getDynamicObject("chgobject").getString("number"), (String)"hrpi_personrolerel")).findFirst().orElse(null);
        if (workRoleTactic == null) {
            return workRoleValueMap;
        }
        List<DynamicObject> workRuleConfigs = ruleConfigMap.get(workRoleTactic);
        DynamicObject roleConfig = workRuleConfigs.stream().filter(row -> HRStringUtils.equals((String)row.getString("chgfile"), (String)"role")).findFirst().orElse(null);
        if (Objects.isNull(roleConfig)) {
            return workRoleValueMap;
        }
        Object role = this.getWorkRoleValue(roleConfig, sourceData);
        workRoleValueMap.put("role", role);
        DynamicObject specialConfig = workRuleConfigs.stream().filter(row -> HRStringUtils.equals((String)row.getString("chgfile"), (String)"special")).findFirst().orElse(null);
        if (Objects.isNull(specialConfig)) {
            workRoleValueMap.put("special", "0");
            return workRoleValueMap;
        }
        Object leaderType = this.getWorkRoleValue(specialConfig, sourceData);
        workRoleValueMap.put("special", leaderType);
        return workRoleValueMap;
    }

    private Object getWorkRoleValue(DynamicObject config, Map<String, List<DynamicObject>> sourceData) {
        String entitySource = config.getString("entitysource");
        String fieldSource = config.getString("fieldsource");
        if (HRStringUtils.isEmpty((String)entitySource) || HRStringUtils.isEmpty((String)fieldSource)) {
            return null;
        }
        List<DynamicObject> dynamicObjectList = sourceData.get(entitySource);
        if (CollectionUtils.isEmpty(dynamicObjectList)) {
            return null;
        }
        return dynamicObjectList.get(0).get(fieldSource);
    }

    private DynamicObject getWorkRoleMappingPlan(DynamicObjectCollection ruleConfigs) {
        for (DynamicObject ruleConfig : ruleConfigs) {
            DynamicObject tableMapping;
            DynamicObjectCollection tableEntry;
            DynamicObject mappingPlan = ruleConfig.getDynamicObject("filemapping");
            if (mappingPlan == null || CollectionUtils.isEmpty((Collection)(tableEntry = mappingPlan.getDynamicObjectCollection("entryentity"))) || (tableMapping = (DynamicObject)tableEntry.stream().filter(row -> HRStringUtils.equals((String)row.getDynamicObject("targetentity").getString("number"), (String)"hrpi_personrolerel")).findFirst().orElse(null)) == null) continue;
            return tableMapping;
        }
        return null;
    }

    private void formatMappingResult(Map<String, List<DynamicObject>> sourceData, DynamicObject chgRuleInfo, List<ParserResult> parserResults, PerChgBizInfo bizInfo, DynamicObject mappingPlan, String chgMode, long tacticId) {
        this.parserEntity(sourceData, chgRuleInfo, parserResults, bizInfo, mappingPlan, chgMode, tacticId);
    }

    private void formatRuleConfigResult(List<ParserResult> tacticResult, List<DynamicObject> configList, Map<String, List<DynamicObject>> sourceData, DynamicObject tactic, PerChgBizInfo bizInfo, String chgMode, Map<String, Object> workRoleMap, long tacticId) {
        String changeObject = tactic.getString("chgobject_id");
        StringBuilder stringBuilder = new StringBuilder();
        HashMap<String, String> appointedValue2FieldMap = new HashMap<String, String>();
        Map<String, Object> value2FieldMap = this.formatValue2FieldMap(configList, sourceData, changeObject, stringBuilder, appointedValue2FieldMap, bizInfo);
        String appointedSource = stringBuilder.toString();
        this.formatData(tacticResult, changeObject, sourceData, bizInfo, chgMode, workRoleMap, tacticId, appointedSource, appointedValue2FieldMap);
        tacticResult.forEach(result -> {
            DynamicObject dyn = (DynamicObject)result.getParserParam().get("hisDy");
            String dynEntityName = dyn.getDataEntityType().getName();
            DataEntityPropertyCollection collection = dyn.getDataEntityType().getProperties();
            value2FieldMap.entrySet().stream().filter(entry -> HRStringUtils.isNotEmpty((String)((String)entry.getKey())) && collection.get(entry.getKey()) != null).forEach(entry -> {
                if (HRStringUtils.equals((String)dynEntityName, (String)"hrpi_emporgrelall")) {
                    if (entry.getValue() instanceof DynamicObject) {
                        dyn.set((String)entry.getKey(), ((DynamicObject)entry.getValue()).get("name"));
                    } else if (entry.getValue() instanceof Long) {
                        dyn.set((String)entry.getKey(), (Object)String.valueOf(entry.getValue()));
                    }
                } else {
                    dyn.set((String)entry.getKey(), entry.getValue());
                }
            });
        });
        if (changeObject.equals("hrpi_depemp") || changeObject.equals("hrpi_empposorgrel")) {
            ChangePersonRelService.getInstance().doChangePositionByDarkPosition(tacticResult);
        }
        if (changeObject.equals("hrpi_empentrel")) {
            tacticResult.forEach(row -> {
                DynamicObject dyn = (DynamicObject)row.getParserParam().get("hisDy");
                Object status = dyn.get("laborrelstatus");
                DataEntityPropertyCollection properties = dyn.getDynamicObjectType().getProperties();
                if (properties.get((Object)"labrelstatusprd") != null) {
                    dyn.set("labrelstatusprd", this.getLaborStatusProd(status));
                }
            });
        }
    }

    private void formatFirstjoincomdate(List<ParserResult> tacticResult, Map<String, List<DynamicObject>> sourceData) {
        DynamicObject newPersonLenDy = tacticResult.stream().filter(row -> HRStringUtils.equals((String)((String)row.getParserParam().get("entityName")), (String)"hrpi_perserlen")).map(row -> (DynamicObject)row.getParserParam().get("hisDy")).findFirst().orElse(null);
        if (Objects.isNull(newPersonLenDy)) {
            return;
        }
        List<DynamicObject> oldPersonLenDys = sourceData.get("hrpi_perserlen");
        DynamicObject oldPersonLenDy = oldPersonLenDys.stream().filter(dy -> HRStringUtils.equals((String)dy.getString("iscurrentversion"), (String)"1") || HRStringUtils.equals((String)dy.getString("iscurrentversion"), (String)"true")).findFirst().orElse(null);
        if (Objects.nonNull(oldPersonLenDy) && Objects.nonNull(oldPersonLenDy.get("firstjoincomdate")) && Objects.nonNull(newPersonLenDy)) {
            newPersonLenDy.set("firstjoincomdate", oldPersonLenDy.get("firstjoincomdate"));
        }
    }

    private void formatData(List<ParserResult> tacticResult, String changeObject, Map<String, List<DynamicObject>> sourceData, PerChgBizInfo bizInfo, String chgMode, Map<String, Object> workRoleMap, long tacticId, String appointedSource, Map<String, String> appointedValue2FieldMap) {
        switch (changeObject) {
            case "hrpi_empentrel": {
                this.formatEmployee(tacticResult, sourceData, bizInfo, chgMode, tacticId, appointedSource, appointedValue2FieldMap);
                break;
            }
            case "hrpi_empposorgrel": {
                this.formatDepEmp(tacticResult, sourceData, bizInfo, chgMode, workRoleMap, tacticId, appointedSource, appointedValue2FieldMap);
                break;
            }
            case "hrpi_managingscope": {
                this.formatCmpEmp(tacticResult, sourceData, bizInfo, chgMode, tacticId, appointedSource, appointedValue2FieldMap);
                break;
            }
            default: {
                if (!tacticResult.isEmpty() || !HRStringUtils.isNotEmpty((String)changeObject)) break;
                List<ParserResult> defaultChgObject = ExecutorDataFormatService.formatNewHisWithoutMap(sourceData, changeObject, bizInfo, chgMode, tacticId, appointedSource, appointedValue2FieldMap);
                tacticResult.addAll(defaultChgObject);
            }
        }
    }

    private void formatEmployee(List<ParserResult> tacticResult, Map<String, List<DynamicObject>> sourceData, PerChgBizInfo bizInfo, String chgMode, long tacticId, String appointedSource, Map<String, String> appointedValue2FieldMap) {
        List<String> pages = Arrays.asList("hrpi_employee", "hrpi_empentrel");
        ExecutorDataFormatService.formatNewHisWithoutMap(tacticResult, sourceData, bizInfo, chgMode, pages, tacticId, appointedSource, appointedValue2FieldMap);
        if (!HRStringUtils.equals((String)chgMode, (String)"0")) {
            return;
        }
        tacticResult.stream().filter(row -> HRStringUtils.equals((String)((String)row.getParserParam().get("entityName")), (String)"hrpi_empentrel")).forEach(row -> {
            DynamicObject dyn = (DynamicObject)row.getParserParam().get("hisDy");
            dyn.set("employee", (Object)bizInfo.getNewEmployeeId());
        });
        tacticResult.stream().filter(row -> HRStringUtils.equals((String)((String)row.getParserParam().get("entityName")), (String)"hrpi_employee")).forEach(row -> {
            DynamicObject dyn = (DynamicObject)row.getParserParam().get("hisDy");
            if (dyn.get("boid") == null || (Long)dyn.get("boid") == 0L) {
                dyn.set("boid", (Object)0L);
            }
        });
    }

    private void formatCmpEmp(List<ParserResult> tacticResult, Map<String, List<DynamicObject>> sourceData, PerChgBizInfo bizInfo, String chgMode, long tacticId, String appointedSource, Map<String, String> appointedValue2FieldMap) {
        List<String> pages = Arrays.asList("hrpi_cmpemp", "hrpi_managingscope");
        ExecutorDataFormatService.formatNewHisWithoutMap(tacticResult, sourceData, bizInfo, chgMode, pages, tacticId, appointedSource, appointedValue2FieldMap);
        if (!HRStringUtils.equals((String)chgMode, (String)"0")) {
            return;
        }
        tacticResult.stream().filter(row -> HRStringUtils.equals((String)((String)row.getParserParam().get("entityName")), (String)"hrpi_managingscope")).forEach(row -> ((DynamicObject)row.getParserParam().get("hisDy")).set("cmpemp", (Object)bizInfo.getNewComempId()));
    }

    private void formatDepEmp(List<ParserResult> tacticResult, Map<String, List<DynamicObject>> sourceData, PerChgBizInfo bizInfo, String chgMode, Map<String, Object> workRoleMap, long tacticId, String appointedSource, Map<String, String> appointedValue2FieldMap) {
        List<String> pages = Arrays.asList("hrpi_depemp", "hrpi_empposorgrel", "hrpi_emporgrelall");
        ExecutorDataFormatService.formatNewHisWithoutMap(tacticResult, sourceData, bizInfo, chgMode, pages, tacticId, appointedSource, appointedValue2FieldMap);
        if (HRStringUtils.equals((String)chgMode, (String)"0")) {
            tacticResult.stream().filter(row -> HRStringUtils.equals((String)((String)row.getParserParam().get("entityName")), (String)"hrpi_empposorgrel") || HRStringUtils.equals((String)((String)row.getParserParam().get("entityName")), (String)"hrpi_emporgrelall")).forEach(row -> ((DynamicObject)row.getParserParam().get("hisDy")).set("depemp", (Object)bizInfo.getNewDepempId()));
        }
        Long eventId = bizInfo.getChgEventId();
        this.specialPerformWorkRole(workRoleMap, sourceData, chgMode, tacticResult, eventId, bizInfo);
    }

    private void specialPerformWorkRole(Map<String, Object> workRoleMap, Map<String, List<DynamicObject>> sourceData, String chgMode, List<ParserResult> parserResults, Long eventId, PerChgBizInfo bizInfo) {
        if (HRStringUtils.equals((String)chgMode, (String)"1")) {
            String warnInfo = "CHG_HPFS_WARN-performWorkRole: chgMode is update";
            LOGGER.warn(warnInfo);
            return;
        }
        List<DynamicObject> empPosRel = parserResults.stream().filter(row -> HRStringUtils.equals((String)((String)row.getParserParam().get("entityName")), (String)"hrpi_empposorgrel")).map(row -> (DynamicObject)row.getParserParam().get("hisDy")).filter(row -> this.filterEmpposByChgMode((DynamicObject)row, chgMode, bizInfo)).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(empPosRel)) {
            String warnInfo = "CHG_HPFS_WARN-performWorkRole: empPosRel is null";
            LOGGER.warn(warnInfo);
            return;
        }
        if (HRStringUtils.equals((String)chgMode, (String)"0")) {
            this.performWorkRoleAdd(workRoleMap, empPosRel, chgMode, parserResults, eventId, bizInfo);
        } else {
            this.performWorkRoleInvalid(empPosRel, chgMode, parserResults, eventId, bizInfo);
        }
    }

    private boolean filterEmpposByChgMode(DynamicObject empDy, String chgMode, PerChgBizInfo bizInfo) {
        Long eventId = bizInfo.getChgEventId();
        Long oldDepempId = bizInfo.getOldDepempId();
        if (HRStringUtils.equals((String)chgMode, (String)"0")) {
            return HRStringUtils.equals((String)empDy.getString("businessstatus"), (String)"1") && empDy.getLong("boid") == 0L;
        }
        if (HRStringUtils.equals((String)chgMode, (String)"2")) {
            if (eventId == 1050L) {
                return HRStringUtils.equals((String)empDy.getString("businessstatus"), (String)"2") && empDy.getLong("depemp.id") == oldDepempId.longValue();
            }
            return HRStringUtils.equals((String)empDy.getString("businessstatus"), (String)"2");
        }
        return false;
    }

    private void performWorkRoleAdd(Map<String, Object> workRoleMap, List<DynamicObject> empPosRel, String chgMode, List<ParserResult> parserResults, Long eventId, PerChgBizInfo bizInfo) {
        empPosRel.forEach(emp -> this.performWorkRole(workRoleMap, (DynamicObject)emp, chgMode, eventId, parserResults, bizInfo));
    }

    private void performWorkRoleInvalid(List<DynamicObject> empPosRel, String chgMode, List<ParserResult> parserResults, Long eventId, PerChgBizInfo bizInfo) {
        empPosRel.forEach(row -> this.parserPersonRelRes(null, Collections.emptyList(), (DynamicObject)row, chgMode, eventId, parserResults, bizInfo));
    }

    private Map<String, Object> getValueFromMapping(DynamicObject mappingTable, Map<String, List<DynamicObject>> sourceData) {
        String sourceEntityName = mappingTable.getDynamicObject("sourceentity").getString("number");
        List<DynamicObject> source = sourceData.get(sourceEntityName);
        if (CollectionUtils.isEmpty(source)) {
            String warnInfo = "CHG_HPFS_WARN-performWorkRole: source is null";
            LOGGER.warn(warnInfo);
            return Collections.emptyMap();
        }
        DynamicObject sourceEntityData = source.get(0);
        DynamicObjectCollection fieldEntry = this.getFieldEntry(mappingTable);
        DynamicObject workRole = null;
        String leaderType = null;
        ArrayList personIds = new ArrayList(16);
        for (DynamicObject field : fieldEntry) {
            String targetField;
            String sourceFiled = field.getString("sourcefield");
            switch (targetField = field.getString("targetfield")) {
                case "person": {
                    DynamicObjectCollection collection = sourceEntityData.getDynamicObjectCollection(sourceFiled);
                    if (CollectionUtils.isEmpty((Collection)collection)) break;
                    personIds.addAll(collection.stream().map(row -> row.getLong("fbasedataid_id")).collect(Collectors.toList()));
                    break;
                }
                case "role": {
                    workRole = sourceEntityData.getDynamicObject(sourceFiled);
                    break;
                }
                case "special": {
                    leaderType = sourceEntityData.getString(sourceFiled);
                    break;
                }
            }
        }
        leaderType = leaderType == null ? "0" : leaderType;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("person", personIds);
        map.put("role", workRole);
        map.put("special", leaderType);
        return map;
    }

    private void performWorkRole(Map<String, Object> workRoleMap, DynamicObject empPosRel, String chgMode, Long eventId, List<ParserResult> parserResults, PerChgBizInfo bizInfo) {
        DynamicObject workRole = (DynamicObject)workRoleMap.get("role");
        String leaderType = workRoleMap.get("special") == null ? null : (workRoleMap.get("special") instanceof String ? (String)workRoleMap.get("special") : ((Boolean)workRoleMap.get("special") != false ? "1" : "0"));
        List personIds = (List)workRoleMap.get("person");
        String string = leaderType = leaderType == null ? "0" : leaderType;
        if (workRole == null) {
            String warnInfo = "CHG_HPFS_WARN-performWorkRole: workRole is null , chgmode :%s, empposrelId:%s";
            LOGGER.warn(String.format(Locale.ROOT, warnInfo, chgMode, empPosRel.getLong("id")));
            return;
        }
        List personIdList = HRStringUtils.equals((String)leaderType, (String)"1") && personIds != null ? personIds : Collections.emptyList();
        this.parserPersonRelRes(workRole, personIdList, empPosRel, chgMode, eventId, parserResults, bizInfo);
    }

    private void parserPersonRelRes(DynamicObject workRole, List<Long> personIds, DynamicObject empPosRel, String chgMode, Long eventId, List<ParserResult> parserResults, PerChgBizInfo bizInfo) {
        String operationType = HRStringUtils.equals((String)chgMode, (String)"0") ? "1" : "0";
        ChangeModel changeModel = new ChangeModel(empPosRel, workRole, personIds, eventId, operationType);
        Map<String, DynamicObjectCollection> workRel = ChangePersonRelService.getInstance().doChangePersonRelation(changeModel);
        if (CollectionUtils.isEmpty(workRel)) {
            String warnInfo = "CHG_HPFS_WARN-performWorkRole: workRel is empty, chgmode :%s, empposrelId:%s";
            LOGGER.warn(String.format(Locale.ROOT, warnInfo, chgMode, empPosRel.getLong("id")));
            return;
        }
        workRel.forEach((entity, dyns) -> dyns.forEach(dyn -> {
            if (!this.parseResultListContainBo(parserResults, (String)entity, (DynamicObject)dyn)) {
                parserResults.add(ExecutorDataFormatService.formatTacticResult(dyn, entity));
                this.formatChgRecord(chgMode, (DynamicObject)dyn, (String)entity, bizInfo);
            }
        }));
    }

    private boolean parseResultListContainBo(List<ParserResult> parserResults, String entityNumber, DynamicObject dynamicObject) {
        if (Objects.isNull(parserResults) || Objects.isNull(entityNumber) || "".equals(entityNumber) || Objects.isNull(dynamicObject)) {
            LOGGER.warn("ExecutorService#parseResultListContainBo request param error, entitynumber is {}", (Object)entityNumber);
            return false;
        }
        DataEntityPropertyCollection properties = dynamicObject.getDataEntityType().getProperties();
        if (!properties.containsKey((Object)"boid") || dynamicObject.getLong("boid") == 0L) {
            LOGGER.info("ExecutorService#parseResultListContainBo dynamicObject not containkey boid or boid is zero, entitynumber is {}", (Object)entityNumber);
            return false;
        }
        return Objects.nonNull(parserResults.stream().filter(parserResult -> {
            if (HRStringUtils.equals((String)((String)parserResult.getParserParam().get("entityName")), (String)entityNumber) && Objects.nonNull(parserResult.getParserParam().get("hisDy"))) {
                DynamicObject parseResultDy = (DynamicObject)parserResult.getParserParam().get("hisDy");
                return parseResultDy.getLong("boid") == dynamicObject.getLong("boid");
            }
            LOGGER.info("ExecutorService#parseResultListContainBo parserResult not contain entityNumber or hisDy is empty, entityNumber is {}", (Object)entityNumber);
            return false;
        }).findFirst().orElse(null));
    }

    private void formatChgRecord(String chgMode, DynamicObject hisDy, String entity, PerChgBizInfo bizInfo) {
        Long newId = ORM.create().genLongId(entity);
        hisDy.set("id", (Object)newId);
        if (HRStringUtils.equals((String)chgMode, (String)"0")) {
            bizInfo.setIdsRecord(entity, ChgRecordEntryDto.formatNewRecord((Long)newId, (String)ChgFlowTypeEnum.FLOW_UNRELATED.getFlowType()));
        } else {
            bizInfo.setIdsRecord(entity, ChgRecordEntryDto.formatRecord((Long)hisDy.getLong("boid"), null, (Long)hisDy.getLong("boid"), (Long)newId, (String)chgMode, (String)ChgFlowTypeEnum.FLOW_UNRELATED.getFlowType()));
        }
    }

    private void updateIdsRecord(PerChgBizInfo bizInfo, Map<String, List<DynamicObject>> sourceData) {
        Map records = bizInfo.getIdsRecord();
        for (String entityName : PERSON_MODEL_PAGES) {
            List<DynamicObject> list;
            ChgRecordEntryDto chgRecordEntry;
            if (null != records && records.get(entityName) != null && (chgRecordEntry = (ChgRecordEntryDto)((List)records.get(entityName)).stream().filter(row -> row.getIdBefore() != null && row.getIdBefore().longValue() == bizInfo.getOldPersonModelId(entityName)).findFirst().orElse(null)) != null || CollectionUtils.isEmpty(list = sourceData.get(entityName))) continue;
            long oldId = bizInfo.getOldPersonModelId(entityName);
            DynamicObject dyn = list.stream().filter(row -> ParserUtil.filterCurrentFromOrigin(row) && row.getLong("boid") == oldId).findAny().orElse(null);
            if (dyn == null) {
                bizInfo.setIdsRecord(entityName, ChgRecordEntryDto.formatRecord(null, null, null, null, (String)ChgModeEnum.UNCHANGED.getChgMode(), (String)ChgFlowTypeEnum.FLOW_UNRELATED.getFlowType()));
                continue;
            }
            long boid = dyn.getLong("boid");
            Long vidBefore = dyn.getLong("sourcevid");
            bizInfo.setIdsRecord(entityName, ChgRecordEntryDto.formatRecord((Long)boid, (Long)vidBefore, (Long)boid, null, (String)ChgModeEnum.UNCHANGED.getChgMode(), (String)ChgFlowTypeEnum.FLOW_UNRELATED.getFlowType()));
        }
    }

    private Map<String, Object> formatValue2FieldMap(List<DynamicObject> configList, Map<String, List<DynamicObject>> sourceData, String changeObject, StringBuilder stringBuilder, Map<String, String> appointedValue2FieldMap, PerChgBizInfo bizInfo) {
        HashMap<String, Object> value2FieldMap = new HashMap<String, Object>(16);
        Map valueMap = bizInfo.getValueMap();
        configList.forEach(config -> {
            String field = config.getString("chgfile");
            String chgType = config.getString("chgtype");
            String valueFixed = config.getString("valuefixed");
            String rpcParam = config.getString("rpcparam");
            if (HRStringUtils.isNotEmpty((String)chgType)) {
                String entitySource = this.getMappingOrigin(changeObject, field);
                this.getValueByChgType(chgType, value2FieldMap, field, (List)sourceData.get(entitySource), valueFixed);
                return;
            }
            if (HRStringUtils.isNotEmpty((String)valueFixed)) {
                value2FieldMap.put(field, valueFixed);
                String idNumber = field + "_" + "id";
                value2FieldMap.put(idNumber, valueFixed);
                return;
            }
            String entitySource = config.getString("entitysource");
            if (HRStringUtils.isNotEmpty((String)entitySource)) {
                List source = (List)sourceData.get(entitySource);
                if (CollectionUtils.isEmpty((Collection)source)) {
                    return;
                }
                String fieldSource = config.getString("fieldsource");
                if (stringBuilder.length() == 0) {
                    stringBuilder.append(entitySource);
                    appointedValue2FieldMap.put(field, fieldSource);
                    return;
                }
                if (HRStringUtils.equals((String)stringBuilder.toString(), (String)entitySource)) {
                    appointedValue2FieldMap.put(field, fieldSource);
                    return;
                }
                this.getValueByAppointSource(fieldSource, source, field, value2FieldMap);
                return;
            }
            if (HRStringUtils.isNotEmpty((String)rpcParam) && !CollectionUtils.isEmpty((Map)valueMap) && valueMap.get(rpcParam) != null) {
                value2FieldMap.put(field, valueMap.get(rpcParam));
                return;
            }
            this.getValueByFixed((DynamicObject)config, field, (Map<String, Object>)value2FieldMap);
        });
        this.specialPerform(changeObject, value2FieldMap);
        return value2FieldMap;
    }

    private String getMappingOrigin(String changeObject, String field) {
        HashSet<String> set = new HashSet<String>(16);
        set.add("assignno");
        set.add("laborrelrecord");
        if (HRStringUtils.equals((String)changeObject, (String)"hrpi_empposorgrel") && set.contains(field)) {
            return "hrpi_depemp";
        }
        return changeObject;
    }

    private void getValueByAppointSource(String fieldSource, List<DynamicObject> sourceData, String field, Map<String, Object> appointedValue2FieldMap) {
        DynamicObject sourceDyn;
        if (CollectionUtils.isEmpty(sourceData)) {
            return;
        }
        DynamicObject dynamicObject = sourceDyn = sourceData.size() == 1 ? sourceData.get(0) : (DynamicObject)sourceData.stream().filter(ParserUtil::filterCurrentFromOrigin).findFirst().orElse(null);
        if (sourceDyn == null) {
            return;
        }
        Object valueSource = sourceDyn.get(fieldSource);
        appointedValue2FieldMap.put(field, valueSource);
    }

    private void getValueByValueFixed(String field, Map<String, Object> value2FieldMap, String valueFixed) {
        if (HRStringUtils.isNotEmpty((String)valueFixed)) {
            value2FieldMap.put(field, valueFixed);
            String idNumber = field + "_" + "id";
            value2FieldMap.put(idNumber, valueFixed);
            return;
        }
    }

    private void getValueByChgType(String chgType, Map<String, Object> value2FieldMap, String field, List<DynamicObject> sourceData, String valueFixed) {
        switch (chgType) {
            case "1": {
                value2FieldMap.put(field, null);
                break;
            }
            case "2": {
                this.getValueByAppointSource(field, sourceData, field, value2FieldMap);
                break;
            }
            case "4": {
                this.getValueByValueFixed(field, value2FieldMap, valueFixed);
                break;
            }
        }
    }

    private void getValueByFixed(DynamicObject config, String field, Map<String, Object> value2FieldMap) {
        String[] values;
        String valRange = config.getString("valrange_tag");
        if (HRStringUtils.isNotEmpty((String)valRange)) {
            QFilter qFilter = QFilter.fromSerializedString((String)valRange);
            List ids = (List)qFilter.getValue();
            if (!CollectionUtils.isEmpty((Collection)ids)) {
                value2FieldMap.put(field, ids.get(0));
                String idNumber = field + "_" + "id";
                value2FieldMap.put(idNumber, ids.get(0));
            }
            return;
        }
        String val = config.getString("val");
        if (HRStringUtils.isNotEmpty((String)val) && (values = val.split(",")).length != 0) {
            value2FieldMap.put(field, values[1]);
        }
    }

    private void specialPerform(String chgObject, Map<String, Object> value2FieldMap) {
        Object status;
        Object statusProd;
        if (HRStringUtils.equals((String)chgObject, (String)"hrpi_empentrel") && (statusProd = this.getLaborStatusProd(status = value2FieldMap.get("laborrelstatus"))) != null) {
            value2FieldMap.put("labrelstatusprd", statusProd);
        }
    }

    private Object getLaborStatusProd(Object status) {
        DynamicObject laborrelstatus = null;
        if (status instanceof String) {
            String id = (String)status;
            laborrelstatus = new HRBaseServiceHelper("hbss_laborrelstatus").loadSingle((Object)id);
        } else if (status instanceof DynamicObject) {
            laborrelstatus = new HRBaseServiceHelper("hbss_laborrelstatus").loadSingle((Object)((DynamicObject)status).getLong("id"));
        }
        if (laborrelstatus == null) {
            LOGGER.warn("CHG_HPFS_WARN laborrelstatus is null");
            return null;
        }
        return laborrelstatus.get("labrelstatusprd");
    }

    private void parserEntity(Map<String, List<DynamicObject>> sourceData, DynamicObject chgRuleInfo, List<ParserResult> parserResults, PerChgBizInfo bizInfo, DynamicObject mappingPlan, String chgMode, long tacticId) {
        EntityParserFactory parserFactory = EntityParserFactory.getInstance();
        DynamicObjectCollection tableEntry = mappingPlan.getDynamicObjectCollection("entryentity");
        HashMap<String, List> targetMap = new HashMap<String, List>(tableEntry.size());
        for (DynamicObject tableMapping : tableEntry) {
            String targetEntityName = tableMapping.getDynamicObject("targetentity").getString("number");
            if (HRStringUtils.equals((String)targetEntityName, (String)"hrpi_personrolerel")) continue;
            if (targetMap.get(targetEntityName) == null) {
                List<ParserResult> newDataList = this.generateNewData(tableMapping, sourceData, parserFactory, chgRuleInfo, mappingPlan, bizInfo, chgMode, tacticId);
                if (CollectionUtils.isEmpty(newDataList)) continue;
                targetMap.put(targetEntityName, newDataList);
                continue;
            }
            String sourceEntity = tableMapping.getDynamicObject("sourceentity").getString("number");
            this.setValueOnGeneratedData((List)targetMap.get(targetEntityName), tableMapping, sourceData.get(sourceEntity), bizInfo);
        }
        targetMap.forEach((key, value) -> parserResults.addAll((Collection<ParserResult>)value));
        EntityParserFactory.SHAREPARAM.remove();
    }

    private List<ParserResult> generateNewData(DynamicObject tableMapping, Map<String, List<DynamicObject>> sourceData, EntityParserFactory parserFactory, DynamicObject chgActionInfo, DynamicObject mappingPlan, PerChgBizInfo bizInfo, String chgMode, long tacticId) {
        String entityName = tableMapping.getDynamicObject("targetentity").getString("number");
        String sourceEntity = tableMapping.getDynamicObject("sourceentity").getString("number");
        List<Object> sourceEntityData = sourceData.get(sourceEntity);
        List<DynamicObject> originEntityData = sourceData.get(entityName);
        if (CollectionUtils.isEmpty(sourceEntityData)) {
            return Collections.emptyList();
        }
        sourceEntityData = sourceEntityData.stream().filter(ParserUtil::filterCurrentFromOrigin).collect(Collectors.toList());
        Parser parser = parserFactory.createParser(entityName, chgActionInfo, mappingPlan, sourceEntityData, originEntityData, bizInfo, tableMapping, chgMode, sourceData, tacticId);
        return parser.addNewAndEffectParser();
    }

    private void setValueOnGeneratedData(List<ParserResult> parserResults, DynamicObject tableMapping, List<DynamicObject> sourceEntityData, PerChgBizInfo bizInfo) {
        if (CollectionUtils.isEmpty(sourceEntityData)) {
            return;
        }
        parserResults.forEach(row -> {
            DynamicObject data = (DynamicObject)row.getParserParam().get("hisDy");
            ParserUtil.generateHisByFieldMapping(this.getFieldEntry(tableMapping), (DynamicObject)sourceEntityData.get(0), data, bizInfo);
        });
    }

    protected DynamicObjectCollection getFieldEntry(DynamicObject tableMapping) {
        return tableMapping.getDynamicObjectCollection("subentryentity");
    }

    private PerChgBizResult executeDB(List<ParserResult> parserResult, PerChgBizOperateType operateType, PerChgBizInfo bizInfo) {
        Map<String, DynamicObjectCollection> dynMap = ExecutorDataFormatService.handleParserResult(parserResult);
        String validateErrorMsg = HRPIValidateFormattedDataService.getInstance().validateByHRPI(dynMap, bizInfo);
        HRPISaveService.getInstance().saveBatchData(dynMap, bizInfo);
        PerChgBizResult bizResult = PerChgBizResult.success((PerChgBizInfo)bizInfo);
        bizResult.setErrMsg(validateErrorMsg);
        if (operateType == PerChgBizOperateType.CHGOPERATION_ADDNEWANDEFFECT) {
            ChgRecordService.addFileChangeRecord(bizInfo);
        }
        bizResult.setRecordId(bizInfo.getChgrecordId());
        return bizResult;
    }
}

