/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hpfs.business.perchg.executor;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hpfs.business.domain.repository.perchg.ChgGuideBaseRepository;
import kd.hr.hpfs.business.perchg.common.ChgLogHelper;
import kd.hr.hpfs.business.perchg.common.MQHelper;
import kd.hr.hpfs.business.perchg.config.ConfigService;
import kd.hr.hpfs.business.perchg.exception.PerChgException;
import kd.hr.hpfs.business.perchg.executor.ExecutorService;
import kd.hr.hpfs.business.perchg.executor.enums.ChgLogStatusEnum;
import kd.hr.hpfs.business.perchg.executor.enums.ChgRecordStatusEnum;
import kd.hr.hpfs.business.perchg.executor.service.InitDataQueryService;
import kd.hr.hpfs.business.perchg.executor.util.PerChgUtils;
import kd.hr.hpfs.common.enums.ChgCarrierEnum;
import kd.hr.hpfs.common.perchg.PerChgBizOperateType;
import kd.hr.hpfs.common.perchg.PerChgEnumUtil;
import kd.sdk.hr.hpfs.business.perchg.bizentity.PerChgBizInfo;
import kd.sdk.hr.hpfs.business.perchg.bizentity.PerChgBizResult;
import kd.sdk.hr.hpfs.business.perchg.bizentity.PerChgParam;
import kd.sdk.hr.hpfs.common.perchg.PerChgConstants;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class MserviceService
implements PerChgConstants {
    private static final Log LOGGER = LogFactory.getLog(MserviceService.class);
    private static final MserviceService MSERVICESERVICE = new MserviceService();

    public static MserviceService getInstance() {
        return MSERVICESERVICE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PerChgBizResult> execute(String msg) throws PerChgException {
        PerChgParam perChgParam = null;
        List<PerChgBizResult> bizResultList = new ArrayList<PerChgBizResult>();
        try {
            String msgInfo = "CHG_HPFS getMessage: " + msg;
            LOGGER.info(msgInfo);
            Map mqParam = (Map)SerializationUtils.fromJsonString((String)msg, Map.class);
            perChgParam = (PerChgParam)SerializationUtils.fromJsonString((String)HRJSONUtils.toString(mqParam.get("billdata")), PerChgParam.class);
            this.resetRequestContext(perChgParam);
            Integer operateTypeCode = (Integer)mqParam.get("operatetype");
            bizResultList = this.execute(perChgParam, operateTypeCode);
            String resultCallBackQueue = perChgParam.getResultCallBackQueue();
            if (StringUtils.isNotEmpty((String)resultCallBackQueue) && !CollectionUtils.isEmpty(bizResultList)) {
                MQHelper.publish(JSONObject.toJSONString(bizResultList), resultCallBackQueue);
            }
        }
        catch (PerChgException perChgException) {
            LOGGER.error("CHG_HPFS_ERROR MserviceService.execute perChgException:", (Throwable)perChgException);
            throw perChgException;
        }
        catch (Exception e) {
            LOGGER.error("CHG_HPFS_ERROR MserviceService.execute Error:", (Throwable)e);
            ChgLogHelper.writeErrorLogBeforeChg(perChgParam, e);
        }
        finally {
            ChgLogHelper.LOG_ID_THREAD_LOCAL.remove();
        }
        return bizResultList;
    }

    private List<PerChgBizResult> execute(PerChgParam perChgParam, Integer operateTypeCode) {
        ArrayList<PerChgBizResult> bizResultList = new ArrayList<PerChgBizResult>();
        List bizInfos = perChgParam.getBizInfoList();
        for (PerChgBizInfo bizInfo : bizInfos) {
            String billSource = bizInfo.getBillSource();
            Long billId = bizInfo.getBillId();
            if (StringUtils.isEmpty((String)billSource) && Objects.isNull(billId)) continue;
            this.perChgExecuteDistributed(bizResultList, bizInfo, operateTypeCode);
        }
        return bizResultList;
    }

    private void perChgExecuteDistributed(List<PerChgBizResult> bizResultList, PerChgBizInfo bizInfo, Integer operateTypeCode) throws PerChgException {
        String billSource = bizInfo.getBillSource();
        Long billId = bizInfo.getBillId();
        Long actionId = bizInfo.getActionId();
        String dlockKey = String.join((CharSequence)"_", billSource, String.valueOf(billId));
        LOGGER.info("MserviceService#perChgExecuteDistributed dlockKey is {}", (Object)dlockKey);
        try (DLock dLock = DLock.create((String)dlockKey);){
            if (!dLock.tryLock(PerChgUtils.getDLockTimeout())) {
                LOGGER.warn("MserviceService#perChgExecuteDistributed tryLock overTime");
                throw new PerChgException("tryLock fail");
            }
            DynamicObject successBill = this.querySuccessBill(billSource, billId, actionId);
            if (!Objects.isNull(successBill)) {
                PerChgBizResult bizResult = this.billExisted(successBill, bizInfo);
                bizResultList.add(bizResult);
                return;
            }
            ChgLogHelper.writeLogAfterObtainDLock(bizInfo);
            this.perChgExecute(bizResultList, bizInfo, operateTypeCode, billId);
        }
        catch (PerChgException perChgException) {
            LOGGER.error("MserviceService.execute perChgExecuteDistributed perChgException", (Throwable)perChgException);
            throw perChgException;
        }
        catch (Exception e) {
            LOGGER.error("MserviceService.execute in dlock error:", (Throwable)e);
            PerChgBizResult result = PerChgBizResult.fail((Long)billId, (String)billSource, (String)ExceptionUtils.getStackTrace((Throwable)e));
            ChgLogHelper.updateLogResult(bizInfo, result, ChgLogStatusEnum.FAIL.getFlag());
            bizResultList.add(result);
        }
    }

    private void perChgExecute(List<PerChgBizResult> bizResultList, PerChgBizInfo bizInfo, Integer operateTypeCode, Long billId) {
        ArrayList<PerChgBizInfo> bizInfoList = new ArrayList<PerChgBizInfo>();
        bizInfoList.add(bizInfo);
        PerChgBizOperateType operateType = PerChgEnumUtil.getByBizOperateCode(PerChgBizOperateType.class, (Integer)operateTypeCode);
        List<Long> pchgCnfIdList = bizInfoList.stream().map(PerChgBizInfo::getActionId).collect(Collectors.toList());
        Map<String, Object> allConfig = ConfigService.getInstance().getAllConfigByBillConfId(pchgCnfIdList);
        bizInfo.setChgRule(ConfigService.getInstance().getChgRuleByBizInfo(bizInfo, allConfig));
        ConfigService.getInstance().initBizInfo(bizInfo);
        Map<Long, Map<String, List<DynamicObject>>> trueData = new InitDataQueryService().getAllBillTrueData(bizInfoList, operateType);
        Map<String, List<DynamicObject>> sourceData = trueData.get(billId);
        DynamicObject chgGuideBase = ChgGuideBaseRepository.getInstance().queryGuideBaseByAction(bizInfo.getActionId(), ChgCarrierEnum.CARRIER_BILL.getCode());
        allConfig.put("chgGuideBase", chgGuideBase);
        PerChgBizResult perChgBizResult = ExecutorService.getInstance().executeSingle(bizInfo, operateType, allConfig, sourceData);
        bizResultList.add(perChgBizResult);
    }

    private PerChgBizResult billExisted(DynamicObject successBill, PerChgBizInfo bizInfo) {
        Long recordId = successBill.getLong("id");
        PerChgBizResult perChgBizResult = PerChgBizResult.success((Long)bizInfo.getBillId(), (String)bizInfo.getBillSource(), (Long)recordId);
        this.wrapPerChgBizResultForRepeatConsume(perChgBizResult, bizInfo);
        bizInfo.setEventId((Long)successBill.get("event"));
        bizInfo.setChgrecordId(recordId);
        perChgBizResult.setErrMsg(ResManager.loadKDString((String)"\u65e0\u6cd5\u751f\u6548\uff0c\u5f53\u524d\u5355\u636e\u5df2\u751f\u6548\u3002", (String)"MserviceService_0", (String)"hr-hpfs-business", (Object[])new Object[0]));
        ChgLogHelper.updateLogResult(bizInfo, perChgBizResult, ChgLogStatusEnum.FAIL.getFlag());
        return perChgBizResult;
    }

    private DynamicObject querySuccessBill(String billSource, Long billId, Long actionId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hpfs_chgrecord");
        QFilter billSourceFilter = new QFilter("billsource", "=", (Object)billSource);
        QFilter billIdFilter = new QFilter("bill", "=", (Object)billId);
        QFilter actionFilter = new QFilter("chgaction", "=", (Object)actionId);
        QFilter transactionStatusFilter = new QFilter("datastatus", "=", (Object)ChgRecordStatusEnum.CHANGED.getCode());
        return helper.queryOne("id,bill,billsource,event", new QFilter[]{billSourceFilter, billIdFilter, transactionStatusFilter, actionFilter});
    }

    private void wrapPerChgBizResultForRepeatConsume(PerChgBizResult result, PerChgBizInfo bizInfo) {
        QFilter filter;
        HRBaseServiceHelper helper;
        DynamicObject chgAction;
        Long actionId;
        Long recordId = result.getRecordId();
        if (!Objects.isNull(recordId) && recordId != 0L) {
            HRBaseServiceHelper helper2 = new HRBaseServiceHelper("hpfs_chgrecord");
            QFilter filter2 = new QFilter("id", "=", (Object)recordId);
            DynamicObject record = helper2.queryOne("entryentity.chgentity,entryentity.idafter", new QFilter[]{filter2});
            if (Objects.isNull(record)) {
                return;
            }
            DynamicObjectCollection entryEntity = record.getDynamicObjectCollection("entryentity");
            if (CollectionUtils.isEmpty((Collection)entryEntity)) {
                return;
            }
            for (DynamicObject object : entryEntity) {
                String entityNumber = object.getString("chgentity.number");
                Long afterId = (Long)object.get("idafter");
                switch (entityNumber) {
                    case "hrpi_person": {
                        result.setNewPersonId(afterId);
                        break;
                    }
                    case "hrpi_employee": {
                        result.setNewEmployeeId(afterId);
                        break;
                    }
                    case "hrpi_cmpemp": {
                        result.setNewComEmpId(afterId);
                        break;
                    }
                    case "hrpi_depemp": {
                        result.setNewDepEmpId(afterId);
                        break;
                    }
                    case "hspm_ermanfile": {
                        result.setNewErfileId(afterId);
                        break;
                    }
                }
            }
        }
        if (!Objects.isNull(actionId = bizInfo.getActionId()) && actionId != 0L && !Objects.isNull(chgAction = (helper = new HRBaseServiceHelper("hpfs_chgaction")).queryOne("action_id", filter = new QFilter("id", "=", (Object)actionId)))) {
            result.setMsgSynActionId(Long.valueOf(chgAction.getLong("action_id")));
        }
    }

    private void resetRequestContext(PerChgParam param) {
        try {
            RequestContext.get().setApi3rdAppId(param.getAppId());
        }
        catch (Exception exe) {
            LOGGER.error("create user info failed", (Throwable)exe);
        }
    }
}

