/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hpfs.business.perchg.executor.service;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hpfs.business.perchg.parser.ParserResult;
import kd.hr.hpfs.common.enums.ChgLogPluginExeStatusEnum;
import kd.sdk.hr.hpfs.business.perchg.bizentity.PerChgBizInfo;
import kd.sdk.hr.hpfs.business.perchg.executor.model.ChgLogEntryDto;

public class ChgLogEntryService {
    private static final ChgLogEntryService CHG_LOG_ENTRY_SERVICE = new ChgLogEntryService();
    private static final Log LOGGER = LogFactory.getLog(ChgLogEntryService.class);

    public static ChgLogEntryService getInstance() {
        return CHG_LOG_ENTRY_SERVICE;
    }

    public void formatLogEntry(Long tacticId, PerChgBizInfo bizInfo, List<ParserResult> tacticResult) {
        for (ParserResult result : tacticResult) {
            String entityName = (String)result.getParserParam().get("entityName");
            DynamicObject dyn = (DynamicObject)result.getParserParam().get("hisDy");
            long id = dyn.getLong("id");
            bizInfo.setLogEntryMap(entityName, Long.valueOf(id), ChgLogEntryDto.init((String)entityName, (long)tacticId, (long)id));
        }
    }

    public void formatLogEntryDto2Dyn(DynamicObject logDyn, PerChgBizInfo bizInfo) {
        Map logEntryMap = bizInfo.getLogEntryMap();
        if (logEntryMap.isEmpty()) {
            LOGGER.warn("CHG_HPFS_WARN formatLogEntryDto2Dyn logEntryMap.isEmpty");
            return;
        }
        DynamicObjectCollection collection = logDyn.getDynamicObjectCollection("entryentity");
        collection.clear();
        logEntryMap.forEach((entityName, entryMap) -> entryMap.forEach((id, dto) -> {
            DynamicObject dyn = collection.addNew();
            dyn.set("chgtactic", (Object)dto.getChgTacticId());
            dyn.set("chgobject", (Object)dto.getChgObject());
            dyn.set("dataid", (Object)dto.getDataId());
            dyn.set("validstatus", (Object)dto.getValidStatus());
            dyn.set("savestatus", (Object)dto.getSaveStatus());
            dyn.set("errormsg", (Object)this.subStringError(dto.getErrorMsg()));
            dyn.set("errormsg_tag", (Object)dto.getErrorMsg());
        }));
    }

    public void formatLogPlugin(DynamicObject logDyn, PerChgBizInfo bizInfo) {
        DynamicObjectCollection pluginEntry = logDyn.getDynamicObjectCollection("pluginentry");
        pluginEntry.clear();
        List pluginEntryList = bizInfo.getPluginEntry();
        Map pluginResMap = bizInfo.getPluginResMap();
        if (CollectionUtils.isEmpty((Collection)pluginEntryList) || CollectionUtils.isEmpty((Map)pluginResMap)) {
            String warnInfo = "formatLogPlugin pluginEntryList or pluginResMap is empty, chgActionId:" + bizInfo.getActionId() + ",billNo:" + bizInfo.getBillNo();
            LOGGER.warn(warnInfo);
            return;
        }
        pluginEntryList.forEach(plugin -> {
            String errorMsg = (String)pluginResMap.get(plugin.getString("plugin.number"));
            String errorMagSub = HRStringUtils.isEmpty((String)errorMsg) || errorMsg.length() < 255 ? errorMsg : errorMsg.substring(0, 255);
            String exeStatus = ChgLogPluginExeStatusEnum.getStatusByMsg((String)errorMsg);
            DynamicObject dynamicObject = pluginEntry.addNew();
            dynamicObject.set("plugin", (Object)plugin.getDynamicObject("plugin"));
            dynamicObject.set("exestatus", (Object)exeStatus);
            dynamicObject.set("occasion", (Object)plugin.getString("plugin.occasion"));
            dynamicObject.set("isinterrupted", plugin.get("isinterrupted"));
            dynamicObject.set("error_tag", (Object)errorMsg);
            dynamicObject.set("error", (Object)errorMagSub);
        });
    }

    private String subStringError(String errorMsg) {
        if (HRStringUtils.isEmpty((String)errorMsg) || errorMsg.length() <= 250) {
            return errorMsg;
        }
        return errorMsg.substring(0, 250) + "...";
    }
}

