/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hpfs.business.perchg.executor.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.util.ExceptionUtils;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hpfs.business.domain.repository.RepositoryUtils;
import kd.hr.hpfs.business.domain.repository.personflow.PersonFlowRepository;
import kd.hr.hpfs.business.perchg.common.ChgLogHelper;
import kd.hr.hpfs.business.perchg.common.MQHelper;
import kd.hr.hpfs.business.perchg.executor.enums.ChgLogStatusEnum;
import kd.hr.hpfs.business.perchg.executor.enums.ChgRecordStatusEnum;
import kd.hr.hpfs.business.perchg.executor.model.ChgAPIDataReturnDto;
import kd.hr.hpfs.business.perchg.executor.model.ChgExternalDataEntryDto;
import kd.hr.hpfs.business.perchg.executor.model.ChgExternalDataReturnDto;
import kd.hr.hpfs.business.perchg.executor.model.ChgExternalRecordDto;
import kd.hr.hpfs.business.perchg.executor.model.ChgRecordEntryDto;
import kd.hr.hpfs.business.perchg.executor.model.ChgRecordExecutorDto;
import kd.hr.hpfs.business.perchg.parser.util.ParserUtil;
import kd.hr.hpfs.common.constants.PerModelConstants;
import kd.sdk.hr.hpfs.business.perchg.executor.enums.ChgModeEnum;
import kd.sdk.hr.hpfs.common.constants.ChgConstants;
import kd.sdk.hr.hpfs.common.perchg.PerChgConstants;

public class ChgRecordExecutorService
implements PerChgConstants,
ChgConstants {
    private static final Log LOGGER = LogFactory.getLog(ChgRecordExecutorService.class);
    private static final HRBaseServiceHelper RECORD_HELPER = new HRBaseServiceHelper("hpfs_chgrecord");
    private static final ChgRecordExecutorService CHG_RECORD_EXECUTOR_SERVICE = new ChgRecordExecutorService();

    public static ChgRecordExecutorService getInstance() {
        return CHG_RECORD_EXECUTOR_SERVICE;
    }

    public void executeMsg(String msg) {
        try {
            this.execute(msg);
        }
        catch (Exception e) {
            LOGGER.error("CHG_HPFS_ERROR ChgRecordExecutorService.executeMsg:", (Throwable)e);
            ChgLogHelper.writeErrorLogBeforeChg(null, e);
        }
        finally {
            ChgLogHelper.LOG_ID_THREAD_LOCAL.remove();
        }
    }

    public void executeExternalRecord(String msg) {
        try {
            this.writeExternalRecord(msg);
        }
        catch (Exception e) {
            LOGGER.error("CHG_HPFS_ERROR ChgRecordExecutorService.executeExternalRecord executeMsg:", (Throwable)e);
            ChgLogHelper.writeErrorLogBeforeChg(null, e);
        }
        finally {
            ChgLogHelper.LOG_ID_THREAD_LOCAL.remove();
        }
    }

    private void writeExternalRecord(String msg) {
        String msgReturned;
        ChgExternalRecordDto chgExternalRecord;
        try {
            chgExternalRecord = (ChgExternalRecordDto)SerializationUtils.fromJsonString((String)msg, ChgExternalRecordDto.class);
        }
        catch (Exception e) {
            LOGGER.error("CHG_HPFS_RECORD_EXECUTOR_ERROR:executeExternalRecord parameter parse error", (Throwable)e);
            ChgLogHelper.writeErrorLogBeforeChg(null, e);
            return;
        }
        try {
            Long recordId = this.saveExternalRecord(chgExternalRecord);
            if (chgExternalRecord.getActionId() == 103000L) {
                LOGGER.info("into handlerPersonFlow");
                this.handlerPersonFlow(chgExternalRecord);
            }
            ChgAPIDataReturnDto<ChgExternalDataReturnDto> dataReturnDtoChgAPIDataReturn = new ChgAPIDataReturnDto<ChgExternalDataReturnDto>().format(Boolean.TRUE, null, ChgExternalDataReturnDto.format(chgExternalRecord, recordId));
            msgReturned = SerializationUtils.toJsonString(dataReturnDtoChgAPIDataReturn);
            ChgLogHelper.updateLog(chgExternalRecord, null, recordId, msgReturned, ChgLogStatusEnum.MAIN_SUCCESS.getFlag());
        }
        catch (Exception e) {
            String errorMsg = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
            LOGGER.error("CHG_HPFS_ERROR ChgRecordExecutorService.writeExternalRecord executeMsg:", (Throwable)e);
            ChgAPIDataReturnDto<ChgExternalDataReturnDto> dataReturnDtoChgAPIDataReturn = new ChgAPIDataReturnDto<ChgExternalDataReturnDto>().format(Boolean.FALSE, errorMsg, ChgExternalDataReturnDto.format(chgExternalRecord, 0L));
            msgReturned = SerializationUtils.toJsonString(dataReturnDtoChgAPIDataReturn);
            ChgLogHelper.updateLog(chgExternalRecord, errorMsg, (Long)0L, msgReturned, ChgLogStatusEnum.FAIL.getFlag());
        }
        if (HRStringUtils.isEmpty((String)chgExternalRecord.getResultCallBackQueue())) {
            return;
        }
        MQHelper.publish(msgReturned, chgExternalRecord.getResultCallBackQueue());
    }

    private void handlerPersonFlow(ChgExternalRecordDto chgExternalRecord) {
        if (chgExternalRecord != null) {
            String billNo = chgExternalRecord.getBillNo();
            if (HRStringUtils.isNotEmpty((String)billNo) && billNo.contains("adm")) {
                Long depEmpId = chgExternalRecord.getDepEmpId();
                Object[] dys = PersonFlowRepository.query("id,flowtype,flowtime,flowyear,flowmonth,flowquarter,flowweek,adminorg,orglonghisid,adminorghis,orglongnumber", new QFilter[]{new QFilter("depemp", "=", (Object)depEmpId)});
                if (HRArrayUtils.isEmpty((Object[])dys)) {
                    LOGGER.info("handlerPersonFlow#depEmpId={},==>PersonFlowRepository.query result is empty!", (Object)depEmpId);
                    return;
                }
                String[] result = HRStringUtils.split((String)billNo, (String)"#");
                Long id = Long.valueOf(result[0]);
                LOGGER.info("handlerPersonFlow#depEmpId={},id={}", (Object)depEmpId, (Object)id);
                DynamicObject dynamicObject = RepositoryUtils.queryById("hrpi_empposorgrel", id);
                if (dynamicObject != null) {
                    Long adminOrgId = dynamicObject.getLong("adminorg.id");
                    for (Object dy : dys) {
                        Date flowTime;
                        if (dy == null || dy.getLong("adminorg.id") == adminOrgId.longValue()) continue;
                        if (HRStringUtils.equals((String)"1", (String)dy.getString("flowtype"))) {
                            flowTime = dynamicObject.getDate("startdate");
                            this.updatePersonFlow(adminOrgId, (DynamicObject)dy, flowTime);
                            continue;
                        }
                        if (HRStringUtils.equals((String)"2", (String)dy.getString("flowtype"))) {
                            flowTime = dynamicObject.getDate("enddate");
                            this.updatePersonFlow(adminOrgId, (DynamicObject)dy, flowTime);
                            continue;
                        }
                        LOGGER.info("handlerPersonFlow#flowtype is wrong!");
                    }
                    try {
                        PersonFlowRepository.update((DynamicObject[])dys);
                    }
                    catch (Exception exception) {
                        LOGGER.error("PersonFlowRepository  update is exception:", (Throwable)exception);
                    }
                }
            } else {
                LOGGER.info("handlerPersonFlow#modified field not contain adminorg!");
            }
        }
    }

    private void updatePersonFlow(Long adminOrgId, DynamicObject dy, Date flowTime) {
        dy.set("flowtime", (Object)flowTime);
        dy.set("flowyear", (Object)HRDateTimeUtils.getYear((Date)flowTime));
        dy.set("flowquarter", (Object)HRDateTimeUtils.getQuarter((Date)flowTime));
        dy.set("flowmonth", (Object)HRDateTimeUtils.getMonth((Date)flowTime));
        dy.set("flowweek", (Object)HRDateTimeUtils.getWeek((Date)flowTime));
        dy.set("adminorg", (Object)adminOrgId);
        ArrayList<Long> ids = new ArrayList<Long>();
        ids.add(adminOrgId);
        Map result = (Map)HRMServiceHelper.invokeHRMPService((String)"haos", (String)"IHAOSBatchAdminOrgStructQueryService", (String)"adminOrgStructQuery", (Object[])new Object[]{ids, dy.getDate("flowtime"), Boolean.TRUE});
        LOGGER.info("updatePersonFlow#flowTime={},result={}", (Object)flowTime, (Object)SerializationUtils.toJsonString((Object)result));
        Map infoMap = (Map)result.get(String.valueOf(adminOrgId));
        if (infoMap != null) {
            dy.set("adminorghis", infoMap.get("id"));
            dy.set("orglonghisid", infoMap.get("adminorgstructvid"));
            dy.set("orglongnumber", infoMap.get("longnumber"));
        }
    }

    private Long saveExternalRecord(ChgExternalRecordDto chgExternalRecord) {
        DynamicObject fileChgRedDy = RECORD_HELPER.generateEmptyDynamicObject();
        DynamicObject action = this.getActionById(chgExternalRecord.getActionId());
        fileChgRedDy.set("chgaction", (Object)action);
        fileChgRedDy.set("chgcategory", action.get("chgcategory"));
        fileChgRedDy.set("datastatus", (Object)"1");
        fileChgRedDy.set("effecttime", (Object)chgExternalRecord.getBsed());
        fileChgRedDy.set("billno", (Object)chgExternalRecord.getBillNo());
        fileChgRedDy.set("billsource", (Object)chgExternalRecord.getBillSource());
        DynamicObjectCollection collection = fileChgRedDy.getDynamicObjectCollection("entryentity");
        this.formatCollection(chgExternalRecord, collection);
        ParserUtil.setSysField(fileChgRedDy);
        RECORD_HELPER.saveOne(fileChgRedDy);
        return fileChgRedDy.getLong("id");
    }

    private void formatCollection(ChgExternalRecordDto chgExternalRecord, DynamicObjectCollection collection) {
        ArrayList<String> personModels = new ArrayList<String>(Arrays.asList(PerModelConstants.PERSON_MODEL_PAGES));
        this.formatDataRow(chgExternalRecord, collection, personModels);
        if (CollectionUtils.isEmpty(personModels)) {
            return;
        }
        this.completePersonModelRecord(chgExternalRecord, collection, personModels);
    }

    private void formatDataRow(ChgExternalRecordDto chgExternalRecord, DynamicObjectCollection collection, List<String> personModels) {
        List<Map<String, List<ChgExternalDataEntryDto>>> dataRow = chgExternalRecord.getDataRow();
        if (CollectionUtils.isEmpty(dataRow)) {
            return;
        }
        dataRow.forEach(entityMap -> entityMap.forEach((entity, datas) -> {
            personModels.remove(entity);
            datas.forEach(data -> {
                DynamicObject dynNew = collection.addNew();
                ChgRecordEntryDto.recordEntrySetValue(dynNew, entity, data);
            });
        }));
    }

    private void completePersonModelRecord(ChgExternalRecordDto chgExternalRecord, DynamicObjectCollection collection, List<String> personModels) {
        DynamicObject dynNew;
        if (chgExternalRecord.getPersonId() != null && personModels.contains("hrpi_person")) {
            dynNew = collection.addNew();
            dynNew.set("chgentity", (Object)"hrpi_person");
            dynNew.set("idbefore", (Object)chgExternalRecord.getPersonId());
            dynNew.set("idafter", (Object)chgExternalRecord.getPersonId());
            dynNew.set("chgmode", (Object)ChgModeEnum.UNCHANGED.getChgMode());
        }
        if (chgExternalRecord.getEmployeeId() != null && personModels.contains("hrpi_employee")) {
            dynNew = collection.addNew();
            dynNew.set("chgentity", (Object)"hrpi_employee");
            dynNew.set("idbefore", (Object)chgExternalRecord.getEmployeeId());
            dynNew.set("idafter", (Object)chgExternalRecord.getEmployeeId());
            dynNew.set("chgmode", (Object)ChgModeEnum.UNCHANGED.getChgMode());
        }
        if (chgExternalRecord.getCmpEmpId() != null && personModels.contains("hrpi_cmpemp")) {
            dynNew = collection.addNew();
            dynNew.set("chgentity", (Object)"hrpi_cmpemp");
            dynNew.set("idbefore", (Object)chgExternalRecord.getCmpEmpId());
            dynNew.set("idafter", (Object)chgExternalRecord.getCmpEmpId());
            dynNew.set("chgmode", (Object)ChgModeEnum.UNCHANGED.getChgMode());
        }
        if (chgExternalRecord.getDepEmpId() != null && personModels.contains("hrpi_depemp")) {
            dynNew = collection.addNew();
            dynNew.set("chgentity", (Object)"hrpi_depemp");
            dynNew.set("idbefore", (Object)chgExternalRecord.getDepEmpId());
            dynNew.set("idafter", (Object)chgExternalRecord.getDepEmpId());
            dynNew.set("chgmode", (Object)ChgModeEnum.UNCHANGED.getChgMode());
        }
    }

    public void execute(String msg) {
        ChgRecordExecutorDto chgRecordExecutor;
        try {
            chgRecordExecutor = (ChgRecordExecutorDto)SerializationUtils.fromJsonString((String)msg, ChgRecordExecutorDto.class);
        }
        catch (Exception e) {
            LOGGER.error("CHG_HPFS_RECORD_EXECUTOR_ERROR:parameter parse error", (Throwable)e);
            ChgLogHelper.writeErrorLogBeforeChg(null, e);
            return;
        }
        String operation = chgRecordExecutor.getOperation();
        DynamicObject dyn = this.getRawDyn(chgRecordExecutor);
        DynamicObject action = this.getActionById(chgRecordExecutor.getActionId());
        String errorMsg = this.validate(operation, dyn, action);
        String msgReturned = this.formatMsgReturned(errorMsg, chgRecordExecutor, dyn, action);
        if (HRStringUtils.isEmpty((String)chgRecordExecutor.getResultCallBackQueue())) {
            return;
        }
        MQHelper.publish(msgReturned, chgRecordExecutor.getResultCallBackQueue());
    }

    private String formatMsgReturned(String errorMsg, ChgRecordExecutorDto chgRecordExecutor, DynamicObject dyn, DynamicObject action) {
        String msgReturned;
        if (HRStringUtils.isEmpty((String)errorMsg)) {
            Long recordId = this.saveRecord(chgRecordExecutor, dyn, action);
            msgReturned = this.formatParamReturn(chgRecordExecutor, true, null);
            ChgLogHelper.updateSuccessLog(chgRecordExecutor, recordId, msgReturned);
        } else {
            msgReturned = this.formatParamReturn(chgRecordExecutor, false, errorMsg);
            ChgLogHelper.updateErrorLog(chgRecordExecutor, errorMsg, msgReturned);
        }
        return msgReturned;
    }

    private DynamicObject getRawDyn(ChgRecordExecutorDto chgRecordExecutor) {
        String billId = chgRecordExecutor.getBillId();
        String billSource = chgRecordExecutor.getBillSource();
        QFilter billQFilter = new QFilter("bill", "=", (Object)Long.parseLong(billId));
        QFilter sourceQFilter = new QFilter("billsource", "=", (Object)billSource);
        QFilter statusQFilter = new QFilter("datastatus", "!=", (Object)ChgRecordStatusEnum.TERMINATED.getCode());
        return RECORD_HELPER.loadDynamicObject(new QFilter[]{billQFilter, sourceQFilter, statusQFilter});
    }

    private DynamicObject getActionById(String actionId) {
        return this.getActionById(Long.parseLong(actionId));
    }

    private DynamicObject getActionById(Long actionId) {
        HRBaseServiceHelper actionHelper = new HRBaseServiceHelper("hpfs_chgaction");
        return actionHelper.loadDynamicObject(new QFilter("id", "=", (Object)actionId));
    }

    private String validate(String operation, DynamicObject dyn, DynamicObject action) {
        String errorMsg = "";
        errorMsg = errorMsg + this.validateAction(action);
        errorMsg = errorMsg + this.validateOperation(operation, dyn);
        return errorMsg;
    }

    private String validateAction(DynamicObject action) {
        if (action == null) {
            return ResManager.loadKDString((String)"\u8be5\u53d8\u52a8\u64cd\u4f5c\u4e0d\u5b58\u5728\u3002", (String)"ChgRecordExecutorService_6", (String)"hr-hpfs-business", (Object[])new Object[0]);
        }
        return "";
    }

    private String validateOperation(String operation, DynamicObject dyn) {
        switch (operation) {
            case "1010": {
                return dyn == null ? "" : ResManager.loadKDString((String)"\u8be5\u5355\u636e\u5df2\u5b58\u5728\uff0c\u65e0\u6cd5\u518d\u6b21\u63d0\u4ea4\u3002", (String)"ChgRecordExecutorService_1", (String)"hr-hpfs-business", (Object[])new Object[0]);
            }
            case "1020": {
                return dyn == null || HRStringUtils.equals((String)dyn.getString("datastatus"), (String)ChgRecordStatusEnum.SUBMITTED.getCode()) ? "" : ResManager.loadKDString((String)"\u8be5\u5355\u636e\u5df2\u751f\u6548\u6216\u5df2\u5904\u4e8e\u5f85\u751f\u6548\u72b6\u6001\uff0c\u65e0\u6cd5\u4fee\u6539\u8be5\u5355\u636e\u3002", (String)"ChgRecordExecutorService_7", (String)"hr-hpfs-business", (Object[])new Object[0]);
            }
            case "1030": {
                return dyn != null && !HRStringUtils.equals((String)dyn.getString("datastatus"), (String)ChgRecordStatusEnum.CHANGED.getCode()) ? "" : ResManager.loadKDString((String)"\u8be5\u5355\u636e\u4e0d\u5b58\u5728\u6216\u5df2\u751f\u6548\uff0c\u65e0\u6cd5\u4fee\u6539\u6570\u636e\u3002", (String)"ChgRecordExecutorService_3", (String)"hr-hpfs-business", (Object[])new Object[0]);
            }
            case "1040": {
                return dyn != null && !HRStringUtils.equals((String)dyn.getString("datastatus"), (String)ChgRecordStatusEnum.CHANGED.getCode()) ? "" : ResManager.loadKDString((String)"\u8be5\u5355\u636e\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u7ec8\u6b62\u8be5\u5355\u636e\u3002", (String)"ChgRecordExecutorService_8", (String)"hr-hpfs-business", (Object[])new Object[0]);
            }
        }
        return ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u8be5\u64cd\u4f5c\u3002", (String)"ChgRecordExecutorService_5", (String)"hr-hpfs-business", (Object[])new Object[0]);
    }

    private Long saveRecord(ChgRecordExecutorDto chgRecordExecutor, DynamicObject dyn, DynamicObject action) {
        if (dyn == null) {
            dyn = RECORD_HELPER.generateEmptyDynamicObject();
            dyn.set("bill", (Object)chgRecordExecutor.getBillId());
            dyn.set("billno", (Object)chgRecordExecutor.getBillNo());
            dyn.set("billsource", (Object)chgRecordExecutor.getBillSource());
        }
        dyn.set("effecttime", (Object)chgRecordExecutor.getBsed());
        dyn.set("chgcategory", (Object)action.getDynamicObject("chgcategory"));
        dyn.set("chgaction", (Object)action);
        this.setRuleByAction(action.getLong("id"), dyn);
        String statusCode = ChgRecordStatusEnum.getCodeByOperation(chgRecordExecutor.getOperation());
        this.formatIdsRecord(dyn, chgRecordExecutor);
        if (StringUtils.isNotEmpty((String)statusCode)) {
            dyn.set("datastatus", (Object)statusCode);
        }
        ParserUtil.setSysField(dyn);
        RECORD_HELPER.saveOne(dyn);
        return dyn.getLong("id");
    }

    private void setRuleByAction(Long actionId, DynamicObject record) {
        HRBaseServiceHelper ruleHelper = new HRBaseServiceHelper("hpfs_chgrule");
        DynamicObject rule = ruleHelper.loadDynamicObject(new QFilter("chgaction", "=", (Object)actionId));
        record.set("chgrule", (Object)rule);
    }

    private void formatIdsRecord(DynamicObject record, ChgRecordExecutorDto chgRecordExecutor) {
        DynamicObject dyn;
        DynamicObjectCollection collection = record.getDynamicObjectCollection("entryentity");
        collection.clear();
        if (chgRecordExecutor.getPersonId() != null) {
            dyn = collection.addNew();
            dyn.set("chgentity", (Object)"hrpi_person");
            dyn.set("chgmode", (Object)ChgModeEnum.UNCHANGED.getChgMode());
            dyn.set("idbefore", (Object)chgRecordExecutor.getPersonId());
        }
        if (chgRecordExecutor.getEmployeeId() != null) {
            dyn = collection.addNew();
            dyn.set("chgentity", (Object)"hrpi_employee");
            dyn.set("chgmode", (Object)ChgModeEnum.UNCHANGED.getChgMode());
            dyn.set("idbefore", (Object)chgRecordExecutor.getEmployeeId());
        }
        if (chgRecordExecutor.getManagingScopeId() != null) {
            dyn = collection.addNew();
            dyn.set("chgentity", (Object)"hrpi_cmpemp");
            dyn.set("chgmode", (Object)ChgModeEnum.UNCHANGED.getChgMode());
            dyn.set("idbefore", (Object)chgRecordExecutor.getManagingScopeId());
        }
        if (chgRecordExecutor.getDepEmpId() != null) {
            dyn = collection.addNew();
            dyn.set("chgentity", (Object)"hrpi_depemp");
            dyn.set("chgmode", (Object)ChgModeEnum.UNCHANGED.getChgMode());
            dyn.set("idbefore", (Object)chgRecordExecutor.getDepEmpId());
        }
    }

    private String formatParamReturn(ChgRecordExecutorDto chgRecordExecutor, boolean success, String msg) {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("success", success);
        map.put("operation", chgRecordExecutor.getOperation());
        map.put("billid", chgRecordExecutor.getBillId());
        map.put("msg", msg);
        return SerializationUtils.toJsonString(map);
    }
}

