/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hpfs.business.perchg.executor.service;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hpfs.business.perchg.executor.enums.ChgModeEnum;
import kd.hr.hpfs.business.perchg.parser.EntityParserFactory;
import kd.hr.hpfs.business.perchg.parser.ParserResult;
import kd.hr.hpfs.business.perchg.parser.parserentity.DefaultEntityParser;
import kd.hr.hpfs.business.perchg.parser.util.ParserUtil;
import kd.sdk.hr.hpfs.business.perchg.bizentity.PerChgBizInfo;

public class ExecutorDataFormatService {
    private static final Log LOGGER = LogFactory.getLog(ExecutorDataFormatService.class);
    private static final ExecutorDataFormatService EXECUTOR_DATA_FORMAT_SERVICE = new ExecutorDataFormatService();

    public ExecutorDataFormatService getInstance() {
        return EXECUTOR_DATA_FORMAT_SERVICE;
    }

    public static Map<String, DynamicObjectCollection> handleParserResult(List<ParserResult> parserResult) {
        HashMap dynMap = Maps.newHashMapWithExpectedSize((int)parserResult.size());
        for (ParserResult pr : parserResult) {
            DynamicObjectCollection doc;
            DynamicObject dy = (DynamicObject)pr.getParserParam().get("hisDy");
            String entityName = (String)pr.getParserParam().get("entityName");
            if (dynMap.containsKey(entityName)) {
                doc = (DynamicObjectCollection)dynMap.get(entityName);
                try {
                    doc.add((Object)dy);
                    continue;
                }
                catch (Exception e) {
                    String errorInfo = String.format(Locale.ROOT, "CHG_HPFS_ERROR_handleParserResult entityName: %s, dy:%s", entityName, SerializationUtils.toJsonString((Object)dy));
                    LOGGER.error(errorInfo, (Throwable)e);
                    throw new KDException((Throwable)e, new ErrorCode("handleParserResult", e.getMessage()), new Object[0]);
                }
            }
            doc = new DynamicObjectCollection();
            doc.add((Object)dy);
            dynMap.put(entityName, doc);
        }
        return dynMap;
    }

    public static List<Map<String, DynamicObjectCollection>> formatDataByApiFormat(Map<String, DynamicObjectCollection> dynMap) {
        return dynMap.values().stream().map(collection -> {
            HashMap<String, DynamicObjectCollection> map = new HashMap<String, DynamicObjectCollection>();
            map.put("hisDyns", (DynamicObjectCollection)collection);
            return map;
        }).collect(Collectors.toList());
    }

    public static void formatNewHisWithoutMap(List<ParserResult> tacticResult, Map<String, List<DynamicObject>> sourceData, PerChgBizInfo bizInfo, String chgMode, List<String> pages, long tacticId, String appointedSource, Map<String, String> appointedValue2FieldMap) {
        List entityName = tacticResult.stream().map(row -> (String)row.getParserParam().get("entityName")).distinct().collect(Collectors.toList());
        List<DynamicObject> sourceDataList = sourceData.get(appointedSource);
        if (!CollectionUtils.isEmpty(tacticResult) && !CollectionUtils.isEmpty(sourceDataList)) {
            DynamicObject sourceDyn = sourceDataList.get(0);
            tacticResult.forEach(row -> {
                DynamicObject dyn = (DynamicObject)row.getParserParam().get("hisDy");
                DataEntityPropertyCollection collection = dyn.getDataEntityType().getProperties();
                String dynEntityName = (String)row.getParserParam().get("entityName");
                appointedValue2FieldMap.forEach((field, fieldSource) -> {
                    if (collection.get(field) == null) {
                        return;
                    }
                    if (HRStringUtils.equals((String)dynEntityName, (String)"hrpi_emporgrelall")) {
                        if (sourceDyn.get(fieldSource) instanceof DynamicObject) {
                            dyn.set(field, ((DynamicObject)sourceDyn.get(fieldSource)).get("name"));
                        } else if (sourceDyn.get(fieldSource) instanceof Long) {
                            dyn.set(field, (Object)String.valueOf(sourceDyn.get(fieldSource)));
                        }
                    } else {
                        try {
                            dyn.set(field, sourceDyn.get(fieldSource));
                        }
                        catch (Exception e) {
                            throw new KDException(new ErrorCode("formatNewHisWithoutMap", e.getMessage()), "", (Throwable)e);
                        }
                    }
                });
            });
        }
        pages.forEach(page -> {
            if (CollectionUtils.isEmpty((Collection)entityName) || !entityName.contains(page)) {
                List<ParserResult> dyns = ExecutorDataFormatService.formatNewHisWithoutMap(sourceData, page, bizInfo, chgMode, tacticId, appointedSource, appointedValue2FieldMap);
                tacticResult.addAll(dyns);
            }
        });
    }

    public static List<ParserResult> formatNewHisWithoutMap(Map<String, List<DynamicObject>> sourceData, String changeObject, PerChgBizInfo bizInfo, String chgMode, long tacticId, String appointedSource, Map<String, String> appointedValue2FieldMap) {
        ArrayList<ParserResult> tacticResult = new ArrayList<ParserResult>();
        DefaultEntityParser parser = (DefaultEntityParser)EntityParserFactory.getInstance().createParser(changeObject, bizInfo, chgMode, sourceData, tacticId);
        List<DynamicObject> source = sourceData.get(changeObject);
        if (HRStringUtils.equals((String)chgMode, (String)ChgModeEnum.ADD_NEW.getChgMode())) {
            if (HRStringUtils.isEmpty((String)appointedSource) || CollectionUtils.isEmpty((Collection)sourceData.get(appointedSource))) {
                ParserResult parserResult = ExecutorDataFormatService.formatTacticResult(parser, null, changeObject, appointedValue2FieldMap, bizInfo, null);
                tacticResult.add(parserResult);
                return tacticResult;
            }
            List<DynamicObject> appointedSourceList = sourceData.get(appointedSource);
            appointedSourceList.stream().filter(ParserUtil::filterCurrentFromOrigin).forEach(row -> {
                ParserResult parserResult = ExecutorDataFormatService.formatTacticResult(parser, row, changeObject, appointedValue2FieldMap, bizInfo, null);
                tacticResult.add(parserResult);
            });
            return tacticResult;
        }
        LOGGER.info("formatNewHisWithoutMap changeObject is {}", (Object)changeObject);
        if (null == source || source.size() == 0) {
            LOGGER.warn("formatNewHisWithoutMap source is empty, changeObject is {}", (Object)changeObject);
            return tacticResult;
        }
        DynamicObject appointedDynamic = sourceData.get(appointedSource) == null ? null : sourceData.get(appointedSource).get(0);
        source.stream().filter(ParserUtil::filterCurrentAndDataEffectFromOrigin).forEach(row -> {
            ParserResult parserResult = ExecutorDataFormatService.formatTacticResult(parser, appointedDynamic, changeObject, appointedValue2FieldMap, bizInfo, row);
            tacticResult.add(parserResult);
        });
        return tacticResult;
    }

    public static ParserResult formatTacticResult(DefaultEntityParser parser, DynamicObject origin, String changeObject, Map<String, String> appointedValue2FieldMap, PerChgBizInfo bizInfo, DynamicObject dataOrigin) {
        DynamicObject hisDy = parser.formatNewDy(dataOrigin);
        DataEntityPropertyCollection collection = hisDy.getDataEntityType().getProperties();
        if (origin != null) {
            appointedValue2FieldMap.forEach((k, v) -> {
                try {
                    if (collection.get(k) != null) {
                        ParserUtil.setValue(origin, v, hisDy, k, changeObject, bizInfo);
                    }
                }
                catch (Exception e) {
                    LOGGER.error("formatTacticResult error: source-{} target-{}", v, k);
                    throw new KDException(new ErrorCode("formatTacticResult", e.getMessage()), "", (Throwable)e);
                }
            });
        }
        return ExecutorDataFormatService.formatTacticResult(hisDy, changeObject);
    }

    public static ParserResult formatTacticResult(DynamicObject hisDy, String changeObject) {
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        map.put("hisDy", hisDy);
        map.put("entityName", changeObject);
        ParserResult parserResult = new ParserResult();
        parserResult.setParserParam(map);
        return parserResult;
    }
}

