/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hpfs.business.perchg.executor.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hpfs.business.domain.repository.hrpi.PersonEntityConfRepository;
import kd.hr.hpfs.business.perchg.executor.service.ExecutorDataFormatService;
import kd.hr.hpfs.business.perchg.executor.util.PerChgUtils;
import kd.hrmp.hrpi.business.domian.service.HRPIServiceFactory;
import kd.sdk.hr.hpfs.business.perchg.bizentity.PerChgBizInfo;
import kd.sdk.hr.hpfs.business.perchg.executor.enums.ChgLogEntryStatusEnum;
import kd.sdk.hr.hpfs.business.perchg.executor.enums.ChgModeEnum;
import kd.sdk.hr.hpfs.business.perchg.executor.model.ChgRecordEntryDto;
import kd.sdk.hr.hpfs.common.constants.ChgConstants;

public class HRPISaveService
implements ChgConstants {
    private static final Log LOGGER = LogFactory.getLog(HRPISaveService.class);
    private static final HRPISaveService HRPI_SAVE_SERVICE = new HRPISaveService();

    public static HRPISaveService getInstance() {
        return HRPI_SAVE_SERVICE;
    }

    public void saveBatchData(Map<String, DynamicObjectCollection> dynMap, PerChgBizInfo bizInfo) {
        List<Map<String, DynamicObjectCollection>> dynList = ExecutorDataFormatService.formatDataByApiFormat(dynMap);
        Map res = HRPIServiceFactory.personGenericService.saveBatch(this.formatParamMap(dynList, bizInfo));
        List<Map<String, Object>> dataRes = this.parseVersionChangeRespDataList(res, bizInfo);
        this.writeBackVidAfterSuccess(dataRes, bizInfo);
        this.invalidOldPersonAttach(bizInfo);
    }

    private Map<String, Object> formatParamMap(List<Map<String, DynamicObjectCollection>> dynList, PerChgBizInfo bizInfo) {
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        map.put("caller", "hpfs");
        map.put("eventId", bizInfo.getEventId());
        map.put("mustAllSuccess", Boolean.TRUE);
        map.put("data", dynList);
        return map;
    }

    private void writeBackVidAfterSuccess(List<Map<String, Object>> dataRes, PerChgBizInfo bizInfo) {
        HashMap<String, Map> idMaps = new HashMap<String, Map>(16);
        dataRes.forEach(row -> {
            DynamicObject[] dyns;
            String entityNumber = (String)row.get("entitynumber");
            for (DynamicObject dyn : dyns = (DynamicObject[])row.get("newDynamicObjects")) {
                if (dyn.getLong("boid") == dyn.getLong("id")) continue;
                idMaps.computeIfAbsent(entityNumber, mapNew -> new HashMap(1)).put(dyn.getLong("boid"), dyn.getLong("id"));
            }
            if (dyns.length == 1) {
                idMaps.computeIfAbsent(entityNumber, mapNew -> new HashMap(1)).put(dyns[0].getLong("boid"), dyns[0].getLong("sourcevid"));
            }
        });
        idMaps.forEach((entityName, idMap) -> idMap.forEach((boid, vid) -> {
            List list = (List)bizInfo.getIdsRecord().get(entityName);
            if (CollectionUtils.isEmpty((Collection)list)) {
                bizInfo.setIdsRecord(entityName, ChgRecordEntryDto.formatRecord(null, null, (Long)boid, (Long)vid, (String)"", (String)""));
            } else {
                list.stream().filter(row -> boid.equals(row.getIdAfter()) || boid.equals(row.getIdBefore())).forEach(row -> row.setVidAfter(vid));
            }
        }));
    }

    private void invalidOldPersonAttach(PerChgBizInfo bizInfo) {
        if (!PerChgUtils.skipCreateNewPerson(bizInfo)) {
            LOGGER.info("skipCreateNewPerson result is false, pass invalidOldPersonAttach");
            return;
        }
        List<String> personAttachEntityNumber = PersonEntityConfRepository.getPersonAttachEntityNumber();
        LOGGER.debug("invalidOldPersonAttach begin, the personId is {} ,the personAttachEntityNumber", (Object)bizInfo.getOldPersonId(), (Object)(Objects.nonNull(personAttachEntityNumber) && personAttachEntityNumber.size() > 0 ? SerializationUtils.toJsonString(personAttachEntityNumber) : ""));
        HashMap<String, List> createMap = new HashMap<String, List>();
        Map idsRecord = bizInfo.getIdsRecord();
        idsRecord.forEach((entityNumber, records) -> {
            if (personAttachEntityNumber.contains(entityNumber) && Objects.nonNull(records) && records.size() > 0) {
                records.stream().filter(record -> ChgModeEnum.ADD_NEW.getChgMode().equals(record.getChgMode())).forEach(record -> createMap.computeIfAbsent((String)entityNumber, list -> new ArrayList()).add(record.getIdAfter()));
            }
        });
        QFilter personFilter = new QFilter("person.id", "=", (Object)bizInfo.getOldPersonId());
        QFilter datastatusFilter = new QFilter("datastatus", "=", (Object)"1");
        QFilter iscurrentversionFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        createMap.forEach((entityName, ids) -> {
            HRBaseServiceHelper attachServiceHelper = new HRBaseServiceHelper(entityName);
            QFilter newBoidFilter = new QFilter("boid", "not in", ids);
            DynamicObject[] attachDataArr = attachServiceHelper.loadDynamicObjectArray(new QFilter[]{personFilter, datastatusFilter, iscurrentversionFilter, newBoidFilter});
            if (Objects.nonNull(attachDataArr) && attachDataArr.length > 0) {
                Arrays.stream(attachDataArr).forEach(attachData -> {
                    attachData.set("datastatus", (Object)"99");
                    bizInfo.setIdsRecord(entityName, ChgRecordEntryDto.formatRecord((Long)attachData.getLong("id"), (Long)attachData.getLong("sourcevid"), (Long)attachData.getLong("id"), null, (String)ChgModeEnum.INVALID.getChgMode(), (String)""));
                });
                attachServiceHelper.updateDatas(attachDataArr);
            } else {
                LOGGER.warn("HRPISaveService#invalidOldPersonAttach not currentversionData, the entityName is {}, personid {}", entityName, (Object)bizInfo.getOldPersonId());
            }
        });
    }

    private List<Map<String, Object>> parseVersionChangeRespDataList(Map<String, Object> res, PerChgBizInfo bizInfo) {
        ArrayList<Map<String, Object>> successDataList = new ArrayList(10);
        StringBuilder errorMsg = new StringBuilder();
        try {
            List data = (List)res.get("data");
            if (data != null) {
                Map dataMap = (Map)((Map)data.get(0)).get("data");
                successDataList = (List)dataMap.get("versionChangeRespDataList");
                errorMsg.append(((Map)data.get(0)).get("errorMessage") == null ? "" : (String)((Map)data.get(0)).get("errorMessage"));
            }
            this.appendErrorMsg(res, errorMsg, bizInfo);
        }
        catch (Exception e) {
            String errorInfo = String.format(Locale.ROOT, "CHG_HPFS_ERROR saveBatchData.parseVersionChangeRespDataList res error format res : %s", res == null ? null : SerializationUtils.toJsonString(res));
            LOGGER.error(errorInfo, (Throwable)e);
            throw new KDException((Throwable)e, new ErrorCode("parseVersionChangeRespDataList", errorInfo), new Object[0]);
        }
        if (HRStringUtils.isNotEmpty((String)errorMsg.toString())) {
            String errorInfo = String.format(Locale.ROOT, "saveBatchData.parseVersionChangeRespDataList save fail , errorInfo : %s", errorMsg);
            throw new KDException((Throwable)new RuntimeException(), new ErrorCode("parseVersionChangeRespDataList", errorInfo), new Object[0]);
        }
        this.writeBackSaveSuccessStatus(bizInfo);
        return successDataList;
    }

    private void appendErrorMsg(Map<String, Object> res, StringBuilder stringBuilder, PerChgBizInfo bizInfo) {
        List errInfos = (List)res.get("errInfos");
        if (CollectionUtils.isEmpty((Collection)errInfos)) {
            LOGGER.warn("CHG_HPFS_WARN appendErrorMsg errInfos is empty");
            return;
        }
        HashMap<String, String> entityErrMap = new HashMap<String, String>(16);
        HashMap<String, Map<Long, String>> entityIdErrMap = new HashMap<String, Map<Long, String>>(16);
        errInfos.forEach(errorInfo -> {
            List errDatas;
            String exceptionMessage;
            String entityNumber = (String)errorInfo.get("entityNumber");
            stringBuilder.append(entityNumber).append(":");
            String string = exceptionMessage = errorInfo.get("exceptionMessage") == null ? "" : (String)errorInfo.get("exceptionMessage");
            if (HRStringUtils.isNotEmpty((String)exceptionMessage)) {
                entityErrMap.put(entityNumber, exceptionMessage);
                stringBuilder.append(exceptionMessage).append(";");
            }
            if (CollectionUtils.isEmpty((Collection)(errDatas = (List)errorInfo.get("errorDatas")))) {
                LOGGER.warn("CHG_HPFS_WARN appendErrorMsg errDatas is empty");
                return;
            }
            errDatas.forEach(errData -> {
                Long id = (Long)errData.get("id");
                String errMsg = (String)errData.get("errMsg");
                stringBuilder.append(id).append(":").append(errMsg).append(";");
                entityIdErrMap.computeIfAbsent(entityNumber, map -> new HashMap(16)).put(id, errMsg);
            });
        });
        this.writeBackSaveFailStatus(bizInfo, entityIdErrMap, entityErrMap);
    }

    private void writeBackSaveFailStatus(PerChgBizInfo bizInfo, Map<String, Map<Long, String>> entityIdErrMap, Map<String, String> entityErrMap) {
        Map logEntryMap = bizInfo.getLogEntryMap();
        logEntryMap.forEach((entityName, idMap) -> {
            String entityErr = (String)entityErrMap.get(entityName);
            idMap.forEach((id, dto) -> {
                Map idErrMap = (Map)entityIdErrMap.get(entityName);
                if (HRStringUtils.isNotEmpty((String)entityErr)) {
                    dto.setSaveStatus(ChgLogEntryStatusEnum.FAIL.getCode());
                    dto.setErrorMsg(entityErr);
                } else if (CollectionUtils.isEmpty((Map)idErrMap) || HRStringUtils.isEmpty((String)((String)idErrMap.get(id)))) {
                    dto.setSaveStatus(ChgLogEntryStatusEnum.SKIP.getCode());
                } else {
                    dto.setSaveStatus(ChgLogEntryStatusEnum.FAIL.getCode());
                    dto.setErrorMsg((String)idErrMap.get(id));
                }
            });
        });
    }

    private void writeBackSaveSuccessStatus(PerChgBizInfo bizInfo) {
        Map logEntryMap = bizInfo.getLogEntryMap();
        logEntryMap.forEach((entityName, idMap) -> idMap.forEach((id, dto) -> {
            if (HRStringUtils.equals((String)dto.getValidStatus(), (String)ChgLogEntryStatusEnum.SUCCESS.getCode())) {
                dto.setSaveStatus(ChgLogEntryStatusEnum.SUCCESS.getCode());
            } else {
                dto.setSaveStatus(ChgLogEntryStatusEnum.SKIP.getCode());
            }
        }));
    }
}

