/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hpfs.business.perchg.executor.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRPerserlenHelper;
import kd.hr.hpfs.business.domain.repository.RepositoryUtils;
import kd.hr.hpfs.business.domain.repository.hspm.ErManFileRepository;
import kd.hr.hpfs.business.perchg.executor.model.enums.FindAllBusinessScheduleEnum;
import kd.hr.hpfs.business.perchg.executor.util.PerChgUtils;
import kd.hr.hpfs.business.perchg.parser.util.ParserUtil;
import kd.hr.hpfs.common.constants.ChgStrategyConstants;
import kd.hr.hpfs.common.constants.PerModelConstants;
import kd.hr.hpfs.common.perchg.PerChgBizOperateType;
import kd.sdk.hr.hpfs.business.perchg.bizentity.PerChgBizInfo;
import kd.sdk.hr.hpfs.common.constants.ChgConstants;

public class InitDataQueryService
implements PerModelConstants,
ChgConstants,
ChgStrategyConstants {
    public Map<Long, Map<String, List<DynamicObject>>> getAllBillTrueData(List<PerChgBizInfo> bizInfoList, PerChgBizOperateType operateType) {
        HashMap<Long, Map<String, List<DynamicObject>>> trueData = new HashMap<Long, Map<String, List<DynamicObject>>>(bizInfoList.size());
        if (PerChgBizOperateType.CHGOPERATION_EFFECT == operateType || PerChgBizOperateType.CHGOPERATION_DISCARDSCHEDULE == operateType) {
            bizInfoList.forEach(bizInfo -> {
                Map cfr_ignored_0 = trueData.put(bizInfo.getBillId(), null);
            });
            return trueData;
        }
        HashMap<String, Map<String, Set<Long>>> querySourceEntity = new HashMap<String, Map<String, Set<Long>>>(8);
        for (PerChgBizInfo perChgBizInfo : bizInfoList) {
            Map<String, Map<String, Set<Long>>> queryMap = this.formatQuery(perChgBizInfo);
            queryMap.forEach((entityName, qryMap) -> qryMap.forEach((field, val) -> querySourceEntity.computeIfAbsent((String)entityName, map -> new HashMap()).computeIfAbsent(field, set -> new HashSet()).addAll(val)));
        }
        Map<String, List<DynamicObject>> allData = this.queryData(querySourceEntity);
        for (PerChgBizInfo perChgBizInfo : bizInfoList) {
            Long billId = perChgBizInfo.getBillId();
            Map billData = trueData.computeIfAbsent(billId, map -> new HashMap());
            Map<String, Map<String, Set<Long>>> queryMap = this.formatQuery(perChgBizInfo);
            queryMap.forEach((entityName, query) -> {
                List entityData = billData.computeIfAbsent(entityName, list -> new ArrayList());
                entityData.addAll(((List)allData.get(entityName)).stream().filter(this.formatPredicate((Map<String, Set<Long>>)query)).collect(Collectors.toList()));
            });
        }
        return trueData;
    }

    private Predicate<DynamicObject> formatPredicate(Map<String, Set<Long>> query) {
        return row -> {
            for (Map.Entry entry : query.entrySet()) {
                if (!((Set)entry.getValue()).contains(row.getLong((String)entry.getKey()))) continue;
                return true;
            }
            return false;
        };
    }

    public Map<String, Map<String, Set<Long>>> formatQuery(PerChgBizInfo perChgBizInfo) {
        Map dataRow = perChgBizInfo.getDataRow();
        Map<String, Map<String, Set<Long>>> entryQuery = dataRow.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            HashMap queryFieldAndValue = new HashMap(1);
            queryFieldAndValue.put("id", new HashSet((Collection)entry.getValue()));
            return queryFieldAndValue;
        }));
        this.formatOldPersonData(perChgBizInfo, entryQuery);
        return entryQuery;
    }

    public void formatOldPersonData(PerChgBizInfo perChgBizInfo, Map<String, Map<String, Set<Long>>> querySourceEntity) {
        DynamicObject chgRule = perChgBizInfo.getChgRule();
        Set<Long> tacticIds = chgRule.getDynamicObjectCollection("customentryentity").stream().map(row -> row.getLong("chgtactic.id")).collect(Collectors.toSet());
        if (perChgBizInfo.getOldPersonId() != null && perChgBizInfo.getOldPersonId() != 0L) {
            querySourceEntity.computeIfAbsent("hrpi_person", map -> new HashMap(1)).computeIfAbsent("boid", set -> new HashSet()).add(perChgBizInfo.getOldPersonId());
        }
        if (perChgBizInfo.getOldEmployeeId() != null && perChgBizInfo.getOldEmployeeId() != 0L) {
            querySourceEntity.computeIfAbsent("hrpi_employee", map -> new HashMap(1)).computeIfAbsent("boid", set -> new HashSet()).add(perChgBizInfo.getOldEmployeeId());
            querySourceEntity.computeIfAbsent("hrpi_empentrel", map -> new HashMap(1)).computeIfAbsent("employee_id", set -> new HashSet()).add(perChgBizInfo.getOldEmployeeId());
        }
        this.queryCmpEmp(tacticIds, perChgBizInfo, querySourceEntity);
        this.queryDepEmp(tacticIds, perChgBizInfo, querySourceEntity);
        this.queryErmanFile(tacticIds, perChgBizInfo, querySourceEntity);
        this.queryLaborRelRecord(tacticIds, perChgBizInfo, querySourceEntity);
        this.queryPersonLeng(tacticIds, perChgBizInfo, querySourceEntity);
        this.queryBusinessScheduleAll(tacticIds, perChgBizInfo, querySourceEntity);
    }

    private void queryPersonLeng(Set<Long> tacticIds, PerChgBizInfo perChgBizInfo, Map<String, Map<String, Set<Long>>> querySourceEntity) {
        if (PerChgUtils.isReemployment(perChgBizInfo)) {
            querySourceEntity.computeIfAbsent("hrpi_perserlen", map -> new HashMap(1)).computeIfAbsent("employee_id", set -> new HashSet()).add(perChgBizInfo.getOldEmployeeId());
        }
    }

    private void queryCmpEmp(Set<Long> tacticIds, PerChgBizInfo perChgBizInfo, Map<String, Map<String, Set<Long>>> querySourceEntity) {
        if (tacticIds.contains(1100L)) {
            if (perChgBizInfo.getOldEmployeeId() != null && perChgBizInfo.getOldEmployeeId() != 0L) {
                querySourceEntity.computeIfAbsent("hrpi_cmpemp", map -> new HashMap(1)).computeIfAbsent("employee_id", set -> new HashSet()).add(perChgBizInfo.getOldEmployeeId());
                querySourceEntity.computeIfAbsent("hrpi_managingscope", map -> new HashMap(1)).computeIfAbsent("employee_id", set -> new HashSet()).add(perChgBizInfo.getOldEmployeeId());
            }
            return;
        }
        if (perChgBizInfo.getOldComempId() != null && perChgBizInfo.getOldComempId() != 0L) {
            querySourceEntity.computeIfAbsent("hrpi_cmpemp", map -> new HashMap(1)).computeIfAbsent("boid", set -> new HashSet()).add(perChgBizInfo.getOldComempId());
            querySourceEntity.computeIfAbsent("hrpi_managingscope", map -> new HashMap(1)).computeIfAbsent("cmpemp_id", set -> new HashSet()).add(perChgBizInfo.getOldComempId());
        }
    }

    private void queryDepEmp(Set<Long> tacticIds, PerChgBizInfo perChgBizInfo, Map<String, Map<String, Set<Long>>> querySourceEntity) {
        if (tacticIds.contains(1130L)) {
            if (perChgBizInfo.getOldEmployeeId() != null && perChgBizInfo.getOldEmployeeId() != 0L) {
                querySourceEntity.computeIfAbsent("hrpi_depemp", map -> new HashMap(1)).computeIfAbsent("employee_id", set -> new HashSet()).add(perChgBizInfo.getOldEmployeeId());
                querySourceEntity.computeIfAbsent("hrpi_empposorgrel", map -> new HashMap(1)).computeIfAbsent("employee_id", set -> new HashSet()).add(perChgBizInfo.getOldEmployeeId());
                querySourceEntity.computeIfAbsent("hrpi_emporgrelall", map -> new HashMap(1)).computeIfAbsent("employee_id", set -> new HashSet()).add(perChgBizInfo.getOldEmployeeId());
            }
            return;
        }
        if (perChgBizInfo.getOldDepempId() != null && perChgBizInfo.getOldDepempId() != 0L) {
            querySourceEntity.computeIfAbsent("hrpi_depemp", map -> new HashMap(1)).computeIfAbsent("boid", set -> new HashSet()).add(perChgBizInfo.getOldDepempId());
            querySourceEntity.computeIfAbsent("hrpi_empposorgrel", map -> new HashMap(1)).computeIfAbsent("depemp_id", set -> new HashSet()).add(perChgBizInfo.getOldDepempId());
            querySourceEntity.computeIfAbsent("hrpi_emporgrelall", map -> new HashMap(1)).computeIfAbsent("depemp_id", set -> new HashSet()).add(perChgBizInfo.getOldDepempId());
        }
    }

    private void queryErmanFile(Set<Long> tacticIds, PerChgBizInfo perChgBizInfo, Map<String, Map<String, Set<Long>>> querySourceEntity) {
        if (tacticIds.contains(1140L)) {
            if (perChgBizInfo.getOldEmployeeId() != null && perChgBizInfo.getOldEmployeeId() != 0L) {
                querySourceEntity.computeIfAbsent("hspm_ermanfile", map -> new HashMap(1)).computeIfAbsent("employee_id", set -> new HashSet()).add(perChgBizInfo.getOldEmployeeId());
            }
            return;
        }
        if (perChgBizInfo.getOldErfileId() != null && perChgBizInfo.getOldErfileId() != 0L) {
            querySourceEntity.computeIfAbsent("hspm_ermanfile", map -> new HashMap(1)).computeIfAbsent("boid", set -> new HashSet()).add(perChgBizInfo.getOldErfileId());
        }
    }

    private void queryLaborRelRecord(Set<Long> tacticIds, PerChgBizInfo perChgBizInfo, Map<String, Map<String, Set<Long>>> querySourceEntity) {
        Long employeeId = perChgBizInfo.getOldEmployeeId();
        Long erManFileId = perChgBizInfo.getOldErfileId();
        if (tacticIds.contains(1290L) && erManFileId != null) {
            String selectFields = "id, org";
            DynamicObject dyn = ErManFileRepository.getInstance().queryOriginOne(selectFields, erManFileId);
            querySourceEntity.computeIfAbsent("hrpi_laborrelrecord", map -> new HashMap(1)).computeIfAbsent("employee_id", set -> new HashSet()).add(employeeId);
            querySourceEntity.computeIfAbsent("hrpi_laborrelrecord", map -> new HashMap(1)).computeIfAbsent("org_id", set -> new HashSet()).add(dyn.getLong("org"));
        }
        if (tacticIds.contains(1300L)) {
            querySourceEntity.computeIfAbsent("hrpi_laborrelrecord", map -> new HashMap(1)).computeIfAbsent("employee_id", set -> new HashSet()).add(employeeId);
        }
    }

    private void queryBusinessScheduleAll(Set<Long> tacticIds, PerChgBizInfo perChgBizInfo, Map<String, Map<String, Set<Long>>> querySourceEntity) {
        Long employeeId = perChgBizInfo.getOldEmployeeId();
        Arrays.stream(FindAllBusinessScheduleEnum.values()).filter(findAllBusinessScheduleEnum -> tacticIds.contains(findAllBusinessScheduleEnum.getTacticId())).forEach(findAllBusinessScheduleEnum -> this.queryBusinessScheduleAll(querySourceEntity, findAllBusinessScheduleEnum.getEntityName(), employeeId));
    }

    private void queryBusinessScheduleAll(Map<String, Map<String, Set<Long>>> querySourceEntity, String entityName, Long employeeId) {
        querySourceEntity.computeIfAbsent(entityName, map -> new HashMap(1)).computeIfAbsent("employee_id", set -> new HashSet()).add(employeeId);
    }

    public Map<String, List<DynamicObject>> queryData(Map<String, Map<String, Set<Long>>> querySourceEntity) {
        HashMap<String, List<DynamicObject>> allData = new HashMap<String, List<DynamicObject>>(querySourceEntity.size());
        querySourceEntity.forEach((key, value) -> {
            if (value == null || value.size() == 0) {
                allData.put((String)key, new ArrayList());
                return;
            }
            ArrayList qFilters = new ArrayList();
            value.forEach((field, valSet) -> qFilters.add(new QFilter(field, "in", valSet)));
            DynamicObject[] result = new HRBaseServiceHelper(key).loadDynamicObjectArray(qFilters.toArray(new QFilter[0]));
            List hasData = allData.computeIfAbsent((String)key, list -> new ArrayList());
            hasData.addAll(Arrays.stream(result).filter(ParserUtil::filterEffectFromOrigin).collect(Collectors.toList()));
        });
        return allData;
    }

    public void quitAndUpdPerserLen(PerChgBizInfo perChgBizInfo) {
        if (PerChgUtils.isQuit(perChgBizInfo)) {
            QFilter filter;
            HRBaseServiceHelper helper;
            DynamicObject[] perserDys;
            Long employeeId = perChgBizInfo.getOldEmployeeId();
            Long personId = perChgBizInfo.getOldPersonId();
            if (employeeId != null && employeeId != 0L && (perserDys = (helper = new HRBaseServiceHelper("hrpi_perserlen")).loadDynamicObjectArray(new QFilter[]{filter = RepositoryUtils.isDataStatus().and("employee.id", "=", (Object)employeeId)})) != null && perserDys.length > 0) {
                for (DynamicObject perserDy : perserDys) {
                    Date joinDate = perserDy.getDate("joincomdate");
                    BigDecimal adjustcomtime = perserDy.getBigDecimal("adjustcomtime");
                    BigDecimal comserCount = HRPerserlenHelper.calcComsercount((Date)joinDate, (BigDecimal)adjustcomtime, (Long)personId);
                    perserDy.set("comsercount", (Object)comserCount);
                }
                helper.update(perserDys);
            }
        }
    }
}

