/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hpfs.business.perchg.parser;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.orm.ORM;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRHistoryHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hpfs.business.perchg.parser.Parser;
import kd.hr.hpfs.business.perchg.parser.ParserResult;
import kd.hr.hpfs.common.perchg.PerChgBoType;
import kd.sdk.hr.hpfs.business.perchg.bizentity.PerChgBizInfo;

public abstract class AbstractParser
implements Parser {
    protected DynamicObject fieldMapConfig;
    protected DynamicObject chgActionConfig;
    protected PerChgBizInfo bizInfo;
    protected List<DynamicObject> sourceBillTrueData;
    protected List<DynamicObject> originData;
    protected DynamicObject tableMapping;
    protected DynamicObject tableMappingInvalid;
    protected HRBaseServiceHelper hisHelper;
    protected String hisEntityName;
    protected Map<String, Object> parserShareParam;
    protected Map<String, List<DynamicObject>> sourceData;
    protected String chgMode;
    protected Map<String, List<DynamicObject>> source;
    protected String flowType;

    @Override
    public List<ParserResult> addNewParser() {
        EnumMap<PerChgBoType, List<DynamicObject>> data = this.doAddNewParser();
        if (data == null || data.size() == 0) {
            return null;
        }
        ArrayList<ParserResult> resultList = new ArrayList<ParserResult>();
        for (Map.Entry<PerChgBoType, List<DynamicObject>> entry : data.entrySet()) {
            PerChgBoType boType = entry.getKey();
            List<DynamicObject> hisDyList = entry.getValue();
            for (DynamicObject hisDy : hisDyList) {
                ParserResult parserResult = new ParserResult();
                switch (boType) {
                    case NEW: 
                    case MODIFY: {
                        parserResult.getParserParam().put("hisDy", hisDy);
                        parserResult.getParserParam().put("entityName", hisDy.getDataEntityType().getName());
                        resultList.add(parserResult);
                        break;
                    }
                }
            }
        }
        return resultList;
    }

    @Override
    public List<ParserResult> addNewAndEffectParser() {
        EnumMap<PerChgBoType, List<DynamicObject>> data = this.doAddNewAndEffectParser();
        if (data == null || data.size() == 0) {
            return null;
        }
        ArrayList<ParserResult> resultList = new ArrayList<ParserResult>();
        for (Map.Entry<PerChgBoType, List<DynamicObject>> entry : data.entrySet()) {
            PerChgBoType boType = entry.getKey();
            List<DynamicObject> hisDyList = entry.getValue();
            for (DynamicObject hisDy : hisDyList) {
                ParserResult parserResult = new ParserResult();
                switch (boType) {
                    case NEW: 
                    case MODIFY: {
                        parserResult.getParserParam().put("entityName", hisDy.getDataEntityType().getName());
                        parserResult.getParserParam().put("hisDy", hisDy);
                        resultList.add(parserResult);
                        break;
                    }
                }
            }
        }
        return resultList;
    }

    @Override
    public List<ParserResult> effectParser() {
        EnumMap<PerChgBoType, Long> data = this.doEffectParser();
        if (data == null || data.size() == 0) {
            return null;
        }
        ArrayList<ParserResult> resultList = new ArrayList<ParserResult>();
        for (Map.Entry<PerChgBoType, Long> entry : data.entrySet()) {
            PerChgBoType boType = entry.getKey();
            Long eventId = entry.getValue();
            ParserResult parserResult = new ParserResult();
            switch (boType) {
                case NEW: {
                    resultList.add(parserResult);
                    break;
                }
                case MODIFY: {
                    resultList.add(parserResult);
                    break;
                }
            }
        }
        return resultList;
    }

    @Override
    public List<ParserResult> discardScheduleParser() {
        EnumMap<PerChgBoType, Long> data = this.doDiscardScheduleParser();
        if (data == null || data.size() == 0) {
            return null;
        }
        ArrayList<ParserResult> resultList = new ArrayList<ParserResult>();
        for (Map.Entry<PerChgBoType, Long> entry : data.entrySet()) {
            PerChgBoType boType = entry.getKey();
            Long eventId = entry.getValue();
            ParserResult parserResult = new ParserResult();
            switch (boType) {
                case NEW: {
                    resultList.add(parserResult);
                    break;
                }
                case MODIFY: {
                    resultList.add(parserResult);
                    break;
                }
            }
        }
        return resultList;
    }

    @Override
    public List<ParserResult> updateScheduleParser() {
        List<DynamicObject> data = this.doUpdateScheduleParser();
        if (data == null || data.size() == 0) {
            return null;
        }
        ArrayList<ParserResult> resultList = new ArrayList<ParserResult>(data.size());
        for (DynamicObject hisDy : data) {
            ParserResult parserResult = new ParserResult();
            parserResult.getParserParam().put("hisDy", hisDy);
            resultList.add(parserResult);
        }
        return resultList;
    }

    protected abstract EnumMap<PerChgBoType, List<DynamicObject>> doAddNewParser();

    protected abstract EnumMap<PerChgBoType, List<DynamicObject>> doAddNewAndEffectParser();

    protected abstract EnumMap<PerChgBoType, Long> doEffectParser();

    protected abstract EnumMap<PerChgBoType, Long> doDiscardScheduleParser();

    protected abstract List<DynamicObject> doUpdateScheduleParser();

    public DynamicObject getFieldMapConfig() {
        return this.fieldMapConfig;
    }

    public void setFieldMapConfig(DynamicObject fieldMapConfig) {
        this.fieldMapConfig = fieldMapConfig;
    }

    public DynamicObject getChgActionConfig() {
        return this.chgActionConfig;
    }

    public void setChgActionConfig(DynamicObject chgActionConfig) {
        this.chgActionConfig = chgActionConfig;
    }

    public PerChgBizInfo getBizInfo() {
        return this.bizInfo;
    }

    public void setBizInfo(PerChgBizInfo bizInfo) {
        this.bizInfo = bizInfo;
    }

    public List<DynamicObject> getSourceBillTrueData() {
        return this.sourceBillTrueData;
    }

    public void setSourceBillTrueData(List<DynamicObject> sourceBillTrueData) {
        this.sourceBillTrueData = sourceBillTrueData;
    }

    public DynamicObject getTableMapping() {
        return this.tableMapping;
    }

    public void setTableMapping(DynamicObject tableMapping) {
        this.tableMapping = tableMapping;
    }

    public String getChgMode() {
        return this.chgMode;
    }

    public void setChgMode(String chgMode) {
        this.chgMode = chgMode;
    }

    public List<DynamicObject> getOriginData() {
        return this.originData;
    }

    public void setOriginData(List<DynamicObject> originData) {
        this.originData = originData;
    }

    public Map<String, List<DynamicObject>> getSource() {
        return this.source;
    }

    public void setSource(Map<String, List<DynamicObject>> source) {
        this.source = source;
    }

    public String getFlowType() {
        return this.flowType;
    }

    public void setFlowType(String flowType) {
        this.flowType = flowType;
    }

    public void setTableMap(DynamicObject fieldMapConfig) {
        DynamicObjectCollection tableEntry = fieldMapConfig.getDynamicObjectCollection("entryentity");
        for (DynamicObject dy : tableEntry) {
            if (!this.hisEntityName.equals(dy.getString("targetentity.id"))) continue;
            this.setTableMapping(dy);
            break;
        }
    }

    public DynamicObject getTableMappingInvalid() {
        return this.tableMappingInvalid;
    }

    public void setTableMappingInvalid(DynamicObject tableMappingInvalid) {
        this.tableMappingInvalid = tableMappingInvalid;
    }

    public HRBaseServiceHelper getHisHelper() {
        return this.hisHelper;
    }

    public void setHisHelper(HRBaseServiceHelper hisHelper) {
        this.hisHelper = hisHelper;
    }

    public String getHisEntityName() {
        return this.hisEntityName;
    }

    public void setHisEntityName(String hisEntityName) {
        this.hisEntityName = hisEntityName;
    }

    public void setParserShareParam(Map<String, Object> parserShareParam) {
        this.parserShareParam = parserShareParam;
    }

    protected DynamicObjectCollection getFieldEntry() {
        return this.tableMapping.getDynamicObjectCollection("subentryentity");
    }

    protected Long getSourceIdVal(DynamicObject sourceDy) {
        String[] sourcefields;
        String sourcefield = "";
        for (String field : sourcefields = this.tableMapping.getString("sourceprikey").split(",")) {
            if (!HRStringUtils.isNotEmpty((String)field)) continue;
            sourcefield = field;
            break;
        }
        if (HRStringUtils.isNotEmpty((String)sourcefield)) {
            if (sourceDy.get(sourcefield) instanceof Long && sourceDy.getLong(sourcefield) != 0L) {
                return sourceDy.getLong(sourcefield);
            }
            if (sourceDy.get(sourcefield) instanceof DynamicObject && sourceDy.getDynamicObject(sourcefield).getLong("id") != 0L) {
                return sourceDy.getDynamicObject(sourcefield).getLong("id");
            }
        }
        return 0L;
    }

    protected String getTargetKey() {
        return "id";
    }

    protected void setBoValue(DynamicObject newHis) {
        newHis.set("bo", (Object)ORM.create().genLongId(HRHistoryHelper.convertHisEntityToCurrent((String)this.hisEntityName)));
        newHis.set("isnewbo", (Object)Character.valueOf('1'));
    }

    protected void setPersonModelVal(DynamicObject hisDy) {
        Long personId = this.bizInfo.getNewPersonId() == null && this.bizInfo.getOldPersonId() != null ? this.bizInfo.getOldPersonId() : this.bizInfo.getNewPersonId();
        Long employeeId = this.bizInfo.getNewEmployeeId() == null && this.bizInfo.getOldEmployeeId() != null ? this.bizInfo.getOldEmployeeId() : this.bizInfo.getNewEmployeeId();
        Long comEmpId = this.bizInfo.getNewComempId() == null && this.bizInfo.getOldComempId() != null ? this.bizInfo.getOldComempId() : this.bizInfo.getNewComempId();
        Long depEmpId = this.bizInfo.getNewDepempId() == null && this.bizInfo.getOldDepempId() != null ? this.bizInfo.getOldDepempId() : this.bizInfo.getNewDepempId();
        this.setModelVal(hisDy, "person", personId);
        this.setModelVal(hisDy, "employee", employeeId);
        this.setModelVal(hisDy, "cmpemp", comEmpId);
        this.setModelVal(hisDy, "depemp", depEmpId);
    }

    protected void setModelVal(DynamicObject hisDy, String modelField, Long val) {
        DataEntityPropertyCollection depc = hisDy.getDataEntityType().getProperties();
        if (!Objects.isNull(depc.get((Object)modelField)) && val != null && val != 0L) {
            if (hisDy.get(modelField) instanceof DynamicObject) {
                hisDy.set(modelField + "_id", (Object)val);
            }
            hisDy.set(modelField, (Object)val);
        }
    }
}

