/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hpfs.business.perchg.parser;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hpfs.business.perchg.parser.Parser;
import kd.hr.hpfs.business.perchg.parser.parserentity.DefaultEntityParser;
import kd.sdk.hr.hpfs.business.perchg.bizentity.PerChgBizInfo;
import kd.sdk.hr.hpfs.business.perchg.executor.enums.ChgFlowTypeEnum;

public class EntityParserFactory {
    public static final ThreadLocal<Map<String, Object>> SHAREPARAM = ThreadLocal.withInitial(HashMap::new);
    private static final Log LOGGER = LogFactory.getLog(EntityParserFactory.class);
    private static final EntityParserFactory PARSERFACTORY = new EntityParserFactory();

    public static EntityParserFactory getInstance() {
        return PARSERFACTORY;
    }

    public Parser createParser(String entityName, DynamicObject chgActionConfig, DynamicObject fieldMapConfig, List<DynamicObject> sourceEntityData, List<DynamicObject> originEntityData, PerChgBizInfo bizInfo, DynamicObject tableMapping, String chgMode, Map<String, List<DynamicObject>> source, long tacticId) {
        if (entityName == null || entityName.isEmpty()) {
            return null;
        }
        DefaultEntityParser parser = new DefaultEntityParser();
        parser.setBizInfo(bizInfo);
        parser.setChgActionConfig(chgActionConfig);
        parser.setFieldMapConfig(fieldMapConfig);
        parser.setSourceBillTrueData(sourceEntityData);
        parser.setOriginData(originEntityData);
        parser.setHisEntityName(entityName);
        parser.setTableMapping(tableMapping);
        parser.setHisHelper(new HRBaseServiceHelper(entityName));
        parser.setChgMode(chgMode);
        parser.setSource(source);
        String flowType = (String)bizInfo.getTacticFlowTypeMap().get(tacticId);
        parser.setFlowType(HRStringUtils.isEmpty((String)flowType) ? ChgFlowTypeEnum.FLOW_UNRELATED.getFlowType() : flowType);
        return parser;
    }

    public Parser createParser(String entityName, PerChgBizInfo bizInfo, String chgMode, Map<String, List<DynamicObject>> source, long tacticId) {
        if (entityName == null || entityName.isEmpty()) {
            return null;
        }
        DefaultEntityParser parser = new DefaultEntityParser();
        parser.setHisEntityName(entityName);
        parser.setHisHelper(new HRBaseServiceHelper(entityName));
        parser.setBizInfo(bizInfo);
        parser.setChgMode(chgMode);
        parser.setSource(source);
        parser.setOriginData(source.get(entityName));
        String flowType = (String)bizInfo.getTacticFlowTypeMap().get(tacticId);
        parser.setFlowType(HRStringUtils.isEmpty((String)flowType) ? ChgFlowTypeEnum.FLOW_UNRELATED.getFlowType() : flowType);
        return parser;
    }
}

